/*
 * Decompiled with CFR 0.152.
 */
package util.comPort;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gui.MainFrame;
import gui.ProcessDialog;
import gui.rightPanels.LogPanel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import objects.Settings;
import util.SysUtil;
import util.comPort.SerialPortException;

public class PortSerial {
    private static PortSerial instance;
    public static boolean useServer;
    private static InputStream inStream;
    private static OutputStream outStream;
    protected static SerialPort mPort;
    public static int SOX;
    public static final int STX = 2;
    public static final int ACK = 6;
    public static final int NACK = 21;
    private static SerialPortException excTO;
    private static SerialPortException excClosed;
    public static SerialPortException excCRC;
    private static byte[] buffer;
    public static String sPort;
    public static int speed;
    private static long TIME;
    public ThreadWatcher theWatcher = new ThreadWatcher();
    public static final Object syncObj;
    int i = 0;

    static {
        useServer = false;
        SOX = 1;
        excCRC = new SerialPortException("Error CRC");
        buffer = new byte[1024];
        sPort = null;
        speed = 115200;
        TIME = System.currentTimeMillis();
        syncObj = new Object();
    }

    private PortSerial() {
        if (MainFrame.PRINTER) {
            SOX = 3;
        }
    }

    public static final PortSerial getInstance() {
        if (instance == null) {
            instance = new PortSerial();
            excTO = new SerialPortException("SERIAL_PORT_ERROR_TIME_OUT-Proverite da li je fiskalni uredjaj povezan sa racunarom.\n\rProverite da li ste odabrali odgovarajuci COM port.\n\rProverite da li ste odabrali odgovarajuci uredjaj.");
            excClosed = new SerialPortException("SERIAL_PORT_ERROR_OPEN-Proverite da li je fiskalni uredjaj povezan sa racunarom.\n\rProverite da li ste odabrali odgovarajuci COM port.\n\rProverite da li ste odabrali odgovarajuci uredjaj.");
        }
        return instance;
    }

    private int readByte(int tt) throws IOException {
        TIME = System.currentTimeMillis();
        long time = System.currentTimeMillis();
        do {
            int b;
            if ((b = inStream.read()) == -1) continue;
            return b;
        } while (System.currentTimeMillis() - time <= (long)tt);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        Object object = syncObj;
        synchronized (object) {
            try {
                if (inStream != null) {
                    inStream.close();
                    inStream = null;
                }
                if (outStream != null) {
                    outStream.close();
                    outStream = null;
                }
                if (mPort != null) {
                    mPort.setDTR(false);
                    mPort.close();
                    mPort = null;
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                Date date = new Date();
                if (LogPanel.com) {
                    System.out.print("\n");
                }
                if (LogPanel.com) {
                    System.out.println("[" + dateFormat.format(date) + "] - Close port " + sPort);
                }
            }
            catch (Exception e) {
                System.out.println("Unable to close port - " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(int speed) throws SerialPortException {
        Object object = syncObj;
        synchronized (object) {
            if (mPort != null) {
                PortSerial.close();
            }
            try {
                CommPortIdentifier commportidentifier = CommPortIdentifier.getPortIdentifier((String)sPort);
                mPort = (SerialPort)commportidentifier.open("PPP3", 100);
                mPort.setDTR(true);
                mPort.setRTS(false);
                mPort.disableReceiveFraming();
                mPort.disableReceiveThreshold();
                inStream = mPort.getInputStream();
                outStream = mPort.getOutputStream();
                mPort.setSerialPortParams(speed, 8, 1, 0);
                mPort.enableReceiveTimeout(10);
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                Date date = new Date();
                if (LogPanel.com) {
                    System.out.print("\n");
                }
                if (LogPanel.com) {
                    System.out.println("[" + dateFormat.format(date) + "] - Open port " + sPort);
                }
            }
            catch (Exception e) {
                throw excClosed;
            }
            TIME = System.currentTimeMillis();
            PortSerial.speed = speed;
            SysUtil.delay(50);
        }
    }

    public void sendFrame(Command command) throws SerialPortException, CommandsErrors {
        if (MainFrame.PRINTER) {
            SOX = 3;
        }
        Object object = syncObj;
        synchronized (object) {
            int check;
            if (outStream == null) {
                this.test(speed);
            }
            int pos = 0;
            int t = command.getPos() + 1;
            TIME = System.currentTimeMillis();
            if (command.bigCommand) {
                PortSerial.buffer[pos++] = (byte)SOX;
                PortSerial.buffer[pos++] = (byte)t;
                PortSerial.buffer[pos++] = (byte)(t >> 8);
                check = t & 0xFF;
                check += t >> 8 & 0xFF;
            } else {
                check = t;
                PortSerial.buffer[pos++] = 2;
                PortSerial.buffer[pos++] = (byte)check;
            }
            PortSerial.buffer[pos++] = (byte)command.getCmd();
            check += command.getCmd() & 0xFF;
            int i = 0;
            while (i < command.getPos()) {
                t = command.getArray()[i] & 0xFF;
                PortSerial.buffer[pos++] = (byte)t;
                check += t;
                ++i;
            }
            PortSerial.buffer[pos++] = (byte)(check >> 8);
            PortSerial.buffer[pos++] = (byte)check;
            int k = 0;
            while (k < 10) {
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                    Date date = new Date();
                    if (LogPanel.com) {
                        System.out.println("[" + dateFormat.format(date) + "] - Write data " + sPort);
                    }
                    LogPanel.byteToHexView(buffer, pos);
                    outStream.write(buffer, 0, pos);
                    outStream.flush();
                    t = this.readByte(3000);
                    dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                    date = new Date();
                    if (LogPanel.com) {
                        System.out.println("[" + dateFormat.format(date) + "] - Read data " + sPort);
                    }
                    LogPanel.intToHexView(t, 1);
                    if (LogPanel.com) {
                        System.out.print("\n");
                    }
                    if (t != 21) {
                        if (t == 6) {
                            return;
                        }
                        if (t == -1) {
                            throw excTO;
                        }
                    }
                }
                catch (Exception e) {
                    throw new SerialPortException(e.getMessage());
                }
                ++k;
            }
            throw new SerialPortException("Data is not sent.-Proverite da li je fiskalni uredjaj povezan sa racunarom.\n\rBudite sigurni da ste odabrali odgovarajuci COM port.\n\rProverite da li ste odabrali odgovarajuci uredjaj.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test(int speed) throws SerialPortException, CommandsErrors {
        Object object = syncObj;
        synchronized (object) {
            Command cmd = Command.testInstance;
            cmd.reset();
            cmd.setCmd(101);
            this.open(speed);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sendFrame(cmd);
        }
    }

    public int readByte(long waitTime) {
        Object object = syncObj;
        synchronized (object) {
            int t;
            TIME = System.currentTimeMillis();
            long time = System.currentTimeMillis();
            while (true) {
                try {
                    t = inStream.read();
                }
                catch (IOException e1) {
                    return -1;
                }
                break;
            }
            {
                block9: {
                    if (t != -1) {
                        time = System.currentTimeMillis() - time;
                        TIME = System.currentTimeMillis();
                        return t;
                    }
                    if (System.currentTimeMillis() - time <= waitTime) break block9;
                    TIME = System.currentTimeMillis();
                    return -1;
                }
                Thread.yield();
                continue;
            }
        }
    }

    public Command receiveFrame() throws SerialPortException {
        Object object = syncObj;
        synchronized (object) {
            int errors = 0;
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            Date date = new Date();
            if (LogPanel.com) {
                System.out.println("[" + dateFormat.format(date) + "] - Read data " + sPort);
            }
            int i = 0;
            while (i < 3) {
                block30: {
                    try {
                        int mm;
                        Command command;
                        int type;
                        block29: {
                            long curTime = System.currentTimeMillis();
                            boolean show = false;
                            while (true) {
                                type = this.readByte(5000);
                                LogPanel.intToHexView(type, 1);
                                while (type == 7) {
                                    type = this.readByte(1000);
                                    LogPanel.intToHexView(type, 1);
                                    type = this.readByte(5000);
                                    LogPanel.intToHexView(type, 1);
                                }
                                TIME = System.currentTimeMillis();
                                if (type == -1) {
                                    throw excTO;
                                }
                                if (type == 2 || type == SOX) break block29;
                                if (type == 8) {
                                    if (System.currentTimeMillis() - curTime <= 4000L || show) continue;
                                    show = true;
                                    continue;
                                }
                                if (type != 9 && ++errors > 10) break;
                            }
                            throw excTO;
                        }
                        int t = this.readByte(200);
                        LogPanel.intToHexView(t, 1);
                        if (t == -1) {
                            throw excTO;
                        }
                        int check = t;
                        int len = t;
                        if (type == SOX) {
                            command = Command.bigInstance;
                            int k = this.readByte(200);
                            LogPanel.intToHexView(k, 1);
                            if (k == -1) {
                                throw excTO;
                            }
                            len |= k << 8;
                            check += k;
                        } else {
                            command = Command.instance;
                        }
                        command.reset();
                        command.setLength(len);
                        if (len < 1) {
                            throw excTO;
                        }
                        long time = System.currentTimeMillis();
                        int pos = 0;
                        while (true) {
                            t = inStream.read(buffer, pos, 1024 - pos);
                            LogPanel.byteToHexView(buffer, t);
                            if (t <= 0) {
                                if (System.currentTimeMillis() - time > 3000L) {
                                    TIME = System.currentTimeMillis();
                                    throw excTO;
                                }
                                Thread.yield();
                                continue;
                            }
                            if ((pos += t) >= len + 2) break;
                        }
                        command.setCmd(buffer[0] & 0xFF);
                        i = 0;
                        while (i < len) {
                            mm = buffer[i] & 0xFF;
                            check += mm;
                            if (i != 0) {
                                command.addByte(mm);
                            }
                            ++i;
                        }
                        if ((mm = buffer[len++] & 0xFF) != (check >>> 8 & 0xFF)) {
                            outStream.write(21);
                            dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                            date = new Date();
                            if (LogPanel.com) {
                                System.out.println("[" + dateFormat.format(date) + "] - Write data " + sPort);
                            }
                            LogPanel.intToHexView(21, 1);
                            if (LogPanel.com) {
                                System.out.print("\n");
                            }
                            break block30;
                        }
                        if ((mm = buffer[len++] & 0xFF) != (check & 0xFF)) {
                            outStream.write(21);
                            dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                            date = new Date();
                            if (LogPanel.com) {
                                System.out.println("[" + dateFormat.format(date) + "] - Write data " + sPort);
                            }
                            LogPanel.intToHexView(21, 1);
                            if (LogPanel.com) {
                                System.out.print("\n");
                            }
                            break block30;
                        }
                        outStream.write(6);
                        dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                        date = new Date();
                        if (LogPanel.com) {
                            System.out.println("[" + dateFormat.format(date) + "] - Write data " + sPort);
                        }
                        LogPanel.intToHexView(6, 1);
                        if (LogPanel.com) {
                            System.out.print("\n");
                        }
                        return command;
                    }
                    catch (IOException e) {
                        throw new SerialPortException(e.getMessage());
                    }
                }
                ++i;
            }
            throw excCRC;
        }
    }

    public void receiveFrame(Command command) throws SerialPortException {
        Object object = syncObj;
        synchronized (object) {
            command.reset();
            int errors = 0;
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            Date date = new Date();
            if (LogPanel.com) {
                System.out.println("[" + dateFormat.format(date) + "] - Read data " + sPort);
            }
            int i = 0;
            while (i < 3) {
                block29: {
                    try {
                        int mm;
                        int type;
                        block28: {
                            long curTime = System.currentTimeMillis();
                            boolean show = false;
                            while (true) {
                                type = this.readByte(5000);
                                LogPanel.intToHexView(type, 1);
                                while (type == 7) {
                                    type = this.readByte(1000);
                                    LogPanel.intToHexView(type, 1);
                                    type = this.readByte(5000);
                                }
                                if (type == -1) {
                                    throw excTO;
                                }
                                if (type == 2) break block28;
                                if (type == 8) {
                                    if (System.currentTimeMillis() - curTime <= 4000L || show) continue;
                                    show = true;
                                    continue;
                                }
                                if (type != 9 && ++errors > 10) break;
                            }
                            throw excTO;
                        }
                        int t = this.readByte(200);
                        LogPanel.intToHexView(t, 1);
                        if (t == -1) {
                            throw excTO;
                        }
                        if (type == SOX) {
                            int k = this.readByte(200);
                            LogPanel.intToHexView(k, 1);
                            if (k == -1) {
                                throw excTO;
                            }
                            t |= k << 8;
                        }
                        command.setLength(t);
                        if (t < 1) {
                            throw excTO;
                        }
                        int check = t;
                        long time = System.currentTimeMillis();
                        int pos = 0;
                        while (true) {
                            t = inStream.read(buffer, pos, 1024 - pos);
                            LogPanel.byteToHexView(buffer, t);
                            if (t <= 0) {
                                if (System.currentTimeMillis() - time > 3000L) {
                                    TIME = System.currentTimeMillis();
                                    throw excTO;
                                }
                                Thread.yield();
                                continue;
                            }
                            if ((pos += t) >= check + 2) break;
                        }
                        TIME = System.currentTimeMillis();
                        command.setCmd(buffer[0] & 0xFF);
                        t = check;
                        int j = 0;
                        while (j < t) {
                            mm = buffer[j] & 0xFF;
                            check += mm;
                            if (j != 0) {
                                command.addByte(mm);
                            }
                            ++j;
                        }
                        if ((mm = buffer[t++] & 0xFF) != check >>> 8) {
                            outStream.write(21);
                            dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                            date = new Date();
                            if (LogPanel.com) {
                                System.out.println("[" + dateFormat.format(date) + "] - Write data " + sPort);
                            }
                            LogPanel.intToHexView(21, 1);
                            if (LogPanel.com) {
                                System.out.print("\n");
                            }
                            break block29;
                        }
                        if ((mm = buffer[t++] & 0xFF) != (check & 0xFF)) {
                            outStream.write(21);
                            dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                            date = new Date();
                            if (LogPanel.com) {
                                System.out.println("[" + dateFormat.format(date) + "] - Write data " + sPort);
                            }
                            LogPanel.intToHexView(21, 1);
                            if (LogPanel.com) {
                                System.out.print("\n");
                            }
                            break block29;
                        }
                        outStream.write(6);
                        dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                        date = new Date();
                        if (LogPanel.com) {
                            System.out.println("[" + dateFormat.format(date) + "] - Write data " + sPort);
                        }
                        LogPanel.intToHexView(6, 1);
                        if (LogPanel.com) {
                            System.out.print("\n");
                        }
                        return;
                    }
                    catch (IOException e) {
                        throw new SerialPortException(e.getMessage());
                    }
                }
                ++i;
            }
            throw excCRC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStatus() {
        Object object = syncObj;
        synchronized (object) {
            if (mPort != null && System.currentTimeMillis() - TIME > 3000L) {
                if (!Settings.getInstance().isSerialOpen()) {
                    PortSerial.close();
                }
                if (!useServer) {
                    ProcessDialog.getInstance().setVisible(false);
                }
            }
        }
    }

    class ThreadWatcher
    extends Thread {
        private ThreadWatcher() {
            this.start();
        }

        @Override
        public void run() {
            while (true) {
                PortSerial.this.checkStatus();
                try {
                    ThreadWatcher.sleep(4000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

