/*
 * Decompiled with CFR 0.152.
 */
package util.XML;

import java.io.IOException;
import java.io.OutputStreamWriter;

public class XmlFileWriter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private OutputStreamWriter out;
    private static final String INDENT = "  ";
    private int currentIndent;
    private boolean newLine = true;

    public XmlFileWriter(OutputStreamWriter newOut) {
        this.out = newOut;
    }

    public void indent() {
        ++this.currentIndent;
    }

    public void unintent() {
        --this.currentIndent;
    }

    public String write(String s) throws IOException {
        if (this.newLine) {
            int i = 0;
            while (i < this.currentIndent) {
                this.out.write(INDENT);
                ++i;
            }
        }
        this.out.write(s);
        this.newLine = false;
        return s;
    }

    public String writeLn(String s) throws IOException {
        this.write(s);
        this.out.write(LINE_SEPARATOR);
        this.newLine = true;
        return String.valueOf(s) + LINE_SEPARATOR;
    }

    public static String compileString(String str) {
        if (str == null || str.equalsIgnoreCase("null") || str.length() <= 0) {
            return "";
        }
        String patternStr = "&";
        String replaceStr = "&amp;";
        str = str.replaceAll(patternStr, replaceStr);
        patternStr = "<";
        replaceStr = "&lt;";
        str = str.replaceAll(patternStr, replaceStr);
        patternStr = ">";
        replaceStr = "&gt;";
        str = str.replaceAll(patternStr, replaceStr);
        patternStr = "'";
        replaceStr = "&#39;";
        str = str.replaceAll(patternStr, replaceStr);
        patternStr = "\"";
        replaceStr = "&quot;";
        str = str.replaceAll(patternStr, replaceStr);
        return str;
    }
}

