/*
 * Decompiled with CFR 0.152.
 */
package org.freixas.tablelayout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Arrays;
import java.util.HashMap;

public class TableLayout
implements LayoutManager2 {
    private Attributes tableAttributes;
    private HashMap compAttributes = new HashMap();
    private int nRows = 0;
    private int nCols = 0;
    private Component[][] components = null;
    private boolean useCacheMeasureResults = false;
    private int[] minWidth;
    private int[] prefWidth;
    private int[] maxWidth;
    private int[] adjWidth;
    private int[] colWeight;
    private int[] minHeight;
    private int[] prefHeight;
    private int[] maxHeight;
    private int[] adjHeight;
    private int[] rowWeight;
    private int MinWidth = 0;
    private int MinHeight = 0;
    private int PrefWidth = 0;
    private int PrefHeight = 0;
    private int MaxWidth = 0;
    private int MaxHeight = 0;
    private int ColWeight = 0;
    private int RowWeight = 0;
    static String[] attr = new String[]{"tn", "tne", "tnw", "ts", "tse", "tsw", "te", "tw", "tc", "tfh", "tfv", "tf", "n", "ne", "nw", "s", "se", "sw", "e", "w", "c", "fh", "fv", "f"};
    static String[] assgn = new String[]{"cols", "rgap", "cgap", "titop", "tibottom", "tileft", "tiright", "itop", "ibottom", "ileft", "iright", "rweight", "cweight", "rspan", "cspan", "col", "skip"};

    public TableLayout() {
        this(null);
    }

    public TableLayout(String attributes) {
        this.tableAttributes = new Attributes(attributes);
    }

    public void setTableAttributes(String attributes) {
        this.tableAttributes = new Attributes(attributes);
        for (Component comp : this.compAttributes.keySet()) {
            Attributes a = (Attributes)this.compAttributes.get(comp);
            a.parse();
        }
        this.components = null;
        this.useCacheMeasureResults = false;
    }

    public void setAttributes(Component comp, String attributes) {
        if (this.compAttributes.get(comp) != null) {
            Attributes a = new Attributes(attributes, false);
            this.compAttributes.put(comp, a);
            this.components = null;
            this.useCacheMeasureResults = false;
        }
    }

    @Override
    public void addLayoutComponent(String attributes, Component comp) {
        Attributes a = new Attributes(attributes, false);
        this.compAttributes.put(comp, a);
        this.components = null;
        this.useCacheMeasureResults = false;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        String attributes = "";
        if (constraints instanceof String) {
            attributes = (String)constraints;
        }
        this.addLayoutComponent(attributes, comp);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.compAttributes.remove(comp);
        this.components = null;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        this.measureComponents(parent);
        int w = insets.left + insets.right + this.tableAttributes.tableInsets.left + this.tableAttributes.tableInsets.right + this.MinWidth;
        int h = insets.top + insets.bottom + this.tableAttributes.tableInsets.top + this.tableAttributes.tableInsets.bottom + this.MinHeight;
        if (w > Short.MAX_VALUE) {
            w = Short.MAX_VALUE;
        }
        if (h > Short.MAX_VALUE) {
            h = Short.MAX_VALUE;
        }
        return new Dimension(w, h);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        this.measureComponents(parent);
        int w = insets.left + insets.right + this.tableAttributes.tableInsets.left + this.tableAttributes.tableInsets.right + this.PrefWidth;
        int h = insets.top + insets.bottom + this.tableAttributes.tableInsets.top + this.tableAttributes.tableInsets.bottom + this.PrefHeight;
        if (w > Short.MAX_VALUE) {
            w = Short.MAX_VALUE;
        }
        if (h > Short.MAX_VALUE) {
            h = Short.MAX_VALUE;
        }
        return new Dimension(w, h);
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        this.measureComponents(parent);
        int w = Short.MAX_VALUE;
        if (this.tableAttributes.tableHorizontal != 5 && (w = insets.left + insets.right + this.tableAttributes.tableInsets.left + this.tableAttributes.tableInsets.right + this.MaxWidth) > Short.MAX_VALUE) {
            w = Short.MAX_VALUE;
        }
        int h = Short.MAX_VALUE;
        if (this.tableAttributes.tableVertical != 5 && (h = insets.top + insets.bottom + this.tableAttributes.tableInsets.top + this.tableAttributes.tableInsets.bottom + this.MaxHeight) > Short.MAX_VALUE) {
            h = Short.MAX_VALUE;
        }
        return new Dimension(w, h);
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container parent) {
        this.useCacheMeasureResults = false;
    }

    @Override
    public void layoutContainer(Container parent) {
        this.measureComponents(parent);
        Insets insets = parent.getInsets();
        int fullWidth = parent.getSize().width - (insets.left + insets.right) - (this.tableAttributes.tableInsets.left + this.tableAttributes.tableInsets.right);
        int fullHeight = parent.getSize().height - (insets.top + insets.bottom) - (this.tableAttributes.tableInsets.top + this.tableAttributes.tableInsets.bottom);
        boolean shrinkWidth = fullWidth < this.PrefWidth;
        boolean shrinkHeight = fullHeight < this.PrefHeight;
        int tableX = insets.left + this.tableAttributes.tableInsets.left;
        int tableY = insets.top + this.tableAttributes.tableInsets.top;
        int tableWidth = this.PrefWidth;
        if (shrinkWidth || this.tableAttributes.tableHorizontal == 5) {
            tableWidth = fullWidth;
        }
        int tableHeight = this.PrefHeight;
        if (shrinkHeight || this.tableAttributes.tableVertical == 5) {
            tableHeight = fullHeight;
        }
        if (this.tableAttributes.tableHorizontal == 0 || this.tableAttributes.tableHorizontal == 5) {
            tableX += (fullWidth - tableWidth) / 2;
        } else if (this.tableAttributes.tableHorizontal == 2) {
            tableX += fullWidth - tableWidth;
        }
        if (this.tableAttributes.tableVertical == 0 || this.tableAttributes.tableVertical == 5) {
            tableY += (fullHeight - tableHeight) / 2;
        } else if (this.tableAttributes.tableVertical == 4) {
            tableY += fullHeight - tableHeight;
        }
        this.adjustCellSizes(this.nCols, this.tableAttributes.tableHorizontal == 5, shrinkWidth, this.minWidth, this.PrefWidth, this.prefWidth, fullWidth, this.ColWeight, this.colWeight, this.adjWidth, parent);
        this.adjustCellSizes(this.nRows, this.tableAttributes.tableVertical == 5, shrinkHeight, this.minHeight, this.PrefHeight, this.prefHeight, fullHeight, this.RowWeight, this.rowWeight, this.adjHeight, parent);
        int r = 0;
        while (r < this.nRows) {
            int c = 0;
            while (c < this.nCols) {
                Component comp = this.components[r][c];
                if (comp != null) {
                    Attributes attributes = (Attributes)this.compAttributes.get(comp);
                    Dimension compMinSize = comp.getMinimumSize();
                    Dimension compPrefSize = comp.getPreferredSize();
                    int compX = tableX + this.tableAttributes.cGap * c + attributes.cellInsets.left;
                    int i = 0;
                    while (i < c) {
                        compX += this.adjWidth[i];
                        ++i;
                    }
                    int compY = tableY + this.tableAttributes.rGap * r + attributes.cellInsets.top;
                    int i2 = 0;
                    while (i2 < r) {
                        compY += this.adjHeight[i2];
                        ++i2;
                    }
                    int cellWidth = this.adjWidth[c];
                    int i3 = 1;
                    while (i3 < attributes.cSpan) {
                        cellWidth += this.tableAttributes.cGap + this.adjWidth[c + i3];
                        ++i3;
                    }
                    int cellHeight = this.adjHeight[r];
                    int i4 = 1;
                    while (i4 < attributes.rSpan) {
                        cellHeight += this.tableAttributes.rGap + this.adjHeight[r + i4];
                        ++i4;
                    }
                    int insetCellWidth = cellWidth - attributes.cellInsets.left - attributes.cellInsets.right;
                    int insetCellHeight = cellHeight - attributes.cellInsets.top - attributes.cellInsets.bottom;
                    int compWidth = compPrefSize.width;
                    int compHeight = compPrefSize.height;
                    if (compWidth > insetCellWidth) {
                        compWidth = insetCellWidth;
                    }
                    if (compHeight > insetCellHeight) {
                        compHeight = insetCellHeight;
                    }
                    if (attributes.horizontal == 5) {
                        compWidth = insetCellWidth;
                        compWidth = Math.max(compWidth, compMinSize.width);
                    }
                    if (attributes.vertical == 5) {
                        compHeight = insetCellHeight;
                        compHeight = Math.max(compHeight, compMinSize.height);
                    }
                    if (attributes.horizontal == 0 || attributes.horizontal == 5) {
                        compX += (cellWidth - (attributes.cellInsets.left + attributes.cellInsets.right) - compWidth) / 2;
                    } else if (attributes.horizontal == 2) {
                        compX += cellWidth - (attributes.cellInsets.left + attributes.cellInsets.right) - compWidth;
                    }
                    if (attributes.vertical == 0 || attributes.vertical == 5) {
                        compY += (cellHeight - (attributes.cellInsets.top + attributes.cellInsets.bottom) - compHeight) / 2;
                    } else if (attributes.vertical == 4) {
                        compY += cellHeight - (attributes.cellInsets.top + attributes.cellInsets.bottom) - compHeight;
                    }
                    comp.setBounds(compX, compY, compWidth, compHeight);
                }
                ++c;
            }
            ++r;
        }
    }

    private void adjustCellSizes(int nCells, boolean fill, boolean shrink, int[] minSize, int PrefSize, int[] prefSize, int fullSize, int CellWeight, int[] cellWeight, int[] adjSize, Container parent) {
        double unitOfSpace = 0.0;
        if (!shrink && !fill) {
            int i = 0;
            while (i < nCells) {
                adjSize[i] = prefSize[i];
                ++i;
            }
            return;
        }
        unitOfSpace = (double)(fullSize - PrefSize) / (double)(shrink || CellWeight == 0 ? nCells : CellWeight);
        double error = 0.0;
        int iError = -999999;
        int i = 0;
        while (i < nCells) {
            adjSize[i] = prefSize[i];
            int adjWeight = shrink || CellWeight == 0 ? 1 : cellWeight[i];
            double extraSpace = unitOfSpace * (double)adjWeight;
            int iExtraSpace = (int)extraSpace;
            int n = i;
            adjSize[n] = adjSize[n] + iExtraSpace;
            iError = (int)(error += extraSpace - (double)iExtraSpace);
            if (shrink) {
                if (iError < 0) {
                    int n2 = i;
                    adjSize[n2] = adjSize[n2] + iError;
                }
            } else if (iError > 0) {
                int n3 = i;
                adjSize[n3] = adjSize[n3] + iError;
            }
            error -= (double)iError;
            if (shrink && adjSize[i] < minSize[i]) {
                error -= (double)(minSize[i] - adjSize[i]);
                adjSize[i] = minSize[i];
            }
            iError = (int)error;
            ++i;
        }
        if (shrink || iError < 0) {
            int lastIError;
            do {
                lastIError = iError;
                int i2 = 0;
                while (i2 < nCells) {
                    if (adjSize[i2] > minSize[i2]) {
                        int n = i2;
                        adjSize[n] = adjSize[n] - 1;
                        ++iError;
                    }
                    ++i2;
                }
            } while (iError < 0 && iError > lastIError);
        }
    }

    private void placeComponents(Container parent) {
        if (this.components != null) {
            return;
        }
        int compCount = parent.getComponentCount();
        this.nCols = this.tableAttributes.columns;
        CompArray compArray = new CompArray(this.tableAttributes.columns, compCount);
        int row = 0;
        int col = 0;
        int i = 0;
        while (i < compCount) {
            Component comp = parent.getComponent(i);
            Attributes attributes = (Attributes)this.compAttributes.get(comp);
            attributes.cSpan = attributes.originalCSpan;
            if (attributes.cSpan > this.tableAttributes.columns) {
                attributes.cSpan = this.tableAttributes.columns;
            }
            if (attributes.column != -1) {
                if (col > attributes.column) {
                    ++row;
                }
                col = attributes.column;
            }
            if ((col += attributes.skip) >= this.nCols) {
                ++row;
                col = 0;
            }
            while (compArray.get(row, col) != null) {
                if (++col < this.nCols) continue;
                ++row;
                col = 0;
            }
            if (col + attributes.cSpan > this.nCols) {
                ++row;
                col = 0;
            }
            int c = 0;
            while (c < attributes.cSpan) {
                int r = 0;
                while (r < attributes.rSpan) {
                    compArray.set(row + r, col + c, comp);
                    ++r;
                }
                ++c;
            }
            if ((col += attributes.cSpan) >= this.nCols) {
                ++row;
                col = 0;
            }
            ++i;
        }
        this.components = compArray.getArray();
        this.nRows = this.components.length;
        row = 0;
        while (row < this.nRows) {
            col = 0;
            while (col < this.nCols) {
                Component comp = this.components[row][col];
                int r = row;
                while (r < this.nRows && this.components[r][col] == comp) {
                    int c = col;
                    while (c < this.nCols && this.components[r][c] == comp) {
                        if (r > row || c > col) {
                            this.components[r][c] = null;
                        }
                        ++c;
                    }
                    ++r;
                }
                ++col;
            }
            ++row;
        }
    }

    private void measureComponents(Container parent) {
        Dimension maxSize;
        Dimension prefSize;
        Dimension minSize;
        Attributes attributes;
        Component comp;
        int col;
        if (this.useCacheMeasureResults) {
            return;
        }
        this.placeComponents(parent);
        if (this.minWidth == null || this.minWidth.length < this.nCols) {
            this.minWidth = new int[this.nCols];
            this.prefWidth = new int[this.nCols];
            this.maxWidth = new int[this.nCols];
            this.adjWidth = new int[this.nCols];
            this.colWeight = new int[this.nCols];
        }
        if (this.minHeight == null || this.minHeight.length < this.nRows) {
            this.minHeight = new int[this.nRows];
            this.prefHeight = new int[this.nRows];
            this.maxHeight = new int[this.nRows];
            this.adjHeight = new int[this.nRows];
            this.rowWeight = new int[this.nRows];
        }
        int i = 0;
        while (i < this.nCols) {
            this.minWidth[i] = 0;
            this.prefWidth[i] = 0;
            this.maxWidth[i] = 0;
            this.colWeight[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.nRows) {
            this.minHeight[i] = 0;
            this.prefHeight[i] = 0;
            this.maxHeight[i] = 0;
            this.rowWeight[i] = 0;
            ++i;
        }
        int row = 0;
        while (row < this.nRows) {
            col = 0;
            while (col < this.nCols) {
                comp = this.components[row][col];
                if (comp != null) {
                    attributes = (Attributes)this.compAttributes.get(comp);
                    minSize = new Dimension(comp.getMinimumSize());
                    prefSize = new Dimension(comp.getPreferredSize());
                    maxSize = new Dimension(comp.getMaximumSize());
                    minSize.width += attributes.cellInsets.left + attributes.cellInsets.right;
                    minSize.height += attributes.cellInsets.top + attributes.cellInsets.bottom;
                    prefSize.width += attributes.cellInsets.left + attributes.cellInsets.right;
                    prefSize.height += attributes.cellInsets.top + attributes.cellInsets.bottom;
                    maxSize.width += attributes.cellInsets.left + attributes.cellInsets.right;
                    maxSize.height += attributes.cellInsets.right + attributes.cellInsets.bottom;
                    this.limitDimension(minSize, new Dimension(0, 0));
                    this.limitDimension(prefSize, minSize);
                    this.limitDimension(maxSize, prefSize);
                    if (attributes.cSpan == 1) {
                        this.minWidth[col] = Math.max(minSize.width, this.minWidth[col]);
                        this.prefWidth[col] = Math.max(prefSize.width, this.prefWidth[col]);
                        this.maxWidth[col] = Math.max(maxSize.width, this.maxWidth[col]);
                    }
                    if (attributes.rSpan == 1) {
                        this.minHeight[row] = Math.max(minSize.height, this.minHeight[row]);
                        this.prefHeight[row] = Math.max(prefSize.height, this.prefHeight[row]);
                        this.maxHeight[row] = Math.max(maxSize.height, this.maxHeight[row]);
                    }
                    if (attributes.cWeight > this.colWeight[col]) {
                        this.colWeight[col] = attributes.cWeight;
                    }
                    if (attributes.rWeight > this.rowWeight[row]) {
                        this.rowWeight[row] = attributes.rWeight;
                    }
                }
                ++col;
            }
            ++row;
        }
        row = 0;
        while (row < this.nRows) {
            col = 0;
            while (col < this.nCols) {
                comp = this.components[row][col];
                if (comp != null) {
                    attributes = (Attributes)this.compAttributes.get(comp);
                    if (attributes.rSpan != 1 || attributes.cSpan != 1) {
                        minSize = new Dimension(comp.getMinimumSize());
                        prefSize = new Dimension(comp.getPreferredSize());
                        maxSize = new Dimension(comp.getMaximumSize());
                        minSize.width += attributes.cellInsets.top + attributes.cellInsets.bottom;
                        minSize.height += attributes.cellInsets.left + attributes.cellInsets.right;
                        prefSize.width += attributes.cellInsets.top + attributes.cellInsets.bottom;
                        prefSize.height += attributes.cellInsets.left + attributes.cellInsets.right;
                        maxSize.width += attributes.cellInsets.top + attributes.cellInsets.bottom;
                        maxSize.height += attributes.cellInsets.left + attributes.cellInsets.right;
                        this.limitDimension(minSize, new Dimension(0, 0));
                        this.limitDimension(prefSize, minSize);
                        this.limitDimension(maxSize, prefSize);
                        if (attributes.cSpan > 1) {
                            this.adjustForSpans(col, minSize.width, this.minWidth, this.colWeight, attributes.cSpan, this.tableAttributes.cGap);
                            this.adjustForSpans(col, prefSize.width, this.prefWidth, this.colWeight, attributes.cSpan, this.tableAttributes.cGap);
                            this.adjustForSpans(col, maxSize.width, this.maxWidth, this.colWeight, attributes.cSpan, this.tableAttributes.cGap);
                        }
                        if (attributes.rSpan > 1) {
                            this.adjustForSpans(row, minSize.height, this.minHeight, this.rowWeight, attributes.rSpan, this.tableAttributes.rGap);
                            this.adjustForSpans(row, prefSize.height, this.prefHeight, this.rowWeight, attributes.rSpan, this.tableAttributes.rGap);
                            this.adjustForSpans(row, maxSize.height, this.maxHeight, this.rowWeight, attributes.rSpan, this.tableAttributes.rGap);
                        }
                    }
                }
                ++col;
            }
            ++row;
        }
        this.MinWidth = 0;
        this.MinHeight = 0;
        this.PrefWidth = 0;
        this.PrefHeight = 0;
        this.MaxWidth = 0;
        this.MaxHeight = 0;
        this.ColWeight = 0;
        this.RowWeight = 0;
        i = 0;
        while (i < this.nCols) {
            this.MinWidth += this.minWidth[i];
            this.PrefWidth += this.prefWidth[i];
            this.MaxWidth += this.maxWidth[i];
            this.ColWeight += this.colWeight[i];
            ++i;
        }
        i = 0;
        while (i < this.nRows) {
            this.MinHeight += this.minHeight[i];
            this.PrefHeight += this.prefHeight[i];
            this.MaxHeight += this.maxHeight[i];
            this.RowWeight += this.rowWeight[i];
            ++i;
        }
        int cExtra = this.tableAttributes.cGap * (this.nCols - 1);
        int rExtra = this.tableAttributes.rGap * (this.nRows - 1);
        this.MinWidth += cExtra;
        this.PrefWidth += cExtra;
        this.MaxWidth += cExtra;
        this.MinHeight += rExtra;
        this.PrefHeight += rExtra;
        this.MaxHeight += rExtra;
        this.useCacheMeasureResults = true;
    }

    private void limitDimension(Dimension d1, Dimension d2) {
        if (d1.width < d2.width) {
            d1.width = d2.width;
        }
        if (d1.height < d2.height) {
            d1.height = d2.height;
        }
        if (d1.width > Short.MAX_VALUE) {
            d1.width = Short.MAX_VALUE;
        }
        if (d1.height > Short.MAX_VALUE) {
            d1.height = Short.MAX_VALUE;
        }
    }

    private void adjustForSpans(int pos, int compSize, int[] sizes, int[] weight, int span, int gap) {
        int totalSize = 0;
        int i = 0;
        while (i < span) {
            totalSize += sizes[pos + i];
            ++i;
        }
        if (compSize > (totalSize += gap * (span - 1))) {
            int extra = compSize - totalSize;
            int totalWeight = 0;
            int i2 = 0;
            while (i2 < span) {
                totalWeight += weight[pos + i2];
                ++i2;
            }
            if (totalWeight == 0) {
                totalWeight = span;
            }
            int remainder = extra;
            int i3 = 0;
            while (i3 < span) {
                int portion = extra * weight[pos + i3] / totalWeight;
                int n = pos + i3;
                sizes[n] = sizes[n] + portion;
                remainder -= portion;
                ++i3;
            }
            if (remainder > 0) {
                int n = pos + span - 1;
                sizes[n] = sizes[n] + remainder;
            }
        }
    }

    private class Attributes {
        static final int CENTER = 0;
        static final int LEFT = 1;
        static final int RIGHT = 2;
        static final int TOP = 3;
        static final int BOTTOM = 4;
        static final int FILL = 5;
        static final int NEXT_COLUMN = -1;
        String attrString;
        int columns = 1;
        int tableHorizontal = 5;
        int tableVertical = 5;
        int rGap = 0;
        int cGap = 0;
        Insets tableInsets = new Insets(0, 0, 0, 0);
        int horizontal = 5;
        int vertical = 5;
        Insets cellInsets = new Insets(0, 0, 0, 0);
        int rWeight = 0;
        int cWeight = 0;
        int rSpan = 1;
        int cSpan;
        int originalCSpan = this.cSpan = 1;
        int column = -1;
        int skip = 0;
        int tkPos = 0;
        boolean isTableAttributes = false;

        Attributes(String attrString) {
            this(attrString, true);
        }

        Attributes(String attrString, boolean isTableAttributes) {
            this.attrString = attrString;
            this.isTableAttributes = isTableAttributes;
            this.parse();
        }

        public String toString() {
            String sep = System.getProperty("line.separator");
            return "TableLayout Attributes:" + sep + "isTableAttributes = " + this.isTableAttributes + sep + "columns = " + this.columns + sep + "tableHorizontal = " + this.tableHorizontal + " " + "tableVertical = " + this.tableVertical + sep + "rGap = " + this.rGap + " " + "cGap = " + this.cGap + sep + "tableInsets = " + this.tableInsets + sep + "horizontal = " + this.horizontal + " " + "vertical = " + this.vertical + sep + "cellInsets = " + this.cellInsets + sep + "rWeight = " + this.rWeight + " " + "cWeight = " + this.cWeight + sep + "rSpan = " + this.rSpan + " " + "cSpan = " + this.cSpan + sep + "originalCSpan = " + this.originalCSpan + sep + "column = " + this.column + sep + "skip = " + this.skip;
        }

        String getStringAttributes() {
            return this.attrString;
        }

        private char getTokenChar() {
            if (this.tkPos >= this.attrString.length()) {
                return '\u0000';
            }
            return Character.toLowerCase(this.attrString.charAt(this.tkPos++));
        }

        private String getToken() {
            StringBuffer token = new StringBuffer();
            char c = this.getTokenChar();
            if (Character.isWhitespace(c)) {
                while (Character.isWhitespace(c = this.getTokenChar())) {
                }
            }
            if (Character.isLetter(c)) {
                do {
                    token.append(c);
                } while (Character.isLetter(c = this.getTokenChar()));
                if (c != '\u0000') {
                    --this.tkPos;
                }
            } else if (Character.isDigit(c)) {
                do {
                    token.append(c);
                } while (Character.isDigit(c = this.getTokenChar()));
                if (c != '\u0000') {
                    --this.tkPos;
                }
            } else {
                if (c == '\u0000') {
                    return null;
                }
                token.append(c);
            }
            return new String(token);
        }

        void parse() {
            if (!this.isTableAttributes) {
                this.horizontal = ((TableLayout)TableLayout.this).tableAttributes.horizontal;
                this.vertical = ((TableLayout)TableLayout.this).tableAttributes.vertical;
                this.cellInsets = (Insets)((TableLayout)TableLayout.this).tableAttributes.cellInsets.clone();
                this.rWeight = ((TableLayout)TableLayout.this).tableAttributes.rWeight;
                this.cWeight = ((TableLayout)TableLayout.this).tableAttributes.cWeight;
            }
            if (this.attrString == null) {
                return;
            }
            this.tkPos = 0;
            while (this.tkPos < this.attrString.length()) {
                this.parseOption();
            }
            if (this.isTableAttributes) {
                if (this.columns == 0) {
                    this.reportSemanticError("cols=0");
                }
            } else {
                if (this.rSpan == 0) {
                    this.reportSemanticError("rspan=0");
                }
                if (this.cSpan == 0) {
                    this.reportSemanticError("cspan=0");
                }
                if (this.column >= ((TableLayout)TableLayout.this).tableAttributes.columns) {
                    this.reportSemanticError("col=" + this.column + " (max is " + (((TableLayout)TableLayout.this).tableAttributes.columns - 1) + ")");
                }
            }
        }

        private void parseOption() {
            String token = this.getToken();
            if (token == null) {
                return;
            }
            int i = 0;
            while (i < attr.length) {
                if (token.equals(attr[i])) {
                    this.parseAttribute(token);
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < assgn.length) {
                if (token.equals(assgn[i])) {
                    this.parseAssignment(token);
                    return;
                }
                ++i;
            }
            this.reportError(token, "Unrecognized attribute");
        }

        private void parseAttribute(String token) {
            if ("tnw".equals(token) || "tw".equals(token) || "tsw".equals(token)) {
                this.tableHorizontal = 1;
            }
            if ("tne".equals(token) || "te".equals(token) || "tse".equals(token)) {
                this.tableHorizontal = 2;
            }
            if ("tn".equals(token) || "tc".equals(token) || "ts".equals(token)) {
                this.tableHorizontal = 0;
            }
            if ("tf".equals(token) || "tfh".equals(token)) {
                this.tableHorizontal = 5;
            }
            if ("tn".equals(token) || "tnw".equals(token) || "tne".equals(token)) {
                this.tableVertical = 3;
            }
            if ("ts".equals(token) || "tsw".equals(token) || "tse".equals(token)) {
                this.tableVertical = 4;
            }
            if ("tw".equals(token) || "tc".equals(token) || "te".equals(token)) {
                this.tableVertical = 0;
            }
            if ("tf".equals(token) || "tfv".equals(token)) {
                this.tableVertical = 5;
            }
            if ("nw".equals(token) || "w".equals(token) || "sw".equals(token)) {
                this.horizontal = 1;
            }
            if ("ne".equals(token) || "e".equals(token) || "se".equals(token)) {
                this.horizontal = 2;
            }
            if ("n".equals(token) || "c".equals(token) || "s".equals(token)) {
                this.horizontal = 0;
            }
            if ("f".equals(token) || "fh".equals(token)) {
                this.horizontal = 5;
            }
            if ("n".equals(token) || "nw".equals(token) || "ne".equals(token)) {
                this.vertical = 3;
            }
            if ("s".equals(token) || "sw".equals(token) || "se".equals(token)) {
                this.vertical = 4;
            }
            if ("w".equals(token) || "c".equals(token) || "e".equals(token)) {
                this.vertical = 0;
            }
            if ("f".equals(token) || "fv".equals(token)) {
                this.vertical = 5;
            }
        }

        private void parseAssignment(String token) {
            String attr = token;
            token = this.getToken();
            if (token != null) {
                if ("=".equals(token) && (token = this.getToken()) != null) {
                    int value = 0;
                    try {
                        value = Integer.parseInt(token);
                    }
                    catch (NumberFormatException e) {
                        this.reportError(token, "Expected an integer");
                    }
                    if ("cols".equals(attr)) {
                        this.columns = value;
                    } else if ("rgap".equals(attr)) {
                        this.rGap = value;
                    } else if ("cgap".equals(attr)) {
                        this.cGap = value;
                    } else if ("titop".equals(attr)) {
                        this.tableInsets.top = value;
                    } else if ("tibottom".equals(attr)) {
                        this.tableInsets.bottom = value;
                    } else if ("tileft".equals(attr)) {
                        this.tableInsets.left = value;
                    } else if ("tiright".equals(attr)) {
                        this.tableInsets.right = value;
                    } else if ("itop".equals(attr)) {
                        this.cellInsets.top = value;
                    } else if ("ibottom".equals(attr)) {
                        this.cellInsets.bottom = value;
                    } else if ("ileft".equals(attr)) {
                        this.cellInsets.left = value;
                    } else if ("iright".equals(attr)) {
                        this.cellInsets.right = value;
                    } else if ("rweight".equals(attr)) {
                        this.rWeight = value;
                    } else if ("cweight".equals(attr)) {
                        this.cWeight = value;
                    } else if ("rspan".equals(attr)) {
                        this.rSpan = value;
                    } else if ("cspan".equals(attr)) {
                        this.originalCSpan = this.cSpan = value;
                    } else if ("col".equals(attr)) {
                        this.column = value;
                    } else if ("skip".equals(attr)) {
                        this.skip = value;
                    }
                    return;
                }
                this.reportError(token, "Expected an '='");
            }
            this.reportError(token, "Expected an '='");
        }

        private void reportError(String token, String message) {
            throw new IllegalArgumentException("TableLayout: " + message + "; near '" + token + "' at position " + this.tkPos + " in '" + this.attrString + "'");
        }

        private void reportSemanticError(String message) {
            throw new IllegalArgumentException("TableLayout: Invalid value: " + message);
        }
    }

    private class CompArray {
        private int nCols;
        private int nRows;
        private int maxRow = 0;
        Component[][] compArray = null;

        CompArray(int nCols, int compCount) {
            this.nRows = (compCount + (nCols - 1)) / nCols;
            this.nRows = Math.max(this.nRows, 1);
            this.nCols = nCols;
            this.compArray = new Component[this.nRows][];
            int i = 0;
            while (i < this.nRows) {
                this.compArray[i] = new Component[nCols];
                Arrays.fill(this.compArray[i], null);
                ++i;
            }
        }

        Component get(int row, int col) {
            if (row >= this.nRows) {
                this.resize(row + 1);
            }
            return this.compArray[row][col];
        }

        void set(int row, int col, Component comp) {
            if (row >= this.nRows) {
                this.resize(row + 1);
            }
            this.compArray[row][col] = comp;
            this.maxRow = Math.max(row, this.maxRow);
        }

        Component[][] getArray() {
            int maxRows = this.maxRow + 1;
            Component[][] array = new Component[maxRows][];
            int r = 0;
            while (r < maxRows) {
                array[r] = new Component[this.nCols];
                System.arraycopy(this.compArray[r], 0, array[r], 0, this.nCols);
                ++r;
            }
            return array;
        }

        private void resize(int newRows) {
            if (newRows - this.nRows < 10) {
                newRows = this.nRows + 10;
            }
            Component[][] newArray = new Component[newRows][];
            System.arraycopy(this.compArray, 0, newArray, 0, this.nRows);
            int i = this.nRows;
            while (i < newRows) {
                newArray[i] = new Component[this.nCols];
                Arrays.fill(newArray[i], null);
                ++i;
            }
            this.compArray = newArray;
            this.nRows = newRows;
        }
    }
}

