/*
 * Decompiled with CFR 0.152.
 */
package org.freixas.jcalendar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freixas.jcalendar.DateEvent;
import org.freixas.jcalendar.DateListener;
import org.freixas.jcalendar.JCalendarCombo;

public class JCalendar
extends JPanel {
    public static final int DISPLAY_DATE = 1;
    public static final int DISPLAY_TIME = 2;
    private static final int MONTH_DECR_BUTTON = 0;
    private static final int MONTH_INCR_BUTTON = 1;
    private static final int YEAR_DECR_BUTTON = 2;
    private static final int YEAR_INCR_BUTTON = 3;
    private int selectedComponents;
    private Calendar selectedCalendar;
    private int selectedYear = -1;
    private int selectedMonth = -1;
    private int selectedDay = -1;
    private int selectedHour = -1;
    private int selectedMinute = -1;
    private int selectedSecond = -1;
    private Calendar displayCalendar;
    private int displayYear;
    private int displayMonth;
    private Locale locale;
    private boolean isTodayDisplayed = false;
    private boolean isNullAllowed = true;
    private boolean isNullDate = true;
    private String timePattern;
    private JButton yearDecrButton;
    private JButton monthDecrButton;
    private JLabel monthYearLabel;
    private JButton monthIncrButton;
    private JButton yearIncrButton;
    private JLabel[] dayOfWeekLabels;
    private JToggleButton[][] dayButtons;
    private JToggleButton offScreenButton;
    private ButtonGroup dayGroup;
    private SpinnerDateModel spinnerDateModel;
    private JSpinner spinner;
    private JLabel todaysLabel;
    private Font titleFont;
    private Font dayOfWeekFont;
    private Font dayFont;
    private Font timeFont;
    private Font todayFont;
    private DateFormat formatMonth;
    private DateFormat formatWeekDay;
    private String lastMonth;
    private String lastYear;
    static InputMap inputMap = new InputMap();
    static ActionMap actionMap = new ActionMap();
    private static Action yearBackward = new AbstractAction("yearBackward"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ((JCalendar)e.getSource()).yearBackward();
        }
    };
    private static Action yearForward = new AbstractAction("yearForward"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ((JCalendar)e.getSource()).yearForward();
        }
    };
    private static Action monthBackward = new AbstractAction("montBackward"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ((JCalendar)e.getSource()).monthBackward();
        }
    };
    private static Action monthForward = new AbstractAction("monthForward"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ((JCalendar)e.getSource()).monthForward();
        }
    };
    private static Action setNullDate = new AbstractAction("setNullDate"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ((JCalendar)e.getSource()).setDate(null);
        }
    };
    private static ResourceBundle bundle = ResourceBundle.getBundle("org.freixas.jcalendar.Bundle");
    private JCalendarCombo comboCalendar;

    static {
        inputMap.put(KeyStroke.getKeyStroke("BACK_SPACE"), "setNullDate");
        inputMap.put(KeyStroke.getKeyStroke("DELETE"), "setNullDate");
        inputMap.put(KeyStroke.getKeyStroke("shift LEFT"), "yearBackward");
        inputMap.put(KeyStroke.getKeyStroke("shift RIGHT"), "yearForward");
        inputMap.put(KeyStroke.getKeyStroke("LEFT"), "monthBackward");
        inputMap.put(KeyStroke.getKeyStroke("RIGHT"), "monthForward");
        actionMap.put("setNullDate", setNullDate);
        actionMap.put("yearBackward", yearBackward);
        actionMap.put("yearForward", yearForward);
        actionMap.put("monthBackward", monthBackward);
        actionMap.put("monthForward", monthForward);
    }

    public JCalendar() {
        this(Calendar.getInstance(), Locale.getDefault(), 1, false, null);
    }

    public JCalendar(int selectedComponents, boolean isTodayDisplayed) {
        this(Calendar.getInstance(), Locale.getDefault(), selectedComponents, isTodayDisplayed, null);
    }

    public JCalendar(Calendar calendar, Locale locale, int selectedComponents, boolean isTodayDisplayed) {
        this(calendar, locale, selectedComponents, isTodayDisplayed, null);
    }

    public JCalendar(Calendar calendar, Locale locale, int selectedComponents, boolean isTodayDisplayed, String timePattern) {
        this.selectedCalendar = (Calendar)calendar.clone();
        this.displayCalendar = (Calendar)this.selectedCalendar.clone();
        this.selectedComponents = selectedComponents;
        if ((selectedComponents & 3) == 0) {
            throw new IllegalStateException(bundle.getString("IllegalStateException"));
        }
        this.locale = locale;
        this.isTodayDisplayed = isTodayDisplayed;
        if ((selectedComponents & 2) > 0) {
            if (timePattern == null) {
                DateFormat timeFormat = DateFormat.getTimeInstance(2, locale);
                this.timePattern = "HH:mm:ss";
                if (timeFormat instanceof SimpleDateFormat) {
                    this.timePattern = ((SimpleDateFormat)timeFormat).toPattern();
                }
            } else {
                this.timePattern = timePattern;
            }
        }
        this.createCalendarComponents();
        this.setDate(new Date());
    }

    public void addDateListener(DateListener listener) {
        this.listenerList.add(DateListener.class, listener);
    }

    public void removeDateListener(DateListener listener) {
        this.listenerList.remove(DateListener.class, listener);
    }

    public boolean isNullAllowed() {
        return this.isNullAllowed;
    }

    public void setNullAllowed(boolean isNullAllowed) {
        this.isNullAllowed = isNullAllowed;
    }

    public Date getDate() {
        if (this.isNullDate) {
            return null;
        }
        this.selectedCalendar.set(11, 0);
        this.selectedCalendar.set(12, 0);
        this.selectedCalendar.set(13, 0);
        return this.selectedCalendar.getTime();
    }

    public void setDate(Date date) {
        if (date == null) {
            if (!this.isNullAllowed) {
                return;
            }
            if (!this.isNullDate) {
                this.isNullDate = true;
                this.selectedYear = -1;
                this.selectedMonth = -1;
                this.selectedDay = -1;
                this.selectedCalendar.set(1, 9999);
                this.selectedCalendar.set(2, 9);
                this.selectedCalendar.set(5, 9);
                this.selectedCalendar.set(11, 0);
                this.selectedCalendar.set(12, 0);
                this.selectedCalendar.set(13, 0);
                this.updateCalendarComponents();
                this.fireDateChange();
            }
        } else {
            int oldYear = this.selectedYear;
            int oldMonth = this.selectedMonth;
            int oldDay = this.selectedDay;
            int oldHour = this.selectedHour;
            int oldMinute = this.selectedMinute;
            int oldSecond = this.selectedSecond;
            this.selectedCalendar.setTime(date);
            this.selectedYear = this.selectedCalendar.get(1);
            this.selectedMonth = this.selectedCalendar.get(2);
            this.selectedDay = this.selectedCalendar.get(5);
            this.selectedHour = this.selectedCalendar.get(11);
            this.selectedMinute = this.selectedCalendar.get(12);
            this.selectedSecond = this.selectedCalendar.get(13);
            if ((this.selectedComponents & 1) > 0 && oldDay != this.selectedDay || oldMonth != this.selectedMonth || oldYear != this.selectedYear || (this.selectedComponents & 2) > 0 && oldHour != this.selectedHour || oldMinute != this.selectedMinute || oldSecond != this.selectedSecond) {
                this.isNullDate = false;
                this.displayCalendar.setTime(date);
                this.updateCalendarComponents();
                this.fireDateChange();
            }
        }
    }

    public void setDisplayDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        this.displayCalendar.setTime(date);
        int oldMonth = this.displayCalendar.get(2);
        int oldYear = this.displayCalendar.get(1);
        if (oldMonth != this.displayMonth || oldYear != this.displayYear) {
            this.updateCalendarComponents();
        }
    }

    public String getTimePattern() {
        if ((this.selectedComponents & 2) != 0) {
            return this.timePattern;
        }
        return null;
    }

    public Calendar getCalendar() {
        return (Calendar)this.selectedCalendar.clone();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public int getSelectedComponents() {
        return this.selectedComponents;
    }

    public boolean isTodayDisplayed() {
        return this.isTodayDisplayed;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font font) {
        if (font == null && this.titleFont != null || !font.equals(this.titleFont)) {
            this.titleFont = font;
            if (this.isDisplayable()) {
                this.setupTitleFont();
            }
        }
    }

    public Font getDayOfWeekFont() {
        return this.dayOfWeekFont;
    }

    public void setDayOfWeekFont(Font font) {
        if (font == null && this.dayOfWeekFont != null || !font.equals(this.dayOfWeekFont)) {
            this.dayOfWeekFont = font;
            if (this.isDisplayable()) {
                this.setupDayOfWeekFonts();
            }
        }
    }

    public Font getDayFont() {
        return this.dayFont;
    }

    public void setDayFont(Font font) {
        if (font == null && this.dayFont != null || !font.equals(this.dayFont)) {
            this.dayFont = font;
            if (this.isDisplayable()) {
                this.setupDayFonts();
            }
        }
    }

    public Font getTimeFont() {
        return this.timeFont;
    }

    public void setTimeFont(Font font) {
        if (font == null && this.timeFont != null || !font.equals(this.timeFont)) {
            this.timeFont = font;
            if (this.isDisplayable()) {
                this.setupTimeFont();
            }
        }
    }

    public Font getTodayFont() {
        return this.todayFont;
    }

    public void setTodayFont(Font font) {
        if (font == null && this.todayFont != null || !font.equals(this.todayFont)) {
            this.todayFont = font;
            if (this.isDisplayable()) {
                this.setupTodayFont();
            }
        }
    }

    @Override
    public void setEnabled(boolean b) {
        if (b != this.isEnabled()) {
            super.setEnabled(b);
            if ((this.selectedComponents & 1) > 0) {
                this.yearDecrButton.setEnabled(b);
                this.monthDecrButton.setEnabled(b);
                this.monthYearLabel.setEnabled(b);
                this.monthIncrButton.setEnabled(b);
                this.yearIncrButton.setEnabled(b);
                int day = 0;
                while (day < 7) {
                    this.dayOfWeekLabels[day].setEnabled(b);
                    ++day;
                }
                int row = 0;
                while (row < 6) {
                    int day2 = 0;
                    while (day2 < 7) {
                        if (this.dayButtons[row][day2].getText().length() > 0) {
                            this.dayButtons[row][day2].setEnabled(b);
                        }
                        ++day2;
                    }
                    ++row;
                }
            }
            if ((this.selectedComponents & 2) > 0) {
                this.spinner.setEnabled(b);
            }
        }
    }

    @Override
    public void addNotify() {
        this.setupTitleFont();
        this.setupDayOfWeekFonts();
        this.setupDayFonts();
        this.setupTimeFont();
        this.setupTodayFont();
        super.addNotify();
    }

    @Override
    protected String paramString() {
        String curDate = (this.selectedComponents & 1) == 1 ? DateFormat.getDateInstance(0, this.locale).format(this.getDate()) : ((this.selectedComponents & 2) == 2 ? DateFormat.getTimeInstance(0, this.locale).format(this.getDate()) : DateFormat.getDateTimeInstance(0, 0, this.locale).format(this.getDate()));
        return String.valueOf(super.paramString()) + ",selectedDate=" + curDate;
    }

    JCalendarCombo getJCalendarComboParent() {
        return this.comboCalendar;
    }

    void setJCalendarComboParent(JCalendarCombo comboCalendar) {
        this.comboCalendar = comboCalendar;
    }

    void addSpinnerMaps(InputMap sim, ActionMap sam) {
        sim.setParent(this.spinner.getInputMap(1));
        this.spinner.setInputMap(1, sim);
        sam.setParent(this.spinner.getActionMap());
        this.spinner.setActionMap(sam);
    }

    protected void fireDateChange() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == DateListener.class) {
                DateEvent dateEvent = this.isNullDate ? new DateEvent(this, null) : new DateEvent(this, this.selectedCalendar);
                ((DateListener)listeners[i + 1]).dateChanged(dateEvent);
            }
            i -= 2;
        }
    }

    protected void setupTitleFont() {
        if (this.monthYearLabel == null) {
            return;
        }
        if (this.titleFont != null) {
            this.monthYearLabel.setFont(this.titleFont);
        } else {
            Font font = UIManager.getFont("Label.font");
            this.monthYearLabel.setFont(font);
        }
    }

    protected void setupDayOfWeekFonts() {
        if (this.dayOfWeekLabels == null) {
            return;
        }
        Font font = this.dayOfWeekFont;
        if (font == null) {
            font = UIManager.getFont("Label.font");
            font = font.deriveFont((float)((double)font.getSize2D() * 9.0 / 11.0));
        }
        int day = 0;
        while (day < 7) {
            this.dayOfWeekLabels[day].setFont(font);
            ++day;
        }
    }

    protected void setupDayFonts() {
        if (this.dayButtons == null) {
            return;
        }
        Font font = this.dayFont;
        if (font == null) {
            font = UIManager.getFont("Button.font");
            font = font.deriveFont((float)((double)font.getSize2D() * 9.0 / 11.0));
        }
        int row = 0;
        while (row < 6) {
            int day = 0;
            while (day < 7) {
                this.dayButtons[row][day].setFont(font);
                ++day;
            }
            ++row;
        }
    }

    protected void setupTimeFont() {
        if (this.spinner == null) {
            return;
        }
        if (this.timeFont != null) {
            this.spinner.setFont(this.timeFont);
        } else {
            Font font = UIManager.getFont("Spinner.font");
            this.spinner.setFont(font);
        }
    }

    protected void setupTodayFont() {
        if (this.todaysLabel == null) {
            return;
        }
        if (this.todayFont != null) {
            this.todaysLabel.setFont(this.todayFont);
        } else {
            Font font = UIManager.getFont("Label.font");
            this.todaysLabel.setFont(font);
        }
    }

    private void createCalendarComponents() {
        JPanel datePanel = new JPanel(new BorderLayout(2, 2));
        if ((this.selectedComponents & 1) > 0) {
            this.formatMonth = new SimpleDateFormat("MMM", this.locale);
            this.formatWeekDay = new SimpleDateFormat("EEE", this.locale);
            this.setInputMap(1, inputMap);
            this.setActionMap(actionMap);
            this.yearDecrButton = new JButton(new ButtonAction("YearDecrButton", "YearDecrButtonMnemonic", "YearDecrButtonAccelerator", "YearDecrButtonImage", "YearDecrButtonShort", "YearDecrButtonLong", 2));
            this.monthDecrButton = new JButton(new ButtonAction("MonthDecrButton", "MonthDecrButtonMnemonic", "MonthDecrButtonAccelerator", "MonthDecrButtonImage", "MonthDecrButtonShort", "MonthDecrButtonLong", 0));
            JPanel decrPanel = new JPanel(new FlowLayout(0, 2, 0));
            decrPanel.add(this.yearDecrButton);
            decrPanel.add(this.monthDecrButton);
            this.monthYearLabel = new JLabel();
            this.monthYearLabel.setHorizontalAlignment(0);
            this.monthIncrButton = new JButton(new ButtonAction("MonthIncrButton", "MonthIncrButtonMnemonic", "MonthIncrButtonAccelerator", "MonthIncrButtonImage", "MonthIncrButtonShort", "MonthIncrButtonLong", 1));
            this.yearIncrButton = new JButton(new ButtonAction("YearIncrButton", "YearIncrButtonMnemonic", "YearIncrButtonAccelerator", "YearIncrButtonImage", "YearIncrButtonShort", "YearIncrButtonLong", 3));
            JPanel incrPanel = new JPanel(new FlowLayout(0, 2, 0));
            incrPanel.add(this.monthIncrButton);
            incrPanel.add(this.yearIncrButton);
            JPanel monthYearNavigator = new JPanel(new BorderLayout(2, 2));
            monthYearNavigator.add((Component)decrPanel, "West");
            monthYearNavigator.add(this.monthYearLabel);
            monthYearNavigator.add((Component)incrPanel, "East");
            JPanel dayPanel = new JPanel(new GridLayout(7, 7));
            int firstDay = this.displayCalendar.getFirstDayOfWeek();
            Calendar temp = Calendar.getInstance(this.locale);
            temp.set(2000, 2, 15);
            while (temp.get(7) != firstDay) {
                temp.add(5, 1);
            }
            this.dayOfWeekLabels = new JLabel[7];
            int i = 0;
            while (i < 7) {
                Date date = temp.getTime();
                String dayOfWeek = this.formatWeekDay.format(date);
                this.dayOfWeekLabels[i] = new JLabel(dayOfWeek);
                this.dayOfWeekLabels[i].setHorizontalAlignment(0);
                dayPanel.add(this.dayOfWeekLabels[i]);
                temp.add(5, 1);
                ++i;
            }
            this.dayButtons = new JToggleButton[6][7];
            this.dayGroup = new ButtonGroup();
            DayListener dayListener = new DayListener();
            int row = 0;
            while (row < 6) {
                int day = 0;
                while (day < 7) {
                    this.dayButtons[row][day] = new JToggleButton();
                    this.dayButtons[row][day].addItemListener(dayListener);
                    dayPanel.add(this.dayButtons[row][day]);
                    this.dayGroup.add(this.dayButtons[row][day]);
                    ++day;
                }
                ++row;
            }
            this.offScreenButton = new JToggleButton("X");
            this.dayGroup.add(this.offScreenButton);
            datePanel.add((Component)monthYearNavigator, "North");
            datePanel.add(dayPanel);
        }
        if ((this.selectedComponents & 2) > 0) {
            this.spinnerDateModel = new SpinnerDateModel();
            this.spinnerDateModel.addChangeListener(new TimeListener());
            this.spinner = new JSpinner(this.spinnerDateModel);
            JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.spinner, this.timePattern);
            dateEditor.getTextField().setEditable(false);
            dateEditor.getTextField().setHorizontalAlignment(0);
            this.spinner.setEditor(dateEditor);
            InputMap sim = new InputMap();
            sim.put(KeyStroke.getKeyStroke("BACK_SPACE"), "setNullDate");
            sim.put(KeyStroke.getKeyStroke("DELETE"), "setNullDate");
            sim.setParent(this.spinner.getInputMap(1));
            ActionMap sam = new ActionMap();
            sam.put("setNullDate", new AbstractAction("setNullDate"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCalendar.this.setDate(null);
                }
            });
            sam.setParent(this.spinner.getActionMap());
            this.spinner.setInputMap(1, sim);
            this.spinner.setActionMap(sam);
            JPanel timePanel = new JPanel(new FlowLayout(1, 2, 2));
            timePanel.add(this.spinner);
            datePanel.add((Component)timePanel, "South");
        }
        this.setLayout(new BorderLayout(2, 2));
        this.add(datePanel);
        if (this.isTodayDisplayed) {
            Object[] args = new Object[]{new Date()};
            String todaysDate = MessageFormat.format(bundle.getString("Today"), args);
            this.todaysLabel = new JLabel(todaysDate);
            this.todaysLabel.setHorizontalAlignment(0);
            this.add((Component)this.todaysLabel, "South");
        }
    }

    private void updateCalendarComponents() {
        if ((this.selectedComponents & 1) > 0) {
            this.offScreenButton.setSelected(true);
            this.displayMonth = this.displayCalendar.get(2);
            this.displayYear = this.displayCalendar.get(1);
            String month = this.formatMonth.format(this.displayCalendar.getTime());
            String year = Integer.toString(this.displayYear);
            Object[] args = new Object[]{month, year};
            this.monthYearLabel.setText(MessageFormat.format(bundle.getString("MonthYearTitle"), args));
            if (!month.equals(this.lastMonth) || !year.equals(this.lastYear)) {
                Calendar temp = (Calendar)this.displayCalendar.clone();
                temp.set(5, 1);
                int dayOfWeek = temp.get(7);
                int firstDay = temp.getFirstDayOfWeek();
                int dayPtr = 0;
                while (dayPtr < 7) {
                    int curDay = (firstDay - 1 + dayPtr) % 7 + 1;
                    if (curDay == dayOfWeek) break;
                    this.dayButtons[0][dayPtr].setText("");
                    this.dayButtons[0][dayPtr].setEnabled(false);
                    ++dayPtr;
                }
                int maxDays = temp.getActualMaximum(5);
                int row = 0;
                int day = 1;
                while (day <= maxDays) {
                    this.dayButtons[row][dayPtr].setText(Integer.toString(day));
                    this.dayButtons[row][dayPtr].setEnabled(true);
                    if (day == this.selectedDay && this.displayMonth == this.selectedMonth && this.displayYear == this.selectedYear) {
                        this.dayButtons[row][dayPtr].setSelected(true);
                    } else {
                        this.dayButtons[row][dayPtr].getModel().setSelected(false);
                    }
                    dayPtr = (dayPtr + 1) % 7;
                    if (dayPtr == 0) {
                        ++row;
                    }
                    ++day;
                }
                while (row < 6) {
                    this.dayButtons[row][dayPtr].setText("");
                    this.dayButtons[row][dayPtr].setEnabled(false);
                    this.dayButtons[row][dayPtr].getModel().setSelected(false);
                    dayPtr = (dayPtr + 1) % 7;
                    if (dayPtr != 0) continue;
                    ++row;
                }
            }
        }
        if ((this.selectedComponents & 2) > 0) {
            if (this.isNullDate) {
                Calendar temp = (Calendar)this.selectedCalendar.clone();
                temp.setTime(new Date());
                temp.set(10, 12);
                temp.set(12, 0);
                temp.set(13, 0);
                this.spinnerDateModel.setValue(temp.getTime());
                this.spinner.setEnabled((this.selectedComponents & 1) == 0);
            } else {
                this.spinner.setEnabled(this.isEnabled());
                this.spinnerDateModel.setValue(this.selectedCalendar.getTime());
                this.spinnerDateModel.setStart(null);
                this.spinnerDateModel.setEnd(null);
                this.spinner.revalidate();
            }
        }
    }

    private void yearBackward() {
        this.displayCalendar.add(1, -1);
        this.updateCalendarComponents();
    }

    private void yearForward() {
        this.displayCalendar.add(1, 1);
        this.updateCalendarComponents();
    }

    private void monthBackward() {
        this.displayCalendar.add(2, -1);
        this.updateCalendarComponents();
    }

    private void monthForward() {
        this.displayCalendar.add(2, 1);
        this.updateCalendarComponents();
    }

    private class ButtonAction
    extends AbstractAction {
        public static final String SMALL = "16.gif";

        ButtonAction(String name, String mnemonic, String accelerator, String image, String shortDescription, String longDescription, int actionId) {
            String longString;
            String shortString;
            String imageName;
            String mnemonicString;
            if (name != null) {
                this.putValue("Name", bundle.getString(name));
            }
            if (mnemonic != null && (mnemonicString = bundle.getString(mnemonic)) != null && mnemonicString.length() > 0) {
                this.putValue("MnemonicKey", new Integer(bundle.getString(mnemonic).charAt(0)));
            }
            if (accelerator != null) {
                String acceleratorString = bundle.getString(accelerator);
                if (accelerator != null && acceleratorString.length() > 0) {
                    this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(acceleratorString));
                }
            }
            if (image != null && (imageName = bundle.getString(image)) != null && imageName.length() > 0) {
                imageName = "images/" + imageName + SMALL;
                URL url = this.getClass().getResource(imageName);
                if (url != null) {
                    this.putValue("SmallIcon", new ImageIcon(url));
                }
            }
            if (shortDescription != null && (shortString = bundle.getString(shortDescription)) != null & shortString.length() > 0) {
                this.putValue("ShortDescription", shortString);
            }
            if (longDescription != null && (longString = bundle.getString(longDescription)) != null && longString.length() > 0) {
                this.putValue("LongDescription", longString);
            }
            this.putValue("buttonAction", new Integer(actionId));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Integer value = (Integer)this.getValue("buttonAction");
            switch (value) {
                case 2: {
                    JCalendar.this.yearBackward();
                    break;
                }
                case 3: {
                    JCalendar.this.yearForward();
                    break;
                }
                case 0: {
                    JCalendar.this.monthBackward();
                    break;
                }
                case 1: {
                    JCalendar.this.monthForward();
                }
            }
        }
    }

    private class DayListener
    implements ItemListener {
        private DayListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                int oldDay = JCalendar.this.selectedDay;
                int oldMonth = JCalendar.this.selectedMonth;
                int oldYear = JCalendar.this.selectedYear;
                String dayString = ((JToggleButton)e.getItem()).getText();
                try {
                    JCalendar.this.selectedDay = Integer.parseInt(dayString);
                }
                catch (Exception ex) {
                    JCalendar.this.selectedDay = 1;
                }
                JCalendar.this.selectedMonth = JCalendar.this.displayMonth;
                JCalendar.this.selectedYear = JCalendar.this.displayYear;
                if (oldDay != JCalendar.this.selectedDay || oldMonth != JCalendar.this.selectedMonth || oldYear != JCalendar.this.selectedYear) {
                    JCalendar.this.isNullDate = false;
                    JCalendar.this.selectedCalendar.set(1, JCalendar.this.selectedYear);
                    JCalendar.this.selectedCalendar.set(2, JCalendar.this.selectedMonth);
                    JCalendar.this.selectedCalendar.set(5, JCalendar.this.selectedDay);
                    JCalendar.this.updateCalendarComponents();
                    JCalendar.this.fireDateChange();
                }
            }
        }
    }

    private class TimeListener
    implements ChangeListener {
        Calendar lastTemp = null;
        Calendar temp;

        private TimeListener() {
            this.temp = Calendar.getInstance(JCalendar.this.locale);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Date date = JCalendar.this.spinnerDateModel.getDate();
            if (!JCalendar.this.isNullDate || (JCalendar.this.selectedComponents & 1) == 0) {
                this.temp.setTime(date);
                this.temp.set(1, JCalendar.this.selectedCalendar.get(1));
                this.temp.set(2, JCalendar.this.selectedCalendar.get(2));
                this.temp.set(5, JCalendar.this.selectedCalendar.get(5));
                if (this.lastTemp == null || !this.lastTemp.equals(this.temp)) {
                    JCalendar.this.setDate(this.temp.getTime());
                    this.lastTemp = (Calendar)this.temp.clone();
                }
            }
        }
    }
}

