/*
 * Decompiled with CFR 0.152.
 */
package objects.lang;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import objects.Settings;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.XML.XmlFileWriter;

public class LanguageStrings {
    private Element docEl;
    public static NodeList langNode;
    private static LanguageStrings instance;
    private static String yes;
    private static String no;
    private static String programIsBusy;
    private static String journalCanNotBeSavedToCash;
    private static String areYouSure;
    private static String success;
    private static String restart;

    static {
        yes = null;
        no = null;
        programIsBusy = null;
        journalCanNotBeSavedToCash = null;
        areYouSure = null;
        success = null;
        restart = null;
    }

    public static LanguageStrings getInstance() {
        if (instance == null) {
            instance = new LanguageStrings();
        }
        return instance;
    }

    private LanguageStrings() {
    }

    public void writeToXML(XmlFileWriter writer) throws Exception {
    }

    public String getStringByName(String name) {
        NodeList dataNode = ((Element)langNode.item(0)).getElementsByTagName(name);
        Element elem = (Element)dataNode.item(0);
        return elem.getAttribute("NAME");
    }

    public void readAll() {
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.docEl = db.parse(this.getClass().getResourceAsStream("languages.xml")).getDocumentElement();
            langNode = this.docEl.getElementsByTagName(Settings.getInstance().getLanguage());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static final String getNo() {
        if (no == null) {
            no = LanguageStrings.getInstance().getStringByName("NO");
        }
        return no;
    }

    public static final String getYes() {
        if (yes == null) {
            yes = LanguageStrings.getInstance().getStringByName("YES");
        }
        return yes;
    }

    public static final String getProgramIsBusy() {
        if (programIsBusy == null) {
            programIsBusy = LanguageStrings.getInstance().getStringByName("PROGRAM_IS_BUSY");
        }
        return programIsBusy;
    }

    public static final String getJournalCanNotBeSavedToCash() {
        if (journalCanNotBeSavedToCash == null) {
            journalCanNotBeSavedToCash = LanguageStrings.getInstance().getStringByName("JOURNAL_CAN_NOT_BE_SAVED_TO_CASH");
        }
        return journalCanNotBeSavedToCash;
    }

    public static final String getAreYouSure() {
        if (areYouSure == null) {
            areYouSure = LanguageStrings.getInstance().getStringByName("ARE_YOU_SURE");
        }
        return areYouSure;
    }

    public static final String getSuccess() {
        if (success == null) {
            success = LanguageStrings.getInstance().getStringByName("SUCCESS");
        }
        return success;
    }

    public static final String getRestart() {
        if (restart == null) {
            restart = LanguageStrings.getInstance().getStringByName("RESTART_PROGRAM");
        }
        return restart;
    }
}

