/*
 * Decompiled with CFR 0.152.
 */
package objects.fisctt;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.MainFrame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import objects.Settings;
import objects.fiscal.CommandWrapper;
import objects.fiscal.PLU;
import objects.fiscal.PLU_Wrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.SysUtil;
import util.XML.XmlFileWriter;
import util.comPort.PortSerial;

public class FisCtt {
    public static final int TEST_CONN = 0;
    public static final int DEFINE_ARTICLES = 1;
    public static final int SELL_ARTICLES = 2;
    public static final int DAILY_RAP = 3;
    public static final int CURR_RAP = 4;
    public static final int FINISH_BILL = 5;
    public static final int STORNO_BILL = 6;
    public static final int DELETE_ALL = 7;
    public static final int SEND_ARTICLES = 8;
    public static final int EXIT_APP = 9;
    public static final int READ_ARTICLES = 66;
    public static final int RESET_SOLD = 64;
    public static final int PERIODICAL = 52;
    public static File fileIn = new File(Settings.getInstance().FOLDER_IN, "MainIn.dat");
    public static File fileOut = new File(Settings.getInstance().FOLDER_OUT, "MainOut.dat");
    public static File fileGreska = new File(Settings.getInstance().FOLDER_OUT, "Greska.dat");
    public static File fileArtikli = new File(Settings.getInstance().FOLDER_IN, "Artikli.xml");
    public static File fileArtikliRead = new File(Settings.getInstance().FOLDER_OUT, "ArtikliRead.xml");
    public static File fileArtRacun = new File(Settings.getInstance().FOLDER_IN, "ArtRacun.xml");
    public static File filePlacanja = new File(Settings.getInstance().FOLDER_IN, "Placanja.xml");
    private static byte[] data;

    public static void printError(Exception e) {
        OutputStream out = null;
        try {
            try {
                if (fileOut.exists()) {
                    if (Settings.getInstance().useThreadDeleteOutput) {
                        SysUtil.delay(Settings.getInstance().timeoutDeleteOutput);
                    }
                    fileOut.delete();
                }
                out = new FileOutputStream(fileOut);
                out.write("1".getBytes());
                out.close();
                if (fileGreska.exists()) {
                    if (Settings.getInstance().useThreadDeleteOutput) {
                        SysUtil.delay(Settings.getInstance().timeoutDeleteOutput);
                    }
                    fileGreska.delete();
                }
                out = new FileOutputStream(fileGreska);
                out.write(e.getMessage().getBytes());
                out.close();
            }
            catch (Exception exception) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void printOk() {
        OutputStream out = null;
        try {
            try {
                if (fileOut.exists()) {
                    if (Settings.getInstance().useThreadDeleteOutput) {
                        SysUtil.delay(Settings.getInstance().timeoutDeleteOutput);
                    }
                    fileOut.delete();
                }
                out = new FileOutputStream(fileOut);
                out.write("0".getBytes());
                out.close();
                if (fileGreska.exists()) {
                    if (Settings.getInstance().useThreadDeleteOutput) {
                        SysUtil.delay(Settings.getInstance().timeoutDeleteOutput);
                    }
                    fileGreska.delete();
                }
            }
            catch (Exception exception) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void execute() throws Exception {
        if (Settings.getInstance().useThreadTimeout) {
            SysUtil.delay(Settings.getInstance().timeoutThread);
        }
        data = new byte[128];
        FileInputStream in = new FileInputStream(fileIn);
        int pos = 0;
        int len = 0;
        while ((len = ((InputStream)in).read(data, pos, data.length - pos)) > 0) {
            pos += len;
        }
        ((InputStream)in).close();
        if (Settings.getInstance().useThreadDeleteInput) {
            SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
        }
        fileIn.delete();
        try {
            switch (data[0] - 48) {
                case 0: {
                    FisCtt.executeConnection();
                    break;
                }
                case 1: {
                    FisCtt.defineArticles();
                    break;
                }
                case 66: {
                    FisCtt.readArticles();
                    break;
                }
                case 8: {
                    FisCtt.programmAll();
                    PLU.hash.clear();
                    break;
                }
                case 2: {
                    FisCtt.sellArticles();
                    FisCtt.payBill();
                    break;
                }
                case 5: {
                    FisCtt.payBill();
                    break;
                }
                case 6: {
                    PLU_Wrapper.stornoBILL();
                    break;
                }
                case 3: {
                    CommandWrapper.daily = true;
                    break;
                }
                case 4: {
                    CommandWrapper.state = true;
                    break;
                }
                case 52: {
                    String str = new String(data, 0, pos);
                    SimpleDateFormat sdf = new SimpleDateFormat("ddMMyy");
                    sdf.parse(str.substring(2, 8));
                    CommandWrapper.from = sdf.getCalendar().getTimeInMillis();
                    sdf.parse(str.substring(9, 15));
                    CommandWrapper.to = sdf.getCalendar().getTimeInMillis();
                    CommandWrapper.periodical = true;
                    break;
                }
                case 7: {
                    CommandWrapper.deleteAll = true;
                    break;
                }
                case 64: {
                    CommandWrapper.resetSold = true;
                    break;
                }
                case 9: {
                    System.exit(0);
                }
            }
        }
        finally {
            CommandWrapper.execAll();
        }
    }

    public static void readArticles() throws Exception {
        PLU.readAllFromCR();
        if (Settings.getInstance().useThreadDeleteInput) {
            SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
        }
        if (fileArtikliRead.exists()) {
            fileArtikliRead.delete();
        }
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(fileArtikliRead), "UTF-8");
        XmlFileWriter writer = new XmlFileWriter(out);
        try {
            int size = PLU.vec.size();
            writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
            writer.writeLn("<!DOCTYPE Artikli SYSTEM 'ArtikliRead.dtd'>");
            writer.writeLn("<ArtikliRead>");
            int i = 0;
            while (i < size) {
                PLU art = (PLU)PLU.vec.get(i);
                if (art != null) {
                    if (writer == null) {
                        return;
                    }
                    writer.indent();
                    writer.write("<Plu");
                    writer.write(" Desc='" + XmlFileWriter.compileString(art.desc) + "'");
                    writer.write(" Vat='" + String.valueOf(art.poreskaStopa) + "'");
                    writer.write(" Price='" + SysUtil.putVisibleNumberFormat(art.cena, 2) + "'");
                    writer.write(" Dep='" + String.valueOf(art.odeljenje) + "'");
                    writer.write(" Mes='" + String.valueOf(art.jedinicaMere) + "'");
                    writer.write(" amount='" + SysUtil.putVisibleNumberFormat(art.kolicina, 2) + "'");
                    if (!MainFrame.PRINTER) {
                        writer.write(">" + art.barCode);
                    } else {
                        writer.write(">" + art.code);
                    }
                    writer.writeLn("</Plu>");
                    writer.unintent();
                }
                ++i;
            }
            writer.writeLn("</ArtikliRead>");
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static final void programmAll() throws Exception {
        Command instance = Command.bigInstance;
        PortSerial port = PortSerial.getInstance();
        int descSize = 0;
        Iterator it = PLU.hash.values().iterator();
        while (it.hasNext()) {
            instance.reset();
            instance.setCmd(12);
            while (instance.getPos() + 30 < 512) {
                if (!it.hasNext()) break;
                PLU plu = (PLU)it.next();
                descSize = plu.desc.length();
                if (instance.getPos() + 30 + descSize >= 512) break;
                if (descSize > 34) {
                    descSize = 34;
                }
                if (!MainFrame.PRINTER) {
                    instance.addByte(18 + descSize);
                } else {
                    instance.addByte(9 + descSize);
                }
                instance.addInt(plu.code);
                if (!MainFrame.PRINTER) {
                    instance.addLong(plu.barCode);
                }
                System.out.println("PLU: " + plu.barCode);
                System.out.println("-----------------------------");
                SysUtil.formatForSend(new String(plu.desc), instance);
                if (!MainFrame.PRINTER) {
                    instance.addByte(plu.odeljenje);
                }
                descSize = plu.jedinicaMere;
                descSize &= 0xF;
                descSize <<= 4;
                instance.addByte(descSize |= plu.poreskaStopa & 0xF);
                instance.addInt(plu.cena);
            }
            port.sendFrame(instance);
            Command ccc = port.receiveFrame();
            int e = ccc.getArray()[0] & 0xFF;
            if (12 == ccc.getCmd() || e == 0) continue;
            CommandsErrors.instanceMain.setError(e);
        }
    }

    private static void payBill() throws Exception {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        doc = db.parse(filePlacanja);
        Element artEl = doc.getDocumentElement();
        NodeList dataNode = artEl.getElementsByTagName("Vrsta");
        int dataList = dataNode.getLength();
        int i = 0;
        while (i < dataList) {
            int type;
            Element elem = (Element)dataNode.item(i);
            long amount = SysUtil.parseLong(elem.getAttribute("kol"), 2);
            int pom = type = Integer.parseInt(elem.getTextContent()) - 1;
            if (type == 1) {
                pom = 2;
            }
            if (type == 2) {
                pom = 1;
            }
            type = pom;
            PLU_Wrapper.plati(type, amount);
            ++i;
        }
        try {
            PLU_Wrapper.plati(0, PLU_Wrapper.getDiference());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void sellArticles() throws Exception {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        doc = db.parse(fileArtRacun);
        Element artEl = doc.getDocumentElement();
        NodeList dataNode = artEl.getElementsByTagName("Plu");
        int dataList = dataNode.getLength();
        int i = 0;
        while (i < dataList) {
            Element elem = (Element)dataNode.item(i);
            long amount = SysUtil.parseLong(elem.getAttribute("kol"), 3);
            long barcode = Long.parseLong(elem.getTextContent());
            PLU plu = (PLU)PLU.hash.get(barcode);
            if (plu != null) {
                plu.programmToCR();
                PLU.hash.remove(barcode);
            }
            PLU_Wrapper.prodaj(barcode, (int)amount, false);
            ++i;
        }
    }

    private static void defineArticles() throws Exception {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        doc = db.parse(fileArtikli);
        Element artEl = doc.getDocumentElement();
        NodeList dataNode = artEl.getElementsByTagName("Plu");
        int dataList = dataNode.getLength();
        PLU.hash.clear();
        int i = 0;
        while (i < dataList) {
            Element elem = (Element)dataNode.item(i);
            PLU plu = new PLU();
            plu.desc = elem.getAttribute("Des");
            plu.poreskaStopa = Byte.parseByte(elem.getAttribute("Vat"));
            plu.cena = (int)SysUtil.parseLong(elem.getAttribute("Price"), 2);
            plu.odeljenje = Byte.parseByte(elem.getAttribute("Dep"));
            plu.jedinicaMere = Byte.parseByte(elem.getAttribute("Mes"));
            if (MainFrame.PRINTER) {
                plu.code = Integer.parseInt(elem.getTextContent());
                PLU.hash.put(plu.code, plu);
                System.out.println("DEFINE1 PLU: " + plu.barCode);
            } else {
                plu.barCode = Long.parseLong(elem.getTextContent());
                PLU.hash.put(plu.barCode, plu);
                System.out.println("DEFINE1 PLU: " + plu.barCode);
            }
            ++i;
        }
    }

    private static void executeConnection() throws Exception {
        if (data[2] <= 0) {
            CommandsErrors.throwError(21);
        }
        PortSerial.sPort = "COM" + (data[2] - 48);
        switch (data[4] - 48) {
            case 1: {
                PortSerial.speed = 9600;
                break;
            }
            case 2: {
                PortSerial.speed = 19200;
                break;
            }
            case 3: {
                PortSerial.speed = 38400;
                break;
            }
            case 4: {
                PortSerial.speed = 57600;
                break;
            }
            default: {
                PortSerial.speed = 115200;
            }
        }
        PortSerial.getInstance().test(PortSerial.speed);
    }
}

