/*
 * Decompiled with CFR 0.152.
 */
package objects.fiscal;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import util.SysUtil;
import util.XML.XmlFileWriter;
import util.comPort.PortSerial;

public class Vats {
    public static int[] vats = new int[9];
    public static int[] measure = new int[15];

    public static void readFromPort() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(32);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 32 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        byte[] b = new byte[18];
        System.arraycopy(instance.getArray(), 0, b, 0, b.length);
        int i = 0;
        while (i < 9) {
            int pomi = 0;
            pomi = b[i * 2] & 0xFF;
            Vats.vats[i] = pomi |= (b[i * 2 + 1] & 0xFF) << 8;
            ++i;
        }
    }

    public static String saveToXml(XmlFileWriter writer) throws Exception {
        String s = "";
        s = String.valueOf(s) + writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        s = String.valueOf(s) + writer.writeLn("<VATS>");
        writer.indent();
        s = String.valueOf(s) + writer.write("<DATA");
        int j = 0;
        while (j < vats.length) {
            s = vats[j] < 10000 ? String.valueOf(s) + writer.write(" PS" + j + "='" + SysUtil.putVisibleNumberFormat(vats[j], 2) + "'") : String.valueOf(s) + writer.write(" PS" + j + "='" + "*.**" + "'");
            ++j;
        }
        s = String.valueOf(s) + writer.writeLn("/>");
        writer.unintent();
        s = String.valueOf(s) + writer.writeLn("</VATS>");
        return s;
    }
}

