/*
 * Decompiled with CFR 0.152.
 */
package objects.fiscal;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.rightPanels.LogPanel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import objects.Settings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.SysUtil;
import util.comPort.PortSerial;

public class Users {
    public String ime;
    public long code = 0L;
    public byte level = 0;
    public long finance = 0L;
    public int no;
    private static Users instance;

    public static final Users getInstance() {
        if (instance == null) {
            instance = new Users();
        }
        return instance;
    }

    public final void sendToPort() throws Exception {
        Command instance = Command.instance;
        PortSerial port = PortSerial.getInstance();
        Command.instance.reset();
        Command.instance.setCmd(40);
        instance.addByte(this.no);
        instance.addByte(this.level);
        SysUtil.formatForSend(this.ime, Command.instance);
        int k = this.ime.length();
        while (k++ < 22) {
            instance.addByte(32);
        }
        instance.addLong(this.code);
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 40 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public final void readFromPort() throws Exception {
        long v;
        Command instance = Command.instance;
        PortSerial port = PortSerial.getInstance();
        Command.instance.reset();
        Command.instance.setCmd(38);
        instance.addByte(this.no);
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 38 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        this.level = Command.instance.getArray()[1];
        byte[] bb = new byte[22];
        System.arraycopy(Command.instance.getArray(), 2, bb, 0, 22);
        this.ime = SysUtil.formatForReceive(bb);
        this.code = v = Command.instance.getLong(24);
        this.finance = v = Command.instance.getLong(32);
    }

    public static final void readFromXML(File file) throws Exception {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        doc = db.parse(file);
        Element docEl = doc.getDocumentElement();
        NodeList dataNode = docEl.getElementsByTagName("DATA");
        int dataList = dataNode.getLength();
        int i = 0;
        while (i < dataList) {
            Element elem = (Element)dataNode.item(i);
            if (elem == null) {
                return;
            }
            Users user = new Users();
            user.no = Integer.parseInt(elem.getAttribute("NO"));
            user.code = Long.parseLong(elem.getAttribute("CODE"));
            user.ime = elem.getAttribute("NAME");
            user.level = Byte.parseByte(elem.getAttribute("LEVEL"));
            user.sendToPort();
            ++i;
        }
    }

    public static void readFromTXT(File file) throws Exception {
        if (Settings.getInstance().useThreadTimeout) {
            SysUtil.delay(Settings.getInstance().timeoutThread);
        }
        BufferedReader input = new BufferedReader(new FileReader(file));
        String str = null;
        String name = file.getName();
        try {
            try {
                if (file.length() <= 1L) {
                    throw new Exception("File is too small!");
                }
                LogPanel.println("FILE CONTENT START:");
                while ((str = input.readLine()) != null) {
                    LogPanel.println(str);
                    Users user = new Users();
                    user.no = Integer.parseInt(str.substring(0, 1));
                    user.level = Byte.parseByte(str.substring(1, 2));
                    user.ime = str.substring(2, 24).trim();
                    LogPanel.println("FILE CONTENT START: " + str.substring(24, str.length()));
                    user.code = Long.parseLong(str.substring(24, str.length()));
                    user.sendToPort();
                }
                LogPanel.println("FILE CONTENT END:");
                SysUtil.writeOkFile(name);
            }
            catch (Exception e) {
                SysUtil.writeErrorFile(name, e);
                input.close();
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
        }
        finally {
            input.close();
            if (Settings.getInstance().useThreadDeleteInput) {
                SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
            }
            file.delete();
        }
    }

    public void parseUsrString(String str) throws Exception {
        HCPStringTokenizer st = new HCPStringTokenizer(str, ',');
        Users user = new Users();
        user.no = Integer.parseInt(st.nextToken().replaceAll("\"", ""));
        user.ime = st.nextToken().replaceAll("\"", "");
        user.code = Long.parseLong(st.nextToken().replaceAll("\"", ""));
        user.level = Byte.parseByte(st.nextToken().replaceAll("\"", ""));
        user.sendToPort();
    }

    public static final void readFromCSV(File file) throws Exception {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        doc = db.parse(file);
        Element docEl = doc.getDocumentElement();
        NodeList dataNode = docEl.getElementsByTagName("DATA");
        int dataList = dataNode.getLength();
        int i = 0;
        while (i < dataList) {
            Element elem = (Element)dataNode.item(i);
            if (elem == null) {
                return;
            }
            Users user = new Users();
            user.no = Integer.parseInt(elem.getAttribute("NO"));
            user.code = Long.parseLong(elem.getAttribute("CODE"));
            user.ime = elem.getAttribute("NAME");
            user.level = Byte.parseByte(elem.getAttribute("LEVEL"));
            user.sendToPort();
            ++i;
        }
    }

    public static void login(int code) throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(42);
        instance.addInt(code);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        int command = instance.getCmd();
        if (command != 42 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    private static class HCPStringTokenizer {
        private String string;
        private char token;
        private int pos;

        public HCPStringTokenizer(String str, char tok) {
            this.string = str;
            this.token = tok;
            this.pos = 0;
        }

        public String nextToken() {
            String s = "";
            char c = '\u0000';
            while (true) {
                if (this.pos == this.string.length()) {
                    return s;
                }
                if ((c = this.string.charAt(this.pos++)) == this.token) break;
                s = String.valueOf(s) + c;
            }
            return s;
        }
    }
}

