/*
 * Decompiled with CFR 0.152.
 */
package objects.fiscal;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.MainFrame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import objects.Settings;
import objects.fiscal.Measures;
import objects.fiscal.PLU;
import objects.fiscal.Vats;
import util.SysUtil;
import util.XML.XmlFileWriter;
import util.comPort.PortSerial;

public class State {
    public long billNumber = 0L;
    public int dailyNumber = 0;
    public long medjuzbir;
    public long razlika;
    public long kes;
    public long kartica;
    public long cek;
    public int brojArtikala;
    public long kesDI;
    public long karticaDI;
    public long cekDI;
    public int brojDI;
    public long[] vatsDI = new long[9];
    public String IBFM;
    public String PIB;
    public String fiscalisationTime;
    public String currentTime;
    public Vector artikli = new Vector();
    private static State instance = new State();

    public static State getInstance() {
        return instance;
    }

    private State() {
    }

    public void readBillState() throws Exception {
        this.artikli.removeAllElements();
        Command instance = Command.instance;
        PortSerial port = PortSerial.getInstance();
        instance.reset();
        instance.setCmd(56);
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        if (Command.instance.getCmd() != 56 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        this.medjuzbir = instance.getLong(0);
        this.razlika = instance.getLong(8);
        this.kes = instance.getLong(20);
        this.kartica = instance.getLong(28);
        this.cek = instance.getLong(36);
        this.brojArtikala = instance.getInt(16);
        int i = 0;
        while (i < this.brojArtikala) {
            instance.reset();
            instance.setCmd(57);
            instance.addInt(i);
            port.sendFrame(instance);
            port.receiveFrame(instance);
            e = instance.getArray()[0] & 0xFF;
            if (Command.instance.getCmd() != 57 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
            SoldArticle sa = new SoldArticle();
            sa.code = instance.getInt(0);
            sa.amount = instance.getInt(4);
            this.artikli.add(sa);
            ++i;
        }
    }

    public void readTime() throws Exception {
        PortSerial port = PortSerial.getInstance();
        Command.instance.reset();
        Command.instance.setCmd(2);
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 2 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        long tt = Command.instance.getLong(0) + 946684800000L;
        SimpleDateFormat dataf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.currentTime = dataf.format(new Date(tt));
    }

    public void readRegisterState() throws Exception {
        int billNumberAddressBest = 1005684;
        int billNumberAddressBestLcPlus = 499644;
        int billNumberAddressPrima = 271352;
        int billNumberAddress = 1005732;
        int dailyNumberAddressPrima = 271336;
        Command instance = Command.bigInstance;
        instance.reset();
        instance.setCmd(9);
        if (MainFrame.PRINTER) {
            instance.addInt(billNumberAddress);
        } else if (MainFrame.BESTLCPLUS) {
            instance.addInt(billNumberAddressBestLcPlus);
        } else if (MainFrame.PRIMA) {
            instance.addInt(billNumberAddressPrima);
        } else {
            instance.addInt(billNumberAddressBest);
        }
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        Command outComm = port.receiveFrame();
        int e = outComm.getArray()[0] & 0xFF;
        int command = outComm.getCmd();
        if (command != 9 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        this.billNumber = outComm.getInt(4);
        if (MainFrame.PRIMA) {
            instance.reset();
            instance.setCmd(9);
            instance.addInt(dailyNumberAddressPrima);
            port.sendFrame(instance);
            outComm = port.receiveFrame();
            e = outComm.getArray()[0] & 0xFF;
            command = outComm.getCmd();
            if (command != 9 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
            this.dailyNumber = outComm.getInt(4);
        } else {
            int COMMAND_DFP = 12;
            instance.reset();
            instance.setCmd(55);
            port.sendFrame(instance);
            outComm = port.receiveFrame();
            e = outComm.getArray()[0] & 0xFF;
            command = outComm.getCmd();
            if (command != 55 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
            this.dailyNumber = outComm.getInt(COMMAND_DFP);
        }
        Command.instance.reset();
        Command.instance.setCmd(3);
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        e = Command.instance.getArray()[0] & 0xFF;
        command = Command.instance.getCmd();
        if (command != 3 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        long pom = Command.instance.getLong(0);
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy,HH:mm:ss");
        Date d = new Date(pom);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.fiscalisationTime = sdf.format(d);
        byte[] b = new byte[8];
        System.arraycopy(Command.instance.getArray(), 8, b, 0, b.length);
        this.IBFM = SysUtil.formatForReceive(b);
        this.PIB = "";
        int i = 16;
        while (i < 25) {
            this.PIB = String.valueOf(this.PIB) + (char)Command.instance.getArray()[i];
            ++i;
        }
        this.readTime();
        if (MainFrame.PRINTER) {
            Command.instance.reset();
            Command.instance.setCmd(56);
            port.sendFrame(Command.instance);
            port.receiveFrame(Command.instance);
            e = Command.instance.getArray()[0] & 0xFF;
            command = Command.instance.getCmd();
            if (command != 56 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
            this.billNumber = Command.instance.getInt(44);
        }
    }

    public void readDIState() throws Exception {
        Command instance = Command.instance;
        PortSerial port = PortSerial.getInstance();
        instance.reset();
        instance.setCmd(86);
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        if (Command.instance.getCmd() != 86 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        int pos = 0;
        this.brojDI = instance.getInt(pos);
        pos += 4;
        int i = 0;
        while (i < 9) {
            this.vatsDI[i] = instance.getLong(pos);
            pos += 8;
            ++i;
        }
        this.kesDI = instance.getLong(pos);
        this.karticaDI = instance.getLong(pos += 8);
        this.cekDI = instance.getLong(pos += 8);
        pos += 8;
    }

    private String writeBillState(XmlFileWriter writer) throws IOException {
        String s = "";
        s = String.valueOf(s) + writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        s = String.valueOf(s) + writer.writeLn("<STANJE_RACUNA MEDJUZBIR='" + this.medjuzbir + "'" + " RAZLIKA='" + this.razlika + "'" + " KES='" + this.kes + "'" + " KARTICA='" + this.kartica + "'" + " CEK='" + this.cek + "'" + " BROJ_ARTIKALA='" + this.brojArtikala + "'" + " >");
        int i = 0;
        while (i < this.artikli.size()) {
            SoldArticle art = (SoldArticle)this.artikli.elementAt(i);
            writer.indent();
            s = String.valueOf(s) + writer.write("<PLU KOD='" + art.code + "'");
            s = String.valueOf(s) + writer.write(" KOLICINA='" + art.amount + "'");
            s = String.valueOf(s) + writer.writeLn(">");
            s = String.valueOf(s) + writer.writeLn("</PLU>");
            writer.unintent();
            ++i;
        }
        s = String.valueOf(s) + writer.writeLn("</STANJE_RACUNA>");
        return s;
    }

    private String writeRegisterState(XmlFileWriter writer) throws IOException {
        String s = "";
        s = String.valueOf(s) + writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        s = String.valueOf(s) + writer.write("<STANJE_KASE BROJ_RACUNA='" + this.billNumber + "'");
        s = String.valueOf(s) + writer.write(" BROJ_DNEVNOG_IZVESTAJA='" + this.dailyNumber + "'");
        s = String.valueOf(s) + writer.write(" VREME='" + this.currentTime + "'");
        s = String.valueOf(s) + writer.write(" IBFM='" + this.IBFM + "'");
        s = String.valueOf(s) + writer.write(" PIB='" + this.PIB + "'");
        s = String.valueOf(s) + writer.write(" VREME_FISKALIZACIJE='" + this.fiscalisationTime + "'");
        s = String.valueOf(s) + writer.writeLn(">");
        s = String.valueOf(s) + writer.writeLn("</STANJE_KASE>");
        return s;
    }

    private String writeDIState(XmlFileWriter writer) throws IOException {
        String s = "";
        s = String.valueOf(s) + writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        s = String.valueOf(s) + writer.write("<STANJE_DI BROJ_DNEVNOG_IZVESTAJA='" + this.brojDI + "'" + " KES='" + this.kesDI + "'" + " KARTICA='" + this.karticaDI + "'" + " CEK='" + this.cekDI + "'");
        s = String.valueOf(s) + writer.writeLn(">");
        int i = 0;
        while (i < 9) {
            writer.indent();
            s = String.valueOf(s) + writer.write("<PS SUMA='" + this.vatsDI[i] + "'");
            s = String.valueOf(s) + writer.writeLn(">");
            s = String.valueOf(s) + writer.writeLn("</PS>");
            writer.unintent();
            ++i;
        }
        s = String.valueOf(s) + writer.writeLn("</STANJE_DI>");
        return s;
    }

    public String writeBill() throws Exception {
        this.readBillState();
        File file = new File(Settings.getInstance().FOLDER_OUT, "bill_state.xml");
        file.mkdirs();
        if (file.exists()) {
            file.delete();
        }
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        XmlFileWriter xmlWriter = new XmlFileWriter(out);
        try {
            String string = this.writeBillState(xmlWriter);
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public String writeRegister() throws Exception {
        this.readRegisterState();
        File file = new File(Settings.getInstance().FOLDER_OUT, "register_state.xml");
        file.mkdirs();
        if (file.exists()) {
            file.delete();
        }
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        XmlFileWriter xmlWriter = new XmlFileWriter(out);
        try {
            String string = this.writeRegisterState(xmlWriter);
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public String writeDI() throws Exception {
        this.readDIState();
        File file = new File(Settings.getInstance().FOLDER_OUT, "z_state.xml");
        file.mkdirs();
        if (file.exists()) {
            file.delete();
        }
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        XmlFileWriter xmlWriter = new XmlFileWriter(out);
        try {
            String string = this.writeDIState(xmlWriter);
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public void isFiscalDayStarted() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(61);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        int command = instance.getCmd();
        if (command != 61 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        int ts = instance.getShort(20);
        long tl = instance.getLong(22);
        instance.reset();
        instance.setCmd(62);
        instance.addShort(ts);
        instance.addLong(tl);
        port.sendFrame(instance);
        port.receiveFrame(instance);
        e = instance.getArray()[0] & 0xFF;
        command = instance.getCmd();
        if (command != 62 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public String writeArticles() throws Exception {
        PLU.readAllFromCR();
        File file = new File(Settings.getInstance().FOLDER_OUT, "articles.xml");
        file.mkdirs();
        if (file.exists()) {
            file.delete();
        }
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        XmlFileWriter xmlWriter = new XmlFileWriter(out);
        try {
            String string = PLU.saveArticlesToFile(xmlWriter);
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public String writeArticle() throws Exception {
        PLU.readArticleFromCR();
        File file = new File(Settings.getInstance().FOLDER_OUT, "article.xml");
        file.mkdirs();
        if (file.exists()) {
            file.delete();
        }
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        XmlFileWriter xmlWriter = new XmlFileWriter(out);
        try {
            String string = PLU.saveArticleToFile(xmlWriter);
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public void getDailyData(int num) throws Exception {
        PortSerial port = PortSerial.getInstance();
        Command.instance.reset();
        Command.instance.setCmd(91);
        Command.instance.addShort(num);
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 91 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        int len = Command.instance.getLength() - 1;
        File file = new File(Settings.getInstance().FOLDER_OUT, "daily_" + num + ".txt");
        file.mkdirs();
        if (file.exists()) {
            file.delete();
        }
        try (FileOutputStream out = null;){
            out = new FileOutputStream(file);
            ((OutputStream)out).write(Command.instance.getArray(), 0, len);
            out.flush();
        }
    }

    public void readFiscalData() throws Exception {
        File file = new File(Settings.getInstance().FOLDER_OUT, "Fiscal.txt");
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream out = null;
        out = new FileOutputStream(file);
        PortSerial port = PortSerial.getInstance();
        try {
            int len;
            Command.instance.reset();
            Command.instance.setCmd(3);
            port.sendFrame(Command.instance);
            port.receiveFrame(Command.instance);
            ((OutputStream)out).write(Command.instance.getArray(), 16, 9);
            ((OutputStream)out).write(32);
            ((OutputStream)out).write(Command.instance.getArray(), 8, 8);
            ((OutputStream)out).write(13);
            ((OutputStream)out).write(10);
            Command.instance.reset();
            Command.instance.setCmd(3);
            port.sendFrame(Command.instance);
            port.receiveFrame(Command.instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != 3 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
            int numDaily = Command.instance.getInt(25);
            if (MainFrame.PRIMA) {
                numDaily = this.getNumDailyPrima(port);
            }
            ++numDaily;
            int i = 1;
            while (i < numDaily) {
                Command.instance.reset();
                Command.instance.setCmd(91);
                Command.instance.addShort(i);
                port.sendFrame(Command.instance);
                port.receiveFrame(Command.instance);
                e = Command.instance.getArray()[0] & 0xFF;
                command = Command.instance.getCmd();
                if (command != 91 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                int len2 = Command.instance.getLength() - 1;
                ((OutputStream)out).write(Command.instance.getArray(), 0, len2);
                ++i;
            }
            file = new File(Settings.getInstance().FOLDER_OUT, "Vats.txt");
            if (file.exists()) {
                file.delete();
            }
            out = new FileOutputStream(file);
            Command.instance.reset();
            Command.instance.setCmd(3);
            port.sendFrame(Command.instance);
            port.receiveFrame(Command.instance);
            e = Command.instance.getArray()[0] & 0xFF;
            command = Command.instance.getCmd();
            if (command != 3 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
            int num = Command.instance.getInt(33);
            ((OutputStream)out).write(Command.instance.getArray(), 16, 9);
            ((OutputStream)out).write(32);
            ((OutputStream)out).write(Command.instance.getArray(), 8, 8);
            ((OutputStream)out).write(13);
            ((OutputStream)out).write(10);
            ++num;
            int i2 = 1;
            while (i2 < num) {
                Command.instance.reset();
                Command.instance.setCmd(93);
                Command.instance.addShort(i2);
                port.sendFrame(Command.instance);
                port.receiveFrame(Command.instance);
                e = Command.instance.getArray()[0] & 0xFF;
                command = Command.instance.getCmd();
                if (command != 93 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                len = Command.instance.getLength();
                ((OutputStream)out).write(Command.instance.getArray(), 0, len - 1);
                ++i2;
            }
            file = new File(Settings.getInstance().FOLDER_OUT, "Resets.txt");
            if (file.exists()) {
                file.delete();
            }
            out = new FileOutputStream(file);
            Command.instance.reset();
            Command.instance.setCmd(3);
            port.sendFrame(Command.instance);
            port.receiveFrame(Command.instance);
            e = Command.instance.getArray()[0] & 0xFF;
            command = Command.instance.getCmd();
            if (command != 3 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
            num = Command.instance.getInt(29);
            ((OutputStream)out).write(Command.instance.getArray(), 16, 9);
            ((OutputStream)out).write(32);
            ((OutputStream)out).write(Command.instance.getArray(), 8, 8);
            ((OutputStream)out).write(13);
            ((OutputStream)out).write(10);
            ++num;
            i2 = 1;
            while (i2 < num) {
                Command.instance.reset();
                Command.instance.setCmd(92);
                Command.instance.addShort(i2);
                port.sendFrame(Command.instance);
                port.receiveFrame(Command.instance);
                e = Command.instance.getArray()[0] & 0xFF;
                command = Command.instance.getCmd();
                if (command != 92 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                len = Command.instance.getLength() - 1;
                ((OutputStream)out).write(Command.instance.getArray(), 0, len);
                ++i2;
            }
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    public String writeSoldArticles() throws Exception {
        PLU.readAllSold();
        File file = new File(Settings.getInstance().FOLDER_OUT, "sold_articles.xml");
        file.mkdirs();
        if (file.exists()) {
            file.delete();
        }
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        XmlFileWriter xmlWriter = new XmlFileWriter(out);
        try {
            String string = PLU.saveSoldArticlesToFile(xmlWriter);
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public String readVats() throws Exception {
        Vats.readFromPort();
        File file = new File(Settings.getInstance().FOLDER_OUT, "vats.xml");
        file.mkdirs();
        if (file.exists()) {
            file.delete();
        }
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        XmlFileWriter xmlWriter = new XmlFileWriter(out);
        try {
            String string = Vats.saveToXml(xmlWriter);
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public String readMeasure() throws Exception {
        Measures.readMeasureFromPort();
        File file = new File(Settings.getInstance().FOLDER_OUT, "measures.xml");
        file.mkdirs();
        if (file.exists()) {
            file.delete();
        }
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        XmlFileWriter xmlWriter = new XmlFileWriter(out);
        try {
            String string = Measures.saveToXml(xmlWriter);
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public String writeUserCommandReply(Command cmd) throws Exception {
        File file = new File(Settings.getInstance().FOLDER_OUT, "user_command_reply.xml");
        file.mkdirs();
        if (file.exists()) {
            file.delete();
        }
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        XmlFileWriter xmlWriter = new XmlFileWriter(out);
        try {
            String string = this.writeUserCommandReply(xmlWriter, cmd);
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private String writeUserCommandReply(XmlFileWriter writer, Command cmd) throws Exception {
        String s = "";
        s = String.valueOf(s) + writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        s = String.valueOf(s) + writer.writeLn("<REPLY>");
        writer.indent();
        int i = 0;
        while (i < cmd.getLength()) {
            s = String.valueOf(s) + writer.write("<DATA BYTE='" + cmd.getByte(i) + "'");
            s = String.valueOf(s) + writer.writeLn(" />");
            ++i;
        }
        writer.unintent();
        s = String.valueOf(s) + writer.writeLn("</REPLY>");
        return s;
    }

    private int getNumDailyPrima(PortSerial port) throws Exception {
        int dailyAddress = 271336;
        Command instance = Command.bigInstance;
        instance.reset();
        instance.setCmd(9);
        instance.addInt(dailyAddress);
        port.sendFrame(instance);
        Command outComm = port.receiveFrame();
        int e = outComm.getArray()[0] & 0xFF;
        int command = outComm.getCmd();
        if (command != 9 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        int numDaily = outComm.getInt(4);
        return numDaily;
    }

    public static class SoldArticle {
        public int code;
        public int amount;
    }
}

