/*
 * Decompiled with CFR 0.152.
 */
package objects.fiscal;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.MainFrame;
import objects.fiscal.PLU;
import util.comPort.PortSerial;

public class PLU_Wrapper {
    public static void prodaj(long barCode, int kolicina, boolean saleByCode) throws Exception {
        if (MainFrame.PRINTER) {
            saleByCode = true;
        }
        PortSerial port = PortSerial.getInstance();
        Command instance = Command.instance;
        instance.reset();
        if (saleByCode) {
            instance.setCmd(48);
            instance.addInt((int)barCode);
        } else {
            instance.setCmd(49);
            instance.addLong(barCode);
        }
        instance.addInt(kolicina);
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 48 && command != 49 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static void prodajKaoP2DS(long barCode, int kolicina, boolean saleByCode) throws Exception {
        int br = PLU_Wrapper.checkAmount(kolicina);
        boolean brSent = false;
        PortSerial port = PortSerial.getInstance();
        Command instance = Command.instance;
        if (br > 4) {
            int i = 0;
            while (i < 2) {
                if (MainFrame.PRINTER) {
                    saleByCode = true;
                }
                instance.reset();
                if (saleByCode) {
                    instance.setCmd(48);
                    instance.addInt((int)barCode);
                } else {
                    instance.setCmd(49);
                    instance.addLong(barCode);
                }
                if (!brSent) {
                    instance.addInt(kolicina / 1000 * 1000);
                    brSent = true;
                } else {
                    instance.addInt(kolicina % 1000);
                }
                port.sendFrame(instance);
                port.receiveFrame(instance);
                int e = Command.instance.getArray()[0] & 0xFF;
                int command = Command.instance.getCmd();
                if (command != 48 && command != 49 && command != 128 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                ++i;
            }
        } else {
            if (MainFrame.PRINTER) {
                saleByCode = true;
            }
            instance.reset();
            if (saleByCode) {
                instance.setCmd(48);
                instance.addInt((int)barCode);
            } else {
                instance.setCmd(49);
                instance.addLong(barCode);
            }
            instance.addInt(kolicina);
            port.sendFrame(instance);
            port.receiveFrame(instance);
            int e1 = Command.instance.getArray()[0] & 0xFF;
            int command1 = Command.instance.getCmd();
            if (command1 != 48 && command1 != 49 && command1 != 128 && e1 != 0) {
                CommandsErrors.instanceMain.setError(e1);
            }
        }
    }

    public static int checkAmount(int kolicina) {
        int decbr = 0;
        int cbr = 1;
        int br = 0;
        int kolicina2 = kolicina;
        int kolicina3 = kolicina / 1000;
        if (kolicina2 % 1000 > 0) {
            int pom = kolicina2 % 1000;
            while (pom % 10 == 0) {
                pom /= 10;
                kolicina2 /= 10;
                ++decbr;
            }
            if (kolicina3 > 0) {
                int pom1 = kolicina3;
                while (pom1 / 10 > 0) {
                    pom1 /= 10;
                    ++cbr;
                }
            }
            br = cbr + (3 - decbr);
        }
        return br;
    }

    public static void plati(int tip, long value) throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(51);
        instance.addLong(value);
        instance.addByte(tip);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 51 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static void stornoLast() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(50);
        instance.addInt(0);
        instance.addInt(100);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 50 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static void stornoArticle(int code) throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(50);
        instance.addInt(code);
        instance.addInt(0);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 50 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static void stornoArticle(long code, int kolicina, boolean byCode) throws Exception {
        if (MainFrame.PRINTER) {
            byCode = true;
        }
        if (!byCode) {
            PLU pomPLU = new PLU();
            pomPLU.readFromCR_BARCode(code);
            code = pomPLU.code;
        }
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(50);
        instance.addInt((int)code);
        instance.addInt(kolicina);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 50 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static void stornoBILL() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(50);
        instance.addInt(65535);
        instance.addInt(1000);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 50 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static long getDiference() throws Exception {
        Command instance = Command.instance;
        PortSerial port = PortSerial.getInstance();
        instance.reset();
        instance.setCmd(56);
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        if (Command.instance.getCmd() != 56 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        return instance.getLong(0);
    }
}

