/*
 * Decompiled with CFR 0.152.
 */
package objects.fiscal;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.MainFrame;
import java.util.HashMap;
import java.util.Vector;
import objects.Settings;
import objects.fiscal.PLU_Wrapper;
import objects.fiscal.State;
import util.BufferByte;
import util.SysUtil;
import util.XML.XmlFileWriter;
import util.comPort.PortSerial;

public class PLU {
    private static final String empStr = "";
    public String desc = "";
    public long barCode = -1L;
    public int code = -1;
    public int cena;
    public byte poreskaStopa;
    public byte jedinicaMere;
    public byte odeljenje;
    public long prodato;
    public long kolicina;
    public static Vector vecNew = new Vector();
    public static Vector vecDelCode = new Vector();
    public static Vector vecDelBarcode = new Vector();
    public static Vector vecPrice = new Vector();
    public static Vector vecPriceBarcode = new Vector();
    public static Vector vecBon = new Vector();
    public static Vector vecPay = new Vector();
    public static Vector vec = new Vector();
    public Vector vecJSON = new Vector();
    public static HashMap hash = new HashMap();
    public static int kod;
    public static final int EMPTY_CODE = -1;
    public static final long EMPTY_BAR_CODE = -1L;

    public final void programmToCR() throws Exception {
        Command.instance.reset();
        Command.instance.setCmd(12);
        Command instance = Command.instance;
        int t = this.desc.length();
        if (t > 34) {
            t = 34;
        }
        instance.addInt(this.code);
        if (!MainFrame.PRINTER) {
            instance.addLong(this.barCode);
        }
        SysUtil.formatForSend(this.desc, instance);
        if (!MainFrame.PRINTER) {
            instance.addByte(this.odeljenje);
        }
        t = this.jedinicaMere;
        t &= 0xF;
        t <<= 4;
        instance.addByte(t |= this.poreskaStopa & 0xF);
        instance.addInt(this.cena);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        if (12 != Command.instance.getCmd() && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public final void deleteFROMCR_barCode() throws Exception {
        Command.instance.reset();
        Command.instance.setCmd(18);
        Command instance = Command.instance;
        instance.addLong(this.barCode);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        if (18 != Command.instance.getCmd() && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public final void readFromCR_BARCode(long barcode) throws Exception {
        Command.instance.reset();
        Command.instance.setCmd(10);
        Command instance = Command.instance;
        instance.addLong(barcode);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        if (10 != Command.instance.getCmd() && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        this.dodeli();
    }

    private final void dodeli() {
        Command cmd = Command.instance;
        byte[] bb = new byte[34];
        this.poreskaStopa = 0;
        this.jedinicaMere = 0;
        this.odeljenje = 0;
        this.code = cmd.getShort(0) & 0xFFFF;
        this.barCode = cmd.getLong(4, 8);
        System.arraycopy(cmd.getArray(), 12, bb, 0, bb.length);
        this.desc = SysUtil.formatForReceive(bb);
        this.prodato = cmd.getLong(46, 6) & 0xFFFFFFFFFFFFL;
        this.kolicina = cmd.getLong(52, 6) & 0xFFFFFFFFFFFFL;
        this.odeljenje = (byte)(this.odeljenje | (byte)cmd.getByte(58));
        this.jedinicaMere = (byte)(this.jedinicaMere | ((byte)cmd.getByte(59) & 0xF0) >> 4);
        this.poreskaStopa = (byte)(this.poreskaStopa | (byte)cmd.getByte(59) & 0xF);
        this.cena = cmd.getInt(60);
    }

    public void changePriceByCode(int cena) throws Exception {
        Command instance = Command.bigInstance;
        instance.reset();
        instance.setCmd(11);
        instance.addInt(this.code);
        instance.addInt(cena);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        Command ccc = port.receiveFrame();
        int e = ccc.getArray()[0] & 0xFF;
        if (11 != ccc.getCmd() && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static void changeAllPrices() throws Exception {
        if (vecPrice.size() <= 0) {
            return;
        }
        Command instance = Command.bigInstance;
        int i = 0;
        int t = 0;
        int nn = vecPrice.size();
        while (i < nn) {
            instance.reset();
            instance.setCmd(11);
            int pos = 0;
            while (i < nn) {
                if (t < 0 || t >= vecPrice.size()) {
                    ++i;
                    break;
                }
                PLU plu = (PLU)vecPrice.elementAt(t);
                if (plu.code <= 0) {
                    vecPriceBarcode.add(plu);
                    ++i;
                    ++t;
                    continue;
                }
                instance.addInt(plu.code);
                instance.addInt(plu.cena);
                ++i;
                ++t;
                if (++pos == 60) break;
            }
            if (pos == 0) {
                return;
            }
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(instance);
            Command ccc = port.receiveFrame();
            int e = ccc.getArray()[0] & 0xFF;
            if (11 == ccc.getCmd() || e == 0) continue;
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static void changeAllPricesBarcode() throws Exception {
        if (MainFrame.PRINTER) {
            return;
        }
        if (vecPriceBarcode.size() <= 0) {
            return;
        }
        int j = 0;
        while (j < vecPriceBarcode.size()) {
            PLU plu = (PLU)vecPriceBarcode.elementAt(j);
            if (plu.barCode > 0L && plu.cena > 0 && plu.kolicina > 0L) {
                PLU pomPLU = new PLU();
                pomPLU.readFromCR_BARCode(plu.barCode);
                pomPLU.changePriceByCode(plu.cena);
            }
            ++j;
        }
    }

    private static void changeAllPricesBon() throws Exception {
        if (vecBon.size() <= 0) {
            return;
        }
        try {
            State.getInstance().readBillState();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Command instance = Command.bigInstance;
        int i = 0;
        int t = 0;
        int nn = vecBon.size();
        while (i < nn) {
            instance.reset();
            instance.setCmd(11);
            int pos = 0;
            while (i < nn) {
                State.SoldArticle art;
                if (t < 0 || t >= vecBon.size()) {
                    ++i;
                    break;
                }
                PLU plu = (PLU)vecBon.elementAt(t);
                if (plu.cena <= 0 || plu.kolicina <= 0L) {
                    ++i;
                    ++t;
                    continue;
                }
                if (!MainFrame.PRINTER && plu.barCode > 32000L) {
                    vecPriceBarcode.add(plu);
                    ++i;
                    ++t;
                    continue;
                }
                boolean ex = false;
                int j = 0;
                while (j < State.getInstance().artikli.size()) {
                    art = (State.SoldArticle)State.getInstance().artikli.elementAt(j);
                    if (plu.barCode == (long)art.code) {
                        ex = true;
                        break;
                    }
                    ++j;
                }
                if (ex) {
                    ++i;
                    ++t;
                    continue;
                }
                art = new State.SoldArticle();
                art.code = (int)plu.barCode;
                art.amount = (int)plu.kolicina;
                State.getInstance().artikli.add(art);
                instance.addInt((int)plu.barCode);
                instance.addInt(plu.cena);
                ++i;
                ++t;
                if (++pos == 60) break;
            }
            if (pos == 0) {
                return;
            }
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(instance);
            Command ccc = port.receiveFrame();
            int e = ccc.getArray()[0] & 0xFF;
            if (11 == ccc.getCmd() || e == 0) continue;
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static final void programmAll() throws Exception {
        int descSize = 0;
        int i = 0;
        if (vecNew.size() == 1) {
            PLU plu = (PLU)vecNew.elementAt(0);
            plu.programmToCR();
            return;
        }
        Command instance = Command.bigInstance;
        PortSerial port = PortSerial.getInstance();
        while (i < vecNew.size()) {
            instance.reset();
            instance.setCmd(12);
            while (instance.getPos() + 30 < 512) {
                if (i >= vecNew.size()) break;
                PLU plu = (PLU)vecNew.elementAt(i);
                descSize = plu.desc.length();
                if (instance.getPos() + 30 + descSize >= 512) break;
                if (descSize > 34) {
                    descSize = 34;
                }
                if (!MainFrame.PRINTER) {
                    instance.addByte(18 + descSize);
                } else {
                    instance.addByte(9 + descSize);
                }
                instance.addInt(plu.code);
                if (!MainFrame.PRINTER) {
                    instance.addLong(plu.barCode);
                }
                SysUtil.formatForSend(new String(plu.desc), instance);
                if (!MainFrame.PRINTER) {
                    instance.addByte(plu.odeljenje);
                }
                descSize = plu.jedinicaMere;
                descSize &= 0xF;
                descSize <<= 4;
                instance.addByte(descSize |= plu.poreskaStopa & 0xF);
                instance.addInt(plu.cena);
                ++i;
            }
            port.sendFrame(instance);
            Command ccc = port.receiveFrame();
            int e = ccc.getArray()[0] & 0xFF;
            if (12 == ccc.getCmd() || e == 0) continue;
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static void deleteAllByBarcode() throws Exception {
        if (vecDelBarcode.size() <= 0) {
            return;
        }
        int j = 0;
        while (j < vecDelBarcode.size()) {
            PLU plu = (PLU)vecDelBarcode.elementAt(j);
            plu.deleteFROMCR_barCode();
            ++j;
        }
    }

    public static final void deleteAllByCode() throws Exception {
        if (vecDelCode.size() <= 0) {
            return;
        }
        Command instance = Command.bigInstance;
        int i = 0;
        int t = 0;
        int nn = vecDelCode.size();
        while (i < nn) {
            instance.reset();
            instance.setCmd(13);
            int pos = 0;
            while (i < nn) {
                if (t < 0 || t >= vecDelCode.size()) {
                    ++i;
                    break;
                }
                PLU plu = (PLU)vecDelCode.elementAt(t);
                if (plu.code <= 0) {
                    vecDelBarcode.add(plu);
                    ++i;
                    ++t;
                    continue;
                }
                instance.addInt(plu.code);
                ++i;
                ++t;
                if (++pos == 120) break;
            }
            if (pos == 0) {
                return;
            }
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(instance);
            Command ccc = port.receiveFrame();
            int e = ccc.getArray()[0] & 0xFF;
            if (13 == ccc.getCmd() || e == 0 || e == 18) continue;
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static void sellAll() throws Exception {
        if (vecBon.size() <= 0) {
            return;
        }
        try {
            PLU.changeAllPricesBon();
            PLU.changeAllPricesBarcode();
        }
        finally {
            vecPriceBarcode.removeAllElements();
        }
        int j = 0;
        while (j < vecBon.size()) {
            PLU plu = (PLU)vecBon.elementAt(j);
            if (plu.barCode > 0L) {
                if (plu.kolicina > 0L) {
                    if (MainFrame.BIG_AMOUNT) {
                        PLU_Wrapper.prodajKaoP2DS(plu.barCode, (int)plu.kolicina, plu.barCode <= 32000L);
                    } else {
                        PLU_Wrapper.prodaj(plu.barCode, (int)plu.kolicina, plu.barCode <= 32000L);
                    }
                } else {
                    PLU_Wrapper.stornoArticle(plu.barCode, Math.abs((int)plu.kolicina), plu.barCode <= 32000L);
                }
            }
            if (plu.barCode < 0L) {
                PLU_Wrapper.stornoBILL();
            }
            if (plu.barCode == 0L) {
                PLU_Wrapper.stornoLast();
            }
            ++j;
        }
    }

    public static void payAll() throws Exception {
        int j = 0;
        while (j < vecPay.size()) {
            PLU plu = (PLU)vecPay.elementAt(j);
            if (plu.barCode > 0L) {
                PLU_Wrapper.plati(0, plu.barCode);
            }
            if (MainFrame.PRIMA) {
                Thread.sleep(1500L);
            }
            if (plu.kolicina > 0L) {
                PLU_Wrapper.plati(1, plu.kolicina);
            }
            if (MainFrame.PRIMA) {
                Thread.sleep(1500L);
            }
            if (plu.prodato > 0L) {
                PLU_Wrapper.plati(2, plu.prodato);
            }
            if (MainFrame.PRIMA) {
                Thread.sleep(1500L);
            }
            if (plu.barCode < 0L) {
                PLU_Wrapper.plati(0, PLU_Wrapper.getDiference());
                return;
            }
            if (plu.kolicina < 0L) {
                PLU_Wrapper.plati(1, PLU_Wrapper.getDiference());
                return;
            }
            if (plu.prodato < 0L) {
                PLU_Wrapper.plati(2, PLU_Wrapper.getDiference());
                return;
            }
            ++j;
        }
        if (Settings.getInstance().useAutoClosure) {
            try {
                PLU_Wrapper.plati(0, PLU_Wrapper.getDiference());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void payAllAbc() throws Exception {
        int j = 1;
        while (j < vecPay.size()) {
            PLU plu = (PLU)vecPay.elementAt(j);
            if (plu.barCode > 0L) {
                PLU_Wrapper.plati(0, plu.barCode);
                System.out.println("GOTOVINA " + plu.barCode);
            }
            if (plu.kolicina > 0L) {
                PLU_Wrapper.plati(1, plu.kolicina);
                System.out.println("KARTICA " + plu.kolicina);
            }
            if (plu.barCode < 0L) {
                PLU_Wrapper.plati(0, PLU_Wrapper.getDiference());
                return;
            }
            if (plu.kolicina < 0L) {
                PLU_Wrapper.plati(1, PLU_Wrapper.getDiference());
                return;
            }
            ++j;
        }
        if (Settings.getInstance().useAutoClosure) {
            try {
                PLU_Wrapper.plati(0, PLU_Wrapper.getDiference());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void readAllFromCR() throws Exception {
        int minSize = 18;
        int descSize = 34;
        int descStart = 12;
        BufferByte arr = new BufferByte(768, 256);
        if (MainFrame.PRINTER) {
            minSize = 10;
            descStart = 4;
        }
        int i = 0;
        Command instance = Command.bigInstance;
        vec.removeAllElements();
        block0: while (true) {
            instance.reset();
            instance.setCmd(19);
            instance.addInt(++i);
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(instance);
            Command command = port.receiveFrame();
            int e = command.getArray()[0] & 0xFF;
            int cmd = command.getCmd();
            if (cmd != 19 && cmd != 128) {
                if (e == 18) {
                    return;
                }
                if (e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
            }
            int len = command.getLength();
            int pos = 0;
            while (true) {
                if (pos + minSize > len) continue block0;
                arr.reset();
                int size = command.getByte(pos++);
                arr.add(command.getArray(), pos, size);
                pos += size;
                if (arr.getInt(0) == 0) {
                    return;
                }
                PLU plu = new PLU();
                i = arr.getInt(0) & 0xFFFFF;
                plu.code = i & 0xFFFFF;
                plu.barCode = MainFrame.PRINTER ? -1L : arr.getLong(4);
                if (MainFrame.PRINTER) {
                    plu.cena = arr.getInt(size - 4);
                    int poreskaStopa = 0;
                    int jedinicaMere = 0;
                    int jj = arr.getValueAt(size - 5);
                    jedinicaMere |= (jj & 0xF0) >> 4;
                    poreskaStopa = (byte)(poreskaStopa | jj & 0xF);
                    byte[] bb = new byte[size - 9];
                    System.arraycopy(arr.getBuffer(), 4, bb, 0, bb.length);
                    plu.desc = SysUtil.formatForReceive(bb);
                    plu.poreskaStopa = (byte)poreskaStopa;
                    plu.jedinicaMere = (byte)jedinicaMere;
                    vec.add(plu);
                    continue;
                }
                int offset = descSize + minSize - size;
                byte[] bb = new byte[descSize];
                System.arraycopy(arr.getBuffer(), descStart, bb, 0, bb.length - offset);
                plu.desc = SysUtil.formatForReceive(bb);
                int poreskaStopa = 0;
                int jedinicaMere = 0;
                byte odeljenje = 0;
                poreskaStopa = (byte)(poreskaStopa | (byte)arr.getValueAt(47 - offset) & 0xF);
                odeljenje = (byte)(odeljenje | (byte)arr.getValueAt(46 - offset));
                plu.poreskaStopa = (byte)poreskaStopa;
                plu.jedinicaMere = (byte)(jedinicaMere |= ((byte)arr.getValueAt(47 - offset) & 0xF0) >> 4);
                plu.odeljenje = odeljenje;
                plu.cena = arr.getInt(48 - offset);
                vec.add(plu);
            }
            break;
        }
    }

    public static final void readArticleFromCR() throws Exception {
        int minSize = 18;
        int descSize = 34;
        int descStart = 12;
        BufferByte arr = new BufferByte(768, 256);
        if (MainFrame.PRINTER) {
            minSize = 10;
            descStart = 4;
        }
        int u = 1;
        Command instance = Command.bigInstance;
        vec.removeAllElements();
        while (true) {
            System.out.println(u);
            instance.reset();
            instance.setCmd(19);
            instance.addInt(kod);
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(instance);
            Command command = port.receiveFrame();
            int e = command.getArray()[0] & 0xFF;
            int cmd = command.getCmd();
            if (cmd != 19 && cmd != 128) {
                if (e == 18) {
                    return;
                }
                if (e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
            }
            int len = command.getLength();
            int pos = 0;
            while (pos < 1) {
                arr.reset();
                int size = command.getByte(pos++);
                arr.add(command.getArray(), pos, size);
                pos += size;
                if (arr.getInt(0) == 0) {
                    return;
                }
                PLU plu = new PLU();
                kod = arr.getInt(0) & 0xFFFFF;
                plu.code = kod & 0xFFFFF;
                plu.barCode = MainFrame.PRINTER ? -1L : arr.getLong(4);
                if (MainFrame.PRINTER) {
                    plu.cena = arr.getInt(size - 4);
                    int poreskaStopa = 0;
                    int jedinicaMere = 0;
                    int jj = arr.getValueAt(size - 5);
                    jedinicaMere |= (jj & 0xF0) >> 4;
                    poreskaStopa = (byte)(poreskaStopa | jj & 0xF);
                    byte[] bb = new byte[size - 9];
                    System.arraycopy(arr.getBuffer(), 4, bb, 0, bb.length);
                    plu.desc = SysUtil.formatForReceive(bb);
                    plu.poreskaStopa = (byte)poreskaStopa;
                    plu.jedinicaMere = (byte)jedinicaMere;
                    vec.add(plu);
                    continue;
                }
                int offset = descSize + minSize - size;
                byte[] bb = new byte[descSize];
                System.arraycopy(arr.getBuffer(), descStart, bb, 0, bb.length - offset);
                plu.desc = SysUtil.formatForReceive(bb);
                int poreskaStopa = 0;
                int jedinicaMere = 0;
                byte odeljenje = 0;
                poreskaStopa = (byte)(poreskaStopa | (byte)arr.getValueAt(47 - offset) & 0xF);
                odeljenje = (byte)(odeljenje | (byte)arr.getValueAt(46 - offset));
                plu.poreskaStopa = (byte)poreskaStopa;
                plu.jedinicaMere = (byte)(jedinicaMere |= ((byte)arr.getValueAt(47 - offset) & 0xF0) >> 4);
                plu.odeljenje = odeljenje;
                plu.cena = arr.getInt(48 - offset);
                vec.add(plu);
            }
            if (u == 1) {
                return;
            }
            ++u;
        }
    }

    public static final String saveArticlesToFile(XmlFileWriter writer) throws Exception {
        String s = empStr;
        int size = vec.size();
        s = String.valueOf(s) + writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        s = String.valueOf(s) + writer.writeLn("<ARTICAL>");
        int i = 0;
        while (i < size) {
            PLU art = (PLU)vec.get(i);
            writer.indent();
            s = String.valueOf(s) + writer.write("<DATA PLU='" + String.valueOf(art.code) + "'");
            s = String.valueOf(s) + writer.write(" DESC='" + XmlFileWriter.compileString(art.desc).trim() + "'");
            s = String.valueOf(s) + writer.write(" VAT='" + String.valueOf(art.poreskaStopa) + "'");
            s = String.valueOf(s) + writer.write(" BCR='" + art.barCode + "'");
            s = String.valueOf(s) + writer.write(" PRC='" + String.valueOf(art.cena) + "'");
            s = String.valueOf(s) + writer.write(" DEP='" + String.valueOf(art.odeljenje) + "'");
            s = String.valueOf(s) + writer.write(" MES='" + String.valueOf(art.jedinicaMere) + "'");
            s = String.valueOf(s) + writer.writeLn("/>");
            writer.unintent();
            ++i;
        }
        s = String.valueOf(s) + writer.writeLn("</ARTICAL>");
        return s;
    }

    public static final String saveArticleToFile(XmlFileWriter writer) throws Exception {
        String s = empStr;
        int size = vec.size();
        s = String.valueOf(s) + writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        s = String.valueOf(s) + writer.writeLn("<ARTICAL>");
        int i = 0;
        while (i < size) {
            PLU art = (PLU)vec.get(i);
            writer.indent();
            s = String.valueOf(s) + writer.write("<DATA PLU='" + String.valueOf(art.code) + "'");
            s = String.valueOf(s) + writer.write(" DESC='" + XmlFileWriter.compileString(art.desc).trim() + "'");
            s = String.valueOf(s) + writer.write(" VAT='" + String.valueOf(art.poreskaStopa) + "'");
            s = String.valueOf(s) + writer.write(" BCR='" + art.barCode + "'");
            s = String.valueOf(s) + writer.write(" PRC='" + String.valueOf(art.cena) + "'");
            s = String.valueOf(s) + writer.write(" DEP='" + String.valueOf(art.odeljenje) + "'");
            s = String.valueOf(s) + writer.write(" MES='" + String.valueOf(art.jedinicaMere) + "'");
            s = String.valueOf(s) + writer.writeLn("/>");
            writer.unintent();
            if (i == 0) break;
            ++i;
        }
        s = String.valueOf(s) + writer.writeLn("</ARTICAL>");
        return s;
    }

    public static void readAllSold() throws Exception {
        if (MainFrame.PRINTER) {
            throw new Exception("Command is not suported for this device!-Komanda nije podrzana od strane uredjaja                                                                  ");
        }
        int descSize = 34;
        Command instance = Command.bigInstance;
        PortSerial port = PortSerial.getInstance();
        BufferByte arr = new BufferByte();
        int code = 1;
        long lll = 0L;
        vec.clear();
        block0: do {
            instance.reset();
            instance.setCmd(29);
            instance.addInt(code);
            port.sendFrame(instance);
            instance = port.receiveFrame();
            int e = instance.getArray()[0] & 0xFF;
            if (29 != instance.getCmd()) {
                if (e == 18) {
                    return;
                }
                if (e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
            }
            int len = instance.getLength();
            len /= 64;
            int j = 0;
            while (j < len) {
                arr.reset();
                arr.add(instance.getArray(), j * 64, 64);
                if (arr.getInt(0) == 0) continue block0;
                PLU plu = new PLU();
                code = arr.getShort(0) & 0xFFFF;
                plu.code = code & 0xFFFF;
                plu.barCode = arr.getLong(4);
                byte[] bb = new byte[descSize];
                System.arraycopy(arr.getBuffer(), 12, bb, 0, bb.length);
                plu.desc = SysUtil.formatForReceive(bb);
                int poreskaStopa = 0;
                int jedinicaMere = 0;
                byte odeljenje = 0;
                poreskaStopa = (byte)(poreskaStopa | (byte)arr.getValueAt(59) & 0xF);
                odeljenje = (byte)(odeljenje | (byte)arr.getValueAt(58));
                plu.poreskaStopa = (byte)poreskaStopa;
                plu.jedinicaMere = (byte)(jedinicaMere |= ((byte)arr.getValueAt(59) & 0xF0) >> 4);
                plu.odeljenje = odeljenje;
                plu.cena = arr.getInt(60);
                lll = arr.getLong(46) & 0xFFFFFFFFFFFFL;
                if ((lll & 0x800000000000L) > 0L) {
                    lll |= 0xFFFF000000000000L;
                }
                plu.prodato = lll;
                lll = arr.getLong(52) & 0xFFFFFFFFFFFFL;
                if ((lll & 0x800000000000L) > 0L) {
                    lll |= 0xFFFF000000000000L;
                }
                plu.kolicina = lll;
                vec.add(plu);
                ++j;
            }
        } while (code++ != 32000);
    }

    public static final String saveSoldArticlesToFile(XmlFileWriter writer) throws Exception {
        String s = empStr;
        int size = vec.size();
        s = String.valueOf(s) + writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        s = String.valueOf(s) + writer.writeLn("<ARTICAL>");
        int i = 0;
        while (i < size) {
            PLU art = (PLU)vec.get(i);
            writer.indent();
            s = String.valueOf(s) + writer.write("<DATA PLU='" + String.valueOf(art.code) + "'");
            s = String.valueOf(s) + writer.write(" DESC='" + XmlFileWriter.compileString(art.desc) + "'");
            s = String.valueOf(s) + writer.write(" VAT='" + String.valueOf(art.poreskaStopa) + "'");
            s = String.valueOf(s) + writer.write(" BCR='" + art.barCode + "'");
            s = String.valueOf(s) + writer.write(" PRC='" + String.valueOf(art.cena) + "'");
            s = String.valueOf(s) + writer.write(" DEP='" + String.valueOf(art.odeljenje) + "'");
            s = String.valueOf(s) + writer.write(" MES='" + String.valueOf(art.jedinicaMere) + "'");
            s = String.valueOf(s) + writer.write(" AMN='" + String.valueOf(art.kolicina) + "'");
            s = String.valueOf(s) + writer.write(" FIN='" + String.valueOf(art.prodato) + "'");
            s = String.valueOf(s) + writer.writeLn("/>");
            writer.unintent();
            ++i;
        }
        s = String.valueOf(s) + writer.writeLn("</ARTICAL>");
        return s;
    }
}

