/*
 * Decompiled with CFR 0.152.
 */
package objects.fiscal;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.MainFrame;
import gui.rightPanels.ControlPanel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import journal.Journal;
import objects.Settings;
import objects.XmlServerReplyException;
import objects.fiscal.AdvertisementWrapper;
import objects.fiscal.PLU_Wrapper;
import objects.fiscal.State;
import objects.fiscal.Users;
import org.gnome.notify.Notification;
import util.SysUtil;
import util.comPort.PortSerial;
import util.comPort.SerialPortException;

public class CommandWrapper {
    public static byte REGULAR = (byte)-1;
    public static byte BOLD = (byte)(REGULAR & 0xFFFFFFEF);
    public static byte LEFT = (byte)(REGULAR & 0xFFFFFF7F);
    public static boolean daily = false;
    public static boolean periodical = false;
    public static boolean state = false;
    public static boolean deleteAll = false;
    public static boolean resetSold = false;
    public static boolean bill_state = false;
    public static boolean register_state = false;
    public static boolean z_state = false;
    public static boolean read_fiscal_data = false;
    public static boolean read_articles = false;
    public static boolean read_sold_articles = false;
    public static boolean read_article = false;
    public static boolean read_journal = false;
    public static boolean read_vats = false;
    public static boolean read_measures = false;
    public static boolean read_daily = false;
    public static int read_daily_num = 0;
    public static boolean fiscal_day_started = false;
    public static boolean user_command = false;
    public static boolean open_drawer = false;
    public static long from;
    public static long to;
    public static boolean cashier_print;
    public static boolean log_in;
    public static int log_in_code;
    public static boolean adver;
    public static int adver_type;
    public static String display_1;
    public static String display_2;
    public static boolean display;
    static int i;
    public static final Object instance;
    public static boolean daily_user;
    public static boolean state_user;
    public static boolean print_settings;
    public static boolean test_port;
    public static boolean storno_bill;
    public static boolean close_bill;
    public static String user_port;
    public static String user_speed;

    static {
        cashier_print = false;
        log_in = false;
        log_in_code = 0;
        adver = false;
        adver_type = 0;
        display = false;
        i = 0;
        instance = new Object();
        daily_user = false;
        state_user = false;
        print_settings = false;
        test_port = false;
        storno_bill = false;
        close_bill = false;
    }

    public static void presek() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(89);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 89 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static void dnevni() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(88);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 88 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static void periodicni() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(90);
        instance.addLong(from - 946684800000L + 43200000L);
        instance.addLong(to - 946684800000L + 43200000L);
        from = 0L;
        to = 0L;
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 90 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void printPeriodicalReport(long from, long to) throws Exception {
        Object object = instance;
        synchronized (object) {
            Command instance = Command.instance;
            instance.reset();
            instance.setCmd(90);
            instance.addLong(from);
            instance.addLong(to);
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(instance);
            port.receiveFrame(instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != 90 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        }
    }

    public static void openDrawer() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(36);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 89 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static final void deleteAll() throws Exception {
        block7: {
            try {
                Command.instance.reset();
                Command.instance.setCmd(14);
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(Command.instance);
                port.receiveFrame(Command.instance);
                int e = Command.instance.getArray()[0] & 0xFF;
                if (14 != Command.instance.getCmd() && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
            }
            catch (SerialPortException e) {
                if (e.getMessage().indexOf("SERIAL_PORT_ERROR_TIME_OUT") >= 0) break block7;
                throw e;
            }
        }
        long time = System.currentTimeMillis();
        Command cmd = Command.testInstance;
        while (true) {
            if (System.currentTimeMillis() - time > 300000L) {
                throw new Exception("ERROR");
            }
            cmd.reset();
            cmd.setCmd(101);
            try {
                PortSerial.getInstance().sendFrame(cmd);
            }
            catch (Exception eeee) {
                SysUtil.delay(100);
                continue;
            }
            break;
        }
    }

    public static void execAll() throws Exception {
        try {
            if (adver) {
                CommandWrapper.execAdver();
            }
            if (log_in) {
                CommandWrapper.logIn();
            }
            if (cashier_print) {
                CommandWrapper.cashierPrint();
            }
            if (fiscal_day_started) {
                CommandWrapper.isFiscalDayStarted();
            }
            if (user_command) {
                CommandWrapper.execUserCommand();
            }
            if (state) {
                CommandWrapper.presek();
            }
            if (daily) {
                CommandWrapper.dnevni();
            }
            if (periodical) {
                CommandWrapper.periodicni();
            }
            if (deleteAll) {
                CommandWrapper.deleteAll();
            }
            if (bill_state) {
                CommandWrapper.billState();
            }
            if (register_state) {
                CommandWrapper.registerState();
            }
            if (z_state) {
                CommandWrapper.zState();
            }
            if (read_fiscal_data) {
                CommandWrapper.readFiscalData();
            }
            if (read_daily) {
                CommandWrapper.readDaily();
            }
            if (read_vats) {
                CommandWrapper.readVats();
            }
            if (read_articles) {
                CommandWrapper.readArticles();
            }
            if (read_article) {
                CommandWrapper.readArticle();
            }
            if (read_sold_articles) {
                CommandWrapper.readSoldArticles();
            }
            if (read_measures) {
                CommandWrapper.readMeasure();
            }
            if (open_drawer) {
                CommandWrapper.openDrawer();
            }
            if (read_journal) {
                CommandWrapper.readJournal();
            }
            if (resetSold) {
                CommandWrapper.resetSold();
            }
            if (display) {
                CommandWrapper.printOnDisplay();
            }
        }
        finally {
            adver = false;
            state = false;
            daily = false;
            periodical = false;
            deleteAll = false;
            bill_state = false;
            register_state = false;
            z_state = false;
            read_fiscal_data = false;
            read_articles = false;
            read_article = false;
            read_vats = false;
            read_sold_articles = false;
            read_measures = false;
            resetSold = false;
            log_in = false;
            cashier_print = false;
            fiscal_day_started = false;
            read_daily = false;
            read_journal = false;
            user_command = false;
            display = false;
            open_drawer = false;
        }
    }

    private static void execAdver() throws Exception {
        switch (adver_type) {
            case 0: {
                AdvertisementWrapper.getInstance().turnOff();
                break;
            }
            case 1: {
                AdvertisementWrapper.getInstance().turnOn();
                break;
            }
            case 2: {
                AdvertisementWrapper.getInstance().print();
                break;
            }
            default: {
                throw new Exception("Wrong type!");
            }
        }
    }

    private static void execUserCommand() throws Exception {
        int ccc = Command.userInstance.getCmd();
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(Command.userInstance);
        Command cmdReply = port.receiveFrame();
        int e = cmdReply.getArray()[0] & 0xFF;
        if (ccc != cmdReply.getCmd() && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        String s = State.getInstance().writeUserCommandReply(cmdReply);
        if (Settings.getInstance().mode == 2) {
            XmlServerReplyException exc = new XmlServerReplyException();
            exc.replyXmlString = s;
            throw exc;
        }
    }

    private static void readJournal() throws Exception {
        String s = Journal.getInstance().writeJournal();
        if (Settings.getInstance().mode == 2) {
            XmlServerReplyException exc = new XmlServerReplyException();
            exc.replyXmlString = s;
            throw exc;
        }
    }

    private static void readVats() throws Exception {
        String s = State.getInstance().readVats();
        if (Settings.getInstance().mode == 2) {
            XmlServerReplyException exc = new XmlServerReplyException();
            exc.replyXmlString = s;
            throw exc;
        }
    }

    private static void readMeasure() throws Exception {
        String s = State.getInstance().readMeasure();
        if (Settings.getInstance().mode == 2) {
            XmlServerReplyException exc = new XmlServerReplyException();
            exc.replyXmlString = s;
            throw exc;
        }
    }

    public static void billState() throws Exception {
        String s = State.getInstance().writeBill();
        if (Settings.getInstance().mode == 2) {
            XmlServerReplyException exc = new XmlServerReplyException();
            exc.replyXmlString = s;
            throw exc;
        }
    }

    public static void registerState() throws Exception {
        String s = State.getInstance().writeRegister();
        if (Settings.getInstance().mode == 2) {
            XmlServerReplyException exc = new XmlServerReplyException();
            exc.replyXmlString = s;
            throw exc;
        }
    }

    public static void zState() throws Exception {
        String s = State.getInstance().writeDI();
        if (Settings.getInstance().mode == 2) {
            XmlServerReplyException exc = new XmlServerReplyException();
            exc.replyXmlString = s;
            throw exc;
        }
    }

    public static void readArticles() throws Exception {
        String s = State.getInstance().writeArticles();
        if (Settings.getInstance().mode == 2) {
            XmlServerReplyException exc = new XmlServerReplyException();
            exc.replyXmlString = s;
            throw exc;
        }
    }

    private static void readArticle() throws Exception {
        String s = State.getInstance().writeArticle();
        if (Settings.getInstance().mode == 2) {
            XmlServerReplyException exc = new XmlServerReplyException();
            exc.replyXmlString = s;
            throw exc;
        }
    }

    public static void readSoldArticles() throws Exception {
        String s = State.getInstance().writeSoldArticles();
        if (Settings.getInstance().mode == 2) {
            XmlServerReplyException exc = new XmlServerReplyException();
            exc.replyXmlString = s;
            throw exc;
        }
    }

    private static void readDaily() throws Exception {
        State.getInstance().getDailyData(read_daily_num);
    }

    public static void readFiscalData() throws Exception {
        State.getInstance().readFiscalData();
    }

    private static void logIn() throws Exception {
        Users.login(log_in_code);
    }

    public static void cashierPrint() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(53);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 88 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    private static void isFiscalDayStarted() throws Exception {
        State.getInstance().isFiscalDayStarted();
    }

    private static void resetSold() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(21);
        instance.addByte(0);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        int command = instance.getCmd();
        if (command != 21 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static void print(String str, int texttype) throws Exception {
        int PRINTER_SIZE = 32;
        if (MainFrame.PRINTER) {
            PRINTER_SIZE = MainFrame.SECUNDA ? 20 : (MainFrame.EPSON ? 34 : 32);
        } else {
            PRINTER_SIZE = 22;
            PRINTER_SIZE = MainFrame.PRIMA ? 19 : (MainFrame.BESTLCPLUS ? 18 : 22);
        }
        String out = "";
        StringTokenizer tock = new StringTokenizer(str, "\n", true);
        while (tock.hasMoreTokens()) {
            String pom = tock.nextToken();
            while (pom.equals("\n") && tock.hasMoreTokens()) {
                pom = tock.nextToken();
                if (!pom.equals("\n")) continue;
                int i = 0;
                while (i < PRINTER_SIZE) {
                    out = String.valueOf(out) + ' ';
                    ++i;
                }
            }
            int ll = pom.length() % PRINTER_SIZE;
            out = String.valueOf(out) + pom;
            while (ll < PRINTER_SIZE) {
                out = String.valueOf(out) + ' ';
                ++ll;
            }
        }
        int len = out.length();
        Command instance = Command.bigInstance;
        int pos = 0;
        while (pos < len) {
            instance.reset();
            instance.setCmd(26);
            instance.addByte(len - pos < 511 ? 1 : 0);
            while (instance.getPos() + PRINTER_SIZE + 1 < 512 && pos < len) {
                int tt;
                int n = tt = pos + PRINTER_SIZE < len ? PRINTER_SIZE : len - pos;
                if (texttype == 0) {
                    instance.addByte(Settings.getInstance().isBold() ? BOLD : REGULAR);
                } else if (texttype == 2) {
                    instance.addByte(247);
                } else if (texttype == 1) {
                    instance.addByte(Settings.getInstance().isBold() ? 235 : 251);
                }
                SysUtil.formatForSend(out.substring(pos, pos + tt), instance);
                pos += tt;
            }
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(instance);
            Command cc = port.receiveFrame();
            int e = cc.getArray()[0] & 0xFF;
            if (26 != cc.getCmd() && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
            if (pos >= len || !Settings.printer || Settings.secunda || Settings.epson) continue;
            Thread.sleep(300L);
        }
    }

    private static void printSettings() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(112);
        instance.addByte(0);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        int command = instance.getCmd();
        if (command != 112 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static void execUserCommands() throws Exception {
        try {
            if (daily_user) {
                CommandWrapper.dnevni();
            }
            if (state_user) {
                CommandWrapper.presek();
            }
            if (print_settings) {
                CommandWrapper.printSettings();
            }
            if (test_port) {
                CommandWrapper.testPort();
            }
            if (storno_bill) {
                CommandWrapper.stornoBill();
            }
            if (close_bill) {
                CommandWrapper.closeBill();
            }
        }
        finally {
            daily_user = false;
            state_user = false;
            print_settings = false;
            test_port = false;
            storno_bill = false;
            close_bill = false;
        }
    }

    public static void testPort() throws Exception {
        PortSerial.sPort = user_port;
        if (user_port != null) {
            PortSerial.speed = Integer.parseInt(user_speed);
            PortSerial.getInstance().test(PortSerial.speed);
            MainFrame.getInstance().notification = new Notification("OK", "Test successful", "images/print.png");
            MainFrame.getInstance().notification.show();
            CommandWrapper.setDevice();
        }
    }

    public static void stornoBill() throws Exception {
        PLU_Wrapper.stornoBILL();
    }

    public static void closeBill() throws Exception {
        PLU_Wrapper.plati(0, (int)PLU_Wrapper.getDiference());
    }

    public static void printOnDisplay() throws Exception {
        Command instance = Command.instance;
        PortSerial port = PortSerial.getInstance();
        if (display_1.length() > 20) {
            display_1 = display_1.substring(0, 20);
        }
        if (display_2.length() > 20) {
            display_2 = display_2.substring(0, 20);
        }
        instance.reset();
        instance.setCmd(33);
        String str = display_1;
        while (str.length() < 20) {
            str = String.valueOf(str) + ' ';
        }
        str = String.valueOf(str) + display_2;
        while (str.length() < 40) {
            str = String.valueOf(str) + ' ';
        }
        SysUtil.formatForSend(str, instance);
        port.sendFrame(instance);
        instance = port.receiveFrame();
        int e = instance.getArray()[0] & 0xFF;
        if (33 != instance.getCmd() && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    private static void setDevice() throws Exception {
        try {
            PortSerial port = PortSerial.getInstance();
            Command.instance.reset();
            Command.instance.setCmd(3);
            port.sendFrame(Command.instance);
            port.receiveFrame(Command.instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != 3 && command != 128) {
                if (e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                System.out.println("klasa CommandWrapper/odeljak za identifikaciju uredjaja");
            }
            long pom = Command.instance.getLong(0);
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy,HH:mm:ss");
            Date d = new Date(pom);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            byte[] b = new byte[8];
            System.arraycopy(Command.instance.getArray(), 8, b, 0, b.length);
            int secondBrIbfm = b[1] & 0xFF;
            switch (secondBrIbfm) {
                case 134: {
                    String text1 = "Uspesno uspostavljena komunikacija sa FLEXI fiskalnim stampacem.";
                    MainFrame.getInstance().notification = new Notification("Connection successful", text1, "images/print.png");
                    MainFrame.getInstance().notification.show();
                    ControlPanel.setPrinterRadioButton();
                    Settings.getInstance().setPrima(false);
                    break;
                }
                case 135: {
                    String text2 = "Uspesno uspostavljena komunikacija sa P2DS fiskalnim stampacem.";
                    MainFrame.getInstance().notification = new Notification("Connection successful", text2, "images/print.png");
                    MainFrame.getInstance().notification.show();
                    ControlPanel.setPrinterRadioButton();
                    Settings.getInstance().setPrima(false);
                    break;
                }
                case 139: {
                    String text3 = "Uspesno uspostavljena komunikacija sa fiskalnim stampacem Secunda.";
                    MainFrame.getInstance().notification = new Notification("Connection successful", text3, "images/print.png");
                    MainFrame.getInstance().notification.show();
                    ControlPanel.setSecundaChekBox();
                    Settings.getInstance().setPrima(false);
                    break;
                }
                case 132: {
                    String text4 = "Uspesno uspostavljena komunikacija sa fiskalnom kasom BEST.";
                    MainFrame.getInstance().notification = new Notification("Connection successful", text4, "images/print.png");
                    MainFrame.getInstance().notification.show();
                    ControlPanel.setRegisterRadioButton();
                    Settings.getInstance().setPrima(false);
                    break;
                }
                case 133: {
                    String text5 = "Uspesno uspostavljena komunikacija sa fiskalnom kasom BEST LC+.";
                    MainFrame.getInstance().notification = new Notification("Connection successful", text5, "images/print.png");
                    MainFrame.getInstance().notification.show();
                    ControlPanel.setBestLcPLusRadioButton();
                    Settings.getInstance().setPrima(false);
                    break;
                }
                case 65: {
                    String text6 = "Uspesno uspostavljena komunikacija sa fiskalnom kasom INTEGRA.";
                    MainFrame.getInstance().notification = new Notification("Connection successful", text6, "images/print.png");
                    MainFrame.getInstance().notification.show();
                    ControlPanel.setRegisterRadioButton();
                    Settings.getInstance().setPrima(false);
                    break;
                }
                case 74: {
                    String text7 = "Uspesno uspostavljena komunikacija sa fiskalnom kasom PRIMA.";
                    MainFrame.getInstance().notification = new Notification("Connection successful", text7, "images/print.png");
                    MainFrame.getInstance().notification.show();
                    ControlPanel.setRegisterRadioButton();
                    Settings.getInstance().setPrima(true);
                    break;
                }
                case 75: {
                    String text8 = "Uspesno uspostavljena komunikacija sa fiskalnim stampacem Epson.";
                    MainFrame.getInstance().notification = new Notification("Connection successful", text8, "images/print.png");
                    MainFrame.getInstance().notification.show();
                    ControlPanel.setEpsonChekBox();
                    Settings.getInstance().setPrima(false);
                    break;
                }
                case 88: {
                    Settings.getInstance().setPrima(false);
                    if (i == 0) {
                        String text9 = "Ukoliko je prikljucen uredjaj: BEST, INTEGRA ili PRIMA - odaberite REGISTER\n\rUkoliko je priljucen uredjaj: FLEXI ili P2DS - odaberite PRINTER\n\rUkoliko je prikljucen uredjaj SECUNDA - odaberite PRINTER i Secunda.\n\rNakon odabira uredjaja ponovite test veze.";
                        MainFrame.getInstance().notification = new Notification("Connection successful", text9, "images/print.png");
                        MainFrame.getInstance().notification.show();
                        ++i;
                        break;
                    }
                    String text9 = "Uspostavili ste komunikaciju sa testnim uredjajem.";
                    MainFrame.getInstance().notification = new Notification("Connection successful", text9, "images/print.png");
                    MainFrame.getInstance().notification.show();
                    if (Settings.getInstance().isPrinter()) {
                        if (Settings.getInstance().isSecunda()) {
                            ControlPanel.setSecundaChekBox();
                        } else {
                            ControlPanel.setPrinterRadioButton();
                        }
                    } else {
                        ControlPanel.setRegisterRadioButton();
                    }
                    --i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

