/*
 * Decompiled with CFR 0.152.
 */
package objects.fiscal;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.MainFrame;
import gui.rightPanels.LogPanel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import javax.xml.parsers.DocumentBuilderFactory;
import objects.Settings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.SysUtil;
import util.comPort.PortSerial;

public class AdvertisementWrapper {
    public static final int NUM_ROWS = 11;
    public static int SIZE_ROW = 42;
    public Row[] arrayRows = new Row[11];
    private static AdvertisementWrapper instance;
    public static final int OFFSET_ADVERTISEMENT_NUMBER = 16;

    public static final AdvertisementWrapper getInstance() {
        if (instance == null) {
            instance = new AdvertisementWrapper();
        }
        return instance;
    }

    private AdvertisementWrapper() {
        int i = 0;
        while (i < 11) {
            this.arrayRows[i] = new Row();
            ++i;
        }
    }

    public void programToCR() throws Exception {
        Row pom;
        Command bigInstance = Command.bigInstance;
        bigInstance.reset();
        bigInstance.setCmd(22);
        int numEmptyRows = 0;
        int i = 11;
        while (--i >= 0) {
            pom = this.arrayRows[i];
            if (pom.text.trim().length() <= 0) continue;
            numEmptyRows = i;
            break;
        }
        i = 0;
        while (i < 11) {
            pom = this.arrayRows[i];
            if (i > numEmptyRows) {
                bigInstance.addByte(255);
            } else if (pom.doubleRow) {
                bigInstance.addByte(63);
            } else {
                bigInstance.addByte(127);
            }
            String sss = pom.text;
            while (sss.length() < SIZE_ROW) {
                sss = String.valueOf(sss) + ' ';
            }
            SysUtil.formatForSend(sss, bigInstance);
            ++i;
        }
        bigInstance.addByte(0);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(bigInstance);
        Command ret = port.receiveFrame();
        int t = ret.getArray()[0] & 0xFF;
        int cm = ret.getCmd();
        if (128 != cm && 22 != cm && t != 0) {
            CommandsErrors.instanceMain.setError(t);
        }
    }

    public void turnOff() throws Exception {
        if (!MainFrame.PRINTER) {
            throw new Exception("COMMAND IS NOT AVAILABLE!");
        }
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(111);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        int cmdRec = instance.getCmd();
        if (cmdRec != 111 && cmdRec != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        int i1 = instance.getInt(0);
        int i2 = instance.getInt(4);
        int pom = instance.getInt(8);
        instance.reset();
        instance.setCmd(110);
        instance.addInt(i1);
        instance.addInt(i2);
        instance.addInt(pom |= 0xF0000);
        port.sendFrame(instance);
        port.receiveFrame(instance);
        e = instance.getArray()[0] & 0xFF;
        int cmdRet = instance.getCmd();
        if (cmdRet != 110 && cmdRet != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public void turnOn() throws Exception {
        if (!MainFrame.PRINTER) {
            throw new Exception("COMMAND IS NOT AVAILABLE!");
        }
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(111);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        int cmdRec = instance.getCmd();
        if (cmdRec != 111 && cmdRec != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        int i1 = instance.getInt(0);
        int i2 = instance.getInt(4);
        int pom = instance.getInt(8);
        instance.reset();
        instance.setCmd(110);
        instance.addInt(i1);
        instance.addInt(i2);
        instance.addInt(pom &= 0xFFF0FFFF);
        port.sendFrame(instance);
        port.receiveFrame(instance);
        e = instance.getArray()[0] & 0xFF;
        int cmdRet = instance.getCmd();
        if (cmdRet != 110 && cmdRet != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public void print() throws Exception {
        if (!MainFrame.PRINTER) {
            throw new Exception("COMMAND IS NOT AVAILABLE!");
        }
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(25);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 25 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public void readFromXML(Document doc) throws Exception {
        int i = 0;
        while (i < 11) {
            this.arrayRows[i] = new Row();
            ++i;
        }
        NodeList dataNode = doc.getDocumentElement().getElementsByTagName("DATA");
        int i2 = 0;
        while (i2 < dataNode.getLength()) {
            Row pom = this.arrayRows[i2];
            Element dataElem = (Element)dataNode.item(i2);
            pom.doubleRow = Boolean.parseBoolean(dataElem.getAttribute("BOLD"));
            pom.text = dataElem.getAttribute("TEXT").toString();
            ++i2;
        }
    }

    public void readFromXML(File file) throws Exception {
        Document doc;
        try (FileInputStream in = null;){
            in = new FileInputStream(file);
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        }
        this.readFromXML(doc);
    }

    public void readFromTXT(File file) throws Exception {
        if (Settings.getInstance().useThreadTimeout) {
            SysUtil.delay(Settings.getInstance().timeoutThread);
        }
        BufferedReader input = new BufferedReader(new FileReader(file));
        String str = null;
        String name = file.getName();
        int i = 0;
        int j = 0;
        while (j < 11) {
            this.arrayRows[j] = new Row();
            ++j;
        }
        try {
            try {
                if (file.length() <= 1L) {
                    throw new Exception("File is too small!");
                }
                LogPanel.println("FILE CONTENT START:");
                while ((str = input.readLine()) != null) {
                    int b = Integer.parseInt(str.substring(0, 1));
                    String strP = str.substring(1, str.length());
                    LogPanel.println(str);
                    Row pom = this.arrayRows[i];
                    pom.doubleRow = b == 1 ? Boolean.parseBoolean("true") : Boolean.parseBoolean("false");
                    pom.text = strP;
                    ++i;
                }
                LogPanel.println("FILE CONTENT END:");
                SysUtil.writeOkFile(name);
            }
            catch (Exception e) {
                SysUtil.writeErrorFile(name, e);
                input.close();
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
        }
        finally {
            input.close();
            if (Settings.getInstance().useThreadDeleteInput) {
                SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
            }
            file.delete();
        }
    }

    public void parseAdvString(String str, int b) throws Exception {
        if (b == 0) {
            int i = 0;
            while (i < 11) {
                this.arrayRows[i] = new Row();
                ++i;
            }
        }
        HCPStringTokenizer st = new HCPStringTokenizer(str, ',');
        int i = b;
        while (i < 11) {
            Row pom = this.arrayRows[i];
            pom.doubleRow = Boolean.parseBoolean(st.nextToken().replaceAll("\"", ""));
            pom.text = st.nextToken().replaceAll("\"", "");
            ++i;
        }
    }

    private static class HCPStringTokenizer {
        private String string;
        private char token;
        private int pos;

        public HCPStringTokenizer(String str, char tok) {
            this.string = str;
            this.token = tok;
            this.pos = 0;
        }

        public String nextToken() {
            String s = "";
            char c = '\u0000';
            while (true) {
                if (this.pos == this.string.length()) {
                    return s;
                }
                if ((c = this.string.charAt(this.pos++)) == this.token) break;
                s = String.valueOf(s) + c;
            }
            return s;
        }
    }

    public class Row {
        public String text = new String();
        public boolean doubleRow;

        public Row() {
            int i = 0;
            while (i < SIZE_ROW) {
                this.text = String.valueOf(this.text) + ' ';
                ++i;
            }
            this.doubleRow = false;
        }
    }
}

