/*
 * Decompiled with CFR 0.152.
 */
package objects;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.MainFrame;
import java.io.InputStream;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import objects.Settings;
import objects.XmlServerReplyException;
import objects.XmlServerThread;
import objects.fiscal.AdvertisementWrapper;
import objects.fiscal.CommandWrapper;
import objects.fiscal.PLU;
import objects.fiscal.Users;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import util.SysUtil;

public class XmlServerWrapper {
    private static DocumentBuilder db = null;
    private static final Exception OK = new Exception("OK");
    private static byte[] buffer = new byte[1024];

    public static void readXmlFile(InputStream in) throws Exception {
        Document doc;
        String myString = "";
        int t = 0;
        long time = System.currentTimeMillis();
        while ((t = in.read(buffer, 0, buffer.length)) >= 0) {
            if ((myString = String.valueOf(myString) + new String(buffer, 0, t, "UTF-8")).endsWith("\r\n\r\n") || myString.endsWith("\r\r")) break;
            if (System.currentTimeMillis() - time <= (long)Settings.getInstance().timeoutErrorClient) continue;
            throw new Exception("TIMEOUT!");
        }
        InputSource is = new InputSource(new StringReader(myString));
        if (db == null) {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        if ((doc = db.parse(is)).getDocumentElement().getNodeName().equals("NEFISKALNI_TEKST")) {
            XmlServerWrapper.parseTxtInput(doc);
        } else if (doc.getDocumentElement().getNodeName().equals("RACUN")) {
            XmlServerWrapper.parseBonInput(doc);
        } else if (doc.getDocumentElement().getNodeName().equals("KOMANDE")) {
            XmlServerWrapper.parseCmdInput(doc);
        } else if (doc.getDocumentElement().getNodeName().equals("ARTICAL")) {
            XmlServerWrapper.parsePluInput(doc);
        } else if (doc.getDocumentElement().getNodeName().equals("USERS")) {
            XmlServerWrapper.parseUsersInput(doc);
        } else if (doc.getDocumentElement().getNodeName().equals("FOOTER")) {
            XmlServerWrapper.parseFooterInput(doc);
        } else {
            throw new Exception("Unknown xml command!");
        }
    }

    private static void parseFooterInput(Document doc) throws Exception {
        try {
            if (!MainFrame.PRINTER) {
                throw new Exception("COMMAND IS NOT AVAILABLE!");
            }
            AdvertisementWrapper.getInstance().readFromXML(doc);
            AdvertisementWrapper.getInstance().programToCR();
            XmlServerThread.sendToErrorClient(0, OK);
        }
        catch (Exception e) {
            if (e instanceof CommandsErrors) {
                CommandsErrors eee = (CommandsErrors)e;
                XmlServerThread.sendToErrorClient(eee.getNumError(), eee);
            } else {
                XmlServerThread.sendToErrorClient(1, e);
            }
            throw e;
        }
    }

    private static void parseUsersInput(Document doc) throws Exception {
        try {
            XmlServerWrapper.readUsersFromXML(doc);
            XmlServerThread.sendToErrorClient(0, OK);
        }
        catch (Exception e) {
            if (e instanceof CommandsErrors) {
                CommandsErrors eee = (CommandsErrors)e;
                XmlServerThread.sendToErrorClient(eee.getNumError(), eee);
            } else {
                XmlServerThread.sendToErrorClient(1, e);
            }
            throw e;
        }
    }

    private static void parsePluInput(Document doc) throws Exception {
        try {
            try {
                XmlServerWrapper.readArticlesFromXML(doc);
                PLU.deleteAllByCode();
                PLU.deleteAllByBarcode();
                PLU.programmAll();
                PLU.changeAllPrices();
                PLU.changeAllPricesBarcode();
                XmlServerThread.sendToErrorClient(0, OK);
            }
            catch (Exception e) {
                if (e instanceof CommandsErrors) {
                    CommandsErrors eee = (CommandsErrors)e;
                    XmlServerThread.sendToErrorClient(eee.getNumError(), eee);
                } else {
                    XmlServerThread.sendToErrorClient(1, e);
                }
                throw e;
            }
        }
        finally {
            PLU.vecDelCode.removeAllElements();
            PLU.vecDelBarcode.removeAllElements();
            PLU.vecNew.removeAllElements();
            PLU.vecPrice.removeAllElements();
            PLU.vecPriceBarcode.removeAllElements();
        }
    }

    private static void parseBonInput(Document doc) throws Exception {
        try {
            try {
                XmlServerWrapper.readBonFromXml(doc);
                PLU.sellAll();
                PLU.payAll();
                XmlServerThread.sendToErrorClient(0, OK);
            }
            catch (Exception e) {
                if (e instanceof CommandsErrors) {
                    CommandsErrors eee = (CommandsErrors)e;
                    XmlServerThread.sendToErrorClient(eee.getNumError(), eee);
                } else {
                    XmlServerThread.sendToErrorClient(1, e);
                }
                throw e;
            }
        }
        finally {
            PLU.vecPay.removeAllElements();
            PLU.vecBon.removeAllElements();
        }
    }

    private static void parseCmdInput(Document doc) throws Exception {
        try {
            XmlServerWrapper.readCommandFromXml(doc);
            CommandWrapper.execAll();
            XmlServerThread.sendToErrorClient(0, OK);
        }
        catch (Exception e) {
            if (e instanceof CommandsErrors) {
                CommandsErrors eee = (CommandsErrors)e;
                XmlServerThread.sendToErrorClient(eee.getNumError(), eee);
            } else {
                if (e instanceof XmlServerReplyException) {
                    XmlServerReplyException eee = (XmlServerReplyException)e;
                    if (eee.replyXmlString != null) {
                        XmlServerThread.sendXmlReplyToClient(eee.replyXmlString);
                    } else {
                        XmlServerThread.sendReplyToClient(eee.cmd.getArray(), 0, eee.cmd.getLength());
                    }
                    return;
                }
                XmlServerThread.sendToErrorClient(1, e);
            }
            throw e;
        }
    }

    private static void parseTxtInput(Document doc) throws Exception {
        try {
            XmlServerWrapper.readTextFromXmlFile(doc);
            XmlServerThread.sendToErrorClient(0, OK);
        }
        catch (Exception e) {
            if (e instanceof CommandsErrors) {
                CommandsErrors eee = (CommandsErrors)e;
                XmlServerThread.sendToErrorClient(eee.getNumError(), eee);
            } else {
                XmlServerThread.sendToErrorClient(1, e);
            }
            throw e;
        }
    }

    private static void readTextFromXmlFile(Document doc) throws Exception {
        Element dataEl = doc.getDocumentElement();
        NodeList dataNode = dataEl.getElementsByTagName("DATA");
        int dataList = dataNode.getLength();
        int i = 0;
        while (i < dataList) {
            Element elem = (Element)dataNode.item(i);
            String text = elem.getAttribute("TXT");
            if (text == null || text.equals("")) {
                throw new Exception("Nepoznata komanda!");
            }
            CommandWrapper.print(text, 0);
            ++i;
        }
    }

    private static final void readArticlesFromXML(Document doc) throws Exception {
        Element artEl = doc.getDocumentElement();
        NodeList dataNode = artEl.getElementsByTagName("DATA");
        int dataList = dataNode.getLength();
        PLU.vecNew.removeAllElements();
        PLU.vecPrice.removeAllElements();
        PLU.vecDelCode.removeAllElements();
        PLU.vecDelBarcode.removeAllElements();
        int i = 0;
        while (i < dataList) {
            Element elem = (Element)dataNode.item(i);
            PLU plu = new PLU();
            plu.code = Integer.parseInt(elem.getAttribute("PLU"));
            plu.desc = elem.getAttribute("DESC");
            plu.poreskaStopa = Byte.parseByte(elem.getAttribute("VAT"));
            if (!MainFrame.PRINTER) {
                plu.barCode = Long.parseLong(elem.getAttribute("BCR"));
            }
            plu.cena = Integer.parseInt(elem.getAttribute("PRC"));
            if (!MainFrame.PRINTER) {
                plu.odeljenje = Byte.parseByte(elem.getAttribute("DEP"));
            }
            plu.jedinicaMere = Byte.parseByte(elem.getAttribute("MES"));
            String pom = elem.getAttribute("CMD");
            if (pom == null) {
                PLU.vecNew.add(plu);
            }
            if (pom.equals("")) {
                PLU.vecNew.add(plu);
            }
            if (pom.equals("N")) {
                PLU.vecNew.add(plu);
            }
            if (pom.equals("D")) {
                PLU.vecDelCode.add(plu);
            }
            if (pom.equals("P")) {
                PLU.vecPrice.add(plu);
            }
            ++i;
        }
    }

    private static void readBonFromXml(Document doc) throws Exception {
        Element dataEl = doc.getDocumentElement();
        NodeList dataNode = dataEl.getElementsByTagName("DATA");
        int dataList = dataNode.getLength();
        PLU.vecBon.removeAllElements();
        PLU.vecPay.removeAllElements();
        int i = 0;
        while (i < dataList) {
            Element elem = (Element)dataNode.item(i);
            PLU plu = new PLU();
            plu.barCode = 0L;
            String pom = elem.getAttribute("PAY");
            if (pom == null || pom.equals("")) {
                plu.barCode = Long.parseLong(elem.getAttribute("BCR"));
                plu.kolicina = SysUtil.parseLong(elem.getAttribute("AMN"), 3);
                plu.cena = (int)SysUtil.parseLong(elem.getAttribute("PRC"), 2);
                PLU.vecBon.add(plu);
            } else {
                if (pom.equals("G")) {
                    plu.barCode = SysUtil.parseLong(elem.getAttribute("AMN"), 2);
                }
                if (pom.equals("C")) {
                    plu.prodato = SysUtil.parseLong(elem.getAttribute("AMN"), 2);
                }
                if (pom.equals("K")) {
                    plu.kolicina = SysUtil.parseLong(elem.getAttribute("AMN"), 2);
                }
                PLU.vecPay.add(plu);
            }
            ++i;
        }
    }

    private static void readCommandFromXml(Document doc) throws Exception {
        Element dataEl = doc.getDocumentElement();
        NodeList dataNode = dataEl.getElementsByTagName("DATA");
        int dataList = dataNode.getLength();
        int i = 0;
        while (i < dataList) {
            Element elem = (Element)dataNode.item(i);
            String pom = elem.getAttribute("CMD");
            if (pom == null || pom.equals("")) {
                throw new Exception("Nepoznata komanda!");
            }
            if (pom.equals("DNEVNI_IZVESTAJ")) {
                CommandWrapper.daily = true;
            } else if (pom.equals("PRESEK_STANJA")) {
                CommandWrapper.state = true;
            } else if (pom.equals("PERIODICNI_IZVESTAJ")) {
                SimpleDateFormat sdf = new SimpleDateFormat("ddMMyy");
                sdf.parse(elem.getAttribute("FROM"));
                CommandWrapper.from = sdf.getCalendar().getTimeInMillis();
                sdf.parse(elem.getAttribute("TO"));
                CommandWrapper.to = sdf.getCalendar().getTimeInMillis();
                CommandWrapper.periodical = true;
            } else if (pom.equals("OBRISI_SVE_ARTIKLE")) {
                CommandWrapper.deleteAll = true;
            } else if (pom.equals("STANJE_RACUNA")) {
                CommandWrapper.bill_state = true;
            } else if (pom.equals("STANJE_KASE")) {
                CommandWrapper.register_state = true;
            } else if (pom.equals("ARTIKLI")) {
                CommandWrapper.read_articles = true;
            } else if (pom.equals("ZURNAL")) {
                CommandWrapper.read_journal = true;
            } else if (pom.equals("PORESKE_STOPE")) {
                CommandWrapper.read_vats = true;
            } else if (pom.equals("PRODATI_ARTIKLI")) {
                CommandWrapper.read_sold_articles = true;
            } else if (pom.equals("PRIJAVA_KASIRA")) {
                CommandWrapper.log_in_code = Integer.parseInt(elem.getAttribute("CODE"));
                CommandWrapper.log_in = true;
            } else if (pom.equals("PROVERI_FISKALNI_DAN")) {
                CommandWrapper.fiscal_day_started = true;
            } else if (pom.equals("REKLAMA")) {
                CommandWrapper.adver_type = Integer.parseInt(elem.getAttribute("TYPE"));
                CommandWrapper.adver = true;
            } else if (pom.equals("USER_COMMAND")) {
                int ccc = Integer.parseInt(elem.getAttribute("COMMAND_BYTE"));
                Command.userInstance.reset();
                Command.userInstance.setCmd(ccc);
                NodeList cdNode = elem.getElementsByTagName("COMMAND_DATA");
                int j = 0;
                while (j < cdNode.getLength()) {
                    Element cdElem = (Element)cdNode.item(j);
                    if (cdElem.hasAttribute("TXT")) {
                        String txt = cdElem.getAttribute("TXT");
                        SysUtil.formatForSend(txt, Command.userInstance);
                    } else {
                        int len = Integer.parseInt(cdElem.getAttribute("LENGTH"));
                        long value = Long.parseLong(cdElem.getAttribute("VALUE"));
                        Command.userInstance.addLong(value, len);
                    }
                    ++j;
                }
                CommandWrapper.user_command = true;
            } else {
                throw new Exception("Nepoznata komanda!");
            }
            ++i;
        }
    }

    private static final void readUsersFromXML(Document doc) throws Exception {
        Element docEl = doc.getDocumentElement();
        NodeList dataNode = docEl.getElementsByTagName("DATA");
        int dataList = dataNode.getLength();
        int i = 0;
        while (i < dataList) {
            Element elem = (Element)dataNode.item(i);
            if (elem == null) {
                return;
            }
            Users user = new Users();
            user.no = Integer.parseInt(elem.getAttribute("NO"));
            user.code = Long.parseLong(elem.getAttribute("CODE"));
            user.ime = elem.getAttribute("NAME");
            user.level = Byte.parseByte(elem.getAttribute("LEVEL"));
            user.sendToPort();
            ++i;
        }
    }
}

