/*
 * Decompiled with CFR 0.152.
 */
package objects;

import cashRegister.Command;
import gui.MainFrame;
import gui.rightPanels.ControlPanel;
import gui.rightPanels.LogPanel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import objects.Settings;
import objects.fiscal.CommandWrapper;
import objects.fiscal.PLU;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.SysUtil;

public class XmlFileWrapper {
    private static DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    public static void parseArtFile(File file) throws Exception {
        if (Settings.getInstance().useThreadTimeout) {
            SysUtil.delay(Settings.getInstance().timeoutThread);
        }
        String name = file.getName();
        try {
            try {
                XmlFileWrapper.readArticlesFromXML(file);
                PLU.deleteAllByCode();
                PLU.deleteAllByBarcode();
                PLU.programmAll();
                PLU.changeAllPrices();
                PLU.changeAllPricesBarcode();
                SysUtil.writeOkFile(name);
            }
            catch (Exception e) {
                SysUtil.writeErrorFile(name, e);
                PLU.vecDelCode.removeAllElements();
                PLU.vecDelBarcode.removeAllElements();
                PLU.vecNew.removeAllElements();
                PLU.vecPrice.removeAllElements();
                PLU.vecPriceBarcode.removeAllElements();
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
        }
        finally {
            PLU.vecDelCode.removeAllElements();
            PLU.vecDelBarcode.removeAllElements();
            PLU.vecNew.removeAllElements();
            PLU.vecPrice.removeAllElements();
            PLU.vecPriceBarcode.removeAllElements();
            if (Settings.getInstance().useThreadDeleteInput) {
                SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
            }
            file.delete();
        }
    }

    public static void parseBonFile(File file) throws Exception {
        if (Settings.getInstance().useThreadTimeout) {
            SysUtil.delay(Settings.getInstance().timeoutThread);
        }
        String name = file.getName();
        try {
            try {
                XmlFileWrapper.readBonFromXml(file);
                PLU.sellAll();
                PLU.payAll();
                SysUtil.writeOkFile(name);
            }
            catch (Exception e) {
                SysUtil.writeErrorFile(name, e);
                PLU.vecPay.removeAllElements();
                PLU.vecBon.removeAllElements();
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
        }
        finally {
            PLU.vecPay.removeAllElements();
            PLU.vecBon.removeAllElements();
            if (Settings.getInstance().useThreadDeleteInput) {
                SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
            }
            file.delete();
        }
    }

    public static void parseCmdFile(File file) throws Exception {
        if (Settings.getInstance().useThreadTimeout) {
            SysUtil.delay(Settings.getInstance().timeoutThread);
        }
        String name = file.getName();
        try {
            try {
                XmlFileWrapper.readCommandFromXml(file);
                CommandWrapper.execAll();
                SysUtil.writeOkFile(name);
            }
            catch (Exception e) {
                SysUtil.writeErrorFile(name, e);
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
        }
        finally {
            if (Settings.getInstance().useThreadDeleteInput) {
                SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
            }
            file.delete();
        }
    }

    public static void parseTxtFile(File file) throws Exception {
        if (Settings.getInstance().useThreadTimeout) {
            SysUtil.delay(Settings.getInstance().timeoutThread);
        }
        String name = file.getName();
        try {
            try {
                XmlFileWrapper.readTextFromXmlFile(file);
                SysUtil.writeOkFile(name);
            }
            catch (Exception e) {
                SysUtil.writeErrorFile(name, e);
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
        }
        finally {
            if (Settings.getInstance().useThreadDeleteInput) {
                SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
            }
            file.delete();
        }
    }

    private static void readTextFromXmlFile(File file) throws Exception {
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            String str;
            LogPanel.println("FILE CONTENT START:");
            while ((str = in.readLine()) != null) {
                LogPanel.println(str);
            }
            LogPanel.println("FILE CONTENT END:");
        }
        Document doc = null;
        DocumentBuilder db = dbf.newDocumentBuilder();
        doc = db.parse(file);
        Element dataEl = doc.getDocumentElement();
        NodeList dataNode = dataEl.getElementsByTagName("DATA");
        int dataList = dataNode.getLength();
        int i = 0;
        while (i < dataList) {
            Element elem = (Element)dataNode.item(i);
            String text = elem.getAttribute("TXT");
            if (text.length() != 0) {
                if (text.length() == 0) {
                    throw new Exception("Nepoznata komanda!");
                }
                CommandWrapper.print(text, 0);
            } else {
                text = elem.getAttribute("T1D");
                if (text.length() != 0) {
                    if ((text = text.trim()).length() == 0) {
                        throw new Exception("Nepoznata komanda!");
                    }
                    if (text.length() > 13) {
                        throw new Exception("Predugacak string!");
                    }
                    CommandWrapper.print(text, 1);
                } else {
                    text = elem.getAttribute("T2D");
                    if (text.length() != 0) {
                        if (text.equals("")) {
                            throw new Exception("Nepoznata komanda!");
                        }
                        if (text.length() > 64) {
                            throw new Exception("Predugacak string!");
                        }
                        CommandWrapper.print(text, 2);
                    } else {
                        throw new Exception("Nepoznata komanda!");
                    }
                }
            }
            ++i;
        }
    }

    private static final void readArticlesFromXML(File file) throws Exception {
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            String str;
            LogPanel.println("FILE CONTENT START:");
            while ((str = in.readLine()) != null) {
                LogPanel.println(str);
            }
            LogPanel.println("FILE CONTENT END:");
        }
        Document doc = null;
        DocumentBuilder db = dbf.newDocumentBuilder();
        doc = db.parse(file);
        Element artEl = doc.getDocumentElement();
        NodeList dataNode = artEl.getElementsByTagName("DATA");
        int dataList = dataNode.getLength();
        PLU.vecNew.removeAllElements();
        PLU.vecPrice.removeAllElements();
        PLU.vecDelCode.removeAllElements();
        PLU.vecDelBarcode.removeAllElements();
        int i = 0;
        while (i < dataList) {
            Element elem = (Element)dataNode.item(i);
            PLU plu = new PLU();
            plu.code = Integer.parseInt(elem.getAttribute("PLU"));
            plu.desc = elem.getAttribute("DESC");
            plu.poreskaStopa = Byte.parseByte(elem.getAttribute("VAT"));
            if (!MainFrame.PRINTER) {
                plu.barCode = Long.parseLong(elem.getAttribute("BCR"));
            }
            plu.cena = Integer.parseInt(elem.getAttribute("PRC"));
            if (!MainFrame.PRINTER) {
                plu.odeljenje = Byte.parseByte(elem.getAttribute("DEP"));
            }
            plu.jedinicaMere = Byte.parseByte(elem.getAttribute("MES"));
            String pom = elem.getAttribute("CMD");
            if (pom == null) {
                PLU.vecNew.add(plu);
            }
            if (pom.equals("")) {
                PLU.vecNew.add(plu);
            }
            if (pom.equals("N")) {
                PLU.vecNew.add(plu);
            }
            if (pom.equals("D")) {
                PLU.vecDelCode.add(plu);
            }
            if (pom.equals("P")) {
                PLU.vecPrice.add(plu);
            }
            ++i;
        }
    }

    private static void readBonFromXml(File file) throws Exception {
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            String str;
            LogPanel.println("FILE CONTENT START:");
            while ((str = in.readLine()) != null) {
                LogPanel.println(str);
            }
            LogPanel.println("FILE CONTENT END:");
        }
        Document doc = null;
        DocumentBuilder db = dbf.newDocumentBuilder();
        doc = db.parse(file);
        Element dataEl = doc.getDocumentElement();
        NodeList dataNode = dataEl.getElementsByTagName("DATA");
        int dataList = dataNode.getLength();
        PLU.vecBon.removeAllElements();
        PLU.vecPay.removeAllElements();
        int i = 0;
        while (i < dataList) {
            Element elem = (Element)dataNode.item(i);
            PLU plu = new PLU();
            plu.barCode = 0L;
            String pom = elem.getAttribute("PAY");
            if (pom == null || pom.equals("")) {
                plu.barCode = Long.parseLong(elem.getAttribute("BCR"));
                plu.kolicina = SysUtil.parseLong(elem.getAttribute("AMN"), 3);
                plu.cena = (int)SysUtil.parseLong(elem.getAttribute("PRC"), 2);
                PLU.vecBon.add(plu);
            } else {
                if (pom.equals("G")) {
                    plu.barCode = SysUtil.parseLong(elem.getAttribute("AMN"), 2);
                }
                if (pom.equals("C")) {
                    plu.prodato = SysUtil.parseLong(elem.getAttribute("AMN"), 2);
                }
                if (pom.equals("K")) {
                    plu.kolicina = SysUtil.parseLong(elem.getAttribute("AMN"), 2);
                }
                PLU.vecPay.add(plu);
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void readCommandFromXml(File file) throws Exception {
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            String str;
            LogPanel.println("FILE CONTENT START:");
            while ((str = in.readLine()) != null) {
                LogPanel.println(str);
            }
            LogPanel.println("FILE CONTENT END:");
        }
        Document doc = null;
        DocumentBuilder db = dbf.newDocumentBuilder();
        doc = db.parse(file);
        Element dataEl = doc.getDocumentElement();
        NodeList dataNode = dataEl.getElementsByTagName("DATA");
        int dataList = dataNode.getLength();
        int i = 0;
        while (i < dataList) {
            Element elem = (Element)dataNode.item(i);
            String pom = elem.getAttribute("CMD");
            if (pom == null || pom.equals("")) {
                throw new Exception("Nepoznata komanda!");
            }
            if (pom.equals("DNEVNI_IZVESTAJ")) {
                CommandWrapper.daily = true;
            } else if (pom.equals("PRESEK_STANJA")) {
                CommandWrapper.state = true;
            } else if (pom.equals("PERIODICNI_IZVESTAJ")) {
                SimpleDateFormat sdf = new SimpleDateFormat("ddMMyy");
                try {
                    sdf.parse(elem.getAttribute("FROM"));
                }
                catch (ParseException e) {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "Pogre\u0161an format datuma!\n" + e.getMessage() + "\n Ispravan format = \"01012017\"", "GRE\u0160KA", 0);
                    return;
                }
                CommandWrapper.from = sdf.getCalendar().getTimeInMillis();
                try {
                    sdf.parse(elem.getAttribute("TO"));
                }
                catch (ParseException e) {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "Pogre\u0161an format datuma!\n" + e.getMessage() + "\n Ispravan format = \"01012017\"", "GRE\u0160KA", 0);
                    return;
                }
                CommandWrapper.to = sdf.getCalendar().getTimeInMillis();
                CommandWrapper.periodical = true;
            } else if (pom.equals("OBRISI_SVE_ARTIKLE")) {
                CommandWrapper.deleteAll = true;
            } else if (pom.equals("STANJE_RACUNA")) {
                CommandWrapper.bill_state = true;
            } else if (pom.equals("STANJE_KASE")) {
                CommandWrapper.register_state = true;
            } else if (pom.equals("STANJE_DNEVNOG_IZVESTAJA")) {
                CommandWrapper.z_state = true;
            } else if (pom.equals("FISKALNI_PODACI")) {
                CommandWrapper.read_fiscal_data = true;
            } else if (pom.equals("ARTIKLI")) {
                CommandWrapper.read_articles = true;
            } else if (pom.equals("ARTIKAL")) {
                int kod = Integer.parseInt(elem.getAttribute("BRC"));
                CommandWrapper.read_article = true;
                PLU.kod = kod;
            } else if (pom.equals("ZURNAL")) {
                CommandWrapper.read_journal = true;
            } else if (pom.equals("PORESKE_STOPE")) {
                CommandWrapper.read_vats = true;
            } else if (pom.equals("JEDINICE_MERE")) {
                CommandWrapper.read_measures = true;
            } else if (pom.equals("PRODATI_ARTIKLI")) {
                CommandWrapper.read_sold_articles = true;
            } else if (pom.equals("PRIJAVA_KASIRA")) {
                CommandWrapper.log_in_code = Integer.parseInt(elem.getAttribute("CODE"));
                CommandWrapper.log_in = true;
            } else if (pom.equals("STAMPAJ_KASIRE")) {
                CommandWrapper.cashier_print = true;
            } else if (pom.equals("PROVERI_FISKALNI_DAN")) {
                CommandWrapper.fiscal_day_started = true;
            } else if (pom.equals("PROCITAJ_FISKALNI_DAN")) {
                CommandWrapper.read_daily_num = Integer.parseInt(elem.getAttribute("NO"));
                CommandWrapper.read_daily = true;
            } else if (pom.equals("OTVORI_FIOKU")) {
                if (!ControlPanel.printer.isSelected()) throw new Exception("Command is not supported on cash register!");
                CommandWrapper.open_drawer = true;
            } else if (pom.equals("REKLAMA")) {
                CommandWrapper.adver_type = Integer.parseInt(elem.getAttribute("TYPE"));
                CommandWrapper.adver = true;
            } else if (pom.equals("DISPLEJ")) {
                CommandWrapper.display_1 = elem.getAttribute("RED_1");
                CommandWrapper.display_2 = elem.getAttribute("RED_2");
                CommandWrapper.display = true;
            } else if (pom.equals("STORNO_RACUN")) {
                CommandWrapper.storno_bill = true;
            } else {
                if (!pom.equals("USER_COMMAND")) throw new Exception("Nepoznata komanda!");
                int ccc = Integer.parseInt(elem.getAttribute("COMMAND_BYTE"));
                Command.userInstance.reset();
                Command.userInstance.setCmd(ccc);
                NodeList cdNode = elem.getElementsByTagName("COMMAND_DATA");
                int j = 0;
                while (j < cdNode.getLength()) {
                    Element cdElem = (Element)cdNode.item(j);
                    if (cdElem.hasAttribute("TXT")) {
                        String txt = cdElem.getAttribute("TXT");
                        SysUtil.formatForSend(txt, Command.userInstance);
                    } else {
                        int len = Integer.parseInt(cdElem.getAttribute("LENGTH"));
                        long value = Long.parseLong(cdElem.getAttribute("VALUE"));
                        Command.userInstance.addLong(value, len);
                    }
                    ++j;
                }
                CommandWrapper.user_command = true;
            }
            ++i;
        }
    }
}

