/*
 * Decompiled with CFR 0.152.
 */
package objects;

import gui.MainFrame;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import objects.XmlServerThread;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.XML.XmlFileWriter;
import util.XML.XmlObject;
import util.comPort.PortSerial;

public class Settings
implements XmlObject {
    public static final int FILE_TYPE_CSV = 1;
    public static final int FILE_TYPE_DBF = 2;
    public static final int FILE_TYPE_XML = 3;
    public static final int FILE_TYPE_FISCTT = 4;
    private volatile int fileType = 0;
    public static final int FILE_MODE = 1;
    public static final int SERVER_MODE = 2;
    public volatile int mode = 0;
    private String language;
    public File FOLDER_OUT;
    public File FOLDER_IN;
    public File SET_FOLDER;
    public static int in = 1;
    public static int out = 2;
    public static int set = 3;
    public boolean EMPTY_OUT;
    public boolean EMPTY_IN;
    private int posx;
    private int posy;
    private int state;
    public volatile boolean bold = false;
    public static volatile boolean printer = false;
    public static volatile boolean secunda = false;
    public static volatile boolean bestlcplus = false;
    public volatile boolean serial_open = false;
    public volatile boolean prima = false;
    public static volatile boolean epson = false;
    public volatile boolean start = true;
    public volatile boolean log_start = false;
    public volatile boolean serial_monitor = true;
    public volatile boolean big_amount = false;
    public volatile boolean show_error_dialog = true;
    public volatile boolean restart = false;
    public volatile int timeoutThread;
    public volatile int timeoutDeleteInput;
    public volatile int timeoutDeleteOutput;
    public volatile boolean useThreadTimeout;
    public volatile boolean useThreadDeleteInput;
    public volatile boolean useThreadDeleteOutput;
    public volatile int timeoutErrorClient;
    public volatile boolean useAutoClosure;
    public volatile int bindingPort;
    private static Settings instance = new Settings();

    public static Settings getInstance() {
        return instance;
    }

    private Settings() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.posx = d.width / 2 - 320;
        this.posy = d.height / 2 - 240;
        this.bold = false;
        this.state = 0;
        this.restart = false;
        this.fileType = 3;
        this.mode = 0;
        this.FOLDER_OUT = new File("HCP/FROM_FP");
        this.FOLDER_IN = new File("HCP/TO_FP");
        this.SET_FOLDER = new File("HCP/log");
        this.FOLDER_IN.mkdirs();
        this.FOLDER_OUT.mkdirs();
        this.SET_FOLDER.mkdirs();
        this.EMPTY_OUT = false;
        this.EMPTY_IN = false;
        this.timeoutThread = 200;
        this.timeoutDeleteInput = 200;
        this.timeoutDeleteOutput = 200;
        this.useThreadTimeout = false;
        this.useThreadDeleteInput = false;
        this.useThreadDeleteOutput = false;
        this.language = "";
        this.bindingPort = 9999;
        this.timeoutErrorClient = 10000;
        this.useAutoClosure = true;
        XmlServerThread.commandServerPort = 3535;
        XmlServerThread.SERVER_IP = "localhost";
    }

    @Override
    public void writeToXML(XmlFileWriter writer) throws Exception {
        writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        writer.writeLn("<SETTINGS>");
        if (writer == null) {
            return;
        }
        writer.indent();
        writer.write("<DATA POSX='" + this.posx + "'");
        writer.write(" POSY='" + this.posy + "'");
        writer.write(" FILE_TYPE='" + this.fileType + "'");
        writer.write(" WORKING_MODE='" + this.mode + "'");
        writer.write(" PORT='" + PortSerial.sPort + "'");
        writer.write(" SPEED='" + PortSerial.speed + "'");
        writer.write(" BOLD='" + this.bold + "'");
        writer.write(" PRINTER='" + printer + "'");
        writer.write(" LANG='" + this.language + "'");
        writer.write(" SECUNDA='" + secunda + "'");
        writer.write(" EPSON='" + epson + "'");
        writer.write(" BESTLCPLUS='" + bestlcplus + "'");
        writer.write(" PRIMA='" + this.prima + "'");
        writer.write(" SERIAL_OPEN='" + this.serial_open + "'");
        writer.write(" WHEN_WIN_START='" + this.start + "'");
        writer.write(" LOG_START='" + this.log_start + "'");
        writer.write(" SERIAL_MONITOR='" + this.serial_monitor + "'");
        writer.write(" BIG_AMOUNT_PARSER='" + this.big_amount + "'");
        writer.write(" SHOW_ERROR_DIALOG='" + this.show_error_dialog + "'");
        writer.write(" STATE='" + this.state + "'");
        writer.write(" RESTART='" + this.restart + "'");
        writer.write(" EMPTY_OUT='" + this.EMPTY_OUT + "'");
        writer.write(" EMPTY_IN='" + this.EMPTY_IN + "'");
        writer.write(" FOLDER_OUT='" + this.FOLDER_OUT + "'");
        writer.write(" FOLDER_IN='" + this.FOLDER_IN + "'");
        writer.write(" SET_FOLDER='" + this.SET_FOLDER + "'");
        writer.write(" T1='" + this.timeoutThread + "'");
        writer.write(" T2='" + this.timeoutDeleteInput + "'");
        writer.write(" T3='" + this.timeoutDeleteOutput + "'");
        writer.write(" useT1='" + this.useThreadTimeout + "'");
        writer.write(" useT2='" + this.useThreadDeleteInput + "'");
        writer.write(" useT3='" + this.useThreadDeleteOutput + "'");
        writer.write(" BINDING_PORT='" + this.bindingPort + "'");
        writer.write(" TE='" + this.timeoutErrorClient + "'");
        writer.write(" useAC='" + this.useAutoClosure + "'");
        writer.write(" COMMAND_PORT='" + XmlServerThread.commandServerPort + "'");
        writer.write(" SERVER_IP='" + XmlServerThread.SERVER_IP + "'");
        writer.writeLn(">");
        writer.writeLn("</DATA>");
        writer.unintent();
        writer.writeLn("</SETTINGS>");
    }

    @Override
    public void readFromXML(File file) throws Exception {
        Element elem;
        block30: {
            Document doc = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(file);
            Element artEl = doc.getDocumentElement();
            NodeList dataNode = artEl.getElementsByTagName("DATA");
            elem = (Element)dataNode.item(0);
            if (elem == null) {
                return;
            }
            try {
                try {
                    this.FOLDER_IN = new File(elem.getAttribute("FOLDER_IN"));
                    this.checkPath(this.FOLDER_IN, in);
                    this.FOLDER_OUT = new File(elem.getAttribute("FOLDER_OUT"));
                    this.checkPath(this.FOLDER_OUT, out);
                    this.SET_FOLDER = new File(elem.getAttribute("SET_FOLDER"));
                    this.checkPath(this.SET_FOLDER, set);
                }
                catch (Exception e) {
                    this.FOLDER_OUT = new File("C:/HCP/FROM_FP");
                    this.FOLDER_IN = new File("C:/HCP/TO_FP");
                    this.SET_FOLDER = new File("C:/HCP/log");
                    this.FOLDER_IN.mkdirs();
                    this.FOLDER_OUT.mkdirs();
                    this.SET_FOLDER.mkdirs();
                    break block30;
                }
            }
            catch (Throwable throwable) {
                this.FOLDER_IN.mkdirs();
                this.FOLDER_OUT.mkdirs();
                this.SET_FOLDER.mkdirs();
                throw throwable;
            }
            this.FOLDER_IN.mkdirs();
            this.FOLDER_OUT.mkdirs();
            this.SET_FOLDER.mkdirs();
        }
        try {
            this.setPosx(Integer.parseInt(elem.getAttribute("POSX")));
            this.setPosy(Integer.parseInt(elem.getAttribute("POSY")));
            this.fileType = Integer.parseInt(elem.getAttribute("FILE_TYPE"));
            this.mode = Integer.parseInt(elem.getAttribute("WORKING_MODE"));
            this.setState(Integer.parseInt(elem.getAttribute("STATE")));
            PortSerial.sPort = elem.getAttribute("PORT");
            PortSerial.speed = Integer.parseInt(elem.getAttribute("SPEED"));
            if (elem.hasAttribute("BOLD")) {
                this.bold = Boolean.parseBoolean(elem.getAttribute("BOLD"));
            }
            if (elem.hasAttribute("PRINTER")) {
                printer = Boolean.parseBoolean(elem.getAttribute("PRINTER"));
            }
            if (elem.hasAttribute("SECUNDA")) {
                secunda = Boolean.parseBoolean(elem.getAttribute("SECUNDA"));
            }
            if (elem.hasAttribute("EPSON")) {
                epson = Boolean.parseBoolean(elem.getAttribute("EPSON"));
            }
            if (elem.hasAttribute("BESTLCPLUS")) {
                bestlcplus = Boolean.parseBoolean(elem.getAttribute("BESTLCPLUS"));
            }
            if (elem.hasAttribute("PRIMA")) {
                this.prima = Boolean.parseBoolean(elem.getAttribute("PRIMA"));
            }
            if (elem.hasAttribute("SERIAL_OPEN")) {
                this.serial_open = Boolean.parseBoolean(elem.getAttribute("SERIAL_OPEN"));
            }
            if (elem.hasAttribute("WHEN_WIN_START")) {
                this.start = Boolean.parseBoolean(elem.getAttribute("WHEN_WIN_START"));
            }
            if (elem.hasAttribute("LOG_START")) {
                this.log_start = Boolean.parseBoolean(elem.getAttribute("LOG_START"));
            }
            if (elem.hasAttribute("SERIAL_MONITOR")) {
                this.serial_monitor = Boolean.parseBoolean(elem.getAttribute("SERIAL_MONITOR"));
            }
            if (elem.hasAttribute("BIG_AMOUNT_PARSER")) {
                this.big_amount = Boolean.parseBoolean(elem.getAttribute("BIG_AMOUNT_PARSER"));
            }
            if (elem.hasAttribute("SHOW_ERROR_DIALOG")) {
                this.show_error_dialog = Boolean.parseBoolean(elem.getAttribute("SHOW_ERROR_DIALOG"));
            }
            if (elem.hasAttribute("RESTART")) {
                this.restart = Boolean.parseBoolean(elem.getAttribute("RESTART"));
            }
            this.language = elem.getAttribute("LANG");
            this.EMPTY_OUT = Boolean.parseBoolean(elem.getAttribute("EMPTY_OUT"));
            this.EMPTY_IN = Boolean.parseBoolean(elem.getAttribute("EMPTY_IN"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.timeoutThread = Integer.parseInt(elem.getAttribute("T1"));
            this.timeoutDeleteInput = Integer.parseInt(elem.getAttribute("T2"));
            this.timeoutDeleteOutput = Integer.parseInt(elem.getAttribute("T3"));
            this.useThreadTimeout = Boolean.parseBoolean(elem.getAttribute("useT1"));
            this.useThreadDeleteInput = Boolean.parseBoolean(elem.getAttribute("useT2"));
            this.useThreadDeleteOutput = Boolean.parseBoolean(elem.getAttribute("useT3"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bindingPort = Integer.parseInt(elem.getAttribute("BINDING_PORT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.timeoutErrorClient = Integer.parseInt(elem.getAttribute("TE"));
            XmlServerThread.commandServerPort = Integer.parseInt(elem.getAttribute("COMMAND_PORT"));
            XmlServerThread.SERVER_IP = elem.getAttribute("SERVER_IP");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (elem.hasAttribute("useAC")) {
                this.useAutoClosure = Boolean.parseBoolean(elem.getAttribute("useAC"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getPosx() {
        return this.posx;
    }

    public int getPosy() {
        return this.posy;
    }

    public void setPosx(int posx) {
        this.posx = posx;
    }

    public void setPosy(int posy) {
        this.posy = posy;
    }

    public final boolean isBold() {
        return this.bold;
    }

    public final void setBold(boolean bold) {
        this.bold = bold;
    }

    public final int getFileType() {
        return this.fileType;
    }

    public final void setFileType(int fileType) {
        this.fileType = fileType;
    }

    public final boolean isPrinter() {
        return printer;
    }

    public final boolean isSecunda() {
        return secunda;
    }

    public final boolean isEpson() {
        return epson;
    }

    public final boolean isBestLcPlus() {
        return bestlcplus;
    }

    public final boolean isSerialOpen() {
        return this.serial_open;
    }

    public final boolean isStartUp() {
        return this.start;
    }

    public final boolean isLogStart() {
        return this.log_start;
    }

    public final boolean isSerialMonitor() {
        return this.serial_monitor;
    }

    public final boolean isBigAmount() {
        return this.big_amount;
    }

    public final boolean isErrorDialog() {
        return this.show_error_dialog;
    }

    public final boolean isRestart() {
        return this.restart;
    }

    public final String getLanguage() {
        return this.language;
    }

    public final void setLanguage(String language) {
        this.language = language;
    }

    public final void setPrinter(boolean printer) {
        Settings.printer = printer;
        MainFrame.PRINTER = printer;
        PortSerial.SOX = MainFrame.PRINTER ? 3 : 1;
    }

    public final void setSecunda(boolean secunda) {
        Settings.secunda = secunda;
        MainFrame.SECUNDA = secunda;
    }

    public final void setEpson(boolean epson) {
        Settings.epson = epson;
        MainFrame.EPSON = epson;
    }

    public final void setBestLcPlus(boolean bestlcplus) {
        Settings.bestlcplus = bestlcplus;
        MainFrame.BESTLCPLUS = bestlcplus;
    }

    public final void setSerialOpen(boolean value) {
        MainFrame.SERIAL_KEEP_OPENED = this.serial_open = value;
    }

    public final void setStartUp(boolean start) {
        this.start = start;
        MainFrame.START = start;
    }

    public final void setLogStart(boolean log_start) {
        this.log_start = log_start;
        MainFrame.LOG_START = log_start;
    }

    public final void setSerialMonitor(boolean serial_monitor) {
        this.serial_monitor = serial_monitor;
        MainFrame.SERIAL_MONITOR = serial_monitor;
    }

    public final void setBigAmount(boolean big_amount) {
        this.big_amount = big_amount;
        MainFrame.BIG_AMOUNT = big_amount;
    }

    public final void setErrorDialog(boolean show_error_dialog) {
        this.show_error_dialog = show_error_dialog;
        MainFrame.SHOW_ERROR_DIALOG = show_error_dialog;
    }

    public final void setRestart(boolean restart) {
        this.restart = restart;
        MainFrame.RESTART = restart;
    }

    public final boolean isPrima() {
        return this.prima;
    }

    public final void setPrima(boolean prima) {
        this.prima = prima;
        MainFrame.PRIMA = prima;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void checkPath(File fj, int i) throws Exception {
        if (!fj.exists()) {
            if (i == 1) {
                this.FOLDER_IN = new File("C:/HCP/TO_FP");
                MainFrame.fIn = true;
            } else if (i == 2) {
                this.FOLDER_OUT = new File("C:/HCP/FROM_FP");
                MainFrame.fOut = true;
            } else if (i == 3) {
                this.SET_FOLDER = new File("C:/HCP/log");
                MainFrame.fFolder = true;
            }
        }
    }
}

