/*
 * Decompiled with CFR 0.152.
 */
package objects;

import gui.MainFrame;
import gui.rightPanels.ControlPanel;
import gui.rightPanels.LogPanel;
import java.io.File;
import java.io.FileFilter;
import java.util.Date;
import objects.CsvFileWrapper;
import objects.DbfFileWrapper;
import objects.Settings;
import objects.XmlFileWrapper;
import objects.fiscal.AdvertisementWrapper;
import objects.fiscal.CommandWrapper;
import objects.fiscal.Users;
import objects.fisctt.FisCtt;
import util.SysUtil;

public class MainThread
extends Thread {
    public static volatile boolean work = false;
    public int i = 0;

    static {
        try {
            Settings.getInstance().FOLDER_OUT.mkdirs();
            Settings.getInstance().FOLDER_IN.mkdirs();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static void startThread() {
        String s;
        int i;
        File[] files;
        if (Settings.getInstance().EMPTY_IN) {
            try {
                files = Settings.getInstance().FOLDER_IN.listFiles();
                i = 0;
                while (i < files.length) {
                    try {
                        s = files[i].getName().toLowerCase();
                        if (s.endsWith("xml") || s.endsWith("dat") || s.endsWith("txt")) {
                            files[i].delete();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Settings.getInstance().EMPTY_OUT) {
            try {
                files = Settings.getInstance().FOLDER_OUT.listFiles();
                i = 0;
                while (i < files.length) {
                    try {
                        s = files[i].getName().toLowerCase();
                        if (s.endsWith("ok") || s.endsWith("err")) {
                            files[i].delete();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        new MainThread().start();
    }

    private synchronized void waithNotification(int time) throws Exception {
        this.wait(time);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.doJob();
                }
            }
            catch (Exception e) {
                MainFrame.getInstance().displayError(e);
                continue;
            }
            break;
        }
    }

    private void doJob() throws Exception {
        CommandWrapper.execUserCommands();
        File file = this.getNextXmlFile("settings");
        if (file != null) {
            try {
                try {
                    if (Settings.getInstance().useThreadTimeout) {
                        SysUtil.delay(Settings.getInstance().timeoutThread);
                    }
                    Settings.getInstance().readFromXML(file);
                    MainFrame.getInstance().reset();
                    SysUtil.writeOkFile("settings.xml");
                }
                catch (Exception e) {
                    SysUtil.writeErrorFile("settings.xml", e);
                    if (Settings.getInstance().useThreadDeleteInput) {
                        SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                    }
                    file.delete();
                }
            }
            finally {
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
            return;
        }
        file = this.getNextXmlFile("users");
        if (file != null) {
            try {
                try {
                    if (Settings.getInstance().useThreadTimeout) {
                        SysUtil.delay(Settings.getInstance().timeoutThread);
                    }
                    Users.readFromXML(file);
                    SysUtil.writeOkFile("users.xml");
                }
                catch (Exception e) {
                    SysUtil.writeErrorFile("users.xml", e);
                    if (Settings.getInstance().useThreadDeleteInput) {
                        SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                    }
                    file.delete();
                }
            }
            finally {
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
            return;
        }
        file = this.getNextXmlFile("advertisement");
        if (file != null) {
            try {
                try {
                    if (Settings.getInstance().useThreadTimeout) {
                        SysUtil.delay(Settings.getInstance().timeoutThread);
                    }
                    if (!MainFrame.PRINTER) {
                        throw new Exception("COMMAND IS NOT AVAILABLE!");
                    }
                    AdvertisementWrapper.getInstance().readFromXML(file);
                    AdvertisementWrapper.getInstance().programToCR();
                    SysUtil.writeOkFile("advertisement.xml");
                }
                catch (Exception e) {
                    SysUtil.writeErrorFile("advertisement.xml", e);
                    if (Settings.getInstance().useThreadDeleteInput) {
                        SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                    }
                    file.delete();
                }
            }
            finally {
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
            return;
        }
        if (!work) {
            this.waithNotification(100);
            return;
        }
        if (!Settings.getInstance().FOLDER_IN.exists()) {
            Settings.getInstance().FOLDER_IN = new File("C:/HCP/TO_FP");
            MainFrame.getInstance().saveSettings();
            ControlPanel.inPath.setText(new File("C:/HCP/TO_FP").toString());
            throw new Exception("Path IN not exists!");
        }
        if (!Settings.getInstance().FOLDER_OUT.exists()) {
            Settings.getInstance().FOLDER_OUT = new File("C:/HCP/FROM_FP");
            MainFrame.getInstance().saveSettings();
            ControlPanel.outPath.setText(new File("C:/HCP/FROM_FP").toString());
            throw new Exception("Path OUT not exists!");
        }
        if (Settings.getInstance().getFileType() == 4) {
            try {
                if (FisCtt.fileIn.exists()) {
                    FisCtt.execute();
                    FisCtt.printOk();
                }
            }
            catch (Exception e) {
                FisCtt.printError(e);
            }
            this.waithNotification(100);
            return;
        }
        if (Settings.getInstance().getFileType() == 1) {
            file = this.getNextCsvFile("ADV_");
            if (file != null) {
                CsvFileWrapper.parseAdvFile(file);
                return;
            }
            file = this.getNextCsvFile("USR_");
            if (file != null) {
                CsvFileWrapper.parseUsrFile(file);
                return;
            }
            file = this.getNextCsvFile("ART_");
            if (file != null) {
                CsvFileWrapper.parseArtFile(file);
                return;
            }
            file = this.getNextCsvFile("BON_");
            if (file != null) {
                CsvFileWrapper.parseBonFile(file);
                CsvFileWrapper.parsePayFile(file.getName());
                return;
            }
            file = this.getNextCsvFile("CMD_");
            if (file != null) {
                CsvFileWrapper.parseCmdFile(file);
                return;
            }
            file = this.getNextCsvFile("TXT_");
            if (file != null) {
                CsvFileWrapper.parseTxtFile(file);
                return;
            }
            file = this.getNextCsvFile("ABC_");
            if (file != null) {
                CsvFileWrapper.parseAbcFile(file);
                CsvFileWrapper.parsePayFile(file.getName());
                return;
            }
        }
        if (Settings.getInstance().getFileType() == 2) {
            file = this.getNextDbfFile("adv");
            if (file != null) {
                DbfFileWrapper.parseAdvFile(file);
                return;
            }
            file = this.getNextDbfFile("usr");
            if (file != null) {
                DbfFileWrapper.parseUsrFile(file);
                return;
            }
            file = this.getNextDbfFile("dat");
            if (file != null) {
                DbfFileWrapper.parseArtFile(file);
                return;
            }
            file = this.getNextDbfFile("rac");
            if (file != null) {
                DbfFileWrapper.parseBonFile(file);
                return;
            }
            file = this.getNextDbfFile("kom");
            if (file != null) {
                DbfFileWrapper.parseCmdFile(file);
                return;
            }
            file = this.getNextDbfFile("txt");
            if (file != null) {
                DbfFileWrapper.parseTxtFile(file);
                return;
            }
        }
        if (Settings.getInstance().getFileType() == 3) {
            file = this.getNextXmlFile("ART_");
            if (file != null) {
                XmlFileWrapper.parseArtFile(file);
                return;
            }
            file = this.getNextXmlFile("RAC_");
            if (file != null) {
                XmlFileWrapper.parseBonFile(file);
                return;
            }
            file = this.getNextXmlFile("KOM_");
            if (file != null) {
                XmlFileWrapper.parseCmdFile(file);
                return;
            }
            file = this.getNextXmlFile("TXT_");
            if (file != null) {
                XmlFileWrapper.parseTxtFile(file);
                return;
            }
        }
        this.waithNotification(100);
    }

    private File getNextXmlFile(String pf) {
        return this.getNextFile(pf, ".XML");
    }

    private File getNextDbfFile(String pf) {
        return this.getNextFile(pf, ".txt");
    }

    private File getNextCsvFile(String pf) {
        return this.getNextFile(pf, ".DAT");
    }

    private int getFileNumber(File file) {
        int num = Integer.MAX_VALUE;
        try {
            String name = file.getName();
            switch (Settings.getInstance().getFileType()) {
                case 2: {
                    num = Integer.parseInt(name.substring(4, name.indexOf(46)));
                    break;
                }
                case 1: {
                    num = Integer.parseInt(name.substring(3, name.indexOf(46)));
                    break;
                }
                case 3: {
                    num = Integer.parseInt(name.substring(4, name.indexOf(46)));
                }
            }
            num = Integer.parseInt(name.substring(4, name.indexOf(46)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }

    private File getNextFile(final String type, final String ext) {
        File ff = null;
        File[] files = Settings.getInstance().FOLDER_IN.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String t = type.toUpperCase();
                String e = ext.toUpperCase();
                String p = pathname.getName().toUpperCase();
                if (pathname.isDirectory()) {
                    return false;
                }
                if (p.length() < 7) {
                    return false;
                }
                if (!p.endsWith(e)) {
                    return false;
                }
                return p.startsWith(t);
            }
        });
        if (files.length <= 0) {
            return null;
        }
        if (type.equalsIgnoreCase("settings")) {
            return files[0];
        }
        if (type.equalsIgnoreCase("users")) {
            return files[0];
        }
        ff = files[0];
        int min = this.getFileNumber(files[0]);
        int i = 1;
        while (i < files.length) {
            int newMin = this.getFileNumber(files[i]);
            if (newMin < min) {
                ff = files[i];
                min = newMin;
            }
            ++i;
        }
        LogPanel.println("FILE FOUND  time=" + new Date().toString() + "; name: " + ff.getName() + "; num: " + min);
        LogPanel.println();
        return ff;
    }
}

