/*
 * Decompiled with CFR 0.152.
 */
package objects;

import gui.MainFrame;
import gui.rightPanels.ControlPanel;
import gui.rightPanels.LogPanel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import objects.Settings;
import objects.fiscal.AdvertisementWrapper;
import objects.fiscal.CommandWrapper;
import objects.fiscal.PLU;
import objects.fiscal.Users;
import util.SysUtil;

public class DbfFileWrapper {
    private static BufferedReader in;

    public static void parseTxtFile(File file) throws Exception {
        if (Settings.getInstance().useThreadTimeout) {
            SysUtil.delay(Settings.getInstance().timeoutThread);
        }
        in = new BufferedReader(new FileReader(file));
        String text = "";
        String str = null;
        String name = file.getName();
        try {
            try {
                if (file.length() <= 1L) {
                    throw new Exception("File is too small!");
                }
                LogPanel.println("FILE CONTENT START:");
                while ((str = in.readLine()) != null) {
                    LogPanel.println(str);
                    text = String.valueOf(text) + str;
                    text = String.valueOf(text) + '\n';
                }
                LogPanel.println("FILE CONTENT END:");
                CommandWrapper.print(text, 0);
                SysUtil.writeOkFile(name);
            }
            catch (Exception e) {
                SysUtil.writeErrorFile(name, e);
                in.close();
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
        }
        finally {
            in.close();
            if (Settings.getInstance().useThreadDeleteInput) {
                SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
            }
            file.delete();
        }
    }

    public static void parseAdvFile(File file) throws Exception {
        if (file != null) {
            try {
                try {
                    if (Settings.getInstance().useThreadTimeout) {
                        SysUtil.delay(Settings.getInstance().timeoutThread);
                    }
                    if (!MainFrame.PRINTER) {
                        throw new Exception("COMMAND IS NOT AVAILABLE!");
                    }
                    AdvertisementWrapper.getInstance().readFromTXT(file);
                    AdvertisementWrapper.getInstance().programToCR();
                }
                catch (Exception exception) {
                    if (Settings.getInstance().useThreadDeleteInput) {
                        SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                    }
                    file.delete();
                }
            }
            finally {
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
            return;
        }
    }

    public static void parseUsrFile(File file) throws Exception {
        if (file != null) {
            try {
                try {
                    if (Settings.getInstance().useThreadTimeout) {
                        SysUtil.delay(Settings.getInstance().timeoutThread);
                    }
                    if (!MainFrame.PRINTER) {
                        throw new Exception("COMMAND IS NOT AVAILABLE!");
                    }
                    Users.readFromTXT(file);
                }
                catch (Exception exception) {
                    if (Settings.getInstance().useThreadDeleteInput) {
                        SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                    }
                    file.delete();
                }
            }
            finally {
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
            return;
        }
    }

    public static void parseCmdFile(File file) throws Exception {
        if (Settings.getInstance().useThreadTimeout) {
            SysUtil.delay(Settings.getInstance().timeoutThread);
        }
        in = new BufferedReader(new FileReader(file));
        String str = null;
        String name = file.getName();
        try {
            try {
                if (file.length() <= 0L) {
                    throw new Exception("File is too small!");
                }
                LogPanel.println("FILE CONTENT START:");
                while ((str = in.readLine()) != null) {
                    LogPanel.println(str);
                    DbfFileWrapper.parseCmdString(str);
                }
                LogPanel.println("FILE CONTENT END:");
                CommandWrapper.execAll();
                SysUtil.writeOkFile(name);
            }
            catch (Exception e) {
                SysUtil.writeErrorFile(name, e);
                in.close();
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
        }
        finally {
            in.close();
            if (Settings.getInstance().useThreadDeleteInput) {
                SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
            }
            file.delete();
        }
    }

    private static void parseCmdString(String str) throws Exception {
        if (str.length() < 3) {
            return;
        }
        int cmd = Integer.parseInt(str.substring(0, 3));
        int d1 = 23;
        switch (cmd) {
            case 50: {
                if (str.length() < 24) {
                    d1 = str.length();
                }
                CommandWrapper.display_1 = str.substring(3, d1);
                CommandWrapper.display_2 = str.length() > 23 ? str.substring(23, str.length()) : "                    ";
                CommandWrapper.display = true;
                break;
            }
            case 52: {
                CommandWrapper.state = true;
                break;
            }
            case 51: {
                CommandWrapper.daily = true;
                break;
            }
            case 100: {
                CommandWrapper.deleteAll = true;
                break;
            }
            case 53: {
                SimpleDateFormat sdf = new SimpleDateFormat("ddMMyy");
                sdf.parse(str.substring(3, 9));
                CommandWrapper.from = sdf.getCalendar().getTimeInMillis();
                sdf.parse(str.substring(9, 15));
                CommandWrapper.to = sdf.getCalendar().getTimeInMillis();
                CommandWrapper.periodical = true;
                break;
            }
            case 54: {
                CommandWrapper.register_state = true;
                break;
            }
            case 55: {
                if (ControlPanel.printer.isSelected()) {
                    CommandWrapper.open_drawer = true;
                    break;
                }
                throw new Exception("Command is not supported on cash register!");
            }
            case 56: {
                String code = str.substring(3, 12);
                code = code.trim();
                CommandWrapper.log_in_code = Integer.parseInt(code);
                CommandWrapper.log_in = true;
                break;
            }
            case 57: {
                CommandWrapper.cashier_print = true;
                break;
            }
            case 58: {
                int type = Integer.parseInt(str.substring(3, 4));
                CommandWrapper.adver = true;
                CommandWrapper.adver_type = type;
                break;
            }
            case 59: {
                CommandWrapper.bill_state = true;
                break;
            }
            default: {
                throw new Exception("Unknown command.");
            }
        }
    }

    private static void parsePayString(String str) throws Exception {
        if (str.length() < 40) {
            return;
        }
        PLU plu = new PLU();
        plu.barCode = 0L;
        switch (str.charAt(40)) {
            case 'G': {
                plu.barCode = SysUtil.parseLong(str.substring(30, 40), 2);
                break;
            }
            case 'K': {
                plu.kolicina = SysUtil.parseLong(str.substring(30, 40), 2);
                break;
            }
            case 'C': {
                plu.prodato = SysUtil.parseLong(str.substring(30, 40), 2);
                break;
            }
            case 'S': {
                DbfFileWrapper.parseBonString(str);
                return;
            }
            default: {
                throw new Exception("Nepoznata stavka");
            }
        }
        PLU.vecPay.add(plu);
    }

    public static void parseBonFile(File file) throws Exception {
        if (Settings.getInstance().useThreadTimeout) {
            SysUtil.delay(Settings.getInstance().timeoutThread);
        }
        in = new BufferedReader(new FileReader(file));
        String str = null;
        String name = file.getName();
        try {
            try {
                if (file.length() <= 1L) {
                    throw new Exception("File is too small!");
                }
                LogPanel.println("FILE CONTENT START:");
                while ((str = in.readLine()) != null) {
                    LogPanel.println(str);
                    DbfFileWrapper.parsePayString(str);
                }
                LogPanel.println("FILE CONTENT END:");
                PLU.sellAll();
                PLU.payAll();
                SysUtil.writeOkFile(name);
            }
            catch (Exception e) {
                SysUtil.writeErrorFile(name, e);
                PLU.vecPay.removeAllElements();
                PLU.vecBon.removeAllElements();
                in.close();
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
        }
        finally {
            PLU.vecPay.removeAllElements();
            PLU.vecBon.removeAllElements();
            in.close();
            if (Settings.getInstance().useThreadDeleteInput) {
                SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
            }
            file.delete();
        }
    }

    private static void parseBonString(String str) {
        PLU plu = new PLU();
        plu.barCode = Long.parseLong(str.substring(0, 20).trim());
        plu.kolicina = SysUtil.parseLong(str.substring(20, 30), 3);
        plu.cena = (int)SysUtil.parseLong(str.substring(30, 40), 2);
        PLU.vecBon.add(plu);
    }

    public static void parseArtFile(File file) throws Exception {
        if (Settings.getInstance().useThreadTimeout) {
            SysUtil.delay(Settings.getInstance().timeoutThread);
        }
        in = new BufferedReader(new FileReader(file));
        String str = null;
        String name = file.getName();
        try {
            try {
                if (file.length() <= 1L) {
                    throw new Exception("File is too small!");
                }
                LogPanel.println("FILE CONTENT START:");
                while ((str = in.readLine()) != null) {
                    LogPanel.println(str);
                    DbfFileWrapper.parseArtString(str);
                }
                LogPanel.println("FILE CONTENT END:");
                PLU.deleteAllByCode();
                PLU.deleteAllByBarcode();
                PLU.programmAll();
                PLU.changeAllPrices();
                PLU.changeAllPricesBarcode();
                SysUtil.writeOkFile(name);
            }
            catch (Exception e) {
                SysUtil.writeErrorFile(name, e);
                PLU.vecDelCode.removeAllElements();
                PLU.vecDelBarcode.removeAllElements();
                PLU.vecNew.removeAllElements();
                PLU.vecPrice.removeAllElements();
                PLU.vecPriceBarcode.removeAllElements();
                in.close();
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
        }
        finally {
            PLU.vecDelCode.removeAllElements();
            PLU.vecDelBarcode.removeAllElements();
            PLU.vecNew.removeAllElements();
            PLU.vecPrice.removeAllElements();
            PLU.vecPriceBarcode.removeAllElements();
            in.close();
            if (Settings.getInstance().useThreadDeleteInput) {
                SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
            }
            file.delete();
        }
    }

    private static void parseArtString(String str) throws Exception {
        if (str.length() < 70) {
            return;
        }
        PLU plu = new PLU();
        plu.barCode = Long.parseLong(str.substring(0, 20).trim());
        if (plu.barCode < 32000L || MainFrame.PRINTER) {
            plu.code = (int)plu.barCode;
            plu.barCode = -1L;
        }
        plu.poreskaStopa = Byte.parseByte(str.substring(20, 22).trim());
        plu.cena = (int)SysUtil.parseLong(str.substring(22, 32), 2);
        plu.desc = str.substring(32, 66).trim();
        switch (str.charAt(72) - 48) {
            case 0: {
                PLU.vecNew.add(plu);
                break;
            }
            case 1: {
                PLU.vecPrice.add(plu);
                break;
            }
            case 2: {
                PLU.vecDelCode.add(plu);
                break;
            }
            default: {
                throw new Exception("Nepoznata operacija");
            }
        }
    }
}

