/*
 * Decompiled with CFR 0.152.
 */
package objects;

import gui.rightPanels.ControlPanel;
import gui.rightPanels.LogPanel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import objects.Settings;
import objects.fiscal.AdvertisementWrapper;
import objects.fiscal.CommandWrapper;
import objects.fiscal.PLU;
import objects.fiscal.Users;
import util.SysUtil;

public class CsvFileWrapper {
    private static BufferedReader in;
    private static BufferedReader searchArt;
    private static BufferedWriter out;
    private static File fileOut;
    private static int brojLinija;

    static {
        fileOut = new File("baza_artikla.txt");
    }

    public static void parseTxtFile(File file) throws Exception {
        if (Settings.getInstance().useThreadTimeout) {
            SysUtil.delay(Settings.getInstance().timeoutThread);
        }
        in = new BufferedReader(new FileReader(file));
        String text = "";
        String str = null;
        String name = file.getName();
        try {
            try {
                if (file.length() <= 1L) {
                    throw new Exception("File is too small!");
                }
                LogPanel.println("FILE CONTENT START:");
                while ((str = in.readLine()) != null) {
                    LogPanel.println(str);
                    text = String.valueOf(text) + str;
                    text = String.valueOf(text) + '\n';
                }
                LogPanel.println("FILE CONTENT END:");
                CommandWrapper.print(text, 0);
                SysUtil.writeOkFile(name);
            }
            catch (Exception e) {
                SysUtil.writeErrorFile(name, e);
                in.close();
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
        }
        finally {
            in.close();
            if (Settings.getInstance().useThreadDeleteInput) {
                SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
            }
            file.delete();
        }
    }

    public static void parseAdvFile(File file) throws Exception {
        if (Settings.getInstance().useThreadTimeout) {
            SysUtil.delay(Settings.getInstance().timeoutThread);
        }
        in = new BufferedReader(new FileReader(file));
        String str = null;
        String name = file.getName();
        int b = 0;
        try {
            try {
                if (file.length() <= 1L) {
                    throw new Exception("File is too small!");
                }
                LogPanel.println("FILE CONTENT START:");
                while ((str = in.readLine()) != null) {
                    LogPanel.println(str);
                    AdvertisementWrapper.getInstance().parseAdvString(str, b);
                    ++b;
                }
                LogPanel.println("FILE CONTENT END:");
                AdvertisementWrapper.getInstance().programToCR();
                SysUtil.writeOkFile(name);
            }
            catch (Exception e) {
                SysUtil.writeErrorFile(name, e);
                in.close();
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
        }
        finally {
            in.close();
            if (Settings.getInstance().useThreadDeleteInput) {
                SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
            }
            file.delete();
        }
    }

    public static void parseUsrFile(File file) throws Exception {
        if (Settings.getInstance().useThreadTimeout) {
            SysUtil.delay(Settings.getInstance().timeoutThread);
        }
        in = new BufferedReader(new FileReader(file));
        String str = null;
        String name = file.getName();
        try {
            try {
                if (file.length() <= 1L) {
                    throw new Exception("File is too small!");
                }
                LogPanel.println("FILE CONTENT START:");
                while ((str = in.readLine()) != null) {
                    LogPanel.println(str);
                    Users.getInstance().parseUsrString(str);
                }
                LogPanel.println("FILE CONTENT END:");
                SysUtil.writeOkFile(name);
            }
            catch (Exception e) {
                SysUtil.writeErrorFile(name, e);
                in.close();
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
        }
        finally {
            in.close();
            if (Settings.getInstance().useThreadDeleteInput) {
                SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
            }
            file.delete();
        }
    }

    public static void parseCmdFile(File file) throws Exception {
        if (Settings.getInstance().useThreadTimeout) {
            SysUtil.delay(Settings.getInstance().timeoutThread);
        }
        in = new BufferedReader(new FileReader(file));
        String str = null;
        String name = file.getName();
        try {
            try {
                if (file.length() <= 1L) {
                    throw new Exception("File is too small!");
                }
                LogPanel.println("FILE CONTENT START:");
                while ((str = in.readLine()) != null) {
                    LogPanel.println(str);
                    CsvFileWrapper.parseCmdString(str);
                }
                LogPanel.println("FILE CONTENT END:");
                CommandWrapper.execAll();
                SysUtil.writeOkFile(name);
            }
            catch (Exception e) {
                SysUtil.writeErrorFile(name, e);
                in.close();
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
        }
        finally {
            in.close();
            if (Settings.getInstance().useThreadDeleteInput) {
                SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
            }
            file.delete();
        }
    }

    private static void parseCmdString(String str) throws Exception {
        HCPStringTokenizer st = new HCPStringTokenizer(str, ',');
        int cmd = Integer.parseInt(st.nextToken().replaceAll("\"", ""));
        if (cmd == 80) {
            CommandWrapper.state = true;
        }
        if (cmd == 90) {
            CommandWrapper.daily = true;
        }
        if (cmd == 100) {
            String range = st.nextToken().replaceAll("\"", "");
            String from = range.substring(0, range.indexOf(45));
            String to = range.substring(range.indexOf(45) + 1, range.length());
            SimpleDateFormat sdf = new SimpleDateFormat("ddMMyy");
            sdf.parse(from);
            CommandWrapper.from = sdf.getCalendar().getTimeInMillis();
            sdf.parse(to);
            CommandWrapper.to = sdf.getCalendar().getTimeInMillis();
            CommandWrapper.periodical = true;
        }
        if (cmd == 110) {
            CommandWrapper.deleteAll = true;
        }
        if (cmd == 120) {
            String red1 = st.nextToken().replaceAll("\"", "");
            String red2 = st.nextToken().replaceAll("\"", "");
            CommandWrapper.display_1 = red1;
            CommandWrapper.display_2 = red2;
            CommandWrapper.display = true;
        }
        if (cmd == 130) {
            String code = st.nextToken().replaceAll("\"", "");
            CommandWrapper.log_in_code = Integer.parseInt(code);
            CommandWrapper.log_in = true;
        }
        if (cmd == 131) {
            CommandWrapper.cashier_print = true;
        }
        if (cmd == 132) {
            String type = st.nextToken().replaceAll("\"", "");
            CommandWrapper.adver_type = Integer.parseInt(type);
            CommandWrapper.adver = true;
        }
        if (cmd == 133) {
            if (ControlPanel.printer.isSelected()) {
                CommandWrapper.open_drawer = true;
            } else {
                throw new Exception("Command is not supported on cash register!");
            }
        }
        if (cmd == 134) {
            CommandWrapper.bill_state = true;
        }
        if (cmd == 135) {
            CommandWrapper.register_state = true;
        }
    }

    public static void parsePayFile(String name) throws Exception {
        String str = null;
        File file = new File(Settings.getInstance().FOLDER_IN, name = name.toUpperCase().replace("BON", "PAY"));
        if (!file.exists()) {
            PLU.payAll();
            return;
        }
        if (Settings.getInstance().useThreadTimeout) {
            SysUtil.delay(Settings.getInstance().timeoutThread);
        }
        in = new BufferedReader(new FileReader(file));
        try {
            try {
                if (file.length() <= 1L) {
                    throw new Exception("File is too small!");
                }
                LogPanel.println("FILE CONTENT START:");
                while ((str = in.readLine()) != null) {
                    LogPanel.println(str);
                    CsvFileWrapper.parsePayString(str);
                }
                LogPanel.println("FILE CONTENT END:");
                PLU.payAll();
                SysUtil.writeOkFile(name);
            }
            catch (Exception e) {
                SysUtil.writeErrorFile(name, e);
                PLU.vecPay.removeAllElements();
                in.close();
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
        }
        finally {
            PLU.vecPay.removeAllElements();
            in.close();
            if (Settings.getInstance().useThreadDeleteInput) {
                SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
            }
            file.delete();
        }
    }

    private static void parsePayString(String str) {
        PLU plu = new PLU();
        plu.barCode = 0L;
        HCPStringTokenizer st = new HCPStringTokenizer(str, ',');
        plu.barCode = SysUtil.parseLong(st.nextToken().replaceAll("\"", ""), 2);
        plu.kolicina = SysUtil.parseLong(st.nextToken().replaceAll("\"", ""), 2);
        plu.prodato = SysUtil.parseLong(st.nextToken().replaceAll("\"", ""), 2);
        PLU.vecPay.add(plu);
    }

    public static void parseBonFile(File file) throws Exception {
        if (Settings.getInstance().useThreadTimeout) {
            SysUtil.delay(Settings.getInstance().timeoutThread);
        }
        in = new BufferedReader(new FileReader(file));
        String str = null;
        String name = file.getName();
        try {
            try {
                if (file.length() <= 1L) {
                    throw new Exception("File is too small!");
                }
                LogPanel.println("FILE CONTENT START:");
                while ((str = in.readLine()) != null) {
                    LogPanel.println(str);
                    CsvFileWrapper.parseBonString(str);
                }
                LogPanel.println("FILE CONTENT END:");
                PLU.sellAll();
                SysUtil.writeOkFile(name);
            }
            catch (Exception e) {
                SysUtil.writeErrorFile(name, e);
                PLU.vecBon.removeAllElements();
                in.close();
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
        }
        finally {
            PLU.vecBon.removeAllElements();
            in.close();
            if (Settings.getInstance().useThreadDeleteInput) {
                SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
            }
            file.delete();
        }
    }

    private static void parseBonString(String str) {
        PLU plu = new PLU();
        HCPStringTokenizer st = new HCPStringTokenizer(str, ',');
        plu.barCode = Long.parseLong(st.nextToken().replaceAll("\"", ""));
        plu.kolicina = (int)SysUtil.parseLong(st.nextToken().replaceAll("\"", ""), 3);
        plu.cena = (int)SysUtil.parseLong(st.nextToken().replaceAll("\"", ""), 2);
        PLU.vecBon.add(plu);
    }

    public static void parseArtFile(File file) throws Exception {
        if (Settings.getInstance().useThreadTimeout) {
            SysUtil.delay(Settings.getInstance().timeoutThread);
        }
        in = new BufferedReader(new FileReader(file));
        String str = null;
        String name = file.getName();
        try {
            try {
                if (file.length() <= 1L) {
                    throw new Exception("File is too small!");
                }
                LogPanel.println("FILE CONTENT START:");
                while ((str = in.readLine()) != null) {
                    LogPanel.println(str);
                    CsvFileWrapper.parseArtString(str);
                }
                LogPanel.println("FILE CONTENT END:");
                PLU.deleteAllByCode();
                PLU.deleteAllByBarcode();
                PLU.programmAll();
                PLU.changeAllPrices();
                PLU.changeAllPricesBarcode();
                SysUtil.writeOkFile(name);
            }
            catch (Exception e) {
                SysUtil.writeErrorFile(name, e);
                PLU.vecDelCode.removeAllElements();
                PLU.vecDelBarcode.removeAllElements();
                PLU.vecNew.removeAllElements();
                PLU.vecPrice.removeAllElements();
                PLU.vecPriceBarcode.removeAllElements();
                in.close();
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
            }
        }
        finally {
            PLU.vecDelCode.removeAllElements();
            PLU.vecDelBarcode.removeAllElements();
            PLU.vecNew.removeAllElements();
            PLU.vecPrice.removeAllElements();
            PLU.vecPriceBarcode.removeAllElements();
            in.close();
            if (Settings.getInstance().useThreadDeleteInput) {
                SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
            }
            file.delete();
        }
    }

    private static void parseArtString(String str) throws Exception {
        PLU plu = new PLU();
        HCPStringTokenizer st = new HCPStringTokenizer(str, ',');
        st.nextToken();
        plu.barCode = Long.parseLong(st.nextToken().replaceAll("\"", ""));
        plu.code = Integer.parseInt(st.nextToken().replaceAll("\"", ""));
        plu.poreskaStopa = Byte.parseByte(st.nextToken().replaceAll("\"", ""));
        plu.desc = st.nextToken().replaceAll("\"", "");
        plu.odeljenje = Byte.parseByte(st.nextToken().replaceAll("\"", ""));
        plu.cena = (int)SysUtil.parseLong(st.nextToken().replaceAll("\"", ""), 2);
        st.nextToken();
        st.nextToken();
        st.nextToken();
        st.nextToken();
        String param = st.nextToken().replaceAll("\"", "");
        if (param.equals("N")) {
            PLU.vecNew.add(plu);
            return;
        }
        if (param.equals("D")) {
            PLU.vecDelCode.add(plu);
            return;
        }
        if (param.equals("P")) {
            PLU.vecPrice.add(plu);
            return;
        }
        throw new Exception("Nepoznata operacija");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void parseAbcFile(File file) throws Exception {
        if (Settings.getInstance().useThreadTimeout) {
            SysUtil.delay(Settings.getInstance().timeoutThread);
        }
        out = new BufferedWriter(new FileWriter(fileOut, true));
        in = new BufferedReader(new FileReader(file));
        String str = null;
        String name = file.getName();
        boolean prog = false;
        brojLinija = 0;
        boolean citaj = false;
        int nadji = 0;
        try {
            try {
                brojLinija = CsvFileWrapper.brojac(fileOut);
                if (file.length() <= 1L) {
                    throw new Exception("File is too small!");
                }
                if (!prog) {
                    LogPanel.println("FILE CONTENT START:");
                    while ((str = in.readLine().trim()) != null) {
                        if (str.substring(0, 11).equals("END_OF_SALE")) {
                            prog = true;
                            out.close();
                            break;
                        }
                        nadji = CsvFileWrapper.pretrazi(fileOut, str.substring(0, 20).trim());
                        if (nadji == 0) {
                            out.append(String.valueOf(str.substring(0, 20)) + ++brojLinija);
                            out.append("\n");
                            nadji = brojLinija;
                        }
                        LogPanel.println(str);
                        CsvFileWrapper.parseArtAbcString(str, nadji);
                    }
                    PLU.deleteAllByCode();
                    PLU.deleteAllByBarcode();
                    PLU.programmAll();
                    PLU.changeAllPrices();
                    PLU.changeAllPricesBarcode();
                }
                in.close();
                in = new BufferedReader(new FileReader(file));
                str = null;
                if (file.length() <= 1L) {
                    throw new Exception("File is too small!");
                }
                while ((str = in.readLine().trim()) != null) {
                    if (str.substring(0, 11).equals("END_OF_SALE")) {
                        citaj = true;
                    }
                    if (str.substring(0, 10).equals("END_OF_PAY")) break;
                    if (!citaj) {
                        LogPanel.println(str);
                        nadji = CsvFileWrapper.pretrazi(fileOut, str.substring(0, 20).trim());
                        CsvFileWrapper.parseAbcString(str, nadji);
                    }
                    if (!citaj) continue;
                    LogPanel.println(str);
                    CsvFileWrapper.parsePayAbcString(str);
                }
                LogPanel.println("FILE CONTENT END:");
                PLU.sellAll();
                PLU.payAllAbc();
                SysUtil.writeOkFile(name);
                return;
            }
            catch (Exception e) {
                SysUtil.writeErrorFile(name, e);
                PLU.vecBon.removeAllElements();
                PLU.vecPay.removeAllElements();
                PLU.vecDelCode.removeAllElements();
                PLU.vecDelBarcode.removeAllElements();
                PLU.vecNew.removeAllElements();
                PLU.vecPrice.removeAllElements();
                PLU.vecPriceBarcode.removeAllElements();
                in.close();
                if (Settings.getInstance().useThreadDeleteInput) {
                    SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
                }
                file.delete();
                return;
            }
        }
        finally {
            PLU.vecBon.removeAllElements();
            PLU.vecPay.removeAllElements();
            PLU.vecDelCode.removeAllElements();
            PLU.vecDelBarcode.removeAllElements();
            PLU.vecNew.removeAllElements();
            PLU.vecPrice.removeAllElements();
            PLU.vecPriceBarcode.removeAllElements();
            in.close();
            if (Settings.getInstance().useThreadDeleteInput) {
                SysUtil.delay(Settings.getInstance().timeoutDeleteInput);
            }
            file.delete();
        }
    }

    private static void parseAbcString(String str, int i) {
        PLU plu = new PLU();
        plu.barCode = i;
        plu.kolicina = (int)SysUtil.parseLong(str.substring(73, 83), 3);
        plu.cena = (int)SysUtil.parseLong(str.substring(63, 73).trim(), 2);
        PLU.vecBon.add(plu);
    }

    private static void parsePayAbcString(String str) {
        PLU plu = new PLU();
        plu.barCode = 0L;
        if (str.substring(0, 4).equals("CASH")) {
            plu.barCode = SysUtil.parseLong(str.substring(63, 73).trim(), 2);
        }
        if (str.substring(0, 4).equals("CARD")) {
            plu.kolicina = SysUtil.parseLong(str.substring(63, 73).trim(), 2);
        }
        PLU.vecPay.add(plu);
    }

    private static void parseArtAbcString(String str, int i) throws Exception {
        PLU plu = new PLU();
        plu.barCode = Long.parseLong(str.substring(0, 2).trim());
        plu.code = i;
        plu.poreskaStopa = Byte.parseByte(str.substring(20, 21));
        String s = str.substring(22, 62).trim();
        plu.desc = s.substring(0, s.length() - 1);
        plu.odeljenje = Byte.parseByte("0");
        plu.cena = (int)SysUtil.parseLong(str.substring(63, 73).trim(), 2);
        PLU.vecNew.add(plu);
    }

    /*
     * Unable to fully structure code
     */
    private static int brojac(File file) throws Exception {
        CsvFileWrapper.searchArt = new BufferedReader(new FileReader(file));
        if (file.length() > 1L) ** GOTO lbl5
        throw new Exception("File is too small!");
lbl-1000:
        // 1 sources

        {
            ++CsvFileWrapper.brojLinija;
lbl5:
            // 2 sources

            ** while (CsvFileWrapper.searchArt.readLine() != null)
        }
lbl6:
        // 1 sources

        return CsvFileWrapper.brojLinija;
    }

    /*
     * Unable to fully structure code
     */
    private static synchronized int pretrazi(File file, String st) throws Exception {
        code = 0;
        CsvFileWrapper.searchArt = new BufferedReader(new FileReader(file));
        if (file.length() > 1L) ** GOTO lbl8
        throw new Exception("File is too small!");
lbl-1000:
        // 1 sources

        {
            System.out.println("Trazi se: " + st + " --- " + s);
            if (!s.substring(0, 20).trim().equals(st)) continue;
            code = Integer.parseInt(s.substring(20, s.length()).trim());
lbl8:
            // 3 sources

            ** while ((s = CsvFileWrapper.searchArt.readLine()) != null)
        }
lbl9:
        // 1 sources

        return code;
    }

    private static class HCPStringTokenizer {
        private String string;
        private char token;
        private int pos;

        public HCPStringTokenizer(String str, char tok) {
            this.string = str;
            this.token = tok;
            this.pos = 0;
        }

        public String nextToken() {
            String s = "";
            char c = '\u0000';
            while (true) {
                if (this.pos == this.string.length()) {
                    return s;
                }
                if ((c = this.string.charAt(this.pos++)) == this.token) break;
                s = String.valueOf(s) + c;
            }
            return s;
        }
    }
}

