/*
 * Decompiled with CFR 0.152.
 */
package journal;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import journal.JournalObjArticle;
import journal.JournalObjArticleBarcode;
import journal.JournalObjCashear;
import journal.JournalObjPaid;
import journal.JournalObject;
import objects.Settings;
import util.XML.XmlFileWriter;
import util.comPort.PortSerial;

public class Journal {
    private static final long START_TIME = 946684800000L;
    private static final SimpleDateFormat dataf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private int rnCount = 0;
    private static final int MAX_NUMBER_OF_JOURFNAL_RECORDS = 19659;
    private static final Vector vec = new Vector();
    private static Journal instance;

    public static Journal getInstance() {
        if (instance == null) {
            instance = new Journal();
        }
        return instance;
    }

    private Journal() {
        dataf.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private void readJournal() throws Exception {
        Command cmd;
        vec.removeAllElements();
        this.rnCount = 0;
        int address = -1;
        int startAddress = -1;
        PortSerial port = PortSerial.getInstance();
        do {
            Command.bigInstance.reset();
            Command.bigInstance.setCmd(75);
            Command.bigInstance.addInt(address);
            port.sendFrame(Command.bigInstance);
            cmd = port.receiveFrame();
            int e = cmd.getArray()[0] & 0xFF;
            int command = cmd.getCmd();
            if (command == 75 || command == 128 || e == 0) continue;
            CommandsErrors.instanceMain.setError(e);
        } while ((address = this.regulateJournalRecord(cmd)) > 0 && address != startAddress);
    }

    private int regulateJournalRecord(Command cmd) throws Exception {
        int newAddres = 0;
        int pos = 0;
        int type = 0;
        long bar = 0L;
        int t = 0;
        newAddres = cmd.getInt(pos);
        pos += 4;
        block8: while (this.rnCount < 19658) {
            type = cmd.getArray()[pos++] & 0xFF;
            switch (type) {
                default: {
                    try {
                        int i = 0;
                        while (i < 20) {
                            if (cmd.getArray()[pos + i] != -1) {
                                return newAddres;
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        return newAddres;
                    }
                    return -1;
                }
                case 7: {
                    JournalObjArticleBarcode obj7 = new JournalObjArticleBarcode();
                    t = cmd.getInt(pos);
                    obj7.setNumOfRec(t &= 0xFFFFFF);
                    bar = cmd.getLong(pos += 3) & 0xFFFFFFFFFFFFL;
                    pos += 6;
                    obj7.setBarcode(bar);
                    t = cmd.getByte(pos++) & 0xFF;
                    obj7.setOrdinalNum(t);
                    t = cmd.getByte(pos++) & 0xFF;
                    int poreskaStopa = 0;
                    int odeljenje = 0;
                    obj7.setDepartment(odeljenje |= (t & 0xF0) >> 4);
                    obj7.setVat(poreskaStopa |= t & 0xF);
                    t = cmd.getInt(pos);
                    obj7.setPrice(t);
                    t = cmd.getInt(pos += 4);
                    pos += 4;
                    obj7.setAmount(t);
                    vec.add(obj7);
                    continue block8;
                }
                case 3: {
                    JournalObjCashear obj = new JournalObjCashear();
                    pos += 5;
                    t = cmd.getArray()[pos++] & 0xFF;
                    obj.setCashearId(t);
                    t = cmd.getArray()[pos++] & 0xFF;
                    obj.setLevel(t);
                    bar = cmd.getLong(pos);
                    obj.setAmount(bar);
                    bar = (long)cmd.getInt(pos += 8) & 0xFFFFFFFFL;
                    pos += 4;
                    bar *= 1000L;
                    obj.setTime(dataf.format(new Date(bar += 946684800000L)));
                    vec.add(obj);
                    continue block8;
                }
                case 1: {
                    JournalObjArticle obj1 = new JournalObjArticle();
                    t = cmd.getShort(++pos);
                    obj1.setCode(t);
                    bar = (long)cmd.getInt(pos += 2) & 0xFFFFFFFFL;
                    bar *= 1000L;
                    obj1.setTime(dataf.format(new Date(bar += 946684800000L)));
                    t = cmd.getInt(pos += 4);
                    obj1.setNumOfRec(t);
                    t = cmd.getInt(pos += 4);
                    obj1.setPrice(t);
                    t = cmd.getInt(pos += 4);
                    pos += 4;
                    obj1.setAmount(t);
                    vec.add(obj1);
                    continue block8;
                }
                case 2: 
            }
            JournalObjPaid obj2 = new JournalObjPaid();
            pos += 2;
            t = cmd.getArray()[pos++] & 0xFF;
            obj2.setType(t);
            bar = cmd.getLong(pos);
            obj2.setAmount(bar);
            t = cmd.getInt(pos += 8);
            obj2.setNumOfRec(t);
            bar = (long)cmd.getInt(pos += 4) & 0xFFFFFFFFL;
            pos += 4;
            bar *= 1000L;
            obj2.setTime(dataf.format(new Date(bar += 946684800000L)));
            vec.add(obj2);
        }
        return -1;
    }

    private String writeToXML(XmlFileWriter writer) throws Exception {
        String s = "";
        int size = vec.size();
        s = String.valueOf(s) + writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        s = String.valueOf(s) + writer.writeLn("<JOURNAL>");
        writer.indent();
        int i = 0;
        while (i < size) {
            JournalObject obj = (JournalObject)vec.get(i);
            s = String.valueOf(s) + obj.writeToXMLWriter(writer);
            ++i;
        }
        writer.unintent();
        s = String.valueOf(s) + writer.writeLn("</JOURNAL>");
        return s;
    }

    public String writeJournal() throws Exception {
        this.readJournal();
        File file = new File(Settings.getInstance().FOLDER_OUT, "journal.xml");
        file.mkdirs();
        if (file.exists()) {
            file.delete();
        }
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        XmlFileWriter xmlWriter = new XmlFileWriter(out);
        try {
            String string = this.writeToXML(xmlWriter);
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

