/*
 * Decompiled with CFR 0.152.
 */
package gui.rightPanels;

import gui.HCPColors;
import gui.HCPGreyButton;
import gui.HCPImage;
import gui.HCPLabel;
import gui.HCPRadioButton;
import gui.HCPTextField;
import gui.HelpLabel;
import gui.MainFrame;
import gui.rightPanels.RightPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import objects.Settings;
import objects.lang.LanguageStrings;

public final class LogPanel
extends RightPanel {
    private static final long serialVersionUID = 1L;
    private JPanel controlPanel;
    private JPanel outerPanel;
    private JPanel inPanel;
    public File logFile = null;
    public File errorFile = null;
    public File comFile = null;
    public OutputStream outLog = null;
    public OutputStream outError = null;
    public OutputStream outCom = null;
    private HCPGreyButton stopLog;
    private HCPGreyButton viewLog;
    private HCPGreyButton setFolder;
    public static HCPGreyButton startLog;
    public static HCPRadioButton comRadioBtn;
    public static HCPRadioButton logRadioBtn;
    public static HCPTextField setPath;
    public static JTextArea proba;
    public static volatile boolean log;
    public static volatile boolean com;

    static {
        log = false;
        com = false;
        try {
            Settings.getInstance().SET_FOLDER.mkdirs();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public LogPanel() {
        super(LanguageStrings.getInstance().getStringByName("LOG_PANEL_BUTTON"), 'L', LanguageStrings.getInstance().getStringByName("LOG_PANEL_BUTTON_TOOLTIP"));
        this.setLayout(new BorderLayout(5, 5));
        this.controlPanel = new JPanel(new BorderLayout());
        this.controlPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
        JPanel buttonsPanel = new JPanel(new GridLayout(9, 1, 5, 5));
        this.controlPanel.add((Component)buttonsPanel, "North");
        startLog = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("LOG_PANEL_START_BUTTON"));
        this.stopLog = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("LOG_PANEL_STOP_BUTTON"));
        this.viewLog = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("LOG_PANEL_VIEW_BUTTON"));
        this.setFolder = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("LOG_PANEL_SET_BUTTON"));
        comRadioBtn = new HCPRadioButton(LanguageStrings.getInstance().getStringByName("LOG_PANEL_COM_RADIO_BUTTON"));
        comRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().setSerialMonitor(comRadioBtn.isSelected());
                MainFrame.SERIAL_MONITOR = comRadioBtn.isSelected();
            }
        });
        logRadioBtn = new HCPRadioButton(LanguageStrings.getInstance().getStringByName("LOG_PANEL_LOG_RADIO_BUTTON"));
        logRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().setSerialMonitor(comRadioBtn.isSelected());
                MainFrame.SERIAL_MONITOR = comRadioBtn.isSelected();
            }
        });
        ButtonGroup btnG = new ButtonGroup();
        btnG.add(comRadioBtn);
        btnG.add(logRadioBtn);
        comRadioBtn.setSelected(true);
        startLog.setIcon(new HCPImage("images/arrow_small.png"));
        this.stopLog.setIcon(new HCPImage("images/arrow_small.png"));
        this.viewLog.setIcon(new HCPImage("images/arrow_small.png"));
        this.setFolder.setToolTipText(LanguageStrings.getInstance().getStringByName("LOG_PANEL_SET_BUTTON_TOOLTIP"));
        this.setFolder.setIcon(MainFrame.slika);
        this.setFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setCurrentDirectory(Settings.getInstance().SET_FOLDER);
                fc.setFileSelectionMode(1);
                fc.showOpenDialog(MainFrame.getInstance());
                File in = fc.getSelectedFile();
                if (in == null) {
                    return;
                }
                Settings.getInstance().SET_FOLDER = in;
                setPath.setText(in.getAbsolutePath());
                setPath.setToolTipText(in.getAbsolutePath());
            }
        });
        setPath = new HCPTextField(Settings.getInstance().SET_FOLDER.getAbsolutePath());
        setPath.setToolTipText(Settings.getInstance().SET_FOLDER.getAbsolutePath());
        setPath.setEditable(false);
        buttonsPanel.add(startLog);
        buttonsPanel.add(comRadioBtn);
        buttonsPanel.add(logRadioBtn);
        buttonsPanel.add(this.stopLog);
        buttonsPanel.add(this.viewLog);
        buttonsPanel.add(new HCPLabel());
        buttonsPanel.add(this.setFolder);
        buttonsPanel.add(setPath);
        this.controlPanel.add((Component)new JPanel(), "Center");
        this.outerPanel = new JPanel();
        this.outerPanel.setLayout(new BorderLayout(10, 10));
        this.outerPanel.setIgnoreRepaint(true);
        this.outerPanel.setBackground(HCPColors.getColorM2st());
        this.outerPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
        this.outerPanel.add((Component)new HelpLabel(LanguageStrings.getInstance().getStringByName("LOG_PANEL_HELP_LABEL")), "North");
        this.add((Component)this.outerPanel, "Center");
        this.inPanel = new JPanel();
        this.inPanel.setLayout(new BorderLayout(10, 10));
        this.inPanel.setIgnoreRepaint(true);
        this.inPanel.setBackground(HCPColors.getColorM2st());
        this.inPanel.setBorder(new CompoundBorder(new SoftBevelBorder(1), new EmptyBorder(5, 5, 5, 5)));
        JTextArea text = new JTextArea();
        text.setWrapStyleWord(true);
        text.setLineWrap(true);
        text.setEditable(false);
        text.setText(String.valueOf(LanguageStrings.getInstance().getStringByName("LOG_PANEL_HELP_TEXT_1")) + "\r\n" + LanguageStrings.getInstance().getStringByName("LOG_PANEL_HELP_TEXT_2") + "\r\n\r\n" + LanguageStrings.getInstance().getStringByName("LOG_PANEL_HELP_TEXT_3") + "\r\n\r\n\r\n" + LanguageStrings.getInstance().getStringByName("LOG_PANEL_HELP_TEXT_4") + "\r\n" + LanguageStrings.getInstance().getStringByName("LOG_PANEL_HELP_TEXT_5") + "\r\n\r\n" + LanguageStrings.getInstance().getStringByName("LOG_PANEL_HELP_TEXT_6"));
        JScrollPane scrText = new JScrollPane(text, 20, 31);
        this.inPanel.add((Component)scrText, "Center");
        this.outerPanel.add((Component)this.inPanel, "Center");
        this.add((Component)this.controlPanel, "West");
        this.stopLog.setEnabled(false);
        this.viewLog.setEnabled(false);
        startLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    long l = System.currentTimeMillis();
                    if (logRadioBtn.isSelected()) {
                        LogPanel.this.logFile = new File(Settings.getInstance().SET_FOLDER, "log_" + l + ".txt");
                    }
                    LogPanel.this.errorFile = new File(Settings.getInstance().SET_FOLDER, "error_" + l + ".txt");
                    if (comRadioBtn.isSelected()) {
                        LogPanel.this.comFile = new File(Settings.getInstance().SET_FOLDER, "com_" + l + ".txt");
                    }
                    if (logRadioBtn.isSelected()) {
                        LogPanel.this.logFile.getParentFile().mkdirs();
                    }
                    if (comRadioBtn.isSelected()) {
                        LogPanel.this.comFile.getParentFile().mkdirs();
                    }
                    if (logRadioBtn.isSelected()) {
                        LogPanel.this.outLog = new FileOutputStream(LogPanel.this.logFile);
                    }
                    LogPanel.this.outError = new FileOutputStream(LogPanel.this.errorFile);
                    if (comRadioBtn.isSelected()) {
                        LogPanel.this.outCom = new FileOutputStream(LogPanel.this.comFile);
                    }
                    System.setErr(new PrintStream(LogPanel.this.outError));
                    if (logRadioBtn.isSelected()) {
                        System.setOut(new PrintStream(LogPanel.this.outLog));
                    }
                    if (comRadioBtn.isSelected()) {
                        System.setOut(new PrintStream(LogPanel.this.outCom));
                    }
                    startLog.setEnabled(false);
                    LogPanel.this.setFolder.setEnabled(false);
                    LogPanel.this.stopLog.setEnabled(true);
                    LogPanel.this.viewLog.setEnabled(true);
                    if (comRadioBtn.isSelected()) {
                        com = true;
                    }
                    if (logRadioBtn.isSelected()) {
                        log = true;
                    }
                    comRadioBtn.setEnabled(false);
                    logRadioBtn.setEnabled(false);
                    Settings.getInstance().setLogStart(true);
                    MainFrame.LOG_START = true;
                }
                catch (Exception e1) {
                    MainFrame.getInstance().displayError(e1);
                }
            }
        });
        this.stopLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Settings.getInstance().setLogStart(false);
                    MainFrame.LOG_START = false;
                    if (logRadioBtn.isSelected()) {
                        LogPanel.this.outLog.close();
                    }
                    LogPanel.this.outError.close();
                    if (comRadioBtn.isSelected()) {
                        LogPanel.this.outCom.close();
                    }
                    System.setOut(System.out);
                    System.setErr(System.err);
                    startLog.setEnabled(true);
                    LogPanel.this.setFolder.setEnabled(true);
                    comRadioBtn.setEnabled(true);
                    logRadioBtn.setEnabled(true);
                    LogPanel.this.stopLog.setEnabled(false);
                    LogPanel.this.viewLog.setEnabled(false);
                    log = false;
                    com = false;
                }
                catch (Exception e1) {
                    MainFrame.getInstance().displayError(e1);
                }
            }
        });
        this.viewLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (comRadioBtn.isSelected()) {
                        Runtime.getRuntime().exec("explorer.exe " + LogPanel.this.comFile.getParentFile().getAbsolutePath());
                    } else {
                        Runtime.getRuntime().exec("explorer.exe " + LogPanel.this.logFile.getParentFile().getAbsolutePath());
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    public static void println(String s) {
        if (!log) {
            return;
        }
        System.out.println(s);
    }

    public static void println() {
        if (!log) {
            return;
        }
        System.out.println();
    }

    public static void byteToHexView(byte[] data, int pos) {
        if (!com) {
            return;
        }
        String pom = new String(data, 0, data.length);
        String s = "";
        if (pom == null) {
            return;
        }
        int k1 = 0;
        while (k1 < pos) {
            if (k1 % 16 == 0) {
                System.out.print("\n");
            }
            String hex = Integer.toHexString(data[k1]);
            System.out.print(String.valueOf(String.format("%02X", data[k1])) + " ");
            if (k1 % 16 == 15 && k1 != pom.length() - 1) {
                s = pom.substring(k1 - 15, k1 + 1);
                s = s.replace('\r', ' ');
                s = s.replace('\n', ' ');
                s = s.replace('\t', ' ');
                System.out.print("  " + s);
            }
            if (k1 % 16 == 15 && k1 == pom.length() - 1) {
                s = pom.substring(k1 - 15, k1 + 1);
                System.out.print("  " + s);
                System.out.print("\r\n");
            }
            ++k1;
        }
        System.out.print("\n");
    }

    public static void intToHexView(int type, int pos) {
        if (!com) {
            return;
        }
        int k1 = 0;
        while (k1 < pos) {
            System.out.print(String.valueOf(String.format("%02X", type)) + " ");
            ++k1;
        }
    }

    public static void setComRdBtn() {
        comRadioBtn.setSelected(true);
    }

    public static void setLogRdBtn() {
        logRadioBtn.setSelected(true);
    }

    public static void startLog() {
        startLog.doClick();
    }
}

