/*
 * Decompiled with CFR 0.152.
 */
package gui.rightPanels;

import gui.HCPCheckBox;
import gui.HCPGreyButton;
import gui.rightPanels.RightPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import objects.Settings;
import objects.lang.LanguageStrings;

public final class FilePanel
extends RightPanel {
    private static final long serialVersionUID = 1L;
    private JTable inTable;
    private JTable outTable;
    private JTextArea inFile;
    private JTextArea outFile;
    private JCheckBox inCheck;
    private JCheckBox outCheck;
    private HCPGreyButton inButton;
    private HCPGreyButton outButton;
    private static final String[] inExt = new String[]{"txt", "dat", "xml"};
    private static final String[] outExt = new String[]{"err", "ok"};

    public FilePanel() {
        super(LanguageStrings.getInstance().getStringByName("FILES_PANEL_BUTTON"), 'F', LanguageStrings.getInstance().getStringByName("FILES_PANEL_BUTTON_TOOLTIP"));
        this.setLayout(new BorderLayout(10, 10));
        JPanel mainPanel = new JPanel(new GridLayout(2, 2, 5, 5));
        this.add((Component)mainPanel, "Center");
        this.inTable = new JTable();
        this.inTable.setModel(new TableModel(){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public String getColumnName(int c) {
                if (c == 0) {
                    return "name";
                }
                return "ext";
            }

            @Override
            public int getRowCount() {
                return FilePanel.this.getInFiles(Settings.getInstance().FOLDER_IN, inExt).length;
            }

            @Override
            public Object getValueAt(int r, int c) {
                try {
                    String f = FilePanel.this.getInFiles(Settings.getInstance().FOLDER_IN, inExt)[r].getName();
                    int ii = f.indexOf(46);
                    if (ii < 0) {
                        ii = f.length() - 1;
                    }
                    if (c == 0) {
                        return f.substring(0, ii);
                    }
                    return f.substring(ii + 1, f.length());
                }
                catch (RuntimeException e) {
                    return "";
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void removeTableModelListener(TableModelListener l) {
            }

            @Override
            public void setValueAt(Object value, int rowIndex, int columnIndex) {
            }

            @Override
            public void addTableModelListener(TableModelListener l) {
            }
        });
        this.inTable.getColumnModel().getColumn(1).setMaxWidth(50);
        this.inTable.setSelectionMode(0);
        mainPanel.add(new JScrollPane(this.inTable, 20, 31));
        this.inFile = new JTextArea();
        this.inFile.setLineWrap(true);
        this.inFile.setEditable(false);
        JPanel p1 = new JPanel(new BorderLayout(5, 5));
        p1.add((Component)new JScrollPane(this.inFile, 20, 31), "Center");
        this.inCheck = new HCPCheckBox(LanguageStrings.getInstance().getStringByName("FILES_PANEL_EMPTY_CHECKBOX_LABEL"), Settings.getInstance().EMPTY_IN);
        this.inCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().EMPTY_IN = !Settings.getInstance().EMPTY_IN;
            }
        });
        this.inButton = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("FILES_PANEL_OPEN_FOLDER_BUTTON"));
        this.inButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Runtime.getRuntime().exec("explorer.exe " + Settings.getInstance().FOLDER_IN.getAbsolutePath());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        JPanel p11 = new JPanel(new GridLayout(2, 1, 5, 5));
        p11.add(this.inButton);
        p11.add(this.inCheck);
        p11.setBorder(new EmptyBorder(0, 0, 0, 80));
        p1.add((Component)p11, "North");
        mainPanel.add(p1);
        this.outTable = new JTable();
        this.outTable.setModel(new TableModel(){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public String getColumnName(int c) {
                if (c == 0) {
                    return "name";
                }
                return "ext";
            }

            @Override
            public int getRowCount() {
                return FilePanel.this.getInFiles(Settings.getInstance().FOLDER_OUT, outExt).length;
            }

            @Override
            public Object getValueAt(int r, int c) {
                try {
                    String f = FilePanel.this.getInFiles(Settings.getInstance().FOLDER_OUT, outExt)[r].getName();
                    int ii = f.indexOf(46);
                    if (ii < 0) {
                        ii = f.length() - 1;
                    }
                    if (c == 0) {
                        return f.substring(0, ii);
                    }
                    return f.substring(ii + 1, f.length());
                }
                catch (RuntimeException e) {
                    return "";
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void removeTableModelListener(TableModelListener l) {
            }

            @Override
            public void setValueAt(Object value, int rowIndex, int columnIndex) {
            }

            @Override
            public void addTableModelListener(TableModelListener l) {
            }
        });
        this.outTable.getColumnModel().getColumn(1).setMaxWidth(50);
        this.outTable.setSelectionMode(0);
        mainPanel.add(new JScrollPane(this.outTable, 20, 31));
        this.inTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int sel = FilePanel.this.inTable.getSelectedRow();
                File[] f = FilePanel.this.getInFiles(Settings.getInstance().FOLDER_IN, inExt);
                if (sel < 0 || sel >= f.length) {
                    return;
                }
                final File ff = f[sel];
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            char[] buff = new char[1024];
                            int len = 0;
                            FilePanel.this.inFile.setText("");
                            FileReader in = new FileReader(ff);
                            while ((len = in.read(buff, 0, buff.length)) >= 0) {
                                FilePanel.this.inFile.append(new String(buff, 0, len));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }.start();
            }
        });
        this.outTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int sel = FilePanel.this.outTable.getSelectedRow();
                File[] f = FilePanel.this.getInFiles(Settings.getInstance().FOLDER_OUT, outExt);
                if (sel < 0 || sel >= f.length) {
                    return;
                }
                final File ff = f[sel];
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            char[] buff = new char[1024];
                            int len = 0;
                            FilePanel.this.outFile.setText("");
                            FileReader in = new FileReader(ff);
                            while ((len = in.read(buff, 0, buff.length)) >= 0) {
                                FilePanel.this.outFile.append(new String(buff, 0, len));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }.start();
            }
        });
        this.outFile = new JTextArea();
        this.outFile.setLineWrap(true);
        this.outFile.setEditable(false);
        JPanel p2 = new JPanel(new BorderLayout(5, 5));
        p2.add((Component)new JScrollPane(this.outFile, 20, 31), "Center");
        this.outCheck = new HCPCheckBox(LanguageStrings.getInstance().getStringByName("FILES_PANEL_EMPTY_CHECKBOX_LABEL"), Settings.getInstance().EMPTY_OUT);
        this.outCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().EMPTY_OUT = !Settings.getInstance().EMPTY_OUT;
            }
        });
        this.outButton = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("FILES_PANEL_OPEN_FOLDER_BUTTON"));
        this.outButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Runtime.getRuntime().exec("explorer.exe " + Settings.getInstance().FOLDER_OUT.getAbsolutePath());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        JPanel p22 = new JPanel(new GridLayout(2, 1, 5, 5));
        p22.add(this.outButton);
        p22.add(this.outCheck);
        p22.setBorder(new EmptyBorder(0, 0, 0, 80));
        p2.add((Component)p22, "North");
        mainPanel.add(p2);
        mainPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
    }

    @Override
    public void setVisible(boolean flag) {
        try {
            this.inTable.revalidate();
            this.inTable.repaint();
            this.outTable.revalidate();
            this.outTable.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setVisible(flag);
    }

    private File[] getInFiles(File folder, final String[] ext) {
        return folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return false;
                }
                int i = 0;
                while (i < ext.length) {
                    String e = ext[i].toUpperCase();
                    String p = pathname.getName().toUpperCase();
                    if (p.endsWith(e)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        });
    }

    public final void reset() {
        this.inCheck.setSelected(Settings.getInstance().EMPTY_IN);
        this.outCheck.setSelected(Settings.getInstance().EMPTY_OUT);
    }
}

