/*
 * Decompiled with CFR 0.152.
 */
package gui.rightPanels;

import gui.HCPCheckBox;
import gui.HCPColors;
import gui.HCPGreyButton;
import gui.HCPImage;
import gui.HelpLabel;
import gui.rightPanels.RightPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import objects.Settings;
import objects.fiscal.CommandWrapper;
import objects.lang.LanguageStrings;

public final class DebugPanel
extends RightPanel {
    private static final long serialVersionUID = 1L;
    private JPanel controlPanel;
    private JPanel outerPanel;
    private JPanel inPanel;
    private HCPGreyButton stornoBill;
    private HCPGreyButton closeReceipt;
    public HCPCheckBox useAutoClosure;

    public DebugPanel() {
        super(LanguageStrings.getInstance().getStringByName("DEBUG_PANEL_BUTTON"), 'D', LanguageStrings.getInstance().getStringByName("DEBUG_PANEL_BUTTON_TOOLTIP"));
        this.setLayout(new BorderLayout(5, 5));
        this.controlPanel = new JPanel(new BorderLayout());
        this.controlPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
        JPanel buttonsPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        this.controlPanel.add((Component)buttonsPanel, "North");
        this.stornoBill = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("DEBUG_PANEL_STORNO_BUTTON_LABEL"));
        this.stornoBill.setToolTipText(LanguageStrings.getInstance().getStringByName("DEBUG_PANEL_STORNO_BUTTON_TOOLTIP"));
        this.closeReceipt = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("DEBUG_PANEL_CLOSE_BUTTON_LABEL"));
        this.closeReceipt.setToolTipText(LanguageStrings.getInstance().getStringByName("DEBUG_PANEL_CLOSE_BUTTON_TOOLTIP"));
        this.stornoBill.setIcon(new HCPImage("images/arrow_small.png"));
        this.closeReceipt.setIcon(new HCPImage("images/arrow_small.png"));
        buttonsPanel.add(this.stornoBill);
        buttonsPanel.add(this.closeReceipt);
        this.controlPanel.add((Component)new JPanel(), "Center");
        this.outerPanel = new JPanel();
        this.outerPanel.setLayout(new BorderLayout(10, 10));
        this.outerPanel.setIgnoreRepaint(true);
        this.outerPanel.setBackground(HCPColors.getColorM2st());
        this.outerPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
        this.outerPanel.add((Component)new HelpLabel(LanguageStrings.getInstance().getStringByName("DEBUG_PANEL_HELP_LABEL")), "North");
        this.add((Component)this.outerPanel, "Center");
        this.inPanel = new JPanel();
        this.inPanel.setLayout(new BorderLayout(10, 10));
        this.inPanel.setIgnoreRepaint(true);
        this.inPanel.setBackground(HCPColors.getColorM2st());
        this.inPanel.setBorder(new CompoundBorder(new SoftBevelBorder(1), new EmptyBorder(5, 5, 5, 5)));
        JTextArea text = new JTextArea();
        text.setWrapStyleWord(true);
        text.setLineWrap(true);
        text.setEditable(false);
        text.setText(String.valueOf(LanguageStrings.getInstance().getStringByName("DEBUG_PANEL_HELP_TEXT_1")) + "\r\n\r\n" + LanguageStrings.getInstance().getStringByName("DEBUG_PANEL_HELP_TEXT_2") + "\r\n\r\n" + LanguageStrings.getInstance().getStringByName("DEBUG_PANEL_HELP_TEXT_3") + "\r\n\r\n");
        JScrollPane scrText = new JScrollPane(text, 20, 31);
        this.inPanel.add((Component)scrText, "Center");
        this.outerPanel.add((Component)this.inPanel, "Center");
        this.add((Component)this.controlPanel, "West");
        this.stornoBill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandWrapper.storno_bill = true;
            }
        });
        this.closeReceipt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandWrapper.close_bill = true;
            }
        });
        this.useAutoClosure = new HCPCheckBox(LanguageStrings.getInstance().getStringByName("DEBUG_PANEL_AUTO_CLOSE_CHECKBOX_LABEL"), Settings.getInstance().useAutoClosure);
        this.useAutoClosure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().useAutoClosure = !Settings.getInstance().useAutoClosure;
            }
        });
        buttonsPanel.add(this.useAutoClosure);
    }
}

