/*
 * Decompiled with CFR 0.152.
 */
package gui.rightPanels;

import gnu.io.CommPortIdentifier;
import gui.HCPCheckBox;
import gui.HCPColors;
import gui.HCPComboBox;
import gui.HCPGreyButton;
import gui.HCPImage;
import gui.HCPLabel;
import gui.HCPRadioButton;
import gui.HCPTextField;
import gui.MainFrame;
import gui.rightPanels.PeriodicalDialog;
import gui.rightPanels.RightPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import objects.MainThread;
import objects.Settings;
import objects.XmlServerThread;
import objects.fiscal.CommandWrapper;
import objects.lang.LanguageStrings;
import org.freixas.tablelayout.TableLayout;
import util.comPort.PortSerial;

public final class ControlPanel
extends RightPanel {
    private static final long serialVersionUID = 1L;
    private JPanel mainPanel;
    private JPanel portPCPanel;
    private JPanel controlPanel;
    private JPanel printPanel;
    private JPanel typePanel;
    private JPanel pathsPanel;
    private HCPComboBox comboPCSpeeds;
    private static HCPComboBox comboPCPort;
    private HCPGreyButton testPCButton;
    private HCPGreyButton refreshPortButton;
    private HCPRadioButton startMainThread;
    private HCPRadioButton startServerThread;
    private HCPRadioButton stop;
    private HCPLabel state;
    private HCPLabel printerState;
    public static HCPTextField inPath;
    public static HCPTextField outPath;
    private SpringLayout osl;
    private HCPRadioButton dbf;
    private HCPRadioButton csv;
    private HCPRadioButton xml;
    private HCPRadioButton fisctt;
    private HCPRadioButton regular;
    private HCPRadioButton bold;
    private HCPGreyButton daily_user;
    private HCPGreyButton state_user;
    private HCPGreyButton print_settings;
    private HCPGreyButton periodical_report;
    public static HCPRadioButton printer;
    public static HCPRadioButton register;
    private static HCPLabel registerState;
    private static HCPCheckBox secundaBox;
    private static HCPCheckBox epsonBox;
    private static HCPCheckBox bestLcPlusBox;

    public ControlPanel() {
        super(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_BUTTON"), 'P', LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_BUTTON_TOOLTIP"));
        this.setLayout(new BorderLayout());
        HCPImage slikaTest = new HCPImage("images/Control-Panel_Small.png");
        this.mainPanel = new JPanel();
        this.osl = new SpringLayout();
        this.mainPanel.setLayout(this.osl);
        this.mainPanel.setIgnoreRepaint(true);
        this.mainPanel.setBackground(HCPColors.getColorM2st());
        this.pathsPanel = new JPanel();
        this.pathsPanel.setLayout(new TableLayout("cols=8 rgap=10 cgap=10"));
        this.pathsPanel.setPreferredSize(new Dimension(470, 90));
        this.pathsPanel.setBackground(HCPColors.getColorM2st());
        this.pathsPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(10, 10, 10, 10)));
        HCPGreyButton folderIn = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_BUTTON_FOLDER_IN"));
        folderIn.setToolTipText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_BUTTON_FOLDER_IN_TOOLTIP"));
        folderIn.setIcon(MainFrame.slika);
        folderIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setCurrentDirectory(Settings.getInstance().FOLDER_IN);
                fc.setFileSelectionMode(1);
                fc.showOpenDialog(MainFrame.getInstance());
                File in = fc.getSelectedFile();
                if (in == null) {
                    return;
                }
                if (in.exists()) {
                    Settings.getInstance().FOLDER_IN = in;
                    inPath.setText(in.getAbsolutePath());
                    inPath.setBackground(HCPColors.getColorM2st());
                } else {
                    try {
                        MainFrame.getInstance().displayError(new Exception("Path = " + in.toString() + " not exists!"));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.pathsPanel.add((Component)folderIn, "cspan=1");
        inPath = new HCPTextField(Settings.getInstance().FOLDER_IN.getAbsolutePath());
        inPath.setEditable(false);
        this.pathsPanel.add((Component)inPath, "cspan=7");
        HCPGreyButton folderOut = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_BUTTON_FOLDER_OUT"));
        folderOut.setToolTipText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_BUTTON_FOLDER_OUT_TOOLTIP"));
        folderOut.setIcon(MainFrame.slika);
        folderOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setCurrentDirectory(Settings.getInstance().FOLDER_OUT);
                fc.setFileSelectionMode(1);
                fc.showOpenDialog(MainFrame.getInstance());
                File out = fc.getSelectedFile();
                if (out == null) {
                    return;
                }
                if (out.exists()) {
                    Settings.getInstance().FOLDER_OUT = out;
                    outPath.setText(out.getAbsolutePath());
                    outPath.setBackground(HCPColors.getColorM2st());
                } else {
                    try {
                        MainFrame.getInstance().displayError(new Exception("Path = " + out.toString() + " not exists!"));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.pathsPanel.add((Component)folderOut, "cspan=1");
        outPath = new HCPTextField(Settings.getInstance().FOLDER_OUT.getAbsolutePath());
        outPath.setEditable(false);
        this.pathsPanel.add((Component)outPath, "cspan=7");
        this.typePanel = new JPanel();
        this.typePanel.setLayout(new GridLayout(5, 1, 10, 10));
        this.typePanel.setPreferredSize(new Dimension(153, 185));
        this.typePanel.setBackground(HCPColors.getColorM2st());
        this.typePanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(10, 10, 10, 10)));
        this.typePanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_FILE_TYPE_LABEL")));
        this.fisctt = new HCPRadioButton(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_FILE_TYPE_FISCTT_LABEL"));
        this.fisctt.setToolTipText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_FILE_TYPE_FISCTT_TOOLTIP"));
        this.fisctt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().setFileType(4);
            }
        });
        this.typePanel.add(this.fisctt);
        this.dbf = new HCPRadioButton(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_FILE_TYPE_DBF_LABEL"));
        this.dbf.setToolTipText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_FILE_TYPE_DBF_TOOLTIP"));
        this.dbf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().setFileType(2);
            }
        });
        this.typePanel.add(this.dbf);
        this.csv = new HCPRadioButton(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_FILE_TYPE_CSV_LABEL"));
        this.csv.setToolTipText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_FILE_TYPE_CSV_TOOLTIP"));
        this.csv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().setFileType(1);
            }
        });
        this.typePanel.add(this.csv);
        this.xml = new HCPRadioButton(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_FILE_TYPE_XML_LABEL"));
        this.xml.setToolTipText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_FILE_TYPE_XML_TOOLTIP"));
        this.xml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().setFileType(3);
            }
        });
        this.typePanel.add(this.xml);
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.dbf);
        bg1.add(this.csv);
        bg1.add(this.xml);
        bg1.add(this.fisctt);
        switch (Settings.getInstance().getFileType()) {
            case 2: {
                this.dbf.doClick();
                break;
            }
            case 1: {
                this.csv.doClick();
                break;
            }
            case 3: {
                this.xml.doClick();
                break;
            }
            case 4: {
                this.fisctt.doClick();
            }
        }
        this.printPanel = new JPanel();
        this.printPanel.setLayout(new GridLayout(4, 1, 10, 10));
        this.printPanel.setPreferredSize(new Dimension(153, 200));
        this.printPanel.setBackground(HCPColors.getColorM2st());
        this.printPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(10, 10, 10, 10)));
        this.printPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_FONT_LABEL")));
        this.regular = new HCPRadioButton(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_FONT_REGULAR_LABEL"));
        this.regular.setToolTipText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_FONT_REGULAR_TOOLTIP"));
        this.regular.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().setBold(false);
                ControlPanel.this.printerState.setText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_FONT_REGULAR_SHOW"));
            }
        });
        this.printPanel.add(this.regular);
        this.bold = new HCPRadioButton(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_FONT_BOLD_LABEL"));
        this.bold.setToolTipText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_FONT_BOLD_TOOLTIP"));
        this.bold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().setBold(true);
                ControlPanel.this.printerState.setText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_FONT_BOLD_SHOW"));
            }
        });
        this.printPanel.add(this.bold);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.regular);
        bg.add(this.bold);
        this.printerState = new HCPLabel("", 0);
        this.printPanel.add(this.printerState);
        if (Settings.getInstance().isBold()) {
            this.bold.doClick();
        } else {
            this.regular.doClick();
        }
        this.portPCPanel = new JPanel();
        this.portPCPanel.setLayout(new GridLayout(5, 1, 10, 10));
        this.portPCPanel.setPreferredSize(new Dimension(153, 200));
        this.portPCPanel.setBackground(HCPColors.getColorM2st());
        this.portPCPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(10, 10, 10, 10)));
        this.portPCPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_PCPORT_LABEL")));
        comboPCPort = new HCPComboBox();
        this.portPCPanel.add(comboPCPort);
        this.comboPCSpeeds = new HCPComboBox();
        this.comboPCSpeeds.addItem("9600");
        this.comboPCSpeeds.addItem("19200");
        this.comboPCSpeeds.addItem("38400");
        this.comboPCSpeeds.addItem("57600");
        this.comboPCSpeeds.addItem("115200");
        this.comboPCSpeeds.addItem("230400");
        this.comboPCSpeeds.setSelectedIndex(4);
        this.portPCPanel.add(this.comboPCSpeeds);
        this.testPCButton = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_PCPORT_TEST_BUTTON"));
        this.testPCButton.setToolTipText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_PCPORT_TEST_BUTTON_TOOLTIP"));
        this.testPCButton.setIcon(slikaTest);
        this.testPCButton.setHorizontalAlignment(2);
        this.testPCButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandWrapper.user_port = (String)comboPCPort.getSelectedItem();
                CommandWrapper.user_speed = (String)ControlPanel.this.comboPCSpeeds.getSelectedItem();
                CommandWrapper.test_port = true;
            }
        });
        this.portPCPanel.add(this.testPCButton);
        this.refreshPortButton = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_PCPORT_REFRESH_BUTTON"));
        this.refreshPortButton.setToolTipText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_PCPORT_REFRESH_BUTTON_TOOLTIP"));
        this.refreshPortButton.setIcon(slikaTest);
        this.refreshPortButton.setHorizontalAlignment(2);
        this.refreshPortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Enumeration enu = null;
                enu = CommPortIdentifier.getPortIdentifiers();
                ControlPanel.clearComboPCPort();
                while (enu.hasMoreElements()) {
                    CommPortIdentifier com = (CommPortIdentifier)enu.nextElement();
                    if (com.getPortType() != 1) continue;
                    ControlPanel.setComboPort(com);
                }
            }
        });
        this.portPCPanel.add(this.refreshPortButton);
        Enumeration ep = null;
        try {
            ep = CommPortIdentifier.getPortIdentifiers();
        }
        catch (Exception exception) {
            // empty catch block
        }
        comboPCPort.removeAllItems();
        while (ep.hasMoreElements()) {
            CommPortIdentifier pom = (CommPortIdentifier)ep.nextElement();
            if (pom.getPortType() != 1) continue;
            comboPCPort.addItem(pom.getName());
        }
        try {
            this.comboPCSpeeds.setSelectedItem("" + PortSerial.speed);
            comboPCPort.setSelectedItem(PortSerial.sPort);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new GridLayout(5, 1, 10, 10));
        this.controlPanel.setPreferredSize(new Dimension(153, 200));
        this.controlPanel.setBackground(HCPColors.getColorM2st());
        this.controlPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(10, 10, 10, 10)));
        this.controlPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_LABEL")));
        this.startMainThread = new HCPRadioButton(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_FILE_MODE_LABEL"));
        this.startMainThread.setToolTipText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_FILE_MODE_TOOLTIP"));
        this.startMainThread.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Settings.getInstance().mode == 1) {
                    return;
                }
                MainThread.work = true;
                XmlServerThread.closeAll();
                Settings.getInstance().mode = 1;
                ControlPanel.this.state.setText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_FILE_MODE_SHOW"));
            }
        });
        this.controlPanel.add(this.startMainThread);
        this.startServerThread = new HCPRadioButton(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_SERVER_MODE_LABEL"));
        this.startServerThread.setToolTipText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_SERVER_MODE_TOOLTIP"));
        this.startServerThread.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Settings.getInstance().mode == 2) {
                    return;
                }
                XmlServerThread.openAll();
                MainThread.work = false;
                Settings.getInstance().mode = 2;
                ControlPanel.this.state.setText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_SERVER_MODE_SHOW"));
            }
        });
        this.controlPanel.add(this.startServerThread);
        this.stop = new HCPRadioButton(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_STOP_LABEL"));
        this.stop.setToolTipText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_STOP_TOOLTIP"));
        this.stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Settings.getInstance().mode == 0) {
                    return;
                }
                MainThread.work = false;
                XmlServerThread.closeAll();
                Settings.getInstance().mode = 0;
                ControlPanel.this.state.setText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_STOP_SHOW"));
            }
        });
        this.controlPanel.add(this.stop);
        this.state = new HCPLabel(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_STOP_SHOW"), 0);
        this.controlPanel.add(this.state);
        ButtonGroup bbb = new ButtonGroup();
        bbb.add(this.startMainThread);
        bbb.add(this.startServerThread);
        bbb.add(this.stop);
        this.stop.setSelected(true);
        switch (Settings.getInstance().mode) {
            case 2: {
                this.startServerThread.setSelected(true);
                XmlServerThread.openAll();
                MainThread.work = false;
                Settings.getInstance().mode = 2;
                this.state.setText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_SERVER_MODE_SHOW"));
                break;
            }
            case 1: {
                this.startMainThread.setSelected(true);
                MainThread.work = true;
                XmlServerThread.closeAll();
                Settings.getInstance().mode = 1;
                this.state.setText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_FILE_MODE_SHOW"));
            }
        }
        JPanel commandsPanel = new JPanel();
        commandsPanel.setLayout(new GridLayout(5, 1, 10, 10));
        commandsPanel.setPreferredSize(new Dimension(153, 185));
        commandsPanel.setBackground(HCPColors.getColorM2st());
        commandsPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(10, 10, 10, 10)));
        commandsPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_COMMAND_LABEL")));
        this.daily_user = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_COMMAND_DAILY_BUTTON_LABEL"));
        this.daily_user.setToolTipText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_COMMAND_DAILY_BUTTON_TOOLTIP"));
        this.daily_user.setIcon(MainFrame.slikaCash);
        this.daily_user.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandWrapper.daily_user = true;
            }
        });
        commandsPanel.add(this.daily_user);
        this.state_user = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_COMMAND_STATE_BUTTON_LABEL"));
        this.state_user.setToolTipText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_COMMAND_STATE_BUTTON_TOOLTIP"));
        this.state_user.setIcon(MainFrame.slikaCash);
        this.state_user.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandWrapper.state_user = true;
            }
        });
        commandsPanel.add(this.state_user);
        this.periodical_report = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_COMMAND_PERIODICAL_BUTTON_LABEL"));
        this.periodical_report.setToolTipText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_COMMAND_PERIODICAL_BUTTON_TOOLTIP"));
        this.periodical_report.setIcon(MainFrame.slikaCash);
        this.periodical_report.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new PeriodicalDialog();
            }
        });
        commandsPanel.add(this.periodical_report);
        this.print_settings = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_COMMAND_SETTINGS_BUTTON_LABEL"));
        this.print_settings.setToolTipText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_COMMAND_SETTINGS_BUTTON_TOOLTIP"));
        this.print_settings.setIcon(MainFrame.slikaCash);
        this.print_settings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandWrapper.print_settings = true;
            }
        });
        commandsPanel.add(this.print_settings);
        JPanel registerPanel = new JPanel();
        registerPanel.setLayout(new GridLayout(7, 1, 10, 10));
        registerPanel.setPreferredSize(new Dimension(153, 185));
        registerPanel.setBackground(HCPColors.getColorM2st());
        registerPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(10, 10, 10, 10)));
        registerPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_DEVICE_LABEL")));
        printer = new HCPRadioButton(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_DEVICE_PRINTER_LABEL"));
        printer.setToolTipText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_DEVICE_PRINTER_TOOLTIP"));
        printer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().setPrinter(true);
                Settings.getInstance().setBestLcPlus(false);
                MainFrame.BESTLCPLUS = false;
                bestLcPlusBox.setSelected(false);
                bestLcPlusBox.setEnabled(false);
                secundaBox.setEnabled(true);
                secundaBox.setSelected(false);
                epsonBox.setEnabled(true);
                epsonBox.setSelected(false);
                registerState.setText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_DEVICE_PRINTER_SHOW"));
            }
        });
        registerPanel.add(printer);
        secundaBox = new HCPCheckBox(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_DEVICE_SECUNDA_LABEL"));
        secundaBox.setSelected(false);
        secundaBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (secundaBox.isSelected()) {
                    epsonBox.setSelected(false);
                    Settings.getInstance().setSecunda(true);
                    Settings.getInstance().setEpson(false);
                    MainFrame.SECUNDA = true;
                    registerState.setText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_DEVICE_SECUNDA_SHOW"));
                } else {
                    Settings.getInstance().setSecunda(false);
                    MainFrame.SECUNDA = false;
                    registerState.setText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_DEVICE_PRINTER_SHOW"));
                }
            }
        });
        registerPanel.add(secundaBox);
        epsonBox = new HCPCheckBox(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_DEVICE_EPSON_LABEL"));
        epsonBox.setSelected(false);
        epsonBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (epsonBox.isSelected()) {
                    secundaBox.setSelected(false);
                    Settings.getInstance().setEpson(true);
                    Settings.getInstance().setSecunda(false);
                    MainFrame.EPSON = true;
                    registerState.setText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_DEVICE_EPSON_SHOW"));
                } else {
                    Settings.getInstance().setEpson(false);
                    MainFrame.EPSON = false;
                    registerState.setText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_DEVICE_PRINTER_SHOW"));
                }
            }
        });
        registerPanel.add(epsonBox);
        register = new HCPRadioButton(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_DEVICE_REGISTER_LABEL"));
        register.setToolTipText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_DEVICE_REGISTER_TOOLTIP"));
        register.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().setPrinter(false);
                secundaBox.setSelected(false);
                epsonBox.setSelected(false);
                MainFrame.SECUNDA = false;
                MainFrame.EPSON = false;
                MainFrame.BESTLCPLUS = false;
                MainFrame.PRINTER = false;
                Settings.getInstance().setSecunda(false);
                Settings.getInstance().setEpson(false);
                secundaBox.setEnabled(false);
                epsonBox.setEnabled(false);
                bestLcPlusBox.setEnabled(true);
                bestLcPlusBox.setSelected(false);
                registerState.setText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_DEVICE_REGISTER_SHOW"));
            }
        });
        registerPanel.add(register);
        bestLcPlusBox = new HCPCheckBox(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_DEVICE_BESTLCPLUS_LABEL"));
        bestLcPlusBox.setSelected(false);
        bestLcPlusBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (bestLcPlusBox.isSelected()) {
                    Settings.getInstance().setBestLcPlus(true);
                    MainFrame.BESTLCPLUS = true;
                    registerState.setText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_DEVICE_BESTLCPLUS_SHOW"));
                } else {
                    Settings.getInstance().setBestLcPlus(false);
                    MainFrame.BESTLCPLUS = false;
                    registerState.setText(LanguageStrings.getInstance().getStringByName("CONTROL_PANEL_CONTROL_DEVICE_REGISTER_SHOW"));
                }
            }
        });
        registerPanel.add(bestLcPlusBox);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(printer);
        bg2.add(register);
        registerState = new HCPLabel("", 0);
        registerPanel.add(registerState);
        if (Settings.getInstance().isPrinter()) {
            printer.doClick();
        } else {
            register.doClick();
        }
        if (Settings.getInstance().isSecunda()) {
            secundaBox.setSelected(true);
            MainFrame.SECUNDA = true;
        }
        if (Settings.getInstance().isEpson()) {
            epsonBox.setSelected(true);
            MainFrame.EPSON = true;
        }
        if (Settings.getInstance().isBestLcPlus()) {
            bestLcPlusBox.setSelected(true);
            MainFrame.BESTLCPLUS = true;
        }
        if (Settings.getInstance().isPrima()) {
            MainFrame.PRIMA = true;
        }
        this.osl.putConstraint("North", (Component)this.portPCPanel, 0, "North", (Component)this.mainPanel);
        this.osl.putConstraint("West", (Component)this.portPCPanel, 0, "West", (Component)this.mainPanel);
        this.mainPanel.add(this.portPCPanel);
        this.osl.putConstraint("North", (Component)this.controlPanel, 0, "North", (Component)this.mainPanel);
        this.osl.putConstraint("West", (Component)this.controlPanel, 5, "East", (Component)this.portPCPanel);
        this.mainPanel.add(this.controlPanel);
        this.osl.putConstraint("North", (Component)this.printPanel, 0, "North", (Component)this.mainPanel);
        this.osl.putConstraint("West", (Component)this.printPanel, 5, "East", (Component)this.controlPanel);
        this.mainPanel.add(this.printPanel);
        this.osl.putConstraint("North", (Component)this.typePanel, 5, "South", (Component)this.portPCPanel);
        this.osl.putConstraint("West", (Component)this.typePanel, 0, "West", (Component)this.mainPanel);
        this.mainPanel.add(this.typePanel);
        this.osl.putConstraint("North", (Component)commandsPanel, 5, "South", (Component)this.portPCPanel);
        this.osl.putConstraint("West", (Component)commandsPanel, 5, "East", (Component)this.typePanel);
        this.mainPanel.add(commandsPanel);
        this.osl.putConstraint("North", (Component)registerPanel, 5, "South", (Component)this.portPCPanel);
        this.osl.putConstraint("West", (Component)registerPanel, 5, "East", (Component)commandsPanel);
        this.mainPanel.add(registerPanel);
        this.osl.putConstraint("North", (Component)this.pathsPanel, 5, "South", (Component)this.typePanel);
        this.osl.putConstraint("West", (Component)this.pathsPanel, 0, "West", (Component)this.mainPanel);
        this.mainPanel.add(this.pathsPanel);
        this.add((Component)this.mainPanel, "Center");
    }

    public final void reset() {
        inPath.setText(Settings.getInstance().FOLDER_IN.getAbsolutePath());
        outPath.setText(Settings.getInstance().FOLDER_OUT.getAbsolutePath());
        switch (Settings.getInstance().getFileType()) {
            case 2: {
                this.dbf.doClick();
                break;
            }
            case 1: {
                this.csv.doClick();
                break;
            }
            case 3: {
                this.xml.doClick();
                break;
            }
            case 4: {
                this.fisctt.doClick();
            }
        }
        switch (Settings.getInstance().mode) {
            case 1: {
                this.startMainThread.doClick();
                break;
            }
            case 2: {
                this.startServerThread.doClick();
                break;
            }
            default: {
                this.stop.doClick();
            }
        }
        if (Settings.getInstance().isBold()) {
            this.bold.doClick();
        } else {
            this.regular.doClick();
        }
        if (Settings.getInstance().isPrinter()) {
            printer.doClick();
        } else {
            register.doClick();
        }
        try {
            this.comboPCSpeeds.setSelectedItem("" + PortSerial.speed);
            comboPCPort.setSelectedItem(PortSerial.sPort);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.revalidate();
        this.repaint();
    }

    public static void clearComboPCPort() {
        comboPCPort.removeAllItems();
    }

    public static void setComboPort(CommPortIdentifier c) {
        comboPCPort.addItem(c.getName());
    }

    public static void setSecundaChekBox() {
        secundaBox.setSelected(true);
        secundaBox.setEnabled(true);
        epsonBox.setSelected(false);
        epsonBox.setEnabled(true);
        MainFrame.SECUNDA = true;
        Settings.getInstance().setPrinter(true);
        Settings.getInstance().setSecunda(true);
        printer.setSelected(true);
        register.setEnabled(true);
        registerState.setText("secunda...");
        MainFrame.getInstance().saveSettings();
    }

    public static void setEpsonChekBox() {
        epsonBox.setSelected(true);
        epsonBox.setEnabled(true);
        secundaBox.setSelected(false);
        secundaBox.setEnabled(true);
        MainFrame.EPSON = true;
        Settings.getInstance().setPrinter(true);
        Settings.getInstance().setEpson(true);
        printer.setSelected(true);
        register.setEnabled(true);
        registerState.setText("epson...");
        MainFrame.getInstance().saveSettings();
    }

    public static void setPrinterRadioButton() {
        printer.setEnabled(true);
        printer.setSelected(true);
        Settings.getInstance().setPrinter(true);
        Settings.getInstance().setSecunda(false);
        Settings.getInstance().setEpson(false);
        registerState.setText("printer...");
        register.setEnabled(true);
        secundaBox.setSelected(false);
        epsonBox.setSelected(false);
        MainFrame.getInstance().saveSettings();
    }

    public static void setRegisterRadioButton() {
        register.setEnabled(true);
        register.setSelected(true);
        bestLcPlusBox.setEnabled(true);
        bestLcPlusBox.setSelected(false);
        MainFrame.BESTLCPLUS = false;
        Settings.getInstance().setPrinter(false);
        secundaBox.setSelected(false);
        MainFrame.SECUNDA = false;
        Settings.getInstance().setSecunda(false);
        secundaBox.setEnabled(false);
        epsonBox.setSelected(false);
        MainFrame.EPSON = false;
        Settings.getInstance().setEpson(false);
        epsonBox.setEnabled(false);
        MainFrame.getInstance().saveSettings();
    }

    public static void setBestLcPLusRadioButton() {
        bestLcPlusBox.setEnabled(true);
        bestLcPlusBox.setSelected(true);
        MainFrame.BESTLCPLUS = true;
        Settings.getInstance().setBestLcPlus(true);
        Settings.getInstance().setPrinter(false);
        Settings.getInstance().setSecunda(false);
        Settings.getInstance().setEpson(false);
        register.setSelected(true);
        printer.setEnabled(true);
        printer.setSelected(false);
        secundaBox.setEnabled(false);
        secundaBox.setSelected(false);
        epsonBox.setSelected(false);
        epsonBox.setEnabled(false);
        MainFrame.PRINTER = false;
        MainFrame.SECUNDA = false;
        MainFrame.EPSON = false;
        registerState.setText("bestLC+...");
        MainFrame.getInstance().saveSettings();
    }
}

