/*
 * Decompiled with CFR 0.152.
 */
package gui.rightPanels;

import gui.HCPCheckBox;
import gui.HCPColors;
import gui.HCPLabel;
import gui.HCPSpinner;
import gui.HCPTextField;
import gui.HelpLabel;
import gui.MainFrame;
import gui.rightPanels.RightPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import objects.Settings;
import objects.XmlServerThread;
import objects.lang.LanguageStrings;

public final class AdvancedSettingsPanel
extends RightPanel {
    private static final long serialVersionUID = 1L;
    private JPanel controlPanel;
    private JPanel outerPanel;
    private JPanel inPanel;
    public HCPSpinner timeoutThread;
    public HCPSpinner timeoutDeleteInput;
    public HCPSpinner timeoutDeleteOutput;
    public HCPCheckBox useThreadTimeout;
    public HCPCheckBox useThreadDeleteInput;
    public HCPCheckBox useThreadDeleteOutput;
    public HCPCheckBox keepSerialOpen;
    public static HCPCheckBox bigAmount;
    public static HCPCheckBox showErrorDialog;
    public HCPSpinner timeoutErrorClient;

    public AdvancedSettingsPanel() {
        super(LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_BUTTON"), 'A', LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_BUTTON_TOOLTIP"));
        this.setLayout(new BorderLayout(5, 5));
        this.controlPanel = new JPanel(new BorderLayout());
        this.controlPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
        JPanel buttonsPanel = new JPanel(new GridLayout(11, 2, 5, 5));
        this.controlPanel.add((Component)buttonsPanel, "North");
        JPanel buttonsPanelDown = new JPanel(new GridLayout(9, 1, 5, 5));
        this.controlPanel.add((Component)buttonsPanelDown, "South");
        buttonsPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_SET_TIMEOUT_LABEL"), 2));
        buttonsPanel.add(new HCPLabel());
        this.timeoutThread = new HCPSpinner();
        this.timeoutThread.setModel(new SpinnerNumberModel(Settings.getInstance().timeoutThread, 100, 5000, 100));
        this.timeoutThread.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Settings.getInstance().timeoutThread = (Integer)AdvancedSettingsPanel.this.timeoutThread.getValue();
            }
        });
        buttonsPanel.add(this.timeoutThread);
        this.useThreadTimeout = new HCPCheckBox(LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_SET_TIMEOUT_MAIN_LABEL"));
        this.useThreadTimeout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().useThreadTimeout = !AdvancedSettingsPanel.this.timeoutThread.isEnabled();
                AdvancedSettingsPanel.this.timeoutThread.setEnabled(!AdvancedSettingsPanel.this.timeoutThread.isEnabled());
            }
        });
        buttonsPanel.add(this.useThreadTimeout);
        this.timeoutDeleteInput = new HCPSpinner();
        this.timeoutDeleteInput.setModel(new SpinnerNumberModel(Settings.getInstance().timeoutDeleteInput, 100, 5000, 100));
        this.timeoutDeleteInput.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Settings.getInstance().timeoutDeleteInput = (Integer)AdvancedSettingsPanel.this.timeoutDeleteInput.getValue();
            }
        });
        buttonsPanel.add(this.timeoutDeleteInput);
        this.useThreadDeleteInput = new HCPCheckBox(LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_SET_TIMEOUT_DELETE_INPUT_LABEL"));
        this.useThreadDeleteInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().useThreadDeleteInput = !AdvancedSettingsPanel.this.timeoutDeleteInput.isEnabled();
                AdvancedSettingsPanel.this.timeoutDeleteInput.setEnabled(!AdvancedSettingsPanel.this.timeoutDeleteInput.isEnabled());
            }
        });
        buttonsPanel.add(this.useThreadDeleteInput);
        this.timeoutDeleteOutput = new HCPSpinner();
        this.timeoutDeleteOutput.setModel(new SpinnerNumberModel(Settings.getInstance().timeoutDeleteOutput, 100, 5000, 100));
        this.timeoutDeleteOutput.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Settings.getInstance().timeoutDeleteOutput = (Integer)AdvancedSettingsPanel.this.timeoutDeleteOutput.getValue();
            }
        });
        buttonsPanel.add(this.timeoutDeleteOutput);
        this.useThreadDeleteOutput = new HCPCheckBox(LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_SET_TIMEOUT_DELETE_OUTPUT_LABEL"));
        this.useThreadDeleteOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().useThreadDeleteOutput = !AdvancedSettingsPanel.this.timeoutDeleteOutput.isEnabled();
                AdvancedSettingsPanel.this.timeoutDeleteOutput.setEnabled(!AdvancedSettingsPanel.this.timeoutDeleteOutput.isEnabled());
            }
        });
        buttonsPanel.add(this.useThreadDeleteOutput);
        this.keepSerialOpen = new HCPCheckBox(LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_KEEP_SERIAL_OPENED_CHECKBOX"));
        this.keepSerialOpen.setSelected(false);
        this.keepSerialOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().setSerialOpen(AdvancedSettingsPanel.this.keepSerialOpen.isSelected());
                MainFrame.SERIAL_KEEP_OPENED = AdvancedSettingsPanel.this.keepSerialOpen.isSelected();
            }
        });
        bigAmount = new HCPCheckBox(LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_BIG_AMOUNT_PARSER_CHECKBOX"));
        bigAmount.setSelected(false);
        bigAmount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().setBigAmount(bigAmount.isSelected());
                MainFrame.BIG_AMOUNT = bigAmount.isSelected();
            }
        });
        showErrorDialog = new HCPCheckBox(LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_SHOW_ERROR_DIALOG_CHECKBOX"));
        showErrorDialog.setSelected(false);
        showErrorDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().setErrorDialog(showErrorDialog.isSelected());
                MainFrame.SHOW_ERROR_DIALOG = showErrorDialog.isSelected();
            }
        });
        buttonsPanel.add(new HCPLabel());
        buttonsPanel.add(new HCPLabel());
        this.addLabel(buttonsPanel, Settings.getInstance().bindingPort, "binding port");
        buttonsPanel.add(new HCPLabel());
        buttonsPanel.add(new HCPLabel());
        buttonsPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_SET_REPLY_TIMEOUT_LABEL"), 2));
        buttonsPanel.add(new HCPLabel());
        this.timeoutErrorClient = new HCPSpinner();
        this.timeoutErrorClient.setModel(new SpinnerNumberModel(Settings.getInstance().timeoutErrorClient / 1000, 1, 30, 1));
        this.timeoutErrorClient.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Settings.getInstance().timeoutErrorClient = Integer.valueOf((Integer)AdvancedSettingsPanel.this.timeoutErrorClient.getValue()) * 1000;
            }
        });
        buttonsPanel.add(this.timeoutErrorClient);
        buttonsPanel.add(new HCPLabel());
        buttonsPanel.add(new HCPLabel());
        buttonsPanel.add(new HCPLabel());
        this.addLabel(buttonsPanel, XmlServerThread.commandServerPort, LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_COMMAND_SERVER_PORT_LABEL"));
        buttonsPanelDown.add(new HCPLabel());
        buttonsPanelDown.add(this.keepSerialOpen);
        buttonsPanelDown.add(new HCPLabel());
        buttonsPanelDown.add(showErrorDialog);
        buttonsPanelDown.add(bigAmount);
        this.useThreadTimeout.setSelected(Settings.getInstance().useThreadTimeout);
        this.useThreadDeleteInput.setSelected(Settings.getInstance().useThreadDeleteInput);
        this.useThreadDeleteOutput.setSelected(Settings.getInstance().useThreadDeleteOutput);
        this.timeoutThread.setEnabled(Settings.getInstance().useThreadTimeout);
        this.timeoutDeleteInput.setEnabled(Settings.getInstance().useThreadDeleteInput);
        this.timeoutDeleteOutput.setEnabled(Settings.getInstance().useThreadDeleteOutput);
        if (Settings.getInstance().isSerialOpen()) {
            this.keepSerialOpen.setSelected(true);
            MainFrame.SERIAL_KEEP_OPENED = true;
        }
        this.controlPanel.add((Component)new JPanel(), "Center");
        this.outerPanel = new JPanel();
        this.outerPanel.setLayout(new BorderLayout(10, 10));
        this.outerPanel.setIgnoreRepaint(true);
        this.outerPanel.setBackground(HCPColors.getColorM2st());
        this.outerPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
        this.outerPanel.add((Component)new HelpLabel(LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_HELP_LABEL")), "North");
        this.add((Component)this.outerPanel, "Center");
        this.inPanel = new JPanel();
        this.inPanel.setLayout(new BorderLayout(10, 10));
        this.inPanel.setIgnoreRepaint(true);
        this.inPanel.setBackground(HCPColors.getColorM2st());
        this.inPanel.setBorder(new CompoundBorder(new SoftBevelBorder(1), new EmptyBorder(5, 5, 5, 5)));
        JTextArea text = new JTextArea();
        text.setWrapStyleWord(true);
        text.setLineWrap(true);
        text.setEditable(false);
        text.setText(String.valueOf(LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_HELP_TEXT_1")) + "\r\n" + LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_HELP_TEXT_2") + "\r\n" + LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_HELP_TEXT_3") + "\r\n\r\n" + LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_HELP_TEXT_4") + "\r\n\r\n" + LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_HELP_TEXT_5") + LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_HELP_TEXT_6") + "\r\n\r\n" + LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_HELP_TEXT_10") + "\r\n\r\n" + LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_HELP_TEXT_7") + "\r\n\r\n" + LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_HELP_TEXT_8") + "\r\n\r\n" + LanguageStrings.getInstance().getStringByName("ADVANCED_PANEL_HELP_TEXT_9"));
        JScrollPane scrText = new JScrollPane(text, 20, 31);
        this.inPanel.add((Component)scrText, "Center");
        this.outerPanel.add((Component)this.inPanel, "Center");
        this.add((Component)this.controlPanel, "West");
    }

    public final void reset() {
        this.useThreadTimeout.setSelected(Settings.getInstance().useThreadTimeout);
        this.useThreadDeleteInput.setSelected(Settings.getInstance().useThreadDeleteInput);
        this.useThreadDeleteOutput.setSelected(Settings.getInstance().useThreadDeleteOutput);
        this.timeoutThread.setEnabled(Settings.getInstance().useThreadTimeout);
        this.timeoutDeleteInput.setEnabled(Settings.getInstance().useThreadDeleteInput);
        this.timeoutDeleteOutput.setEnabled(Settings.getInstance().useThreadDeleteOutput);
        this.timeoutThread.setValue(Settings.getInstance().timeoutThread);
        this.timeoutDeleteInput.setValue(Settings.getInstance().timeoutDeleteInput);
        this.timeoutDeleteOutput.setValue(Settings.getInstance().timeoutDeleteOutput);
        this.timeoutErrorClient.setValue(Settings.getInstance().timeoutErrorClient);
    }

    private void addLabel(JPanel buttonsPanel, int val, String title) {
        HCPTextField port = new HCPTextField();
        port.setEditable(false);
        port.setText("" + val);
        buttonsPanel.add(port);
        buttonsPanel.add(new HCPLabel(title, 2));
    }
}

