/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.HCPColors;
import gui.MainFrame;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class NumTextFieldRange
extends JTextField {
    private static final long serialVersionUID = 1L;
    protected int lenght;
    protected int min;
    protected long max;

    public NumTextFieldRange(int len, int minn, long max) {
        super(len);
        this.lenght = len;
        this.min = minn;
        this.max = max;
        this.setFont(MainFrame.font);
        this.setForeground(HCPColors.getColorM3st());
        this.setHorizontalAlignment(4);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                NumTextFieldRange.this.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                long l;
                String s = NumTextFieldRange.this.getText();
                if (s.length() == 0) {
                    s = String.valueOf(NumTextFieldRange.this.min);
                    NumTextFieldRange.this.setText(s);
                }
                if ((l = Long.parseLong(s)) < (long)NumTextFieldRange.this.min) {
                    NumTextFieldRange.this.setText(String.valueOf(NumTextFieldRange.this.min));
                }
            }
        });
        this.setText(String.valueOf(this.min));
    }

    @Override
    protected Document createDefaultModel() {
        return new DesField();
    }

    class DesField
    extends PlainDocument {
        DesField() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char c;
            int l = str.length();
            if (str == null) {
                return;
            }
            if (l == 0) {
                return;
            }
            if (this.getLength() + l > NumTextFieldRange.this.lenght) {
                return;
            }
            long val = 0L;
            int oldL = this.getLength();
            String olds = this.getText(0, oldL);
            int i = 0;
            while (i < oldL) {
                c = olds.charAt(i);
                val *= 10L;
                val += (long)(c - 48);
                ++i;
            }
            i = 0;
            while (i < l) {
                c = str.charAt(i);
                if (c < '0' || c > '9') {
                    return;
                }
                val *= 10L;
                val += (long)(c - 48);
                ++i;
            }
            if (val > NumTextFieldRange.this.max) {
                return;
            }
            super.insertString(offs, str, a);
        }
    }
}

