/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.HCPArrowPopButton;
import gui.HCPColors;
import gui.HCPComboBox;
import gui.HCPImage;
import gui.HCPLabel;
import gui.rightPanels.AboutHcpPanel;
import gui.rightPanels.AdvancedSettingsPanel;
import gui.rightPanels.ControlPanel;
import gui.rightPanels.DebugPanel;
import gui.rightPanels.FilePanel;
import gui.rightPanels.LogPanel;
import gui.rightPanels.RightPanel;
import gui.rightPanels.RightPanelListener;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import objects.Settings;
import objects.lang.LanguageStrings;
import org.gnome.notify.Notification;
import util.XML.XmlExecuter;

public final class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static boolean PRINTER;
    public static boolean SECUNDA;
    public static boolean PRIMA;
    public static boolean EPSON;
    public static boolean BESTLCPLUS;
    public static boolean SERIAL_KEEP_OPENED;
    public static boolean START;
    public static boolean BIG_AMOUNT;
    public static boolean SHOW_ERROR_DIALOG;
    public static String CHECK;
    public static boolean fIn;
    public static boolean fOut;
    public static boolean fFolder;
    public static boolean LOG_START;
    public static boolean SERIAL_MONITOR;
    public static HCPComboBox langChoose;
    public static boolean RESTART;
    public static final int IBFM_ID_INTEGRA = 65;
    public static final int IBFM_ID_BEST = 132;
    public static final int IBFM_ID_BEST_LC = 133;
    public static final int IBFM_ID_FLEXI = 134;
    public static final int IBFM_ID_P2DS = 135;
    public static final int IBFM_ID_ULTIMA = 69;
    public static final int IBFM_ID_SECUNDA = 139;
    public static final int IBFM_ID_PRIMA = 74;
    public static final int IBFM_ID_EPSON = 75;
    public static final int IBFM_ID_TESTNI_UREDJAJ = 88;
    public String lastError = "No errors occured!";
    public static JPanel rightPane;
    public static JPanel leftPanel;
    public static JPanel mainPanel;
    public CardLayout cLayout;
    public ControlPanel controlPane;
    public FilePanel filePanel;
    public AdvancedSettingsPanel advancedPanel;
    public LogPanel logPanel;
    public DebugPanel debugPanel;
    private final JButton hideAll;
    public static final String version = "ver. 5.95";
    public static Font font;
    private static final String mainTitle = "HCP d.o.o.";
    private static MainFrame instance;
    public Notification notification;
    public static HCPImage slika;
    public static HCPImage slikaComp;
    public static HCPImage slikaCash;
    public static MenuItem menuExit;
    public static MenuItem menuShow;
    public static MenuItem menuHide;
    public static MenuItem menuError;

    static {
        SECUNDA = false;
        PRIMA = false;
        EPSON = false;
        BESTLCPLUS = false;
        SERIAL_KEEP_OPENED = false;
        START = false;
        BIG_AMOUNT = false;
        SHOW_ERROR_DIALOG = false;
        CHECK = null;
        fIn = false;
        fOut = false;
        fFolder = false;
        LOG_START = false;
        SERIAL_MONITOR = false;
        RESTART = false;
        font = new Font("SansSerif", 0, 10);
        slika = new HCPImage("images/Floppy_Drive_Small.png");
        slikaComp = new HCPImage("images/ComputerSmall.png");
        slikaCash = new HCPImage("images/CashSmall.png");
    }

    public void displayError(Exception e) {
        this.lastError = e.getMessage();
        if (this.lastError.equals("ERROR_FISCAL_BILL_NOT_STARTED") && !PRINTER) {
            return;
        }
        if (this.lastError.contains("-")) {
            String[] parts = this.lastError.split("-");
            String errorPart1 = parts[0];
            String errorPart2 = parts[1];
            this.notification = new Notification("GRE\u0160KA!", errorPart2, "images/print.png");
            this.notification.show();
            if (!SHOW_ERROR_DIALOG) {
                JOptionPane.showMessageDialog(this, "<html><body><p style='width: 250px;'>" + errorPart2, "Greska: " + errorPart1, 0);
            }
        } else {
            this.notification = new Notification("GRE\u0160KA!", this.lastError, "images/Floppy_Drive_Small.png");
            this.notification.show();
            if (!SHOW_ERROR_DIALOG) {
                JOptionPane.showMessageDialog(this, "<html><body><p style='width: 250px'>" + this.lastError, "Greska:  ", 0);
            }
            LogPanel.println("ERROR show=true; time=" + new Date().toString() + "; message: " + e.getMessage());
            LogPanel.println();
        }
    }

    public void displayError(String e) {
        this.lastError = e;
        if (this.lastError.equals("ERROR_FISCAL_BILL_NOT_STARTED") && !PRINTER) {
            return;
        }
        this.notification = new Notification("ERROR!", e, "images/print.png");
        this.notification.show();
        LogPanel.println("ERROR show=true; time=" + new Date().toString() + "; message: " + e);
        LogPanel.println();
    }

    public static MainFrame getInstance() {
        if (instance == null) {
            instance = new MainFrame();
        }
        return instance;
    }

    private MainFrame() {
        this.setDefaultCloseOperation(3);
        mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBackground(HCPColors.getColorM2st());
        leftPanel = new JPanel();
        leftPanel.setLayout(new GridLayout(19, 1, 0, 2));
        leftPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        leftPanel.setBackground(HCPColors.getColorM2st());
        leftPanel.setPreferredSize(new Dimension(150, 530));
        leftPanel.setMinimumSize(new Dimension(150, 465));
        leftPanel.setIgnoreRepaint(true);
        this.hideAll = new JButton("<<");
        this.hideAll.setHorizontalAlignment(2);
        this.hideAll.setBackground(HCPColors.getColorM2st());
        this.hideAll.setForeground(HCPColors.getColorM3st());
        this.hideAll.setBorder(new MatteBorder(1, 1, 1, 1, HCPColors.getColorM2st()));
        this.hideAll.setFont(font);
        this.setFont(font);
        langChoose = new HCPComboBox();
        langChoose = new HCPComboBox();
        langChoose.addItem("SRPSKI");
        langChoose.addItem("\u0421\u0420\u041f\u0421\u041a\u0418");
        langChoose.addItem("ENGLISH");
        langChoose.setSelectedIndex(1);
        this.hideAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean visible = MainFrame.this.controlPane.button.isVisible();
                int i = 0;
                while (i < RightPanelListener.vec.size()) {
                    HCPArrowPopButton pom = ((RightPanel)RightPanelListener.vec.elementAt((int)i)).button;
                    pom.setVisible(!visible);
                    ++i;
                }
                if (!visible) {
                    leftPanel.setPreferredSize(new Dimension(150, 500));
                    MainFrame.this.hideAll.setText("<<");
                } else {
                    leftPanel.setPreferredSize(new Dimension(30, 500));
                    MainFrame.this.hideAll.setText(">>");
                }
            }
        });
        leftPanel.add(this.hideAll);
        mainPanel.add((Component)leftPanel, "West");
        this.cLayout = new CardLayout();
        rightPane = new JPanel(this.cLayout);
        mainPanel.add((Component)rightPane, "Center");
        this.setContentPane(mainPanel);
    }

    public final void init() {
        try {
            this.controlPane = new ControlPanel();
            this.filePanel = new FilePanel();
            this.advancedPanel = new AdvancedSettingsPanel();
            this.debugPanel = new DebugPanel();
            this.logPanel = new LogPanel();
            new AboutHcpPanel();
            leftPanel.add(new JComponent(){});
            leftPanel.add(new JComponent(){});
            new RightPanel(LanguageStrings.getInstance().getStringByName("SAVE_PANEL_BUTTON"), 'S', LanguageStrings.getInstance().getStringByName("SAVE_PANEL_BUTTON_TOOLTIP"));
            leftPanel.add(new JComponent(){});
            new RightPanel(LanguageStrings.getInstance().getStringByName("HIDE_PANEL_BUTTON"), 'M', LanguageStrings.getInstance().getStringByName("HIDE_PANEL_BUTTON_TOOLTIP"));
            new RightPanel(LanguageStrings.getInstance().getStringByName("EXIT_PANEL_BUTTON"), 'X', LanguageStrings.getInstance().getStringByName("EXIT_PANEL_BUTTON_TOOLTIP"));
            leftPanel.add(new JComponent(){});
            leftPanel.add(new JComponent(){});
            leftPanel.add(new JComponent(){});
            leftPanel.add(new JComponent(){});
            leftPanel.add(new HCPLabel(LanguageStrings.getInstance().getStringByName("CHOOSE_LANGUAGE_LABEL")));
            leftPanel.add(langChoose);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        HCPImage slika = new HCPImage("images/hcplogo.png");
        this.setIconImage(slika.getImage());
        this.setTitle("HCP d.o.o.  - ver. 5.95");
        int x = Settings.getInstance().getPosx();
        int y = Settings.getInstance().getPosy();
        this.setLocation(x, y);
        if (Settings.getInstance().isSerialMonitor()) {
            LogPanel.setComRdBtn();
        } else {
            LogPanel.setLogRdBtn();
        }
        if (Settings.getInstance().isLogStart()) {
            LogPanel.startLog();
        }
        if (Settings.getInstance().isBigAmount()) {
            AdvancedSettingsPanel.bigAmount.setSelected(true);
            BIG_AMOUNT = true;
        }
        if (Settings.getInstance().isErrorDialog()) {
            AdvancedSettingsPanel.showErrorDialog.setSelected(true);
            SHOW_ERROR_DIALOG = true;
        }
        langChoose.setSelectedItem(Settings.getInstance().getLanguage());
        this.setPreferredSize(new Dimension(640, 525));
        this.controlPane.button.doClick();
        this.pack();
        this.setExtendedState(this.getExtendedState() | Settings.getInstance().getState());
        instance.setVisible(true);
        this.saveSettings();
        langChoose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getInstance().setRestart(true);
                MainFrame.this.saveSettings();
                try {
                    MainFrame.applicationRestart();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        if (fIn) {
            ControlPanel.inPath.setBackground(Color.RED);
            this.displayError("Folder IN path not exists\nSet default path C:/HCP/TO_FP");
        }
        if (fOut) {
            ControlPanel.outPath.setBackground(Color.RED);
            this.displayError("Folder OUT path not exists\nSet default path C:/HCP/FROM_FP");
        }
        if (fFolder) {
            this.displayError("Folder LOG path not exists\nSet default path C:/HCP/log");
        }
    }

    public final void reset() {
        this.controlPane.reset();
        this.filePanel.reset();
        this.advancedPanel.reset();
        int x = Settings.getInstance().getPosx();
        int y = Settings.getInstance().getPosy();
        this.setLocation(x, y);
        this.setPreferredSize(new Dimension(640, 490));
    }

    public void appExit() {
        System.exit(0);
    }

    public void saveSettings() {
        new Thread(){

            @Override
            public void run() {
                Settings settings = Settings.getInstance();
                if ((instance.getExtendedState() & 6) <= 0) {
                    settings.setPosx(MainFrame.this.getX());
                    settings.setPosy(MainFrame.this.getY());
                }
                settings.setLanguage((String)langChoose.getSelectedItem());
                settings.setState(MainFrame.this.getExtendedState());
                File file = new File("properties", "settings.xml");
                file.mkdirs();
                if (file.exists()) {
                    file.delete();
                }
                try {
                    XmlExecuter.getInstance().write(settings, file.getPath());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "ERROR", e.getMessage(), 0);
                }
            }
        }.start();
    }

    public static synchronized void applicationRestart() throws Exception {
        try {
            Runtime.getRuntime().exec("java -jar ResidentialGateway.jar");
            Runtime.getRuntime().exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

