/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.MainFrame;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public final class HCPfileChooser {
    private int retVal;
    private JFileChooser fc;
    private Component comp;

    public HCPfileChooser() {
        this.comp = MainFrame.getInstance();
        this.fc = new JFileChooser(".");
        this.fc.setAcceptAllFileFilterUsed(true);
    }

    public HCPfileChooser(String newExtension) {
        this.comp = MainFrame.getInstance();
        this.fc = new JFileChooser(".");
        this.fc.addChoosableFileFilter(new NewFilter(newExtension));
        this.fc.setAcceptAllFileFilterUsed(false);
    }

    public HCPfileChooser(Component c) {
        this.comp = c;
        this.fc = new JFileChooser(".");
        this.fc.setAcceptAllFileFilterUsed(true);
    }

    public HCPfileChooser(String newExtension, Component c) {
        this.comp = c;
        this.fc = new JFileChooser(".");
        this.fc.addChoosableFileFilter(new NewFilter(newExtension));
        this.fc.setAcceptAllFileFilterUsed(false);
    }

    public final File openFile() {
        this.retVal = this.fc.showOpenDialog(this.comp);
        if (this.retVal == 0) {
            return this.fc.getSelectedFile();
        }
        return null;
    }

    public final File saveFile() {
        this.retVal = this.fc.showSaveDialog(this.comp);
        if (this.retVal == 0) {
            String pom = this.fc.getSelectedFile().getName();
            FileFilter ff = this.fc.getFileFilter();
            if (ff != this.fc.getAcceptAllFileFilter()) {
                String ext = ((NewFilter)ff).exten;
                if (pom.indexOf(String.valueOf('.') + ext) < 0 || pom.indexOf(String.valueOf('.') + ext) != pom.length() - (ext.length() + 1)) {
                    return new File(this.fc.getCurrentDirectory(), String.valueOf(pom) + '.' + ext);
                }
                return this.fc.getSelectedFile();
            }
            return this.fc.getSelectedFile();
        }
        return null;
    }

    public void addExtension(String newExtension) {
        this.fc.addChoosableFileFilter(new NewFilter(newExtension));
    }

    public void setAcceptAllFileFilterUsed(boolean value) {
        this.fc.setAcceptAllFileFilterUsed(value);
    }

    public void setCurrentDirectory(File dir) {
        this.fc.setCurrentDirectory(dir);
    }

    public void setSelectedFile(File file) {
        this.fc.setSelectedFile(file);
    }

    class NewFilter
    extends FileFilter {
        String exten;

        public NewFilter(String newExt) {
            this.exten = newExt;
        }

        @Override
        public final boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String s = f.getName();
            int i = s.lastIndexOf(46);
            return i > 0 && i < s.length() - 1 && s.substring(i + 1).toLowerCase().equalsIgnoreCase(this.exten);
        }

        @Override
        public final String getDescription() {
            return "Accepts *." + this.exten + " files only.";
        }
    }
}

