/*
 * Decompiled with CFR 0.152.
 */
package com.lipstikLF.delegate;

import com.lipstikLF.delegate.LipstikFileChooserUI;
import java.io.File;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;

class LipstikFileChooserUI$DetailsTableModel
extends AbstractTableModel
implements ListDataListener {
    String[] columnNames;
    JFileChooser chooser;
    ListModel listModel;
    private final LipstikFileChooserUI this$0;

    LipstikFileChooserUI$DetailsTableModel(LipstikFileChooserUI lipstikFileChooserUI, JFileChooser jFileChooser) {
        this.this$0 = lipstikFileChooserUI;
        this.columnNames = new String[]{LipstikFileChooserUI.S(this.this$0), LipstikFileChooserUI.A(this.this$0), LipstikFileChooserUI.E(this.this$0), LipstikFileChooserUI.G(this.this$0), LipstikFileChooserUI.H(this.this$0)};
        this.chooser = jFileChooser;
        this.listModel = lipstikFileChooserUI.getModel();
        this.listModel.addListDataListener(this);
    }

    public final int getRowCount() {
        return this.listModel.getSize();
    }

    public final int getColumnCount() {
        return 5;
    }

    public final String getColumnName(int n) {
        return this.columnNames[n];
    }

    public final Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return LipstikFileChooserUI.Z == null ? (LipstikFileChooserUI.Z = LipstikFileChooserUI.I("java.io.File")) : LipstikFileChooserUI.Z;
            }
            case 3: {
                return LipstikFileChooserUI.B == null ? (LipstikFileChooserUI.B = LipstikFileChooserUI.I("java.util.Date")) : LipstikFileChooserUI.B;
            }
        }
        return super.getColumnClass(n);
    }

    public final Object getValueAt(int n, int n2) {
        File file = (File)this.listModel.getElementAt(n);
        switch (n2) {
            case 0: {
                return file;
            }
            case 1: {
                if (!file.exists() || file.isDirectory()) {
                    return null;
                }
                long l = file.length() >> 10;
                if (l < 1024L) {
                    return (l == 0L ? 1L : l) + " KB";
                }
                if ((l >>= 10) < 1024L) {
                    return l + " MB";
                }
                return (l >>= 10) + " GB";
            }
            case 2: {
                if (!file.exists()) {
                    return null;
                }
                return this.chooser.getFileSystemView().getSystemTypeDescription(file);
            }
            case 4: {
                if (!file.exists() || this.chooser.getFileSystemView().isFileSystemRoot(file)) {
                    return null;
                }
                String string = "";
                if (!file.canWrite()) {
                    string = string + "R";
                }
                if (file.isHidden()) {
                    string = string + "H";
                }
                return string;
            }
            case 3: {
                if (!file.exists() || this.chooser.getFileSystemView().isFileSystemRoot(file)) {
                    return null;
                }
                long l = file.lastModified();
                return l == 0L ? null : new Date(l);
            }
        }
        return null;
    }

    public final void contentsChanged(ListDataEvent listDataEvent) {
        this.fireTableDataChanged();
    }

    public final void intervalAdded(ListDataEvent listDataEvent) {
        this.fireTableDataChanged();
    }

    public final void intervalRemoved(ListDataEvent listDataEvent) {
        this.fireTableDataChanged();
    }
}

