/*
 * Decompiled with CFR 0.152.
 */
package com.lipstikLF.delegate;

import com.lipstikLF.util.F;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.TreeCellRenderer;

public class LipstikDefaultTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private JTree tree;
    protected boolean selected;
    protected boolean hasFocus;
    private boolean drawsFocusBorderAroundIcon;
    private transient Icon I;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    private Color textSelectionColor;
    private Color textNonSelectionColor;
    private Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    private Color borderSelectionColor;

    public LipstikDefaultTreeCellRenderer() {
        this.setHorizontalAlignment(2);
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
        Object object = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.drawsFocusBorderAroundIcon = object != null && (Boolean)object != false;
    }

    public static final Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    public static final Icon getDefaultClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    public final Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    public final void setOpenIcon(Icon icon) {
        this.openIcon = icon;
    }

    public final Icon getOpenIcon() {
        return this.openIcon;
    }

    public final void setClosedIcon(Icon icon) {
        this.I = icon;
    }

    public final Icon getClosedIcon() {
        return this.I;
    }

    public final void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
    }

    public final Icon getLeafIcon() {
        return this.leafIcon;
    }

    public final void setTextSelectionColor(Color color) {
        this.textSelectionColor = color;
    }

    public final Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public final void setTextNonSelectionColor(Color color) {
        this.textNonSelectionColor = color;
    }

    public final Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public final void setBackgroundSelectionColor(Color color) {
        this.backgroundSelectionColor = color;
    }

    public final Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public final void setBackgroundNonSelectionColor(Color color) {
        this.backgroundNonSelectionColor = color;
    }

    public final Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public final void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public final Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public final void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    public final Font getFont() {
        Font font = super.getFont();
        if (font == null && this.tree != null) {
            font = this.tree.getFont();
        }
        return font;
    }

    public final void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public final Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
        this.tree = jTree;
        this.hasFocus = bl4;
        this.setText(string);
        if (bl) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        if (!jTree.isEnabled()) {
            this.setEnabled(false);
            if (bl3) {
                this.setDisabledIcon(this.getLeafIcon());
            } else if (bl2) {
                this.setDisabledIcon(this.getOpenIcon());
            } else {
                this.setDisabledIcon(this.getClosedIcon());
            }
        } else {
            this.setEnabled(true);
            if (bl3) {
                this.setIcon(this.getLeafIcon());
            } else if (bl2) {
                this.setIcon(this.getOpenIcon());
            } else {
                this.setIcon(this.getClosedIcon());
            }
        }
        this.setComponentOrientation(jTree.getComponentOrientation());
        this.selected = bl;
        return this;
    }

    public final void paint(Graphics graphics) {
        Color color;
        int n = -1;
        boolean bl = this.getComponentOrientation().isLeftToRight();
        if (this.selected && this.hasFocus) {
            color = this.getBackgroundSelectionColor();
        } else {
            color = this.getBackgroundNonSelectionColor();
            if (color == null) {
                color = this.getBackground();
            }
        }
        if (color != null) {
            n = this.I();
            graphics.setColor(color);
            if (bl) {
                graphics.fillRect(n, 0, this.getWidth() - n, this.getHeight());
            } else {
                graphics.fillRect(0, 0, this.getWidth() - n, this.getHeight());
            }
        }
        if (this.selected || this.hasFocus) {
            if (this.drawsFocusBorderAroundIcon) {
                n = 0;
            } else if (n == -1) {
                n = this.I();
            }
            if (bl) {
                F.I(graphics, n, 0, this.getWidth() - n, this.getHeight());
            } else {
                F.I(graphics, 0, 0, this.getWidth() - n, this.getHeight());
            }
        }
        super.paint(graphics);
    }

    private int I() {
        Icon icon = this.getIcon();
        if (icon != null && this.getText() != null) {
            return icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 2);
        }
        return 0;
    }

    public final Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension = new Dimension(dimension.width + 3, dimension.height);
        }
        return dimension;
    }

    public final void validate() {
    }

    public final void invalidate() {
    }

    public final void revalidate() {
    }

    public final void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public final void repaint(Rectangle rectangle) {
    }

    public final void repaint() {
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        if (string.equals("text")) {
            super.firePropertyChange(string, object, object2);
        }
    }

    public final void firePropertyChange(String string, byte by, byte by2) {
    }

    public final void firePropertyChange(String string, char c, char c2) {
    }

    public final void firePropertyChange(String string, short s, short s2) {
    }

    public final void firePropertyChange(String string, int n, int n2) {
    }

    public final void firePropertyChange(String string, long l, long l2) {
    }

    public final void firePropertyChange(String string, float f, float f2) {
    }

    public final void firePropertyChange(String string, double d, double d2) {
    }

    public final void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

