/*
 * Decompiled with CFR 0.152.
 */
package com.lipstikLF.util;

import com.lipstikLF.util.GradientInfo;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;

class Gradient {
    private GradientInfo info;
    private int perpendicularLength = 0;
    private WritableRaster raster;
    private HashMap childRasterCache;

    Gradient(GradientInfo i) {
        this.info = i;
    }

    Raster getRaster(int parallelPos, int perpendicularLength) {
        Integer key;
        Object o;
        if (this.raster == null || this.perpendicularLength < perpendicularLength) {
            this.createRaster(perpendicularLength);
        }
        if ((o = this.childRasterCache.get(key = new Integer(parallelPos))) != null) {
            return (Raster)o;
        }
        Raster r = this.info.isVertical ? this.raster.createChild(0, parallelPos, this.perpendicularLength, this.info.parallelLength - parallelPos, 0, 0, null) : this.raster.createChild(parallelPos, 0, this.info.parallelLength - parallelPos, this.perpendicularLength, 0, 0, null);
        this.childRasterCache.put(key, r);
        return r;
    }

    public void dispose() {
        this.raster = null;
    }

    private void createRaster(int perpendicularLength) {
        int db;
        int dg;
        int dr;
        int gradientWidth;
        int gradientHeight;
        if (this.info.isVertical) {
            gradientHeight = this.info.parallelLength;
            gradientWidth = this.perpendicularLength = perpendicularLength;
        } else {
            gradientWidth = this.info.parallelLength;
            gradientHeight = this.perpendicularLength = perpendicularLength;
        }
        int sr = this.info.startColor >> 16 & 0xFF;
        int sg = this.info.startColor >> 8 & 0xFF;
        int sb = this.info.startColor & 0xFF;
        if (this.info.endColor == 0) {
            sg -= 5;
            sb -= 5;
            if ((sr -= 5) < 0) {
                sr = 0;
            }
            if (sg < 0) {
                sg = 0;
            }
            if (sb < 0) {
                sb = 0;
            }
            dr = sr + 26 & 0xFF;
            dg = sg + 26 & 0xFF;
            db = sb + 26 & 0xFF;
        } else {
            dr = this.info.endColor >> 16 & 0xFF;
            dg = this.info.endColor >> 8 & 0xFF;
            db = this.info.endColor & 0xFF;
        }
        dr -= sr;
        dg -= sg;
        db -= sb;
        this.raster = this.info.model.createCompatibleWritableRaster(gradientWidth, gradientHeight);
        Object c = null;
        int pl = this.info.parallelLength;
        for (int i = 0; i < pl; ++i) {
            c = this.info.model.getDataElements(sr + i * dr / pl << 16 | sg + i * dg / pl << 8 | sb + i * db / pl, c);
            for (int j = 0; j < perpendicularLength; ++j) {
                if (this.info.isVertical) {
                    this.raster.setDataElements(j, i, c);
                    continue;
                }
                this.raster.setDataElements(i, j, c);
            }
        }
        this.childRasterCache = new HashMap();
    }
}

