/*
 * Decompiled with CFR 0.152.
 */
package com.lipstikLF.delegate;

import com.lipstikLF.LipstikLookAndFeel;
import com.lipstikLF.util.LipstikGradients;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public final class LipstikTabbedPaneUI
extends BasicTabbedPaneUI {
    private Color outerHighlight = LipstikLookAndFeel.getMyCurrentTheme().getControlHighlight();
    private Color roundShadow = LipstikLookAndFeel.getMyCurrentTheme().getControlDarkShadow();
    private Color outerShadow = LipstikLookAndFeel.getMyCurrentTheme().getBorderNormal();
    private Color innerShadow = LipstikLookAndFeel.getMyCurrentTheme().getControlShadow();

    public static ComponentUI createUI(JComponent c) {
        return new LipstikTabbedPaneUI();
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout layout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    public void paint(Graphics g, JComponent c) {
        int selectedIndex = this.tabPane.getSelectedIndex();
        int tabPlacement = this.tabPane.getTabPlacement();
        int tabCount = this.tabPane.getTabCount();
        this.ensureCurrentLayout();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle clipRect = g.getClipBounds();
        for (int i = this.runCount - 1; i >= 0; --i) {
            int end;
            int start = this.tabRuns[i];
            int next = this.tabRuns[i == this.runCount - 1 ? 0 : i + 1];
            for (int j = end = next != 0 ? next - 1 : tabCount - 1; j >= start; --j) {
                if (!this.rects[j].intersects(clipRect)) continue;
                this.paintTab(g, tabPlacement, this.rects, j, iconRect, textRect);
            }
        }
        if (selectedIndex >= 0 && this.rects[selectedIndex].intersects(clipRect)) {
            this.paintTab(g, tabPlacement, this.rects, selectedIndex, iconRect, textRect);
        }
        this.paintContentBorder(g, tabPlacement, selectedIndex);
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (isSelected) {
            g.setColor(LipstikLookAndFeel.getMyCurrentTheme().getControl());
            g.fillRect(x, y, w, h);
        } else {
            LipstikGradients.drawGradient(g, LipstikLookAndFeel.getMyCurrentTheme().getControl(), null, x, y, w - 1, h - 1, true);
        }
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        boolean leftToRight = this.tabPane.getComponentOrientation().isLeftToRight();
        g.setColor(this.outerShadow);
        if (tabPlacement != 1 || selectedIndex < 0) {
            g.drawLine(x, y, x + w - 1, y);
            g.setColor(this.outerHighlight);
            g.drawLine(x + 1, y + 1, x + w - 1, y + 1);
        } else {
            Rectangle selRect = this.rects[selectedIndex];
            if (!(selRect.x <= 0 || this.tabRuns[0] == selectedIndex && leftToRight)) {
                g.drawLine(x, y, selRect.x - 1, y);
                g.setColor(this.outerHighlight);
                g.drawLine(x, y + 1, selRect.x + 1, y + 1);
            } else {
                g.setColor(this.outerHighlight);
            }
            if (selRect.x + selRect.width < x + w) {
                g.drawLine(selRect.x + selRect.width - 1, y + 1, x + w - 1, y + 1);
                g.setColor(this.outerShadow);
                g.drawLine(selRect.x + selRect.width, y, x + w - 2, y);
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        boolean leftToRight = this.tabPane.getComponentOrientation().isLeftToRight();
        y += h - 1;
        g.setColor(this.outerShadow);
        if (tabPlacement != 3 || selectedIndex < 0) {
            g.drawLine(x, y, x + w - 1, y);
            g.setColor(this.innerShadow);
            g.drawLine(x + 1, y - 1, x + w - 1, y - 1);
        } else {
            Rectangle selRect = this.rects[selectedIndex];
            if (!(selRect.x <= 0 || this.tabRuns[0] == selectedIndex && leftToRight)) {
                g.drawLine(x, y, selRect.x - 1, y);
                g.setColor(this.innerShadow);
                g.drawLine(x + 1, y - 1, selRect.x + 1, y - 1);
            } else {
                g.setColor(this.innerShadow);
            }
            if (selRect.x + selRect.width < x + w) {
                g.drawLine(selRect.x + selRect.width - 1, y - 1, x + w - 2, y - 1);
                g.setColor(this.outerShadow);
                g.drawLine(selRect.x + selRect.width, y, x + w - 1, y);
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(this.outerShadow);
        if (tabPlacement != 2 || selectedIndex < 0) {
            g.drawLine(x, y, x, y + h - 2);
            g.setColor(this.outerHighlight);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 3);
        } else {
            Rectangle selRect = this.rects[selectedIndex];
            if (this.tabRuns[0] != selectedIndex) {
                g.drawLine(x, y, x, selRect.y - 1);
                g.setColor(this.outerHighlight);
                g.drawLine(x + 1, y + 1, x + 1, selRect.y);
            } else {
                g.setColor(this.outerHighlight);
            }
            if (selRect.y + selRect.height < y + h) {
                g.drawLine(x + 1, selRect.y + selRect.height, x + 1, y + h - 3);
                g.setColor(this.outerShadow);
                g.drawLine(x, selRect.y + selRect.height, x, y + h - 2);
            }
        }
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(this.outerShadow);
        x += w - 1;
        if (tabPlacement != 4 || selectedIndex < 0) {
            g.drawLine(x, y, x, y + h - 2);
            g.setColor(this.innerShadow);
            g.drawLine(x - 1, y + 1, x - 1, y + h - 3);
        } else {
            Rectangle selRect = this.rects[selectedIndex];
            if (this.tabRuns[0] != selectedIndex) {
                g.drawLine(x, y, x, selRect.y - 1);
                g.setColor(this.innerShadow);
                g.drawLine(x - 1, y + 1, x - 1, selRect.y);
            } else {
                g.setColor(this.innerShadow);
            }
            if (selRect.y + selRect.height < y + h) {
                g.drawLine(x - 1, selRect.y + selRect.height, x - 1, y + h - 3);
                g.setColor(this.outerShadow);
                g.drawLine(x, selRect.y + selRect.height, x, y + h - 2);
            }
        }
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int tabCount = this.tabPane.getTabCount();
        boolean leftToRight = this.tabPane.getComponentOrientation().isLeftToRight();
        boolean last = tabIndex == this.lastTabInRun(tabCount, this.runCount - 1);
        boolean first = tabIndex == this.tabRuns[this.runCount - 1];
        Color background = this.tabPane.getParent().getBackground();
        --w;
        if (x < 0) {
            x = 0;
        }
        g.setColor(this.outerShadow);
        switch (tabPlacement) {
            case 2: {
                g.translate(x, y);
                g.drawLine(0, 0, w, 0);
                g.drawLine(0, 1, 0, h - 1);
                g.drawLine(0, h, w, h);
                g.setColor(this.outerHighlight);
                g.drawLine(1, 1, w, 1);
                g.drawLine(1, 2, 1, h - 1);
                if (isSelected || this.tabRuns[this.runCount - 1] == tabIndex) {
                    g.setColor(this.roundShadow);
                    g.drawLine(1, 0, 1, 0);
                    g.drawLine(0, 1, 1, 1);
                    g.setColor(background);
                    g.drawLine(0, 0, 0, 0);
                }
                if (isSelected || tabIndex == this.lastTabInRun(tabCount, this.runCount - 1)) {
                    g.setColor(this.roundShadow);
                    g.drawLine(1, h - 1, 1, h);
                    g.drawLine(0, h - 1, 1, h - 1);
                    g.setColor(background);
                    g.drawLine(0, h, 0, h);
                }
                g.translate(-x, -y);
                break;
            }
            case 4: {
                g.translate(x, y);
                g.drawLine(0, 0, w, 0);
                g.drawLine(w, 1, w, h - 1);
                g.drawLine(0, h, w, h);
                g.setColor(this.outerHighlight);
                g.drawLine(0, 1, w - 1, 1);
                if (isSelected || this.tabRuns[this.runCount - 1] == tabIndex) {
                    g.setColor(this.roundShadow);
                    g.drawLine(w - 1, 0, w - 1, 0);
                    g.drawLine(w - 1, 1, w, 1);
                    g.setColor(background);
                    g.drawLine(w, 0, w, 0);
                }
                if (isSelected || tabIndex == this.lastTabInRun(tabCount, this.runCount - 1)) {
                    g.setColor(this.roundShadow);
                    g.drawLine(w - 1, h - 1, w - 1, h);
                    g.drawLine(w - 1, h - 1, w, h - 1);
                    g.setColor(background);
                    g.drawLine(w, h, w, h);
                }
                g.translate(-x, -y);
                break;
            }
            case 3: {
                g.translate(x, y);
                g.drawLine(0, h, w, h);
                g.drawLine(w, 0, w, h);
                if (isSelected || this.shouldDrawLeftEdge(tabIndex, leftToRight)) {
                    g.drawLine(0, 0, 0, h - 1);
                    if (isSelected) {
                        g.setColor(this.outerHighlight);
                        g.drawLine(1, 0, 1, h - 2);
                    }
                }
                g.setColor(this.innerShadow);
                g.drawLine(1, h - 1, w - 1, h - 1);
                if (isSelected || first && leftToRight || last && !leftToRight) {
                    g.setColor(this.roundShadow);
                    g.drawLine(1, h, 1, h);
                    g.drawLine(0, h - 1, 1, h - 1);
                    g.setColor(background);
                    g.drawLine(0, h, 0, h);
                }
                if (isSelected || last && leftToRight || first && !leftToRight) {
                    g.setColor(this.roundShadow);
                    g.drawLine(w - 1, h, w - 1, h);
                    g.drawLine(w - 1, h - 1, w, h - 1);
                    g.setColor(background);
                    g.drawLine(w, h, w, h);
                }
                g.translate(-x, -y);
                break;
            }
            default: {
                g.translate(x, y);
                g.drawLine(0, 0, w, 0);
                g.drawLine(w, 0, w, h - 1);
                if (isSelected || this.shouldDrawLeftEdge(tabIndex, leftToRight)) {
                    g.drawLine(0, 0, 0, h - 1);
                    g.setColor(this.outerHighlight);
                    g.drawLine(1, 2, 1, h - 1);
                } else {
                    g.setColor(this.outerHighlight);
                }
                g.drawLine(1, 1, w - 1, 1);
                if (isSelected || leftToRight && first || !leftToRight && last) {
                    g.setColor(this.roundShadow);
                    g.drawLine(1, 0, 1, 0);
                    g.drawLine(0, 1, 1, 1);
                    g.setColor(background);
                    g.drawLine(0, 0, 0, 0);
                }
                if (isSelected || leftToRight && last || !leftToRight && first) {
                    g.setColor(this.roundShadow);
                    g.drawLine(w - 1, 0, w - 1, 0);
                    g.drawLine(w - 1, 1, w, 1);
                    g.setColor(background);
                    g.drawLine(w, 0, w, 0);
                }
                g.translate(-x, -y);
            }
        }
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        Rectangle calcRectangle = new Rectangle(tabRect);
        if (isSelected) {
            Insets calcInsets = this.getSelectedTabPadInsets(tabPlacement);
            calcRectangle.x += calcInsets.left;
            calcRectangle.y += calcInsets.top;
            calcRectangle.width -= calcInsets.left + calcInsets.right;
            calcRectangle.height -= calcInsets.bottom + calcInsets.top;
        }
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        if (!(tabPlacement != 4 && tabPlacement != 2 || icon == null || title == null || title.equals(""))) {
            SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 2, 0, 11, calcRectangle, iconRect, textRect, this.textIconGap);
            xNudge += 4;
        } else {
            SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 0, 0, 11, calcRectangle, iconRect, textRect, this.textIconGap);
            iconRect.y += calcRectangle.height % 2;
        }
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    protected boolean shouldRotateTabRuns(int tabPlacement) {
        return true;
    }

    private boolean shouldDrawLeftEdge(int tabIndex, boolean leftToRight) {
        int tabCount = this.tabPane.getTabCount();
        for (int i = 0; i < this.runCount; ++i) {
            if (!(leftToRight ? tabIndex == this.tabRuns[i] : tabIndex == this.lastTabInRun(tabCount, i))) continue;
            return true;
        }
        return false;
    }
}

