/*
 * Decompiled with CFR 0.152.
 */
package com.lipstikLF.delegate;

import com.lipstikLF.delegate.LipstikToggleButtonUI;
import com.lipstikLF.util.LipstikBorderFactory;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;

public class LipstikRadioButtonUI
extends LipstikToggleButtonUI {
    private static Rectangle prefViewRect = new Rectangle();
    private static Rectangle prefIconRect = new Rectangle();
    private static Rectangle prefTextRect = new Rectangle();
    private static Insets prefInsets = new Insets(2, 2, 1, 1);
    private static Dimension size = new Dimension();
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    protected Icon selectedEnabledIcon;
    protected Icon selectedDisabledIcon;
    protected Icon unselectedEnabledIcon;
    protected Icon unselectedDisabledIcon;
    protected Icon defaultIcon;
    private boolean defaults_initialized = false;
    private static final String propertyPrefix = "RadioButton.";
    private static final LipstikRadioButtonUI _radioButtonUI = new LipstikRadioButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return _radioButtonUI;
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (!this.defaults_initialized) {
            this.defaultIcon = UIManager.getIcon(this.getPropertyPrefix() + "icon");
            this.selectedEnabledIcon = UIManager.getIcon(this.getPropertyPrefix() + "selectedEnabledIcon");
            this.selectedDisabledIcon = UIManager.getIcon(this.getPropertyPrefix() + "selectedDisabledIcon");
            this.unselectedEnabledIcon = UIManager.getIcon(this.getPropertyPrefix() + "unselectedEnabledIcon");
            this.unselectedDisabledIcon = UIManager.getIcon(this.getPropertyPrefix() + "unselectedDisabledIcon");
            this.defaults_initialized = true;
        }
    }

    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.defaults_initialized = false;
    }

    public synchronized void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        size = b.getSize(size);
        LipstikRadioButtonUI.viewRect.y = 0;
        LipstikRadioButtonUI.viewRect.x = 0;
        LipstikRadioButtonUI.viewRect.width = LipstikRadioButtonUI.size.width;
        LipstikRadioButtonUI.viewRect.height = LipstikRadioButtonUI.size.height;
        LipstikRadioButtonUI.iconRect.height = 0;
        LipstikRadioButtonUI.iconRect.width = 0;
        LipstikRadioButtonUI.iconRect.y = 0;
        LipstikRadioButtonUI.iconRect.x = 0;
        LipstikRadioButtonUI.textRect.height = 0;
        LipstikRadioButtonUI.textRect.width = 0;
        LipstikRadioButtonUI.textRect.y = 0;
        LipstikRadioButtonUI.textRect.x = 0;
        Icon altIcon = b.getIcon();
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), altIcon != null ? altIcon : this.defaultIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        if (c.getComponentOrientation().isLeftToRight()) {
            LipstikRadioButtonUI.textRect.x += LipstikRadioButtonUI.prefInsets.left;
            LipstikRadioButtonUI.iconRect.x += LipstikRadioButtonUI.prefInsets.left;
        } else {
            LipstikRadioButtonUI.textRect.x -= LipstikRadioButtonUI.prefInsets.left;
            LipstikRadioButtonUI.iconRect.x -= LipstikRadioButtonUI.prefInsets.left;
        }
        if (c.isOpaque()) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, LipstikRadioButtonUI.size.width, LipstikRadioButtonUI.size.height);
        }
        if (b.getIcon() != null) {
            altIcon = b.getIcon();
            if (!model.isEnabled()) {
                altIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                altIcon = b.getPressedIcon();
                if (altIcon == null) {
                    altIcon = b.getSelectedIcon();
                }
            } else if (model.isSelected()) {
                if (b.isRolloverEnabled() && model.isRollover()) {
                    altIcon = b.getRolloverSelectedIcon();
                    if (altIcon == null) {
                        altIcon = b.getSelectedIcon();
                    }
                } else {
                    altIcon = b.getSelectedIcon();
                }
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                altIcon = b.getRolloverIcon();
            }
            if (altIcon == null) {
                altIcon = b.getIcon();
            }
            altIcon.paintIcon(c, g, LipstikRadioButtonUI.iconRect.x, LipstikRadioButtonUI.iconRect.y);
        } else {
            Icon icon = model.isEnabled() ? (model.isSelected() ? this.selectedEnabledIcon : this.unselectedEnabledIcon) : (model.isSelected() ? this.selectedDisabledIcon : this.unselectedDisabledIcon);
            icon.paintIcon(c, g, LipstikRadioButtonUI.iconRect.x, LipstikRadioButtonUI.iconRect.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
                if (b.hasFocus() && b.isFocusPainted() && LipstikRadioButtonUI.textRect.width > 0 && LipstikRadioButtonUI.textRect.height > 0) {
                    LipstikBorderFactory.paintFocusBorder(g, 0, 0, LipstikRadioButtonUI.size.width, LipstikRadioButtonUI.size.height);
                }
            }
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        if (c.getComponentCount() > 0) {
            return null;
        }
        AbstractButton b = (AbstractButton)c;
        String text = b.getText();
        Icon buttonIcon = b.getIcon();
        if (buttonIcon == null) {
            buttonIcon = this.defaultIcon;
        }
        FontMetrics fm = b.getFontMetrics(b.getFont());
        LipstikRadioButtonUI.prefViewRect.y = 0;
        LipstikRadioButtonUI.prefViewRect.x = 0;
        LipstikRadioButtonUI.prefViewRect.width = Short.MAX_VALUE;
        LipstikRadioButtonUI.prefViewRect.height = Short.MAX_VALUE;
        LipstikRadioButtonUI.prefIconRect.height = 0;
        LipstikRadioButtonUI.prefIconRect.width = 0;
        LipstikRadioButtonUI.prefIconRect.y = 0;
        LipstikRadioButtonUI.prefIconRect.x = 0;
        LipstikRadioButtonUI.prefTextRect.height = 0;
        LipstikRadioButtonUI.prefTextRect.width = 0;
        LipstikRadioButtonUI.prefTextRect.y = 0;
        LipstikRadioButtonUI.prefTextRect.x = 0;
        SwingUtilities.layoutCompoundLabel(c, fm, text, buttonIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), prefViewRect, prefIconRect, prefTextRect, text == null ? 0 : b.getIconTextGap());
        LipstikRadioButtonUI.prefTextRect.width += 2;
        int x1 = Math.min(LipstikRadioButtonUI.prefIconRect.x, LipstikRadioButtonUI.prefTextRect.x);
        int x2 = Math.max(LipstikRadioButtonUI.prefIconRect.x + LipstikRadioButtonUI.prefIconRect.width, LipstikRadioButtonUI.prefTextRect.x + LipstikRadioButtonUI.prefTextRect.width);
        int y1 = Math.min(LipstikRadioButtonUI.prefIconRect.y, LipstikRadioButtonUI.prefTextRect.y);
        int y2 = Math.max(LipstikRadioButtonUI.prefIconRect.y + LipstikRadioButtonUI.prefIconRect.height, LipstikRadioButtonUI.prefTextRect.y + LipstikRadioButtonUI.prefTextRect.height);
        int width = x2 - x1;
        int height = y2 - y1;
        return new Dimension(width += LipstikRadioButtonUI.prefInsets.left + LipstikRadioButtonUI.prefInsets.right, height += LipstikRadioButtonUI.prefInsets.top + LipstikRadioButtonUI.prefInsets.bottom);
    }
}

