/*
 * Decompiled with CFR 0.152.
 */
package com.lipstikLF.delegate;

import com.lipstikLF.LipstikLookAndFeel;
import com.lipstikLF.delegate.ComboBoxButtonIcon;
import com.lipstikLF.theme.LipstikColorTheme;
import com.lipstikLF.util.LipstikBorderFactory;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class LipstikComboBoxButton
extends JButton {
    private final JList listBox;
    private final CellRendererPane rendererPane;
    private static final ComboBoxButtonIcon comboIcon = new ComboBoxButtonIcon();
    private JComboBox comboBox;
    protected boolean iconOnly = false;

    LipstikComboBoxButton(JComboBox comboBox, boolean iconOnly, CellRendererPane rendererPane, JList listBox) {
        super("");
        this.setModel(new DefaultButtonModel(){

            public void setArmed(boolean armed) {
                super.setArmed(this.isPressed() || armed);
            }
        });
        this.comboBox = comboBox;
        this.iconOnly = iconOnly;
        this.rendererPane = rendererPane;
        this.listBox = listBox;
        this.setEnabled(comboBox.isEnabled());
        this.setFocusable(false);
        this.setRequestFocusEnabled(comboBox.isEnabled());
        if (iconOnly) {
            this.setBorder(UIManager.getBorder("ComboBox.arrowButtonBorder"));
        }
        this.setMargin(new Insets(2, 4, 0, 3));
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public void setComboBox(JComboBox cb) {
        this.comboBox = cb;
    }

    public Icon getComboIcon() {
        return comboIcon;
    }

    public boolean isIconOnly() {
        return this.iconOnly;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void setIconOnly(boolean b) {
        this.iconOnly = b;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        boolean leftToRight = this.comboBox.getComponentOrientation().isLeftToRight();
        Insets insets = this.getInsets();
        int width = this.getWidth() - (insets.left + insets.right);
        int height = this.getHeight() - (insets.top + insets.bottom);
        if (height <= 0 || width <= 0) {
            return;
        }
        int left = insets.left;
        int top = insets.top;
        int iconWidth = 0;
        int hoffs = 0;
        int xoffs = 0;
        if (comboIcon != null) {
            int iconLeft;
            iconWidth = comboIcon.getIconWidth();
            int iconHeight = comboIcon.getIconHeight();
            int iconTop = this.getHeight() - iconHeight >> 1;
            if (this.iconOnly) {
                iconLeft = width - iconWidth >> 1;
                if (!leftToRight) {
                    ++iconLeft;
                }
            } else if (leftToRight) {
                iconLeft = left + width - iconWidth;
                hoffs = iconLeft - 4;
                xoffs = left;
            } else {
                iconLeft = left;
                hoffs = iconLeft + iconWidth + 2;
                xoffs = hoffs + 5;
            }
            comboIcon.paintIcon(this, g, iconLeft, iconTop);
        }
        if (!this.iconOnly && this.comboBox != null) {
            LipstikColorTheme theme = LipstikLookAndFeel.getMyCurrentTheme();
            g.setColor(theme.getControlDarkShadow());
            g.drawLine(hoffs, 0, hoffs, height + 1);
            ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
            Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, this.getModel().isPressed(), false);
            c.setFont(this.rendererPane.getFont());
            if (this.model.isArmed() && this.model.isPressed()) {
                if (this.isOpaque()) {
                    c.setBackground(UIManager.getColor("Button.select"));
                }
                c.setForeground(this.comboBox.getForeground());
            } else if (!this.comboBox.isEnabled()) {
                if (this.isOpaque()) {
                    c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                }
                c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            } else {
                c.setForeground(this.comboBox.getForeground());
                c.setBackground(this.comboBox.getBackground());
            }
            int cWidth = width - (insets.right + iconWidth);
            boolean shouldValidate = c instanceof JPanel;
            if (c instanceof JComponent) {
                JComponent component = (JComponent)c;
                component.setOpaque(false);
                this.rendererPane.paintComponent(g, c, this, xoffs, top + 1, cWidth, height - 3, shouldValidate);
                component.setOpaque(true);
            } else {
                this.rendererPane.paintComponent(g, c, this, xoffs, top + 1, cWidth, height - 3, shouldValidate);
            }
        }
        if (this.comboBox != null && this.comboBox.hasFocus()) {
            LipstikBorderFactory.paintFocusBorder(g, 2, 2, this.getWidth() - 4, this.getHeight() - 4);
        }
    }
}

