/*
 * Decompiled with CFR 0.152.
 */
package util.comPort;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gui.GlavniFrame;
import gui.ProcessDialog;
import gui.ProcessingDialog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import objects.lang.LanguageStrings;
import serverRemote.TerminalSocket;
import util.SysUtil;
import util.comPort.SerialPortException;

public class PortSerial {
    private static PortSerial instance;
    public static boolean useServer;
    private static InputStream inStream;
    private static OutputStream outStream;
    protected static SerialPort mPort;
    public static int SOX;
    public static int STX;
    public static final int ACK = 6;
    public static final int NACK = 21;
    private static SerialPortException excTO;
    private static SerialPortException excClosed;
    public static SerialPortException excCRC;
    private static byte[] buffer;
    public static String sPort;
    public static int speed;
    private static long TIME;
    public ThreadWatcher theWatcher = new ThreadWatcher();
    public static final Object syncObj;
    private int SEQ = 34;

    static {
        useServer = false;
        SOX = 1;
        STX = 2;
        excCRC = new SerialPortException("Error CRC");
        buffer = new byte[1024];
        sPort = null;
        speed = 115200;
        TIME = System.currentTimeMillis();
        syncObj = new Object();
    }

    private PortSerial() {
        if (GlavniFrame.PRINTER) {
            SOX = 3;
        }
    }

    public static final PortSerial getInstance() {
        if (instance == null) {
            instance = new PortSerial();
            excTO = new SerialPortException(LanguageStrings.getInstance().getStringByName("SERIAL_PORT_ERROR_TIME_OUT"));
            excClosed = new SerialPortException(LanguageStrings.getInstance().getStringByName("SERIAL_PORT_ERROR_OPEN"));
        }
        return instance;
    }

    public void sendFrameGaleb(String s) throws IOException, SerialPortException {
        int b;
        this.open(19200);
        int len = s.length();
        int crc = len + 3 + 32;
        outStream.write(1);
        TIME = System.currentTimeMillis();
        outStream.write(crc);
        crc += this.SEQ;
        outStream.write(this.SEQ++);
        if (this.SEQ > 127) {
            this.SEQ = 22;
        }
        TIME = System.currentTimeMillis();
        int i = 0;
        while (i < len) {
            b = s.charAt(i) & 0xFF;
            outStream.write(b);
            crc += b;
            ++i;
        }
        outStream.write(5);
        crc += 5;
        TIME = System.currentTimeMillis();
        i = 0;
        while (i < 4) {
            outStream.write(crc >> (3 - i) * 4 & 0xF | 0x30);
            ++i;
        }
        outStream.write(3);
        TIME = System.currentTimeMillis();
        this.readByte(1000);
        TIME = System.currentTimeMillis();
        long time = System.currentTimeMillis();
        do {
            b = this.readByte(100);
            TIME = System.currentTimeMillis();
        } while (b != 3 && System.currentTimeMillis() - time <= 2000L);
    }

    private int readByte(int tt) throws IOException {
        TIME = System.currentTimeMillis();
        long time = System.currentTimeMillis();
        do {
            int b;
            if ((b = inStream.read()) == -1) continue;
            return b;
        } while (System.currentTimeMillis() - time <= (long)tt);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = syncObj;
        synchronized (object) {
            try {
                if (mPort != null) {
                    mPort.close();
                    mPort = null;
                }
            }
            catch (Exception e) {
                System.out.println("Unable to close port - " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(int speed) throws SerialPortException {
        Object object = syncObj;
        synchronized (object) {
            if (mPort != null) {
                this.close();
            }
            try {
                CommPortIdentifier commportidentifier = CommPortIdentifier.getPortIdentifier((String)sPort);
                mPort = (SerialPort)commportidentifier.open("PPP3", 100);
                mPort.setDTR(true);
                mPort.setRTS(false);
                mPort.disableReceiveFraming();
                mPort.disableReceiveThreshold();
                inStream = mPort.getInputStream();
                outStream = mPort.getOutputStream();
                mPort.setSerialPortParams(speed, 8, 1, 0);
                mPort.enableReceiveTimeout(10);
            }
            catch (Exception e) {
                throw excClosed;
            }
            TIME = System.currentTimeMillis();
            PortSerial.speed = speed;
            SysUtil.delay(50);
        }
    }

    public void sendFrame(Command command) throws SerialPortException {
        if (useServer) {
            try {
                TerminalSocket.current.sendFrame(command);
            }
            catch (Exception e) {
                throw new SerialPortException("Socket exception: " + e.getMessage());
            }
            return;
        }
        Object object = syncObj;
        synchronized (object) {
            int check;
            if (outStream == null) {
                this.test(speed);
            }
            int pos = 0;
            int t = command.getPos() + 1;
            TIME = System.currentTimeMillis();
            if (command.bigCommand) {
                PortSerial.buffer[pos++] = (byte)SOX;
                PortSerial.buffer[pos++] = (byte)t;
                PortSerial.buffer[pos++] = (byte)(t >> 8);
                check = t & 0xFF;
                check += t >> 8 & 0xFF;
            } else {
                check = t;
                PortSerial.buffer[pos++] = (byte)STX;
                PortSerial.buffer[pos++] = (byte)check;
            }
            PortSerial.buffer[pos++] = (byte)command.getCmd();
            check += command.getCmd() & 0xFF;
            int i = 0;
            while (i < command.getPos()) {
                t = command.getArray()[i] & 0xFF;
                PortSerial.buffer[pos++] = (byte)t;
                check += t;
                ++i;
            }
            PortSerial.buffer[pos++] = (byte)(check >> 8);
            PortSerial.buffer[pos++] = (byte)check;
            int k = 0;
            while (k < 3) {
                try {
                    outStream.write(buffer, 0, pos);
                    outStream.flush();
                    t = this.readByte(3000);
                    if (t != 21) {
                        if (t == 6) {
                            return;
                        }
                        if (t == -1) {
                            throw excTO;
                        }
                    }
                }
                catch (Exception e) {
                    throw new SerialPortException(e.getMessage());
                }
                ++k;
            }
            throw excCRC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test(int speed) throws SerialPortException {
        Object object = syncObj;
        synchronized (object) {
            this.open(speed);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Command cmd = Command.testInstance;
            cmd.reset();
            cmd.setCmd(101);
            this.sendFrame(cmd);
        }
    }

    public int readByte(long waitTime) {
        Object object = syncObj;
        synchronized (object) {
            int t;
            TIME = System.currentTimeMillis();
            long time = System.currentTimeMillis();
            while (true) {
                try {
                    t = inStream.read();
                }
                catch (IOException e1) {
                    return -1;
                }
                break;
            }
            {
                block9: {
                    if (t != -1) {
                        time = System.currentTimeMillis() - time;
                        TIME = System.currentTimeMillis();
                        return t;
                    }
                    if (System.currentTimeMillis() - time <= waitTime) break block9;
                    TIME = System.currentTimeMillis();
                    return -1;
                }
                Thread.yield();
                continue;
            }
        }
    }

    public Command receiveFrame() throws SerialPortException {
        if (useServer) {
            try {
                return TerminalSocket.current.receiveFrame();
            }
            catch (Exception e) {
                throw new SerialPortException("Socket exception: " + e.getMessage());
            }
        }
        Object object = syncObj;
        synchronized (object) {
            int errors = 0;
            int i = 0;
            if (i < 3) {
                try {
                    int mm;
                    Command command;
                    int type;
                    block26: {
                        do {
                            type = this.readByte(5000);
                            while (type == 7) {
                                type = this.readByte(1000);
                                try {
                                    CommandsErrors.instanceMain.setError(type);
                                }
                                catch (CommandsErrors e) {
                                    ProcessingDialog.getInstance().setTitle(e.getMessage());
                                    ProcessDialog.getInstance().setTitle(e.getMessage());
                                }
                                type = this.readByte(1000);
                            }
                            TIME = System.currentTimeMillis();
                            if (type == -1) {
                                throw excTO;
                            }
                            if (type == STX || type == SOX) break block26;
                        } while (type == 8 || type == 9 || ++errors <= 10);
                        throw excTO;
                    }
                    int t = this.readByte(200);
                    if (t == -1) {
                        throw excTO;
                    }
                    int check = t;
                    int len = t;
                    if (type == SOX) {
                        command = Command.bigReturnInstance;
                        int k = this.readByte(200);
                        if (k == -1) {
                            throw excTO;
                        }
                        len |= k << 8;
                        check += k;
                    } else {
                        command = Command.instance;
                    }
                    command.reset();
                    command.setLength(len);
                    if (len < 1) {
                        throw excTO;
                    }
                    long time = System.currentTimeMillis();
                    int pos = 0;
                    while (true) {
                        if ((t = inStream.read(buffer, pos, 1024 - pos)) <= 0) {
                            if (System.currentTimeMillis() - time > 3000L) {
                                TIME = System.currentTimeMillis();
                                throw excTO;
                            }
                            Thread.yield();
                            continue;
                        }
                        if ((pos += t) >= len + 2) break;
                    }
                    command.setCmd(buffer[0] & 0xFF);
                    int j = 0;
                    while (j < len) {
                        mm = buffer[j] & 0xFF;
                        check += mm;
                        if (j != 0) {
                            command.addByte(mm);
                        }
                        ++j;
                    }
                    if ((mm = buffer[len++] & 0xFF) != (check >>> 8 & 0xFF)) {
                        throw excCRC;
                    }
                    if ((mm = buffer[len++] & 0xFF) != (check & 0xFF)) {
                        throw excCRC;
                    }
                    outStream.write(6);
                    return command;
                }
                catch (IOException e) {
                    throw new SerialPortException(e.getMessage());
                }
            }
            throw excCRC;
        }
    }

    public void receiveFrame(Command command) throws SerialPortException {
        if (useServer) {
            try {
                TerminalSocket.current.receiveFrame(command);
            }
            catch (Exception e) {
                throw new SerialPortException("Socket exception: " + e.getMessage());
            }
            return;
        }
        Object object = syncObj;
        synchronized (object) {
            command.reset();
            int errors = 0;
            int i = 0;
            if (i < 3) {
                try {
                    int mm;
                    int type;
                    block25: {
                        do {
                            type = this.readByte(5000);
                            while (type == 7) {
                                type = this.readByte(1000);
                                try {
                                    CommandsErrors.instanceMain.setError(type);
                                }
                                catch (CommandsErrors e) {
                                    ProcessingDialog.getInstance().setTitle(e.getMessage());
                                    ProcessDialog.getInstance().setTitle(e.getMessage());
                                }
                                type = this.readByte(1000);
                            }
                            if (type == -1) {
                                throw excTO;
                            }
                            if (type == STX) break block25;
                        } while (type == 8 || type == 9 || ++errors <= 10);
                        throw excTO;
                    }
                    int t = this.readByte(200);
                    if (t == -1) {
                        throw excTO;
                    }
                    if (type == SOX) {
                        int k = this.readByte(200);
                        if (k == -1) {
                            throw excTO;
                        }
                        t |= k << 8;
                    }
                    command.setLength(t);
                    if (t < 1) {
                        throw excTO;
                    }
                    int check = t;
                    long time = System.currentTimeMillis();
                    int pos = 0;
                    while (true) {
                        if ((t = inStream.read(buffer, pos, 1024 - pos)) <= 0) {
                            if (System.currentTimeMillis() - time > 3000L) {
                                TIME = System.currentTimeMillis();
                                throw excTO;
                            }
                            Thread.yield();
                            continue;
                        }
                        if ((pos += t) >= check + 2) break;
                    }
                    TIME = System.currentTimeMillis();
                    command.setCmd(buffer[0] & 0xFF);
                    t = check;
                    int j = 0;
                    while (j < t) {
                        mm = buffer[j] & 0xFF;
                        check += mm;
                        if (j != 0) {
                            command.addByte(mm);
                        }
                        ++j;
                    }
                    if ((mm = buffer[t++] & 0xFF) != check >>> 8) {
                        throw excCRC;
                    }
                    if ((mm = buffer[t++] & 0xFF) != (check & 0xFF)) {
                        throw excCRC;
                    }
                    outStream.write(6);
                    return;
                }
                catch (IOException e) {
                    throw new SerialPortException(e.getMessage());
                }
            }
            throw excCRC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStatus() {
        Object object = syncObj;
        synchronized (object) {
            if (mPort != null && System.currentTimeMillis() - TIME > 3000L) {
                this.close();
                if (!useServer) {
                    ProcessDialog.getInstance().setVisible(false);
                }
            }
        }
    }

    class ThreadWatcher
    extends Thread {
        private ThreadWatcher() {
            this.start();
        }

        public void run() {
            while (true) {
                PortSerial.this.checkStatus();
                try {
                    ThreadWatcher.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

