/*
 * Decompiled with CFR 0.152.
 */
package util.comPort;

import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gui.ProcessDialog;
import java.io.InputStream;
import java.io.OutputStream;
import util.SysUtil;
import util.comPort.PortSerial;
import util.comPort.SerialPortException;

public class BarcodePort {
    private static BarcodePort instance;
    private static InputStream inStream;
    private static OutputStream outStream;
    protected static SerialPort mPort;
    private static byte[] buffer;
    public static String barcodePort;
    public static int barcodePortSpeed;
    private static long TIME;
    public ThreadWatcher theWatcher = new ThreadWatcher();
    private static final Object syncObj;

    static {
        buffer = new byte[1024];
        barcodePort = null;
        barcodePortSpeed = 9600;
        TIME = System.currentTimeMillis();
        syncObj = PortSerial.syncObj;
        instance = new BarcodePort();
    }

    private BarcodePort() {
    }

    public static final BarcodePort getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = syncObj;
        synchronized (object) {
            try {
                if (inStream != null) {
                    inStream.close();
                    inStream = null;
                }
                if (outStream != null) {
                    outStream.close();
                    outStream = null;
                }
                if (mPort != null) {
                    mPort.setDTR(false);
                    mPort.close();
                    mPort = null;
                }
            }
            catch (Exception e) {
                System.out.println("PortSerial.close() - " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws SerialPortException {
        Object object = syncObj;
        synchronized (object) {
            if (mPort != null) {
                this.close();
            }
            try {
                CommPortIdentifier commportidentifier = CommPortIdentifier.getPortIdentifier((String)barcodePort);
                mPort = (SerialPort)commportidentifier.open("PPP3", 100);
                mPort.setDTR(true);
                mPort.disableReceiveFraming();
                mPort.disableReceiveThreshold();
                inStream = mPort.getInputStream();
                outStream = mPort.getOutputStream();
                mPort.setSerialPortParams(barcodePortSpeed, 8, 1, 0);
                mPort.enableReceiveTimeout(10);
            }
            catch (Exception e) {
                throw new SerialPortException(String.valueOf(e.getClass().toString()) + " : " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBarcode(long barcode) throws Exception {
        Object object = syncObj;
        synchronized (object) {
            if (outStream == null) {
                this.test();
            }
            String str = String.valueOf(barcode);
            int i = 0;
            while (i < str.length()) {
                BarcodePort.buffer[i] = (byte)str.charAt(i);
                ++i;
            }
            SysUtil.delay(100);
            i = 0;
            while (i < str.length()) {
                outStream.write(buffer[i]);
                ++i;
            }
            outStream.write(13);
            outStream.flush();
            SysUtil.delay(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws SerialPortException {
        Object object = syncObj;
        synchronized (object) {
            this.open();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStatus() {
        Object object = syncObj;
        synchronized (object) {
            if (mPort != null && System.currentTimeMillis() - TIME > 2000L) {
                this.close();
                ProcessDialog.getInstance().setVisible(false);
            }
        }
    }

    class ThreadWatcher
    extends Thread {
        private ThreadWatcher() {
            this.start();
        }

        public void run() {
            while (true) {
                BarcodePort.this.checkStatus();
                SysUtil.delay(10000);
            }
        }
    }
}

