/*
 * Decompiled with CFR 0.152.
 */
package util;

public class SHA2 {
    private static final SHA2 instance = new SHA2();
    static final byte[] padding = new byte[136];
    private byte[] abyte0;
    final byte[] oneByte;
    final int digestLength;
    final int blockSize;
    final byte[] buffer;
    int bufOfs;
    long bytesProcessed;
    private static final int[] ROUND_CONSTS;
    private final int[] W;
    private final int[] state = new int[8];
    private final byte[] bits;
    private final int[] intBits;

    static {
        SHA2.padding[0] = -128;
        ROUND_CONSTS = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    }

    public static final SHA2 getInstance() {
        return instance;
    }

    public SHA2() {
        this.W = new int[64];
        this.bits = new byte[8];
        this.intBits = new int[2];
        this.implReset();
        this.digestLength = 32;
        this.abyte0 = new byte[this.digestLength];
        this.oneByte = new byte[1];
        this.blockSize = 64;
        this.buffer = new byte[64];
    }

    public Object clone() {
        return null;
    }

    void implReset() {
        this.state[0] = 1779033703;
        this.state[1] = -1150833019;
        this.state[2] = 1013904242;
        this.state[3] = -1521486534;
        this.state[4] = 1359893119;
        this.state[5] = -1694144372;
        this.state[6] = 528734635;
        this.state[7] = 1541459225;
    }

    static void i2bBig(int[] ai, int i, byte[] abyte0, int j, int k) {
        while (k > 0) {
            int l = ai[i++];
            abyte0[j++] = (byte)(l >> 24);
            abyte0[j++] = (byte)(l >> 16);
            abyte0[j++] = (byte)(l >> 8);
            abyte0[j++] = (byte)l;
            k -= 4;
        }
    }

    void implDigest(byte[] abyte0, int i) {
        long l = this.bytesProcessed << 3;
        int j = (int)this.bytesProcessed & 0x3F;
        int k = j >= 56 ? 120 - j : 56 - j;
        this.engineUpdate(padding, 0, k);
        this.intBits[1] = (int)l;
        this.intBits[0] = (int)(l >> 32);
        SHA2.i2bBig(this.intBits, 0, this.bits, 0, 8);
        this.engineUpdate(this.bits, 0, 8);
        SHA2.i2bBig(this.state, 0, abyte0, i, 32);
    }

    private static int lf_ch(int i, int j, int k) {
        return i & j ^ ~i & k;
    }

    private static int lf_maj(int i, int j, int k) {
        return i & j ^ i & k ^ j & k;
    }

    private static int lf_R(int i, int j) {
        return i >>> j;
    }

    private static int lf_S(int i, int j) {
        return i >>> j | i << 32 - j;
    }

    private static int lf_sigma0(int i) {
        return SHA2.lf_S(i, 2) ^ SHA2.lf_S(i, 13) ^ SHA2.lf_S(i, 22);
    }

    private static int lf_sigma1(int i) {
        return SHA2.lf_S(i, 6) ^ SHA2.lf_S(i, 11) ^ SHA2.lf_S(i, 25);
    }

    private static int lf_delta0(int i) {
        return SHA2.lf_S(i, 7) ^ SHA2.lf_S(i, 18) ^ SHA2.lf_R(i, 3);
    }

    private static int lf_delta1(int i) {
        return SHA2.lf_S(i, 17) ^ SHA2.lf_S(i, 19) ^ SHA2.lf_R(i, 10);
    }

    static void b2iBig(byte[] abyte0, int i, int[] ai, int j, int k) {
        while (k > 0) {
            int l = abyte0[i + 3] & 0xFF | (abyte0[i + 2] & 0xFF) << 8 | (abyte0[i + 1] & 0xFF) << 16 | abyte0[i] << 24;
            ai[j++] = l;
            i += 4;
            k -= 4;
        }
    }

    void implCompress(byte[] abyte0, int i) {
        SHA2.b2iBig(abyte0, i, this.W, 0, 64);
        int j = 16;
        while (j < 64) {
            this.W[j] = SHA2.lf_delta1(this.W[j - 2]) + this.W[j - 7] + SHA2.lf_delta0(this.W[j - 15]) + this.W[j - 16];
            ++j;
        }
        int k = this.state[0];
        int l = this.state[1];
        int i1 = this.state[2];
        int j1 = this.state[3];
        int k1 = this.state[4];
        int l1 = this.state[5];
        int i2 = this.state[6];
        int j2 = this.state[7];
        int k2 = 0;
        while (k2 < 64) {
            int l2 = j2 + SHA2.lf_sigma1(k1) + SHA2.lf_ch(k1, l1, i2) + ROUND_CONSTS[k2] + this.W[k2];
            int i3 = SHA2.lf_sigma0(k) + SHA2.lf_maj(k, l, i1);
            j2 = i2;
            i2 = l1;
            l1 = k1;
            k1 = j1 + l2;
            j1 = i1;
            i1 = l;
            l = k;
            k = l2 + i3;
            ++k2;
        }
        this.state[0] = this.state[0] + k;
        this.state[1] = this.state[1] + l;
        this.state[2] = this.state[2] + i1;
        this.state[3] = this.state[3] + j1;
        this.state[4] = this.state[4] + k1;
        this.state[5] = this.state[5] + l1;
        this.state[6] = this.state[6] + i2;
        this.state[7] = this.state[7] + j2;
    }

    public final void engineReset() {
        if (this.bytesProcessed == 0L) {
            return;
        }
        this.implReset();
        this.bufOfs = 0;
        this.bytesProcessed = 0L;
    }

    protected final void engineUpdate(byte[] abyte0, int i, int j) {
        if (j == 0) {
            return;
        }
        if (this.bytesProcessed < 0L) {
            this.engineReset();
        }
        this.bytesProcessed += (long)j;
        if (this.bufOfs != 0) {
            int k = Math.min(j, this.blockSize - this.bufOfs);
            System.arraycopy(abyte0, i, this.buffer, this.bufOfs, k);
            this.bufOfs += k;
            i += k;
            j -= k;
            if (this.bufOfs >= this.blockSize) {
                this.implCompress(this.buffer, 0);
                this.bufOfs = 0;
            }
        }
        while (j >= this.blockSize) {
            this.implCompress(abyte0, i);
            j -= this.blockSize;
            i += this.blockSize;
        }
        if (j > 0) {
            System.arraycopy(abyte0, i, this.buffer, 0, j);
            this.bufOfs = j;
        }
    }

    public final void engineUpdate(byte byte0) {
        this.oneByte[0] = byte0;
        this.engineUpdate(this.oneByte, 0, 1);
    }

    public final byte[] engineDigest() {
        this.engineDigest(this.abyte0, 0, this.abyte0.length);
        return this.abyte0;
    }

    protected final int engineDigest(byte[] abyte0, int i, int j) {
        if (this.bytesProcessed < 0L) {
            this.engineReset();
        }
        this.implDigest(abyte0, i);
        this.bytesProcessed = -1L;
        return this.digestLength;
    }
}

