/*
 * Decompiled with CFR 0.152.
 */
package util;

public class HCPCalendar {
    private static byte ADD = 1;
    public static final long START_TIME = 946684800000L;
    public static final long END_TIME = 1609455595937L;
    public static final long ONE_DAY = 86400000L;
    public static final int ONE_HOUR = 3600000;
    public static final int ONE_MIN = 60000;
    private static final int START_DAY = 6;
    private static byte[] dateForm = new byte[13];

    static {
        ADD = (byte)HCPCalendar.getADDER(System.currentTimeMillis());
    }

    public static int getADDER(long timeE) {
        int mon = HCPCalendar.getField(2, timeE);
        if (mon > 2 && mon < 9) {
            return 2;
        }
        if (mon > 9 || mon < 2) {
            return 1;
        }
        long time = HCPCalendar.setField(11, 1, timeE);
        time = HCPCalendar.setField(12, 0, time);
        time = HCPCalendar.setField(13, 0, time);
        int i = 31;
        while (i > 0) {
            if (HCPCalendar.getField(7, time = HCPCalendar.setField(5, i, time)) == 1) break;
            --i;
        }
        if (mon == 2) {
            if (timeE < time) {
                return 1;
            }
            return 2;
        }
        if (timeE < time) {
            return 2;
        }
        return 1;
    }

    private static long getTimeInMilis(int YY, int MM, int DD, int HH, int mm, int ss) {
        long time2 = 946684800000L;
        int i = 0;
        while (i < YY) {
            time2 = i % 4 == 0 ? (time2 += 31622400000L) : (time2 += 31536000000L);
            ++i;
        }
        i = 0;
        while (i < MM) {
            switch (i) {
                case 1: {
                    if (YY % 4 == 0) {
                        time2 += 2505600000L;
                        break;
                    }
                    time2 += 2419200000L;
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 10: {
                    time2 += 2592000000L;
                    break;
                }
                default: {
                    time2 += 2678400000L;
                }
            }
            ++i;
        }
        time2 += (long)(DD - 1) * 86400000L;
        time2 += (long)(HH * 3600000);
        time2 += (long)(mm * 60000);
        return time2 += (long)(ss * 1000);
    }

    public static final long getRTC() {
        return System.currentTimeMillis() + (long)(ADD * 3600000);
    }

    public static final long getRTC(long time) {
        byte ADD = (byte)HCPCalendar.getADDER(time);
        return time + (long)(ADD * 3600000);
    }

    public static boolean isTimeDateValid(int year, int month, int day, int hour, int min, int sec) {
        if (year < 0 || year > 24) {
            return false;
        }
        if (month < 0 || month > 11) {
            return false;
        }
        if (day < 1 || day > 31) {
            return false;
        }
        if (month == 1) {
            if (day > 29) {
                return false;
            }
            if (year % 4 != 0 && day > 28) {
                return false;
            }
        }
        switch (month) {
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                if (day <= 30) break;
                return false;
            }
        }
        return true;
    }

    public static long getTimeMilis(int year, int month, int day, int hour, int min, int sec) {
        if (!HCPCalendar.isTimeDateValid(year, month, day, hour, min, sec)) {
            return -1L;
        }
        return HCPCalendar.getTimeInMilis(year, month, day, hour, min, sec);
    }

    public static long setField(int field, int fieldValue, long time) {
        int miliS = (int)(time % 1000L);
        time -= 946684800000L;
        int sek = (int)((time /= 1000L) % 60L);
        int min = (int)((time /= 60L) % 60L);
        int hour = (int)((time /= 60L) % 24L);
        time /= 24L;
        int i = 0;
        while (i < 25) {
            if (i % 4 == 0) {
                if (time - 366L < 0L) break;
                time -= 366L;
            } else {
                if (time - 365L < 0L) break;
                time -= 365L;
            }
            ++i;
        }
        int year = i;
        i = 0;
        while (i < 12) {
            int val;
            switch (i) {
                case 1: {
                    if (year % 4 == 0) {
                        val = 29;
                        break;
                    }
                    val = 28;
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 10: {
                    val = 30;
                    break;
                }
                default: {
                    val = 31;
                }
            }
            if (time - (long)val < 0L) break;
            time -= (long)val;
            ++i;
        }
        int month = i;
        int day = (int)time + 1;
        switch (field) {
            case 13: {
                sek = fieldValue;
                break;
            }
            case 12: {
                min = fieldValue;
                break;
            }
            case 11: {
                hour = fieldValue;
                break;
            }
            case 10: {
                hour = fieldValue;
                break;
            }
            case 2: {
                month = fieldValue;
                break;
            }
            case 5: {
                day = fieldValue;
                break;
            }
            case 1: {
                year = fieldValue;
            }
        }
        time = HCPCalendar.getTimeMilis(year, month, day, hour, min, sek);
        if (time == -1L) {
            return -1L;
        }
        return time += (long)miliS;
    }

    public static byte[] getFormatDateDDMMYY_HHMMSS(long time) {
        time -= 946684800000L;
        int sek = (int)((time /= 1000L) % 60L);
        int min = (int)((time /= 60L) % 60L);
        int hour = (int)((time /= 60L) % 24L);
        time /= 24L;
        int i = 0;
        while (i < 25) {
            if (i % 4 == 0) {
                if (time - 366L < 0L) break;
                time -= 366L;
            } else {
                if (time - 365L < 0L) break;
                time -= 365L;
            }
            ++i;
        }
        int year = i;
        i = 0;
        while (i < 12) {
            int val;
            switch (i) {
                case 1: {
                    if (year % 4 == 0) {
                        val = 29;
                        break;
                    }
                    val = 28;
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 10: {
                    val = 30;
                    break;
                }
                default: {
                    val = 31;
                }
            }
            if (time - (long)val < 0L) break;
            time -= (long)val;
            ++i;
        }
        int month = i + 1;
        int day = (int)time + 1;
        HCPCalendar.dateForm[0] = (byte)(day / 10 + 48);
        HCPCalendar.dateForm[1] = (byte)(day % 10 + 48);
        HCPCalendar.dateForm[2] = (byte)(month / 10 + 48);
        HCPCalendar.dateForm[3] = (byte)(month % 10 + 48);
        HCPCalendar.dateForm[4] = (byte)((year %= 100) / 10 + 48);
        HCPCalendar.dateForm[5] = (byte)(year % 10 + 48);
        HCPCalendar.dateForm[6] = 32;
        HCPCalendar.dateForm[7] = (byte)(hour / 10 + 48);
        HCPCalendar.dateForm[8] = (byte)(hour % 10 + 48);
        HCPCalendar.dateForm[9] = (byte)(min / 10 + 48);
        HCPCalendar.dateForm[10] = (byte)(min % 10 + 48);
        HCPCalendar.dateForm[11] = (byte)(sek / 10 + 48);
        HCPCalendar.dateForm[12] = (byte)(sek % 10 + 48);
        return dateForm;
    }

    private static int getPartOfDate(int field, long time) {
        time -= 946684800000L;
        time /= 1000L;
        if (field == 13) {
            return (int)(time % 60L);
        }
        time /= 60L;
        if (field == 12) {
            return (int)(time % 60L);
        }
        time /= 60L;
        if (field == 11 || field == 10) {
            return (int)(time % 24L);
        }
        time /= 24L;
        int i = 0;
        while (i < 25) {
            if (i % 4 == 0) {
                if (time - 366L < 0L) break;
                time -= 366L;
            } else {
                if (time - 365L < 0L) break;
                time -= 365L;
            }
            ++i;
        }
        int year = i;
        i = 0;
        while (i < 12) {
            int val;
            switch (i) {
                case 1: {
                    if (year % 4 == 0) {
                        val = 29;
                        break;
                    }
                    val = 28;
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 10: {
                    val = 30;
                    break;
                }
                default: {
                    val = 31;
                }
            }
            if (time - (long)val < 0L) break;
            time -= (long)val;
            ++i;
        }
        if (field == 2) {
            return i;
        }
        if (field == 5) {
            return (int)time + 1;
        }
        return year %= 100;
    }

    private static int getDayInWeek(long time) {
        time -= 946684800000L;
        time /= 86400000L;
        time += 6L;
        time %= 7L;
        return (int)(++time);
    }

    public static int getField(int field, long time) {
        switch (field) {
            case 7: {
                return HCPCalendar.getDayInWeek(time);
            }
            case 1: 
            case 2: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return HCPCalendar.getPartOfDate(field, time);
            }
        }
        return 0;
    }

    public static int getField(int field) {
        return HCPCalendar.getField(field, HCPCalendar.getRTC());
    }
}

