/*
 * Decompiled with CFR 0.152.
 */
package util;

public class BufferByte {
    private byte[] buffer;
    private int pos;
    private int add;
    private int offset;
    private static final ArrayIndexOutOfBoundsException arrExc = new ArrayIndexOutOfBoundsException("BufferIndexOutOfRange");

    public BufferByte() {
        this.buffer = new byte[1024];
        this.add = 128;
        this.pos = 0;
        this.offset = 0;
    }

    public BufferByte(int size, int adder) {
        this.buffer = new byte[size];
        this.add = adder;
        this.pos = 0;
        this.offset = 0;
    }

    public void setValue(int value, int offset) {
        if (offset >= this.pos) {
            throw arrExc;
        }
        this.buffer[offset] = (byte)value;
    }

    public void reset() {
        this.pos = 0;
    }

    public int getSize() {
        return this.pos;
    }

    public void add(int t) {
        if (this.pos == this.buffer.length) {
            byte[] arr = new byte[this.buffer.length + this.add];
            System.arraycopy(this.buffer, 0, arr, 0, this.buffer.length);
            this.buffer = arr;
        }
        this.buffer[this.pos++] = (byte)t;
    }

    public void remove(int start, int amn) {
        if (start + amn > this.pos) {
            return;
        }
        System.arraycopy(this.buffer, start + amn, this.buffer, start, this.pos - start - amn);
        this.pos -= amn;
    }

    public void addLong(long t) {
        int i = 7;
        while (i > -1) {
            long k = t >> i * 8;
            this.add((byte)(k & 0xFFL));
            --i;
        }
    }

    public void addLongASCII(long t) {
        int i = 7;
        while (i > -1) {
            int k = (int)(t >> i * 8 & 0xFFL);
            int x = k >> 4 & 0xF;
            x = x > 9 ? (x += 55) : (x += 48);
            this.add((byte)x);
            x = k & 0xF;
            x = x > 9 ? (x += 55) : (x += 48);
            this.add((byte)x);
            --i;
        }
    }

    public long getLong(int pos) {
        long k = 0L;
        int i = 0;
        while (i < 8) {
            long t = this.buffer[i + pos] & 0xFF;
            k |= t << i * 8;
            ++i;
        }
        return k;
    }

    public int getInt(int pos) {
        long k = 0L;
        int i = 0;
        while (i < 4) {
            long t = this.buffer[i + pos] & 0xFF;
            k |= t << i * 8;
            ++i;
        }
        return (int)k;
    }

    public short getShort(int pos) {
        int k = 0;
        int i = 0;
        while (i < 2) {
            int t = this.buffer[i + pos] & 0xFF;
            k |= t << i * 8;
            ++i;
        }
        return (short)k;
    }

    public long getLongASCII(int pos) {
        long k = 0L;
        int i = 0;
        while (i < 8) {
            int y = this.getValueAt(pos + 2 * i);
            if ((y -= 48) > 9) {
                y -= 7;
            }
            y <<= 4;
            int x = this.getValueAt(pos + 2 * i + 1);
            if ((x -= 48) > 9) {
                x -= 7;
            }
            long t = y |= x;
            k |= (t <<= (7 - i) * 8);
            ++i;
        }
        return k;
    }

    public void add(byte[] bb) {
        this.add(bb, 0, bb.length);
    }

    public void add(byte[] bb, int offset, int len) {
        if (this.buffer.length - this.pos > len) {
            System.arraycopy(bb, offset, this.buffer, this.pos, len);
            this.pos += len;
            return;
        }
        int t = this.buffer.length;
        while (t - this.pos <= len) {
            t += this.add;
        }
        byte[] arr = new byte[t];
        System.arraycopy(this.buffer, 0, arr, 0, this.pos);
        this.buffer = arr;
        System.arraycopy(bb, offset, this.buffer, this.pos, len);
        this.pos += len;
    }

    public void trimToMinSize(int size) {
        if (this.buffer.length >= size) {
            return;
        }
        byte[] arr = new byte[size];
        System.arraycopy(this.buffer, 0, arr, 0, this.pos);
        this.buffer = arr;
    }

    public void setPosition(int p) {
        if (p < 0 || p > this.buffer.length) {
            return;
        }
        this.pos = p;
    }

    public String getString() {
        return new String(this.buffer, 0, this.pos);
    }

    public void put(byte b, int start) {
        if (start >= this.pos) {
            this.add(b);
            return;
        }
        if (this.buffer.length - this.pos > 1) {
            System.arraycopy(this.buffer, start, this.buffer, start + 1, this.pos - start);
            this.buffer[start] = b;
            ++this.pos;
            return;
        }
        byte[] arr = new byte[this.buffer.length + this.add];
        System.arraycopy(this.buffer, 0, arr, 0, this.pos);
        this.buffer = arr;
        this.put(b, start);
    }

    public void put(byte[] bb, int start) {
        this.put(bb, 0, bb.length, start);
    }

    public void put(byte[] bb, int bbOffset, int bblen, int start) {
        if (start >= this.pos) {
            this.add(bb, bbOffset, bblen);
            return;
        }
        if (this.buffer.length - this.pos > bblen) {
            System.arraycopy(this.buffer, start, this.buffer, start + bblen, this.pos - start);
            System.arraycopy(bb, bbOffset, this.buffer, start, bblen);
            this.pos += bblen;
            return;
        }
        int t = this.buffer.length;
        while (t - this.pos <= bblen) {
            t += this.add;
        }
        byte[] arr = new byte[t];
        System.arraycopy(this.buffer, 0, arr, 0, this.pos);
        this.buffer = arr;
        this.put(bb, bbOffset, bblen, start);
    }

    public void removeTo(int poss) {
        if (poss > this.pos) {
            this.pos = 0;
            return;
        }
        System.arraycopy(this.buffer, poss, this.buffer, 0, this.pos - poss);
        this.pos -= poss;
    }

    public void compress() {
        if (this.buffer.length - 2 * this.add > this.pos) {
            return;
        }
        byte[] arr = new byte[this.pos + this.add];
        System.arraycopy(this.buffer, 0, arr, 0, this.pos);
        this.buffer = arr;
    }

    public int getValueAt(int poss) {
        if (poss < 0 || poss >= this.pos) {
            throw arrExc;
        }
        return this.buffer[poss] & 0xFF;
    }

    public byte[] getValues(int start, int end, byte[] bValues) {
        if (start > end || bValues.length < end - start) {
            throw arrExc;
        }
        if (start < 0 || end > this.pos) {
            throw arrExc;
        }
        System.arraycopy(this.buffer, start, bValues, 0, end - start);
        return bValues;
    }

    public byte removeValueAt(int poss) {
        if (poss < 0 || poss >= this.pos) {
            throw arrExc;
        }
        byte b = this.buffer[poss];
        --this.pos;
        if (poss == this.pos) {
            return b;
        }
        System.arraycopy(this.buffer, poss + 1, this.buffer, poss, this.pos - poss);
        return b;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int replaceWith(byte bOld, byte bNew, int start) {
        return BufferByte.replaceWith(this.buffer, this.pos, bOld, bNew, start);
    }

    public int replaceWith(byte[] abyteOld, byte[] abyteNew, int start) {
        int t = this.indexOf(abyteOld);
        if (t < 0) {
            return t;
        }
        int t1 = abyteOld.length;
        int t2 = abyteNew.length;
        if (t1 == t2) {
            System.arraycopy(abyteOld, 0, this.buffer, t, t1);
            return t + t2;
        }
        System.arraycopy(this.buffer, t + t1, this.buffer, t, this.pos - t - t1);
        this.pos -= t1;
        this.put(abyteNew, 0, t2, t);
        return t + t2;
    }

    public String toString() {
        return new String(this.buffer, 0, this.pos);
    }

    private static int replaceWith(byte[] buffer, int pos, byte bOld, byte bNew, int start) {
        if (start >= pos) {
            return -1;
        }
        int i = start;
        while (i < pos) {
            if (buffer[i] == bOld) {
                buffer[i] = bNew;
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(byte b, int start) {
        int i = start;
        while (i < this.pos) {
            if (this.buffer[i] == b) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(byte[] find) {
        return this.indexOf(find, 0);
    }

    public int indexOf(byte[] find, int fromIndex) {
        return BufferByte.indexOf(this.buffer, this.offset, this.pos, find, 0, find.length, fromIndex);
    }

    public int indexOf(byte[] find, int offset, int length, int fromIndex) {
        return BufferByte.indexOf(this.buffer, 0, this.pos, find, offset, length, fromIndex);
    }

    public static int indexOf(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        int i = sourceOffset + fromIndex;
        while (i <= max) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i <= max) {
                int j = i + 1;
                int end = j + targetCount - 1;
                int k = targetOffset + 1;
                while (j < end && source[j] == target[k]) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i - sourceOffset;
                }
            }
            ++i;
        }
        return -1;
    }

    public boolean isEquals(byte[] source, int from, int to, byte[] target) {
        return BufferByte.isEquals(source, from, to, target, 0, target.length);
    }

    public boolean isEquals(byte[] source, byte[] target) {
        return BufferByte.isEquals(source, 0, source.length, target, 0, target.length);
    }

    static boolean isEquals(byte[] source, int fromSourceIndex, int toSourceIndex, byte[] target, int fromTargetIndex, int toTargetIndex) {
        if (toSourceIndex - fromSourceIndex != toTargetIndex - fromTargetIndex) {
            return false;
        }
        if (source.length < toSourceIndex || fromSourceIndex < 0) {
            return false;
        }
        if (target.length < toTargetIndex || fromTargetIndex < 0) {
            return false;
        }
        int pos = fromTargetIndex;
        byte first = target[fromTargetIndex];
        int i = fromSourceIndex;
        while (i < toSourceIndex) {
            if (source[i] != first) {
                return false;
            }
            if (pos < toTargetIndex - 1) {
                first = target[++pos];
            }
            ++i;
        }
        return true;
    }

    public void addShort(int t) {
        int i = 2;
        while (--i >= 0) {
            int k = t >> i * 8;
            this.add((byte)(k & 0xFF));
        }
    }

    public void addInt(int t) {
        int i = 4;
        while (--i >= 0) {
            int k = t >> i * 8;
            this.add((byte)(k & 0xFF));
        }
    }

    public void addShortReversed(int t) {
        int i = 0;
        while (i < 2) {
            this.add(t >> i * 8);
            ++i;
        }
    }

    public void addThreeBytesReversed(int t) {
        int i = 0;
        while (i < 3) {
            int k = t >> i * 8;
            this.add((byte)(k & 0xFF));
            ++i;
        }
    }

    public void addIntReversed(int t) {
        int i = 0;
        while (i < 4) {
            this.add(t >> i * 8);
            ++i;
        }
    }

    public void addLongReversed(long t) {
        int i = 0;
        while (i < 8) {
            long k = t >> i * 8;
            this.add((byte)(k & 0xFFL));
            ++i;
        }
    }

    public void addSixBytesReversed(long t) {
        int i = 0;
        while (i < 6) {
            long k = t >> i * 8;
            this.add((byte)(k & 0xFFL));
            ++i;
        }
    }
}

