/*
 * Decompiled with CFR 0.152.
 */
package tables.zagRekTable;

import gui.GlavniFrame;
import gui.HCPColors;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.border.SoftBevelBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import objects.Header_Advertisement;
import objects.lang.LanguageStrings;
import tables.zagRekTable.ZagRekCellEditor;
import tables.zagRekTable.ZagRekTableModel;

public class TableZagRek
extends JTable
implements MouseListener {
    public static ZagRekCellEditor zce;
    private static final int ROW_NUM = 11;
    boolean header;

    public TableZagRek(boolean head) {
        this.header = head;
        this.addMouseListener(this);
        this.setFont(new Font(GlavniFrame.font.getName(), GlavniFrame.font.getStyle(), GlavniFrame.font.getSize() + 7));
        this.setBorder(new SoftBevelBorder(0));
        this.setRowHeight(25);
        this.setShowHorizontalLines(false);
        this.setSelectionBackground(HCPColors.getColorM4st());
        this.setModel(new ZagRekTableModel(this));
        TableColumnModel columnm = this.getColumnModel();
        TableColumn cl = columnm.getColumn(0);
        zce = new ZagRekCellEditor();
        cl.setCellEditor(zce);
        columnm.getColumn(1).setMaxWidth(40);
        this.setToolTipText("<html>ALT_DOWN + C = <i>" + LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_TABLE_TOOLTIP_0") + "</i>" + "<br>" + "CTRL_DOWN + SPACE =<i> " + LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_TABLE_TOOLTIP_1") + "</i>" + "<br>" + "RIGHT_CLICK  = <i>" + LanguageStrings.getInstance().getStringByName("ADVERTISEMENT_TABLE_TOOLTIP_1") + "</i>" + "<br>" + "</html>");
        InputMap mapIn = this.getInputMap(1);
        mapIn.put(KeyStroke.getKeyStroke(9, 0), "t");
        mapIn.put(KeyStroke.getKeyStroke(10, 0), "t");
        mapIn.put(KeyStroke.getKeyStroke(40, 0), "t");
        mapIn.put(KeyStroke.getKeyStroke(38, 0), "u");
        mapIn.put(KeyStroke.getKeyStroke(32, 128), "s");
        ActionMap actMap = this.getActionMap();
        actMap.put("t", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TableZagRek.this.setNextRow();
            }
        });
        actMap.put("u", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TableZagRek.this.setPreviousRow();
            }
        });
        actMap.put("s", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int row = TableZagRek.this.getSelectedRow();
                if (row < 0 || row > 11) {
                    return;
                }
                Header_Advertisement.getInstance().setBooleanValue(ZagRekTableModel.currentRow, row, !Header_Advertisement.getInstance().getBooleanValue(ZagRekTableModel.currentRow, row));
                TableZagRek.this.revalidate();
                TableZagRek.this.repaint();
            }
        });
    }

    public void setPreviousRow() {
        int t = this.getEditingRow();
        Object s = zce.getCellEditorValue();
        this.getModel().setValueAt(s, t, 0);
        if (--t == -1) {
            t = 10;
        }
        s = this.getModel().getValueAt(t, 0);
        zce.setValue((String)s);
        this.clearSelection();
        this.changeSelection(t, 0, false, false);
        this.setEditingRow(t);
    }

    public void setNextRow() {
        int t = this.getEditingRow();
        Object s = zce.getCellEditorValue();
        this.getModel().setValueAt(s, t, 0);
        if (++t == 11) {
            t = 0;
        }
        s = this.getModel().getValueAt(t, 0);
        zce.setValue((String)s);
        this.clearSelection();
        this.changeSelection(t, 0, false, false);
        this.setEditingRow(t);
    }

    public void mouseClicked(MouseEvent e) {
        int rowHeight = this.getHeight() / 11;
        if (e.getButton() == 1) {
            int t = this.getEditingRow();
            Object s = zce.getCellEditorValue();
            this.getModel().setValueAt(s, t, 0);
            t = e.getY() / rowHeight;
            if (t >= 11 || t < 0) {
                return;
            }
            s = this.getModel().getValueAt(t, 0);
            zce.setValue((String)s);
            this.clearSelection();
            this.changeSelection(t, 0, false, false);
            this.setEditingRow(t);
            TableZagRek.zce.ds.grabFocus();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        int rowHeight = this.getHeight() / 11;
        if (e.getButton() == 3) {
            int t = e.getY() / rowHeight;
            if (t >= 11 || t < 0) {
                return;
            }
            Header_Advertisement.getInstance().setBooleanValue(ZagRekTableModel.currentRow, t, !Header_Advertisement.getInstance().getBooleanValue(ZagRekTableModel.currentRow, t));
            this.revalidate();
            this.repaint();
        }
    }

    public JToolTip createToolTip() {
        JToolTip tip = new JToolTip(){};
        tip.setBackground(HCPColors.getColorM4st());
        return tip;
    }
}

