/*
 * Decompiled with CFR 0.152.
 */
package tables.testTable;

import java.text.DecimalFormat;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import objects.FiscallObjects;
import tables.testTable.PLUtest;

public class TestTableModel
extends DefaultTableModel
implements TableModel {
    private static final String[] kolone = new String[]{"NO", "Code", "Name", "Vat", "Price", "Amount", "Value"};
    private static final String empStr = "";
    public static final DecimalFormat dformat = new DecimalFormat("######0.00");
    public static final DecimalFormat dformat3 = new DecimalFormat("######0.000");
    private static final String EMPTY_FF = "FFFF";

    public Class getColumnClass(int col) {
        return String.class;
    }

    public int getColumnCount() {
        return 7;
    }

    public String getColumnName(int c) {
        return kolone[c];
    }

    public int getRowCount() {
        return PLUtest.vec.size() + 1;
    }

    public Object getValueAt(int row, int column) {
        PLUtest plu;
        if (PLUtest.vec.size() <= row) {
            return empStr;
        }
        if (PLUtest.vec.size() == 0) {
            return empStr;
        }
        try {
            plu = (PLUtest)PLUtest.vec.get(row);
        }
        catch (Exception e) {
            e.printStackTrace();
            return empStr;
        }
        switch (column) {
            case 0: {
                return empStr + (row + 1);
            }
            case 1: {
                if (plu.getCode() != -1) {
                    return String.valueOf(plu.getCode());
                }
                return EMPTY_FF;
            }
            case 2: {
                return plu.getDesc();
            }
            case 3: {
                byte pomb = plu.getPoreskaStopa();
                if (FiscallObjects.poreskeStope.length <= pomb || pomb < 0) {
                    pomb = 0;
                }
                return FiscallObjects.poreskeStope[pomb].opis;
            }
            case 4: {
                double dpom = plu.getCena();
                return dformat.format(dpom / 100.0);
            }
            case 5: {
                double dpom = plu.getKolicina();
                return dformat3.format(dpom / 1000.0);
            }
            case 6: {
                double dpom = plu.getVrednost();
                return dformat.format(dpom / 100.0);
            }
        }
        return null;
    }

    public boolean isCellEditable(int r, int c) {
        return false;
    }

    public void removeTableModelListener(TableModelListener arg0) {
    }

    public void setValueAt(Object s, int row, int col) {
    }

    public void addTableModelListener(TableModelListener arg0) {
    }
}

