/*
 * Decompiled with CFR 0.152.
 */
package tables.testTable;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import cashRegister.FiscalCommands;
import gui.GlavniFrame;
import gui.PlacanjeDialog;
import gui.PopupListener;
import gui.RacuniDialog;
import gui.rightPanels.TestProdajePanel;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import tables.articlesTable.ArticleTableCellRenderer;
import tables.testTable.PLUtest;
import tables.testTable.RacunTest;
import tables.testTable.TestTableModel;
import util.comPort.PortSerial;

public class TableTest
extends JTable {
    static long kes;
    static long bon;
    static long card;
    private TableTest pointer = this;

    public TableTest() {
        this.setModel(new TestTableModel());
        this.setFont(new Font(GlavniFrame.font.getName(), GlavniFrame.font.getStyle(), GlavniFrame.font.getSize() + 2));
        int rh = this.getRowHeight() + 5;
        this.setRowHeight(rh);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(true);
        TableColumnModel columnm = this.getColumnModel();
        columnm.setColumnSelectionAllowed(false);
        int i = 0;
        while (i < 7) {
            int len;
            TableColumn cl = columnm.getColumn(i);
            switch (i) {
                case 0: {
                    len = 2;
                    break;
                }
                case 1: {
                    len = 5;
                    break;
                }
                case 2: {
                    len = 19;
                    break;
                }
                case 3: {
                    len = 2;
                    break;
                }
                case 4: {
                    cl.setCellRenderer(new ArticleTableCellRenderer(4));
                    len = 10;
                    break;
                }
                case 5: {
                    cl.setCellRenderer(new ArticleTableCellRenderer(4));
                    len = 10;
                    break;
                }
                case 6: {
                    cl.setCellRenderer(new ArticleTableCellRenderer(4));
                    len = 10;
                    break;
                }
                default: {
                    len = 15;
                }
            }
            cl.setPreferredWidth(len * 13);
            ++i;
        }
        JPopupMenu popMenu = new JPopupMenu();
        PopupListener popUp = new PopupListener(popMenu);
        PopListener ppl = new PopListener();
        this.addMouseListener(popUp);
        JMenuItem item7 = new JMenuItem("sell all");
        item7.addActionListener(ppl);
        item7.setMnemonic('D');
        popMenu.add(item7);
        popMenu.addSeparator();
        JMenuItem item8 = new JMenuItem("clear all");
        item8.addActionListener(ppl);
        item8.setMnemonic('C');
        popMenu.add(item8);
        popMenu.addSeparator();
        JMenuItem item16 = new JMenuItem("void last");
        item16.addActionListener(ppl);
        item16.setMnemonic('6');
        popMenu.add(item16);
        JMenuItem item17 = new JMenuItem("void bill");
        item17.addActionListener(ppl);
        item17.setMnemonic('7');
        popMenu.add(item17);
        JMenuItem item18 = new JMenuItem("void PLU");
        item18.addActionListener(ppl);
        item18.setMnemonic('8');
        popMenu.add(item18);
    }

    public void stornoLast(int code, int amount) throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(50);
        instance.addInt(code);
        instance.addInt(amount);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 50 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public void stornoArticle() throws Exception {
        int row = this.getSelectedRow();
        if (row < 0 || row >= PLUtest.vec.size()) {
            return;
        }
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(50);
        PLUtest plu = (PLUtest)PLUtest.vec.elementAt(row);
        row = plu.getCode();
        instance.addInt(row);
        instance.addInt(0);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 50 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public void stornoBILL() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(50);
        instance.addInt(65535);
        instance.addInt(1000);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 50 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        PLUtest.vec.removeAllElements();
    }

    public static void plati(int tip, double db) throws Exception {
        long k = (long)(db * 100.0);
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(51);
        instance.addLong(k);
        instance.addByte(tip);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 51 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static long readBillDiference() throws Exception {
        Command instance = Command.instance;
        PortSerial port = PortSerial.getInstance();
        instance.reset();
        instance.setCmd(56);
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        if (Command.instance.getCmd() != 56 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        return instance.getLong(8);
    }

    public long getBillPrice() {
        long pom = 0L;
        Enumeration en = PLUtest.vec.elements();
        while (en.hasMoreElements()) {
            pom += ((PLUtest)en.nextElement()).getVrednost();
        }
        return pom;
    }

    private void prodajSve() throws Exception {
        int[] sel = this.getSelectedRows();
        if (sel == null || sel.length <= 0) {
            return;
        }
        int i = 0;
        while (i < sel.length) {
            ((PLUtest)PLUtest.vec.get(sel[i])).prodaj();
            ++i;
        }
    }

    public void payBill() throws Exception {
        if (GlavniFrame.PRINTER) {
            do {
                PlacanjeDialog pd = new PlacanjeDialog();
                pd.setVisible(true);
                if (pd.opt < 0) {
                    return;
                }
                if (pd.pomf < 0.0) {
                    throw new Exception("Wrong amount.");
                }
                TableTest.plati(pd.opt, pd.pomf);
            } while (TableTest.readBillDiference() != -1L);
            PLUtest.vec.removeAllElements();
            this.revalidate();
            this.repaint();
            return;
        }
        if (PLUtest.vec.size() <= 0) {
            throw new Exception("No PLUs in table.");
        }
        long bill = this.getBillPrice();
        long paid = 0L;
        do {
            PlacanjeDialog pd = new PlacanjeDialog();
            pd.setVisible(true);
            if (pd.opt < 0) {
                return;
            }
            if (pd.pomf < 0.0) {
                throw new Exception("Wrong amount.");
            }
            TableTest.plati(pd.opt, pd.pomf);
            switch (pd.opt) {
                case 0: {
                    if (pd.pomf == 0.0) {
                        kes += bill - (card + bon + kes);
                    }
                    paid += (kes += (long)(pd.pomf * 100.0));
                    break;
                }
                case 1: {
                    if (pd.pomf == 0.0) {
                        card += bill - (card + bon + kes);
                    }
                    paid += (card += (long)(pd.pomf * 100.0));
                    break;
                }
                case 2: {
                    if (pd.pomf == 0.0) {
                        bon += bill - (card + bon + kes);
                    }
                    paid += (bon += (long)(pd.pomf * 100.0));
                }
            }
        } while (bill > card + bon + kes);
        this.printBill();
        RacuniDialog rd = new RacuniDialog();
        rd.initialize();
        rd.lista.setSelectedIndex(rd.lista.getItemCount() - 1);
        rd.print();
    }

    private void printBill() {
        RacunTest rt = new RacunTest();
        Enumeration en1 = PLUtest.vec.elements();
        rt.card = card;
        rt.bon = bon;
        rt.kes = kes;
        while (en1.hasMoreElements()) {
            PLUtest pt = (PLUtest)en1.nextElement();
            rt.vecPLU.addElement(pt);
        }
        RacunTest.vec.addElement(rt);
        PLUtest.vec.removeAllElements();
        card = 0L;
        bon = 0L;
        kes = 0L;
        this.revalidate();
        this.repaint();
        TestProdajePanel.uTxtField.setText("0");
    }

    public void TEST_plati() throws Exception {
        if (PLUtest.vec.size() <= 0) {
            throw new Exception("No PLUs.");
        }
        RacunTest rt = new RacunTest();
        Enumeration en1 = PLUtest.vec.elements();
        while (en1.hasMoreElements()) {
            PLUtest pt = (PLUtest)en1.nextElement();
            rt.vecPLU.addElement(pt);
        }
        byte tip = (byte)(Math.random() * 9.0 % 3.0);
        switch (tip) {
            case 0: {
                kes = TestProdajePanel.TEST_fullValue;
                break;
            }
            case 1: {
                card = TestProdajePanel.TEST_fullValue;
                break;
            }
            case 2: {
                bon = TestProdajePanel.TEST_fullValue;
                break;
            }
            default: {
                kes = TestProdajePanel.TEST_fullValue;
            }
        }
        rt.card = card;
        rt.bon = bon;
        rt.kes = kes;
        RacunTest.vec.addElement(rt);
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(51);
        instance.addLong(TestProdajePanel.TEST_fullValue);
        instance.addByte(tip);
        System.out.println("$$$$$ Sell all... value = " + TestProdajePanel.TEST_fullValue + "\tby: " + tip);
        PLUtest.vec.removeAllElements();
        card = 0L;
        bon = 0L;
        kes = 0L;
        TestProdajePanel.TEST_fullValue = 0L;
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 51 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    protected class PopListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            int c = ((JMenuItem)e.getSource()).getMnemonic();
            try {
                switch (c) {
                    case 54: {
                        TableTest.this.stornoLast(0, 0);
                        break;
                    }
                    case 55: {
                        TableTest.this.stornoBILL();
                        PLUtest.vec.removeAllElements();
                        TableTest.this.revalidate();
                        TableTest.this.repaint();
                        break;
                    }
                    case 56: {
                        int row = TableTest.this.pointer.getSelectedRow();
                        if (row == PLUtest.vec.size()) {
                            return;
                        }
                        TableTest.this.stornoArticle();
                        int i = PLUtest.vec.size() - 1;
                        while (i >= 0) {
                            PLUtest pom = (PLUtest)PLUtest.vec.elementAt(i);
                            if (pom.getCode() == row) {
                                PLUtest.vec.removeElementAt(i);
                            }
                            --i;
                        }
                        break;
                    }
                    case 68: {
                        TableTest.this.prodajSve();
                        break;
                    }
                    case 67: {
                        PLUtest.vec.removeAllElements();
                        break;
                    }
                    case 57: {
                        FiscalCommands.execCommand(35);
                    }
                }
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
            }
            TableTest.this.pointer.revalidate();
            TableTest.this.pointer.repaint();
        }
    }
}

