/*
 * Decompiled with CFR 0.152.
 */
package tables.testTable;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.GlavniFrame;
import gui.rightPanels.TestProdajePanel;
import java.util.Vector;
import objects.FiscallObjects;
import objects.PLU;
import util.SysUtil;
import util.XML.XmlFileWriter;
import util.comPort.BarcodePort;
import util.comPort.PortSerial;

public class PLUtest {
    private String desc;
    private long barCode;
    private int code;
    private int cena = 0;
    private byte poreskaStopa;
    private byte JedinicaMere;
    private long vrednost;
    private int kolicina;
    public boolean saleByCode = true;
    public static Vector vec = new Vector(200);

    public PLUtest(PLU pc, int kol) throws Exception {
        this.saleByCode = pc.getCode() <= 0;
        this.desc = pc.getDesc();
        this.barCode = pc.getBarCode();
        this.code = pc.getCode();
        this.cena = pc.getCena();
        this.poreskaStopa = pc.getPoreskaStopa();
        this.JedinicaMere = pc.getJedinicaMere();
        this.kolicina = kol;
        this.vrednost = (long)this.cena * (long)kol;
        this.vrednost = SysUtil.round(this.vrednost, 3);
    }

    public void prodaj() throws Exception {
        PortSerial port = PortSerial.getInstance();
        Command instance = Command.instance;
        instance.reset();
        if (this.saleByCode) {
            instance.setCmd(48);
            instance.addInt(this.code);
        } else {
            instance.setCmd(49);
            instance.addLong(this.barCode);
        }
        instance.addInt(this.kolicina);
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 48 && command != 49 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public void TEST_prodaj(PLU plu) throws Exception {
        PortSerial port = PortSerial.getInstance();
        Command instance = Command.instance;
        instance.reset();
        if (GlavniFrame.PRINTER || !TestProdajePanel.useBarcode.isSelected() || Math.random() < 0.5 || vec.size() == 0 || this.barCode <= 0L) {
            instance.setCmd(48);
            instance.addInt(this.code);
            instance.addInt(this.kolicina);
            System.out.println("   Dodaj... code= " + this.code);
            port.sendFrame(instance);
            port.receiveFrame(instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != 48 && command != 49 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        } else {
            System.out.println("   Dodaj... barCode= " + this.barCode);
            this.kolicina = 1000;
            this.vrednost = (long)this.cena * (long)this.kolicina;
            this.vrednost = SysUtil.round(this.vrednost, 3);
            if ((double)this.vrednost * FiscallObjects.poreskeStope[this.getPoreskaStopa()].pravaVrednost / ((100.0 + FiscallObjects.poreskeStope[this.getPoreskaStopa()].pravaVrednost) * 100.0) < 0.01) {
                throw new Exception("Premala vrednost!!!!");
            }
            BarcodePort.getInstance().sendBarcode(this.barCode);
        }
    }

    public long getBarCode() {
        return this.barCode;
    }

    public void setBarCode(long barCode) {
        this.barCode = barCode;
    }

    public int getCena() {
        return this.cena;
    }

    public void setCena(int cena) {
        this.cena = cena;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public int getKolicina() {
        return this.kolicina;
    }

    public void setKolicina(int kolicina) {
        this.kolicina = kolicina;
    }

    public byte getPoreskaStopa() {
        return this.poreskaStopa;
    }

    public void setPoreskaStopa(byte poreskaStopa) {
        this.poreskaStopa = poreskaStopa;
    }

    public long getVrednost() {
        return this.vrednost;
    }

    public void setVrednost(int vrednost) {
        this.vrednost = vrednost;
    }

    public byte getJedinicaMere() {
        return this.JedinicaMere;
    }

    public void setJedinicaMere(byte jedinicaMere) {
        this.JedinicaMere = jedinicaMere;
    }

    public void writeToXML(XmlFileWriter xmlWriter) throws Exception {
        if (xmlWriter == null) {
            return;
        }
        xmlWriter.indent();
        xmlWriter.write("<DATA PLU='" + this.code + "'");
        xmlWriter.write(" DESC='" + this.desc + "'");
        xmlWriter.write(" VAT='" + this.poreskaStopa + "'");
        xmlWriter.write(" MES='" + this.JedinicaMere + "'");
        xmlWriter.write(" BCR='" + this.barCode + "'");
        xmlWriter.write(" PRC='" + this.cena + "'");
        xmlWriter.write(" AMN='" + this.kolicina + "'");
        xmlWriter.writeLn("/>");
        xmlWriter.unintent();
    }
}

