/*
 * Decompiled with CFR 0.152.
 */
package tables.kasiriTable;

import java.text.DecimalFormat;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import objects.Kasiri;
import objects.lang.LanguageStrings;

public class KasiriTableModel
implements TableModel {
    private static final String decFor = "######0.00";
    private DecimalFormat df = new DecimalFormat("######0.00");
    private static final String empStr = "";
    public static final String lowStr = LanguageStrings.getInstance().getStringByName("CASHIERS_LOW");
    public static final String mediumStr = LanguageStrings.getInstance().getStringByName("CASHIERS_MEDIUM");
    public static final String hiStr = LanguageStrings.getInstance().getStringByName("CASHIERS_HI");

    public void addTableModelListener(TableModelListener arg0) {
    }

    public Class getColumnClass(int arg0) {
        return String.class;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int c) {
        return LanguageStrings.getInstance().getStringByName("CASHIERS_TABLE_COLUMN_" + c);
    }

    public int getRowCount() {
        return Kasiri.vec.length;
    }

    public Object getValueAt(int row, int column) {
        if (Kasiri.vec.length <= row) {
            return empStr;
        }
        Kasiri kas = Kasiri.vec[row];
        switch (column) {
            case 0: {
                return kas.getIme();
            }
            case 1: {
                return String.valueOf(kas.getCode());
            }
            case 2: {
                switch (kas.getLevel()) {
                    case 0: {
                        return lowStr;
                    }
                    case 1: {
                        return mediumStr;
                    }
                    case 2: {
                        return hiStr;
                    }
                }
            }
            case 3: {
                return this.df.format((double)kas.getFinance() / 100.0);
            }
        }
        return null;
    }

    public boolean isCellEditable(int arg0, int col) {
        return col < 3;
    }

    public void removeTableModelListener(TableModelListener arg0) {
    }

    public void setValueAt(Object s, int row, int col) {
        if (s == null) {
            return;
        }
        String poms = (String)s;
        if (poms == empStr) {
            return;
        }
        Kasiri kas = Kasiri.vec[row];
        switch (col) {
            case 0: {
                kas.setIme(poms);
                break;
            }
            case 1: {
                try {
                    kas.setCode(Long.parseLong(poms));
                }
                catch (Exception e) {
                    kas.setCode(0L);
                }
                break;
            }
            case 2: {
                if (poms.indexOf(lowStr) >= 0) {
                    kas.setLevel((byte)0);
                }
                if (poms.trim().indexOf(mediumStr) >= 0) {
                    kas.setLevel((byte)1);
                }
                if (poms.trim().indexOf(hiStr) < 0) break;
                kas.setLevel((byte)2);
            }
        }
    }
}

