/*
 * Decompiled with CFR 0.152.
 */
package tables.displayTable2;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.GlavniFrame;
import gui.PopupListener;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import tables.displayTable2.DisplayData2;
import tables.displayTable2.DisplayTableModel2;
import tables.displayTable2.DisplayTableRBCellModel2;
import tables.displayTable2.DisplayTxtCellModel2;
import util.comPort.PortSerial;

public class TableDisplay2
extends JTable {
    public static DisplayData2 dd2 = new DisplayData2();

    public TableDisplay2() {
        this.setModel(new DisplayTableModel2(this));
        this.setFont(new Font(GlavniFrame.font.getName(), GlavniFrame.font.getStyle(), GlavniFrame.font.getSize() + 2));
        int rh = this.getRowHeight() + 5;
        this.setRowHeight(rh);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(true);
        TableColumnModel columnm = this.getColumnModel();
        columnm.setColumnSelectionAllowed(false);
        TableColumn cl = columnm.getColumn(0);
        cl.setMaxWidth(30);
        cl = columnm.getColumn(1);
        cl.setMaxWidth(50);
        cl.setCellEditor(new DefaultCellEditor(new DisplayTableRBCellModel2(5)));
        cl = columnm.getColumn(2);
        cl.setCellEditor(new DefaultCellEditor(new DisplayTxtCellModel2()));
        cl = columnm.getColumn(3);
        cl.setCellEditor(new DefaultCellEditor(new DisplayTxtCellModel2()));
        this.setToolTipText("<html>alt + C = <i>center selection</i><br>ctrl + INSERT = <i>insert row</i><br>ctrl + DELETE  = <i>delete row</i><br></html>");
        InputMap mapIn = this.getInputMap(1);
        mapIn.put(KeyStroke.getKeyStroke(67, 512), "c");
        mapIn.put(KeyStroke.getKeyStroke(155, 128), "i");
        mapIn.put(KeyStroke.getKeyStroke(127, 128), "d");
        ActionMap actMap = this.getActionMap();
        actMap.put("c", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TableDisplay2.this.centriraj();
                TableDisplay2.this.revalidate();
                TableDisplay2.this.repaint();
            }
        });
        actMap.put("i", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TableDisplay2.this.insert();
                TableDisplay2.this.revalidate();
                TableDisplay2.this.repaint();
            }
        });
        actMap.put("d", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TableDisplay2.this.delete();
                TableDisplay2.this.revalidate();
                TableDisplay2.this.repaint();
            }
        });
        JPopupMenu popMenu = new JPopupMenu();
        PopupListener popUp = new PopupListener(popMenu);
        PopListener ppl = new PopListener();
        this.addMouseListener(popUp);
        JMenuItem item1 = new JMenuItem("Sortiraj");
        item1.addActionListener(ppl);
        item1.setMnemonic('S');
        popMenu.add(item1);
        popMenu.addSeparator();
        JMenuItem item3 = new JMenuItem("Centriraj stavku (CTRL+C)");
        item3.addActionListener(ppl);
        item3.setMnemonic('C');
        popMenu.add(item3);
        popMenu.addSeparator();
        JMenuItem item5 = new JMenuItem("Reset CR");
        item5.addActionListener(ppl);
        item5.setMnemonic('R');
        popMenu.add(item5);
        JMenuItem item7 = new JMenuItem("Validate all");
        item7.addActionListener(ppl);
        item7.setMnemonic('V');
        popMenu.add(item7);
    }

    private void reset() throws Exception {
        Command.instance.reset();
        Command.instance.setCmd(0);
        Command.instance.addByte(222);
        Command.instance.addByte(10);
        Command.instance.addByte(75);
        Command.instance.addByte(38);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 0 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    private void validateAll() throws Exception {
        Command.instance.reset();
        Command.instance.setCmd(0);
        Command.instance.addByte(5);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 0 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    private void insert() {
        if (this.getSelectedRowCount() == 0) {
            return;
        }
        int sel = this.getSelectedRow();
        DisplayData2.DD2Row dd = new DisplayData2.DD2Row();
        dd.num = sel;
        dd.menuNum = 65535;
        dd.data1 = "";
        dd.data2 = "";
        TableDisplay2.dd2.vec.add(sel, dd);
        int i = 0;
        while (i < TableDisplay2.dd2.vec.size()) {
            ((DisplayData2.DD2Row)TableDisplay2.dd2.vec.elementAt((int)i)).num = i;
            ++i;
        }
    }

    private void delete() {
        if (this.getSelectedRowCount() == 0) {
            return;
        }
        int sel = this.getSelectedRow();
        DisplayData2.DD2Row dd = new DisplayData2.DD2Row();
        dd.num = 255;
        dd.menuNum = 65535;
        dd.data1 = "";
        dd.data2 = "";
        TableDisplay2.dd2.vec.add(dd);
        TableDisplay2.dd2.vec.removeElementAt(sel);
        int i = 0;
        while (i < TableDisplay2.dd2.vec.size()) {
            ((DisplayData2.DD2Row)TableDisplay2.dd2.vec.elementAt((int)i)).num = i;
            ++i;
        }
    }

    private void centriraj() {
        if (this.getSelectedColumn() < 2) {
            return;
        }
        String pom = "";
        switch (this.getSelectedColumn()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                pom = ((DisplayData2.DD2Row)TableDisplay2.dd2.vec.elementAt((int)this.getSelectedRow())).data1;
                break;
            }
            case 3: {
                pom = ((DisplayData2.DD2Row)TableDisplay2.dd2.vec.elementAt((int)this.getSelectedRow())).data2;
            }
        }
        pom = pom.trim();
        while (pom.length() < 25) {
            pom = String.valueOf(pom) + " ";
            pom = " " + pom;
        }
        if (pom.length() > 24) {
            pom = pom.substring(1, 25);
        }
        switch (this.getSelectedColumn()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                ((DisplayData2.DD2Row)TableDisplay2.dd2.vec.elementAt((int)this.getSelectedRow())).data1 = pom;
                break;
            }
            case 3: {
                ((DisplayData2.DD2Row)TableDisplay2.dd2.vec.elementAt((int)this.getSelectedRow())).data2 = pom;
            }
        }
    }

    protected class PopListener
    implements ActionListener {
        protected PopListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int c = ((JMenuItem)e.getSource()).getMnemonic();
            try {
                switch (c) {
                    case 83: {
                        dd2.quicksort(0, TableDisplay2.dd2.vec.size() - 1);
                        break;
                    }
                    case 67: {
                        TableDisplay2.this.centriraj();
                        break;
                    }
                    case 82: {
                        TableDisplay2.this.reset();
                        break;
                    }
                    case 86: {
                        TableDisplay2.this.validateAll();
                    }
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), ex.getMessage(), "ERROR", 0);
            }
            TableDisplay2.this.revalidate();
            TableDisplay2.this.repaint();
        }
    }
}

