/*
 * Decompiled with CFR 0.152.
 */
package tables.displayTable2;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.ProcessDialog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import util.BufferByte;
import util.SysUtil;
import util.XML.XmlFileWriter;
import util.XML.XmlObject;
import util.comPort.ComObject;
import util.comPort.PortSerial;

public class DisplayData2
implements ComObject,
XmlObject {
    public final Vector vec = new Vector(256);

    public DisplayData2() {
        int i = 0;
        while (i < 256) {
            DD2Row dd = new DD2Row();
            dd.num = i++;
            this.vec.add(dd);
        }
    }

    public void programAllKeys(int tableNum) throws Exception {
        Command instance = Command.bigInstance;
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(this.vec.size());
        pd.setVisible(true);
        int i = 0;
        try {
            while (i < this.vec.size()) {
                instance.reset();
                instance.setCmd(0);
                instance.addByte(4);
                instance.addByte(i);
                instance.addByte(tableNum);
                instance.addByte(255);
                while (instance.getPos() + 4 < 512) {
                    if (i >= this.vec.size()) break;
                    DD2Row dd = (DD2Row)this.vec.get(i);
                    instance.addShort(dd.menuNum);
                    instance.addShort(dd.num);
                    ++i;
                    pd.increaseBar();
                }
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(instance);
                port.receiveFrame(instance);
                int e = instance.getArray()[0] & 0xFF;
                if (instance.getCmd() == 0 || e == 0) continue;
                CommandsErrors.instanceMain.setError(e);
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public void programAllMenies(int tableNum) throws Exception {
        this.programAllMenies(tableNum, false);
    }

    public void programAllMenies(int tableNum, boolean trim) throws Exception {
        Command instance = Command.bigInstance;
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(this.vec.size());
        pd.setVisible(true);
        int i = 0;
        try {
            while (i < this.vec.size()) {
                instance.reset();
                instance.setCmd(0);
                instance.addByte(1);
                instance.addByte(i);
                instance.addByte(tableNum);
                instance.addByte(255);
                while (instance.getPos() + 48 < 512) {
                    if (i >= this.vec.size()) break;
                    DD2Row dd = (DD2Row)this.vec.get(i);
                    if (trim) {
                        SysUtil.formatForSend(dd.data1.trim(), instance);
                        SysUtil.formatForSend(dd.data2.trim(), instance);
                    } else {
                        SysUtil.formatForSend(dd.data1, instance);
                        SysUtil.formatForSend(dd.data2, instance);
                    }
                    ++i;
                    pd.increaseBar();
                }
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(instance);
                port.receiveFrame(instance);
                int e = instance.getArray()[0] & 0xFF;
                if (instance.getCmd() == 0 || e == 0) continue;
                CommandsErrors.instanceMain.setError(e);
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public void sendToPort() throws Exception {
        this.quicksort(0, this.vec.size() - 1);
        this.programAllKeys(0);
        this.programAllMenies(0);
    }

    public void readAllKeys(int tableNum) throws Exception {
        PortSerial port = PortSerial.getInstance();
        Command instance = Command.bigInstance;
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(this.vec.size());
        pd.setVisible(true);
        int i = 0;
        try {
            while (i < this.vec.size()) {
                instance.reset();
                instance.setCmd(0);
                instance.addByte(4);
                instance.addByte(i);
                instance.addByte(tableNum);
                instance.addByte(255);
                port.sendFrame(instance);
                instance = port.receiveFrame();
                int e = instance.getArray()[0] & 0xFF;
                if (instance.getCmd() != 0 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                for (int pos = 0; i < this.vec.size() && pos != instance.getPos(); pos += 2, ++i) {
                    DD2Row dd = (DD2Row)this.vec.get(i);
                    dd.menuNum = instance.getShort(pos);
                    dd.num = instance.getShort(pos += 2);
                    pd.increaseBar();
                }
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public void readAllMenies(int tableNum) throws Exception {
        PortSerial port = PortSerial.getInstance();
        Command instance = Command.bigInstance;
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(this.vec.size());
        pd.setVisible(true);
        int i = 0;
        try {
            while (i < this.vec.size()) {
                instance.reset();
                instance.setCmd(0);
                instance.addByte(1);
                instance.addByte(i);
                instance.addByte(tableNum);
                instance.addByte(255);
                port.sendFrame(instance);
                instance = port.receiveFrame();
                int e = instance.getArray()[0] & 0xFF;
                if (instance.getCmd() != 0 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                byte[] arr = new byte[24];
                for (int pos = 0; i < this.vec.size() && pos != instance.getPos(); pos += 24, ++i) {
                    DD2Row dd = (DD2Row)this.vec.get(i);
                    System.arraycopy(instance.getArray(), pos, arr, 0, arr.length);
                    dd.data1 = SysUtil.formatForReceive(arr);
                    System.arraycopy(instance.getArray(), pos += 24, arr, 0, arr.length);
                    dd.data2 = SysUtil.formatForReceive(arr);
                    pd.increaseBar();
                }
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public void readFromPort() throws Exception {
    }

    public void writeToXML(XmlFileWriter writer) throws Exception {
        int size = 256;
        if (writer == null) {
            return;
        }
        ProcessDialog pd = ProcessDialog.getInstance();
        try {
            writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
            writer.writeLn("<DISPLAY_MESSAGES>");
            pd.setMaximum(size);
            pd.setVisible(true);
            int i = 0;
            while (i < size) {
                DD2Row dd = (DD2Row)this.vec.get(i);
                writer.indent();
                writer.write("<DATA NUM='" + dd.menuNum + "'");
                while (dd.data1.length() < 24) {
                    dd.data1 = String.valueOf(dd.data1) + ' ';
                }
                while (dd.data2.length() < 24) {
                    dd.data2 = String.valueOf(dd.data2) + ' ';
                }
                writer.write(" TXT1='" + XmlFileWriter.compileString(dd.data1) + "'");
                writer.write(" TXT2='" + XmlFileWriter.compileString(dd.data2) + "'");
                writer.writeLn("/>");
                writer.unintent();
                pd.increaseBar();
                ++i;
            }
            writer.writeLn("</DISPLAY_MESSAGES>");
        }
        catch (Exception e) {
            pd.setVisible(false);
            throw e;
        }
        pd.setVisible(false);
    }

    public void readFromXML(File file) throws Exception {
        Document doc = null;
        ProcessDialog pd = ProcessDialog.getInstance();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(file);
            Element artEl = doc.getDocumentElement();
            NodeList dataNode = artEl.getElementsByTagName("DATA");
            int dataList = dataNode.getLength();
            this.vec.removeAllElements();
            pd.setMaximum(dataList);
            pd.setVisible(true);
            int i = 0;
            while (i < dataList) {
                DD2Row dd = new DD2Row();
                Element elem = (Element)dataNode.item(i);
                if (elem == null) {
                    return;
                }
                dd.num = i;
                String s = elem.getAttribute("NUM");
                dd.menuNum = (s = s.trim()).length() == 0 ? 65535 : Integer.parseInt(elem.getAttribute("NUM"));
                dd.data1 = elem.getAttribute("TXT1");
                dd.data2 = elem.getAttribute("TXT2");
                while (dd.data1.length() < 24) {
                    dd.data1 = String.valueOf(dd.data1) + ' ';
                }
                while (dd.data2.length() < 24) {
                    dd.data2 = String.valueOf(dd.data2) + ' ';
                }
                this.vec.add(dd);
                pd.increaseBar();
                ++i;
            }
        }
        finally {
            pd.setVisible(false);
        }
        pd.setVisible(false);
    }

    public void writeToXMLElement(XmlFileWriter writer) throws Exception {
        this.writeToXMLElement(writer, false);
    }

    public void writeToXMLElement(XmlFileWriter writer, boolean trim) throws Exception {
        int size = 256;
        if (writer == null) {
            return;
        }
        writer.writeLn("<DISPLAY_MENY>");
        int i = 0;
        while (i < size) {
            DD2Row dd = (DD2Row)this.vec.get(i);
            writer.indent();
            writer.write("<DATA NUM='" + dd.menuNum + "'");
            String pom = dd.data1;
            if (trim) {
                pom = pom.trim();
            }
            while (pom.length() < 24) {
                pom = String.valueOf(pom) + ' ';
            }
            writer.write(" TXT1='" + XmlFileWriter.compileString(pom) + "'");
            pom = dd.data2;
            if (trim) {
                pom = pom.trim();
            }
            while (pom.length() < 24) {
                pom = String.valueOf(pom) + ' ';
            }
            writer.write(" TXT2='" + XmlFileWriter.compileString(pom) + "'");
            writer.writeLn("/>");
            writer.unintent();
            ProcessDialog.getInstance().increaseBar();
            ++i;
        }
        writer.writeLn("</DISPLAY_MENY>");
    }

    public void readFromXMLElement(Element displayEl) throws IOException, ParserConfigurationException, SAXException {
        NodeList dataNode = displayEl.getElementsByTagName("DATA");
        int dataList = dataNode.getLength();
        this.vec.removeAllElements();
        int i = 0;
        while (i < dataList) {
            DD2Row dd = new DD2Row();
            Element elem = (Element)dataNode.item(i);
            if (elem == null) {
                return;
            }
            dd.num = i;
            String s = elem.getAttribute("NUM");
            dd.menuNum = (s = s.trim()).length() == 0 ? 65535 : Integer.parseInt(elem.getAttribute("NUM"));
            dd.data1 = elem.getAttribute("TXT1");
            dd.data2 = elem.getAttribute("TXT2");
            while (dd.data1.length() < 24) {
                dd.data1 = String.valueOf(dd.data1) + ' ';
            }
            while (dd.data2.length() < 24) {
                dd.data2 = String.valueOf(dd.data2) + ' ';
            }
            this.vec.add(dd);
            ProcessDialog.getInstance().increaseBar();
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void quicksort(int start, int end) {
        block5: {
            if (start >= end) {
                return;
            }
            lo = start;
            hi = end;
            if (lo >= hi) break block5;
            t = ((DD2Row)this.vec.get((int)(lo + hi >> 1))).menuNum;
            ** GOTO lbl22
            {
                ++lo;
                do {
                    if (lo < hi && ((DD2Row)this.vec.get((int)lo)).menuNum < t) continue block0;
                    while (lo < hi && ((DD2Row)this.vec.get((int)hi)).menuNum > t) {
                        --hi;
                    }
                    if (lo >= hi) continue;
                    dd2 = (DD2Row)this.vec.get(lo);
                    dd2.num = hi;
                    ((DD2Row)this.vec.get((int)hi)).num = lo;
                    this.vec.setElementAt((DD2Row)this.vec.get(hi), lo);
                    this.vec.setElementAt(dd2, hi);
                    ++lo;
                    --hi;
lbl22:
                    // 3 sources

                } while (lo < hi);
            }
        }
        if (hi < lo) {
            k = hi;
            hi = lo;
            lo = k;
        }
        this.quicksort(start, lo);
        this.quicksort(lo == start ? lo + 1 : lo, end);
    }

    public void readAll(int tableNum, InputStream in) throws Exception {
        this.vec.clear();
        int b = 0;
        int i = 0;
        while (i < 256) {
            DD2Row dd = new DD2Row();
            dd.menuNum = 0;
            b = in.read();
            if (b < 0) {
                throw new Exception("Data end!");
            }
            dd.menuNum |= b;
            b = in.read();
            if (b < 0) {
                throw new Exception("Data end!");
            }
            dd.menuNum |= b << 8;
            dd.num = 0;
            b = in.read();
            if (b < 0) {
                throw new Exception("Data end!");
            }
            dd.num |= b;
            b = in.read();
            if (b < 0) {
                throw new Exception("Data end!");
            }
            dd.num |= b << 8;
            this.vec.add(dd);
            ++i;
        }
        byte[] arr = new byte[24];
        int pos = 0;
        int i2 = 0;
        while (i2 < 256) {
            int len;
            DD2Row dd = (DD2Row)this.vec.get(i2);
            pos = 0;
            while ((len = in.read(arr, pos, arr.length - pos)) > 0) {
                pos += len;
            }
            dd.data1 = SysUtil.formatForReceive(arr);
            pos = 0;
            while ((len = in.read(arr, pos, arr.length - pos)) > 0) {
                pos += len;
            }
            dd.data2 = SysUtil.formatForReceive(arr);
            ++i2;
        }
    }

    public void saveAll(int tableNum, OutputStream out) throws Exception {
        DD2Row dd;
        BufferByte bb = new BufferByte(13312, 256);
        int i = 0;
        while (i < 256) {
            dd = (DD2Row)this.vec.get(i);
            bb.addShort(dd.menuNum);
            bb.addShort(dd.num);
            ++i;
        }
        i = 0;
        while (i < 256) {
            dd = (DD2Row)this.vec.get(i);
            while (dd.data1.length() < 24) {
                dd.data1 = String.valueOf(dd.data1) + ' ';
            }
            while (dd.data2.length() < 24) {
                dd.data2 = String.valueOf(dd.data2) + ' ';
            }
            SysUtil.formatForSend(dd.data1, bb);
            SysUtil.formatForSend(dd.data2, bb);
            ++i;
        }
        out.write(bb.getBuffer(), 0, bb.getSize());
    }

    public static class DD2Row {
        public int num = 0;
        public int menuNum = 65535;
        public String data1 = "";
        public String data2 = "";
    }
}

