/*
 * Decompiled with CFR 0.152.
 */
package tables.displayTable;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.GlavniFrame;
import gui.PopupListener;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import tables.displayTable.DisplayData;
import tables.displayTable.DisplayTableModel;
import tables.displayTable.DisplayTableRBCellModel;
import tables.displayTable.DisplayTxtCellModel;
import util.comPort.PortSerial;

public class TableDisplay
extends JTable {
    public static DisplayData dd = new DisplayData();

    public TableDisplay() {
        this.setModel(new DisplayTableModel(this));
        this.setFont(new Font(GlavniFrame.font.getName(), GlavniFrame.font.getStyle(), GlavniFrame.font.getSize() + 2));
        int rh = this.getRowHeight() + 5;
        this.setRowHeight(rh);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(true);
        TableColumnModel columnm = this.getColumnModel();
        columnm.setColumnSelectionAllowed(false);
        TableColumn cl = columnm.getColumn(0);
        cl.setMaxWidth(30);
        cl.setCellEditor(new DefaultCellEditor(new DisplayTableRBCellModel(3)));
        cl = columnm.getColumn(2);
        cl.setCellEditor(new DefaultCellEditor(new DisplayTxtCellModel()));
        cl = columnm.getColumn(1);
        cl.setCellEditor(new DefaultCellEditor(new DisplayTxtCellModel()));
        this.setToolTipText("<html>alt + C = <i>center selection</i><br>ctrl + PAGE_UP =<i> shift selection up</i><br>ctrl + PAGE_DOWN  = <i>shift selection down</i><br></html>");
        InputMap mapIn = this.getInputMap(1);
        mapIn.put(KeyStroke.getKeyStroke(67, 512), "c");
        mapIn.put(KeyStroke.getKeyStroke(33, 128), "u");
        mapIn.put(KeyStroke.getKeyStroke(34, 128), "d");
        ActionMap actMap = this.getActionMap();
        actMap.put("c", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TableDisplay.this.centriraj();
                TableDisplay.this.revalidate();
                TableDisplay.this.repaint();
            }
        });
        actMap.put("u", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TableDisplay.this.shiftDown();
                TableDisplay.this.revalidate();
                TableDisplay.this.repaint();
            }
        });
        actMap.put("d", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TableDisplay.this.shiftUp();
                TableDisplay.this.revalidate();
                TableDisplay.this.repaint();
            }
        });
        JPopupMenu popMenu = new JPopupMenu();
        PopupListener popUp = new PopupListener(popMenu);
        PopListener ppl = new PopListener();
        this.addMouseListener(popUp);
        JMenuItem item1 = new JMenuItem("Sortiraj rastuce po R.B.");
        item1.addActionListener(ppl);
        item1.setMnemonic('<');
        popMenu.add(item1);
        JMenuItem item2 = new JMenuItem("Sortiraj opadajuce po R.B.");
        item2.addActionListener(ppl);
        item2.setMnemonic('>');
        popMenu.add(item2);
        popMenu.addSeparator();
        JMenuItem item3 = new JMenuItem("Centriraj stavku (CTRL+C)");
        item3.addActionListener(ppl);
        item3.setMnemonic('C');
        popMenu.add(item3);
        popMenu.addSeparator();
        JMenuItem item5 = new JMenuItem("Reset CR");
        item5.addActionListener(ppl);
        item5.setMnemonic('R');
        popMenu.add(item5);
        JMenuItem item7 = new JMenuItem("Validate all");
        item7.addActionListener(ppl);
        item7.setMnemonic('V');
        popMenu.add(item7);
    }

    private void shiftUp() {
        if (this.getSelectedRowCount() == 0) {
            return;
        }
        int[] sel = this.getSelectedRows();
        if (sel[sel.length - 1] >= 255) {
            return;
        }
        int i = sel[sel.length - 1];
        while (i >= sel[0]) {
            TableDisplay.dd.data[1][i + 1] = TableDisplay.dd.data[1][i];
            TableDisplay.dd.data[2][i + 1] = TableDisplay.dd.data[2][i];
            --i;
        }
        i = sel[0];
        TableDisplay.dd.data[1][i] = "";
        TableDisplay.dd.data[2][i] = "";
        this.setRowSelectionInterval(i + 1, sel[sel.length - 1] + 1);
    }

    private void shiftDown() {
        if (this.getSelectedRowCount() == 0) {
            return;
        }
        int[] sel = this.getSelectedRows();
        if (sel[0] <= 0) {
            return;
        }
        int i = sel[0];
        while (i <= sel[sel.length - 1]) {
            TableDisplay.dd.data[1][i - 1] = TableDisplay.dd.data[1][i];
            TableDisplay.dd.data[2][i - 1] = TableDisplay.dd.data[2][i];
            ++i;
        }
        i = sel[sel.length - 1];
        TableDisplay.dd.data[1][i] = "";
        TableDisplay.dd.data[2][i] = "";
        this.setRowSelectionInterval(sel[0] - 1, i - 1);
    }

    private void reset() throws Exception {
        Command.instance.reset();
        Command.instance.setCmd(0);
        Command.instance.addByte(222);
        Command.instance.addByte(10);
        Command.instance.addByte(75);
        Command.instance.addByte(38);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 0 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    private void validateAll() throws Exception {
        Command.instance.reset();
        Command.instance.setCmd(0);
        Command.instance.addByte(5);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 0 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    private void centriraj() {
        if (this.getSelectedColumn() < 1) {
            return;
        }
        String pom = TableDisplay.dd.data[this.getSelectedColumn()][this.getSelectedRow()];
        pom = pom.trim();
        while (pom.length() < 25) {
            pom = String.valueOf(pom) + " ";
            pom = " " + pom;
        }
        if (pom.length() > 24) {
            pom = pom.substring(1, 25);
        }
        TableDisplay.dd.data[this.getSelectedColumn()][this.getSelectedRow()] = pom;
    }

    protected class PopListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            int c = ((JMenuItem)e.getSource()).getMnemonic();
            try {
                switch (c) {
                    case 60: {
                        this.quicksort(0, TableDisplay.this.getRowCount() - 1);
                        break;
                    }
                    case 62: {
                        this.quicksortr(0, TableDisplay.this.getRowCount() - 1);
                        break;
                    }
                    case 67: {
                        TableDisplay.this.centriraj();
                        break;
                    }
                    case 82: {
                        TableDisplay.this.reset();
                        break;
                    }
                    case 86: {
                        TableDisplay.this.validateAll();
                    }
                }
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), "ERROR", 0);
            }
            TableDisplay.this.revalidate();
            TableDisplay.this.repaint();
        }

        /*
         * Unable to fully structure code
         */
        private void quicksort(int start, int end) {
            block5: {
                if (start >= end) {
                    return;
                }
                lo = start;
                hi = end;
                if (lo >= hi) break block5;
                t = Integer.parseInt(TableDisplay.dd.data[0][lo + hi >> 1].trim());
                ** GOTO lbl26
                {
                    ++lo;
                    do {
                        if (lo < hi && Integer.parseInt(TableDisplay.dd.data[0][lo].trim()) < t) continue block0;
                        while (lo < hi && Integer.parseInt(TableDisplay.dd.data[0][hi].trim()) > t) {
                            --hi;
                        }
                        if (lo >= hi) continue;
                        pom0 = TableDisplay.dd.data[0][lo];
                        TableDisplay.dd.data[0][lo] = TableDisplay.this.getValueAt(hi, 0).toString();
                        TableDisplay.dd.data[0][hi] = pom0;
                        pom1 = TableDisplay.dd.data[1][lo];
                        TableDisplay.dd.data[1][lo] = TableDisplay.this.getValueAt(hi, 1).toString();
                        TableDisplay.dd.data[1][hi] = pom1;
                        pom2 = TableDisplay.dd.data[2][lo];
                        TableDisplay.dd.data[2][lo] = TableDisplay.this.getValueAt(hi, 2).toString();
                        TableDisplay.dd.data[2][hi] = pom2;
                        ++lo;
                        --hi;
lbl26:
                        // 3 sources

                    } while (lo < hi);
                }
            }
            if (hi < lo) {
                k = hi;
                hi = lo;
                lo = k;
            }
            this.quicksort(start, lo);
            this.quicksort(lo == start ? lo + 1 : lo, end);
        }

        /*
         * Unable to fully structure code
         */
        private void quicksortr(int start, int end) {
            block5: {
                if (start >= end) {
                    return;
                }
                lo = start;
                hi = end;
                if (lo >= hi) break block5;
                t = Integer.parseInt(TableDisplay.dd.data[0][lo + hi >> 1].trim());
                ** GOTO lbl26
                {
                    ++lo;
                    do {
                        if (lo < hi && Integer.parseInt(TableDisplay.dd.data[0][lo].trim()) > t) continue block0;
                        while (lo < hi && Integer.parseInt(TableDisplay.dd.data[0][hi].trim()) < t) {
                            --hi;
                        }
                        if (lo >= hi) continue;
                        pom0 = TableDisplay.dd.data[0][lo];
                        TableDisplay.dd.data[0][lo] = TableDisplay.this.getValueAt(hi, 0).toString();
                        TableDisplay.dd.data[0][hi] = pom0;
                        pom1 = TableDisplay.dd.data[1][lo];
                        TableDisplay.dd.data[1][lo] = TableDisplay.this.getValueAt(hi, 1).toString();
                        TableDisplay.dd.data[1][hi] = pom1;
                        pom2 = TableDisplay.dd.data[2][lo];
                        TableDisplay.dd.data[2][lo] = TableDisplay.this.getValueAt(hi, 2).toString();
                        TableDisplay.dd.data[2][hi] = pom2;
                        ++lo;
                        --hi;
lbl26:
                        // 3 sources

                    } while (lo < hi);
                }
            }
            if (hi < lo) {
                k = hi;
                hi = lo;
                lo = k;
            }
            this.quicksortr(start, lo);
            this.quicksortr(lo == start ? lo + 1 : lo, end);
        }
    }
}

