/*
 * Decompiled with CFR 0.152.
 */
package tables.displayTable;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import gui.ProcessDialog;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.BufferByte;
import util.SysUtil;
import util.XML.XmlFileWriter;
import util.XML.XmlObject;
import util.comPort.ComObject;
import util.comPort.PortSerial;

public class DisplayData
implements ComObject,
XmlObject {
    public String[][] data = new String[3][256];

    public DisplayData() {
        int i = 0;
        while (i < 256) {
            this.data[0][i] = String.valueOf(i);
            this.data[1][i] = "";
            this.data[2][i] = "";
            ++i;
        }
    }

    public void programAllMessages(int tableNum) throws Exception {
        this.programAllMessages(tableNum, false);
    }

    public void programAllMessages(int tableNum, boolean trim) throws Exception {
        Command instance = Command.bigInstance;
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(256);
        pd.setVisible(true);
        int i = 0;
        try {
            while (i < 256) {
                instance.reset();
                instance.setCmd(0);
                instance.addByte(3);
                instance.addByte(i);
                instance.addByte(tableNum);
                instance.addByte(255);
                while (instance.getPos() + 48 < 512) {
                    if (i >= 256) break;
                    String s = this.data[1][i];
                    if (s.length() < 24) {
                        throw new Exception("ERROR: Table is empty!");
                    }
                    if (trim) {
                        s = s.trim();
                    }
                    SysUtil.formatForSend(s, instance);
                    s = this.data[2][i];
                    if (s.length() < 24) {
                        throw new Exception("ERROR: Table is empty!");
                    }
                    if (trim) {
                        s = s.trim();
                    }
                    SysUtil.formatForSend(s, instance);
                    ++i;
                    pd.increaseBar();
                }
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(instance);
                port.receiveFrame(instance);
                int e = instance.getArray()[0] & 0xFF;
                if (instance.getCmd() == 0 || e == 0) continue;
                CommandsErrors.instanceMain.setError(e);
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public void readAllMessages(int tableNum) throws Exception {
        Command instance = Command.bigInstance;
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(256);
        pd.setVisible(true);
        int i = 0;
        try {
            while (i < 256) {
                instance.reset();
                instance.setCmd(0);
                instance.addByte(3);
                instance.addByte(i);
                instance.addByte(tableNum);
                instance.addByte(255);
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(instance);
                instance = port.receiveFrame();
                int e = instance.getArray()[0] & 0xFF;
                if (instance.getCmd() != 0 && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
                byte[] arr = new byte[24];
                for (int pos = 0; i < 256 && pos != instance.getPos(); pos += 24, ++i) {
                    System.arraycopy(instance.getArray(), pos, arr, 0, arr.length);
                    this.data[1][i] = SysUtil.formatForReceive(arr);
                    System.arraycopy(instance.getArray(), pos += 24, arr, 0, arr.length);
                    this.data[2][i] = SysUtil.formatForReceive(arr);
                    pd.increaseBar();
                }
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public void sendToPort() throws Exception {
        this.programAllMessages(0);
    }

    public void readFromPort() throws Exception {
    }

    public void writeToXML(XmlFileWriter writer) throws Exception {
        int size = 256;
        if (writer == null) {
            return;
        }
        ProcessDialog pd = ProcessDialog.getInstance();
        try {
            writer.writeLn("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
            writer.writeLn("<DISPLAY>");
            pd.setMaximum(size);
            pd.setVisible(true);
            int i = 0;
            while (i < size) {
                writer.indent();
                writer.write("<DATA TXT1='" + XmlFileWriter.compileString(this.data[0][i]) + "'");
                while (this.data[1][i].length() < 24) {
                    String[] stringArray = this.data[1];
                    int n = i;
                    stringArray[n] = String.valueOf(stringArray[n]) + ' ';
                }
                writer.write(" TXT2='" + XmlFileWriter.compileString(this.data[1][i]) + "'");
                while (this.data[2][i].length() < 24) {
                    String[] stringArray = this.data[2];
                    int n = i;
                    stringArray[n] = String.valueOf(stringArray[n]) + ' ';
                }
                writer.write(" TXT3='" + XmlFileWriter.compileString(this.data[2][i]) + "'");
                writer.writeLn("/>");
                writer.unintent();
                pd.increaseBar();
                ++i;
            }
            writer.writeLn("</DISPLAY>");
        }
        catch (Exception e) {
            pd.setVisible(false);
            throw e;
        }
        pd.setVisible(false);
    }

    public void readFromXML(File file) throws Exception {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        ProcessDialog pd = ProcessDialog.getInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(file);
            Element displayEl = doc.getDocumentElement();
            NodeList dataNode = displayEl.getElementsByTagName("DATA");
            int dataList = dataNode.getLength();
            pd.setMaximum(dataList);
            pd.setVisible(true);
            int i = 0;
            while (i < dataList) {
                Element elem = (Element)dataNode.item(i);
                if (elem == null) {
                    return;
                }
                this.data[0][i] = elem.getAttribute("TXT1");
                this.data[1][i] = elem.getAttribute("TXT2");
                this.data[2][i] = elem.getAttribute("TXT3");
                while (this.data[1][i].length() < 24) {
                    String[] stringArray = this.data[1];
                    int n = i;
                    stringArray[n] = String.valueOf(stringArray[n]) + ' ';
                }
                while (this.data[2][i].length() < 24) {
                    String[] stringArray = this.data[2];
                    int n = i;
                    stringArray[n] = String.valueOf(stringArray[n]) + ' ';
                }
                pd.increaseBar();
                ++i;
            }
        }
        finally {
            pd.setVisible(false);
        }
        pd.setVisible(false);
    }

    public void writeToXMLElement(XmlFileWriter writer) throws Exception {
        this.writeToXMLElement(writer, false);
    }

    public void writeToXMLElement(XmlFileWriter writer, boolean trim) throws Exception {
        int size = 256;
        if (writer == null) {
            return;
        }
        writer.writeLn("<DISPLAY_MESSAGES>");
        int i = 0;
        while (i < size) {
            writer.indent();
            String pom = this.data[0][i];
            if (trim) {
                pom = pom.trim();
            }
            writer.write("<DATA TXT1='" + XmlFileWriter.compileString(pom) + "'");
            pom = this.data[1][i];
            if (trim) {
                pom = pom.trim();
            }
            while (pom.length() < 24) {
                pom = String.valueOf(pom) + ' ';
            }
            writer.write(" TXT2='" + XmlFileWriter.compileString(pom) + "'");
            pom = this.data[2][i];
            if (trim) {
                pom = pom.trim();
            }
            while (pom.length() < 24) {
                pom = String.valueOf(pom) + ' ';
            }
            writer.write(" TXT3='" + XmlFileWriter.compileString(pom) + "'");
            writer.writeLn("/>");
            writer.unintent();
            ProcessDialog.getInstance().increaseBar();
            ++i;
        }
        writer.writeLn("</DISPLAY_MESSAGES>");
    }

    public void readFromXMLElement(Element displayEl) throws Exception {
        NodeList dataNode = displayEl.getElementsByTagName("DATA");
        int dataList = dataNode.getLength();
        int i = 0;
        while (i < dataList) {
            Element elem = (Element)dataNode.item(i);
            if (elem == null) {
                return;
            }
            this.data[0][i] = elem.getAttribute("TXT1");
            this.data[1][i] = elem.getAttribute("TXT2");
            this.data[2][i] = elem.getAttribute("TXT3");
            while (this.data[1][i].length() < 24) {
                String[] stringArray = this.data[1];
                int n = i;
                stringArray[n] = String.valueOf(stringArray[n]) + ' ';
            }
            while (this.data[2][i].length() < 24) {
                String[] stringArray = this.data[2];
                int n = i;
                stringArray[n] = String.valueOf(stringArray[n]) + ' ';
            }
            ProcessDialog.getInstance().increaseBar();
            ++i;
        }
    }

    public void readAll(int tableNum, InputStream in) throws Exception {
        byte[] arr = new byte[24];
        int pos = 0;
        int i = 0;
        while (i < 256) {
            int len;
            pos = 0;
            while ((len = in.read(arr, pos, arr.length - pos)) > 0) {
                pos += len;
            }
            this.data[1][i] = SysUtil.formatForReceive(arr);
            pos = 0;
            while ((len = in.read(arr, pos, arr.length - pos)) > 0) {
                pos += len;
            }
            this.data[2][i] = SysUtil.formatForReceive(arr);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void saveAll(int tableNum, OutputStream out) throws Exception {
        bb = new BufferByte(13312, 256);
        i = 0;
        ** GOTO lbl17
        {
            v0 = this.data[1];
            v1 = i;
            v0[v1] = String.valueOf(v0[v1]) + ' ';
            do {
                if (this.data[1][i].length() < 24) continue block0;
                while (this.data[2][i].length() < 24) {
                    v2 = this.data[2];
                    v3 = i;
                    v2[v3] = String.valueOf(v2[v3]) + ' ';
                }
                SysUtil.formatForSend(this.data[1][i], bb);
                SysUtil.formatForSend(this.data[2][i], bb);
                ++i;
lbl17:
                // 2 sources

            } while (i < 256);
        }
        out.write(bb.getBuffer(), 0, bb.getSize());
    }
}

