/*
 * Decompiled with CFR 0.152.
 */
package tables.articlesTable;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import cashRegister.FiscalCommands;
import gui.GlavniFrame;
import gui.HCPColors;
import gui.HCPTable;
import gui.HCPfileChooser;
import gui.NewArticleDialog;
import gui.PopupListener;
import gui.ProcessDialog;
import gui.ProcessingDialog;
import gui.importTxt.TxtImporer;
import gui.importXls.ExcelImporer;
import gui.search.SearchPluDialog;
import hcp.constants.Constants;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.sql.rowset.serial.SerialException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import objects.FiscallObjects;
import objects.PLU;
import objects.PLUSorter;
import objects.lang.LanguageStrings;
import objects.wrappers.PLUWrapper;
import tables.articlesTable.ArticleTableCellRenderer;
import tables.articlesTable.ArticleTableComboCellModel;
import tables.articlesTable.ArticleTableModel;
import tables.articlesTable.ArticleTableTxtCellModel;
import util.BufferByte;
import util.SysUtil;
import util.comPort.PortSerial;

public final class TableArticle
extends HCPTable {
    public MainThread runner;
    public JPopupMenu popMenu;
    private final TableArticle pointer = this;
    private static int MAX_PRICE = 999999999;

    public TableArticle() {
        ImageIcon slikaCash = new ImageIcon("images/CashSmall.png");
        this.runner = new MainThread();
        this.setModel(new ArticleTableModel());
        this.setFont(new Font(GlavniFrame.font.getName(), GlavniFrame.font.getStyle(), GlavniFrame.font.getSize() + 2));
        int rh = this.getRowHeight() + 5;
        this.setRowHeight(rh);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(true);
        TableColumnModel columnm = this.getColumnModel();
        columnm.setColumnSelectionAllowed(false);
        int i = 0;
        while (i < 11) {
            TableColumn cl;
            try {
                cl = columnm.getColumn(i);
            }
            catch (Exception e1) {
                break;
            }
            switch (i) {
                case 0: {
                    cl.setCellRenderer(new ArticleTableCellRenderer(2));
                    cl.setPreferredWidth(50);
                    cl.setMaxWidth(50);
                    cl.setMinWidth(50);
                    cl.setResizable(false);
                }
                case 1: {
                    cl.setCellRenderer(new ArticleTableCellRenderer(2));
                    cl.setPreferredWidth(340);
                    cl.setMinWidth(50);
                    int descSize = 34;
                    if (GlavniFrame.PRINTER) {
                        descSize = 32;
                    }
                    cl.setCellEditor(new DefaultCellEditor(new ArticleTableTxtCellModel(1, descSize)));
                    break;
                }
                case 2: {
                    cl.setCellRenderer(new ArticleTableCellRenderer(2));
                    cl.setPreferredWidth(50);
                    cl.setMaxWidth(50);
                    cl.setMinWidth(50);
                    cl.setResizable(false);
                    cl.setCellEditor(new DefaultCellEditor(new ArticleTableTxtCellModel(2, 5)));
                    break;
                }
                case 3: {
                    cl.setCellRenderer(new ArticleTableCellRenderer(2));
                    if (GlavniFrame.PRINTER) {
                        cl.setMaxWidth(1);
                    } else {
                        cl.setPreferredWidth(200);
                        cl.setMinWidth(50);
                    }
                    cl.setCellEditor(new DefaultCellEditor(new ArticleTableTxtCellModel(3, 19)));
                    break;
                }
                case 4: {
                    cl.setCellRenderer(new ArticleTableCellRenderer(4));
                    cl.setPreferredWidth(140);
                    cl.setMinWidth(50);
                    cl.setCellEditor(new DefaultCellEditor(new ArticleTableTxtCellModel(4, 11)));
                    break;
                }
                case 5: {
                    cl.setCellRenderer(new ArticleTableCellRenderer(0));
                    cl.setPreferredWidth(40);
                    cl.setMaxWidth(40);
                    cl.setMinWidth(40);
                    cl.setResizable(false);
                    cl.setCellEditor(new DefaultCellEditor(new ArticleTableComboCellModel(FiscallObjects.poreskeStope)));
                    break;
                }
                case 6: {
                    cl.setCellRenderer(new ArticleTableCellRenderer(0));
                    cl.setPreferredWidth(40);
                    cl.setMaxWidth(40);
                    cl.setMinWidth(40);
                    cl.setResizable(false);
                    cl.setCellEditor(new DefaultCellEditor(new ArticleTableComboCellModel(FiscallObjects.jediniceMere)));
                    break;
                }
                case 7: {
                    cl.setCellRenderer(new ArticleTableCellRenderer(0));
                    cl.setPreferredWidth(90);
                    cl.setMinWidth(50);
                    cl.setCellEditor(new DefaultCellEditor(new ArticleTableComboCellModel(FiscallObjects.odeljenja)));
                    break;
                }
                case 8: {
                    cl.setCellRenderer(new ArticleTableCellRenderer(4));
                }
                case 9: {
                    cl.setCellRenderer(new ArticleTableCellRenderer(4));
                }
                case 10: {
                    cl.setCellRenderer(new ArticleTableCellRenderer(4));
                }
                case 11: {
                    cl.setCellRenderer(new ArticleTableCellRenderer(4));
                }
            }
            ++i;
        }
        this.setToolTipText("<html>ctrl + SPACE = <i>" + LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_TOOLTIP_0") + "</i>" + "<br>" + "ctrl + F  = <i>" + LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_SEARCH") + "</i>" + "<br>" + "DELETE  = <i>" + LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_TOOLTIP_1") + "</i>" + "<br>" + "INSERT  = <i>" + LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_TOOLTIP_11") + "</i>" + "<br>" + "<br>" + "<u>" + LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_TOOLTIP_2") + "</u>" + "<br>" + "<u>" + LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_TOOLTIP_3") + "</u>" + "<br>" + "<u>" + LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_TOOLTIP_4") + "</u>" + "<br>" + "</html>");
        InputMap mapIn = this.getInputMap(1);
        mapIn.put(KeyStroke.getKeyStroke(127, 0), "d");
        mapIn.put(KeyStroke.getKeyStroke(155, 0), "i");
        mapIn.put(KeyStroke.getKeyStroke(32, 128), "s");
        mapIn.put(KeyStroke.getKeyStroke(70, 128), "f");
        ActionMap actMap = this.getActionMap();
        actMap.put("s", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int col = TableArticle.this.getSelectedColumn();
                int row = TableArticle.this.getSelectedRow();
                if (col > 7) {
                    return;
                }
                TableArticle.this.editCellAt(row, col);
                if (col > 4) {
                    ((ArticleTableComboCellModel)((DefaultCellEditor)TableArticle.this.getCellEditor(row, col)).getComponent()).grabFocus();
                } else {
                    ((ArticleTableTxtCellModel)((DefaultCellEditor)TableArticle.this.getCellEditor(row, col)).getComponent()).grabFocus();
                }
            }
        });
        actMap.put("d", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TableArticle.this.deleteSelectedRows();
            }
        });
        actMap.put("i", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                new NewArticleDialog();
                TableArticle.this.revalidate();
                TableArticle.this.repaint();
            }
        });
        actMap.put("f", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SearchPluDialog.getInstance().setVisible(true);
            }
        });
        this.popMenu = new JPopupMenu();
        PopupListener popUp = new PopupListener(this.popMenu);
        PopListener ppl = new PopListener();
        this.addMouseListener(popUp);
        JMenuItem itemSearch = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_SEARCH"));
        itemSearch.setIcon(new ImageIcon("images/search.png"));
        itemSearch.addActionListener(ppl);
        itemSearch.setMnemonic('F');
        this.popMenu.add(itemSearch);
        this.popMenu.addSeparator();
        JMenuItem itemImport = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_IMPORT"));
        itemImport.setIcon(new ImageIcon("images/excel.png"));
        itemImport.addActionListener(ppl);
        itemImport.setMnemonic('T');
        this.popMenu.add(itemImport);
        JMenuItem itemExport = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_EXPORT"));
        itemExport.setIcon(new ImageIcon("images/excel.png"));
        itemExport.addActionListener(ppl);
        itemExport.setMnemonic('R');
        this.popMenu.add(itemExport);
        this.popMenu.addSeparator();
        JMenuItem item1 = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_SORT_DESCENDING"));
        item1.addActionListener(ppl);
        item1.setMnemonic('<');
        this.popMenu.add(item1);
        JMenuItem item2 = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_SORT_ASCENDING"));
        item2.addActionListener(ppl);
        item2.setMnemonic('>');
        this.popMenu.add(item2);
        this.popMenu.addSeparator();
        JMenuItem item5 = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_PROGRAM"));
        item5.setIcon(slikaCash);
        item5.addActionListener(ppl);
        item5.setMnemonic('U');
        this.popMenu.add(item5);
        this.popMenu.addSeparator();
        JMenuItem item8 = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_DELETE"));
        item8.setIcon(slikaCash);
        item8.addActionListener(ppl);
        item8.setMnemonic('D');
        this.popMenu.add(item8);
        JMenuItem item13 = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_DELETE_ALL"));
        item13.setIcon(slikaCash);
        item13.addActionListener(ppl);
        item13.setMnemonic('1');
        this.popMenu.add(item13);
        this.popMenu.addSeparator();
        JMenuItem item3 = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_GENERATE_RANDOM"));
        item3.addActionListener(ppl);
        item3.setMnemonic('3');
        this.popMenu.add(item3);
        if (!GlavniFrame.PRINTER) {
            this.popMenu.addSeparator();
            JMenu itemSale = new JMenu(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_SUBMENU_SALE"));
            this.popMenu.add(itemSale);
            JMenuItem item18 = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_READ_ALL_SOLD"));
            item18.setIcon(slikaCash);
            item18.addActionListener(ppl);
            item18.setMnemonic('X');
            itemSale.add(item18);
            JMenuItem item20 = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_SOLD_FROM_TABLE"));
            item20.setIcon(slikaCash);
            item20.addActionListener(ppl);
            item20.setMnemonic('Z');
            itemSale.add(item20);
            JMenuItem item19 = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_RESET_SOLD"));
            item19.setIcon(slikaCash);
            item19.addActionListener(ppl);
            item19.setMnemonic('Y');
            itemSale.add(item19);
        }
        if (GlavniFrame.PRINTER) {
            this.popMenu.addSeparator();
            JMenu itemPrinter = new JMenu(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_PRINTER"));
            this.popMenu.add(itemPrinter);
            JMenuItem itemPrintArticles = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_PRINT_ALL_ARTICLES"));
            itemPrintArticles.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        TableArticle.this.runner.setJob(30);
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), " ERROR", 0);
                    }
                }
            });
            itemPrintArticles.setIcon(slikaCash);
            itemPrinter.add(itemPrintArticles);
            JMenuItem item85 = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_PRINT_SELECTED_ARTICLES"));
            item85.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        TableArticle.this.runner.setJob(31);
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), " ERROR", 0);
                    }
                }
            });
            item85.setIcon(slikaCash);
            itemPrinter.add(item85);
            JMenuItem item84 = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_PRINT_ARTICLES_BY_CODE"));
            item84.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        TableArticle.this.runner.setJob(32);
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), " ERROR", 0);
                    }
                }
            });
            item84.setIcon(slikaCash);
            itemPrinter.add(item84);
            itemPrinter.addSeparator();
            JMenuItem item80 = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_PRINTER_FREE_CODE"));
            item80.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        TableArticle.this.runner.setJob(33);
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), " ERROR", 0);
                    }
                }
            });
            item80.setIcon(slikaCash);
            itemPrinter.add(item80);
        }
        this.popMenu.addSeparator();
        JMenu itemPrice = new JMenu(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_SUBMENU_PRICE"));
        this.popMenu.add(itemPrice);
        JMenuItem itemCene = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_CHANGE_PRICE"));
        itemCene.setIcon(slikaCash);
        itemCene.addActionListener(ppl);
        itemCene.setMnemonic('C');
        itemPrice.add(itemCene);
        JMenuItem itemSavePrice = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_SAVE_PRICE"));
        itemSavePrice.addActionListener(ppl);
        itemSavePrice.setMnemonic('P');
        itemPrice.add(itemSavePrice);
        this.popMenu.addSeparator();
        JMenu itemBinary = new JMenu(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_SUBMENU_BYNARY"));
        this.popMenu.add(itemBinary);
        JMenuItem itemSave = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_SAVE_ALL_TO_FILE"));
        itemSave.addActionListener(ppl);
        itemSave.setMnemonic('S');
        itemBinary.add(itemSave);
        JMenuItem itemLoad = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_READ_ALL_FROM_FILE"));
        itemLoad.addActionListener(ppl);
        itemLoad.setMnemonic('L');
        itemBinary.add(itemLoad);
        this.popMenu.addSeparator();
        JMenu itemMySQL = new JMenu("MySQL");
        this.popMenu.add(itemMySQL);
        JMenuItem itemBase = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_SAVE_TO_BASE"));
        itemBase.addActionListener(ppl);
        itemBase.setMnemonic('B');
        itemMySQL.add(itemBase);
        JMenuItem itemBaseLoad = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_LOAD_FROM_BASE"));
        itemBaseLoad.addActionListener(ppl);
        itemBaseLoad.setMnemonic('^');
        itemMySQL.add(itemBaseLoad);
        JMenuItem itemBaseLoadSale = new JMenuItem(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_MENU_LOAD_SALE_FROM_BASE"));
        itemBaseLoadSale.addActionListener(ppl);
        itemBaseLoadSale.setMnemonic('*');
        itemMySQL.add(itemBaseLoadSale);
    }

    protected void testVat() {
        new Thread(){

            public void run() {
                int sel = TableArticle.this.getSelectedRow();
                if (sel < 0 || sel >= PLU.vec.size()) {
                    return;
                }
                PLU plu = (PLU)PLU.vec.elementAt(sel);
                int amount = 99999000;
                do {
                    try {
                        plu.sell(amount);
                    }
                    catch (CommandsErrors ce) {
                        System.out.println(ce.getClass() + " : " + ce.getMessage());
                        if (ce.getNumError() == 34) {
                            try {
                                FiscalCommands.platiSve();
                            }
                            catch (Exception e) {
                                return;
                            }
                            amount = 99999000;
                        }
                        amount /= 2;
                    }
                    catch (SerialException se) {
                        System.out.println(se.getClass() + " : " + se.getMessage());
                        return;
                    }
                    catch (Exception e) {
                        System.out.println(e.getClass() + " : " + e.getMessage());
                        amount /= 2;
                    }
                    System.out.println("sell with amount: " + amount);
                } while (amount >= 1);
            }
        }.start();
    }

    public final void revalitadeCombos() {
        TableColumnModel columnm = this.getColumnModel();
        columnm.setColumnSelectionAllowed(false);
        int i = 0;
        while (i < 8) {
            TableColumn cl;
            try {
                cl = columnm.getColumn(i);
            }
            catch (Exception e1) {
                break;
            }
            switch (i) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    cl.setPreferredWidth(40);
                    cl.setCellEditor(new DefaultCellEditor(new ArticleTableComboCellModel(FiscallObjects.poreskeStope)));
                    break;
                }
                case 6: {
                    cl.setPreferredWidth(40);
                    cl.setCellEditor(new DefaultCellEditor(new ArticleTableComboCellModel(FiscallObjects.jediniceMere)));
                    break;
                }
                case 7: {
                    cl.setPreferredWidth(40);
                    cl.setCellEditor(new DefaultCellEditor(new ArticleTableComboCellModel(FiscallObjects.odeljenja)));
                }
            }
            ++i;
        }
        this.revalidate();
        this.repaint();
    }

    public final void deleteSelectedRows() {
        int[] k = this.getSelectedRows();
        int nn = k.length;
        if (nn <= 0) {
            return;
        }
        if (k[k.length - 1] == PLU.vec.size()) {
            --nn;
        }
        int i = nn - 1;
        while (i >= 0) {
            int t = k[i];
            if (t < 0 || t >= PLU.vec.size()) break;
            PLU.vec.remove(t);
            --i;
        }
        this.revalidate();
        this.repaint();
    }

    public void resetSold() throws Exception {
        if (JOptionPane.showConfirmDialog(GlavniFrame.getInstance(), LanguageStrings.getAreYouSure(), "RESET", 2) != 0) {
            return;
        }
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(17);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(Command.instance);
        port.receiveFrame(Command.instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        if (17 != Command.instance.getCmd() && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    private void readSoldNoDefinition() throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            PLUWrapper.readSold();
        }
        finally {
            pd.setInstanceVisible(false);
            this.revalidate();
            this.repaint();
        }
    }

    private void readSold() throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        int descSize = 34;
        try {
            Command instance = Command.bigInstance;
            PortSerial port = PortSerial.getInstance();
            BufferByte arr = new BufferByte();
            int code = 1;
            long lll = 0L;
            PLU.vec.clear();
            block4: do {
                instance.reset();
                instance.setCmd(29);
                instance.addInt(code);
                port.sendFrame(instance);
                instance = port.receiveFrame();
                int e = instance.getArray()[0] & 0xFF;
                if (29 != instance.getCmd()) {
                    if (e == 18) {
                        return;
                    }
                    if (e != 0) {
                        CommandsErrors.instanceMain.setError(e);
                    }
                }
                int len = instance.getLength();
                len /= 64;
                int j = 0;
                while (j < len) {
                    arr.reset();
                    arr.add(instance.getArray(), j * 64, 64);
                    if (arr.getInt(0) == 0) continue block4;
                    PLU plu = new PLU();
                    code = arr.getShort(0) & 0xFFFF;
                    plu.setCode(code & 0xFFFF);
                    plu.setBarCode(arr.getLong(4));
                    byte[] bb = new byte[descSize];
                    System.arraycopy(arr.getBuffer(), 12, bb, 0, bb.length);
                    plu.setDesc(SysUtil.formatForReceive(bb));
                    byte poreskaStopa = 0;
                    int jedinicaMere = 0;
                    byte odeljenje2 = 0;
                    poreskaStopa = (byte)(poreskaStopa | (byte)arr.getValueAt(59) & 0xF);
                    odeljenje2 = (byte)(odeljenje2 | (byte)arr.getValueAt(58));
                    plu.setPoreskaStopa(poreskaStopa);
                    plu.setJedinicaMere(jedinicaMere |= ((byte)arr.getValueAt(59) & 0xF0) >> 4);
                    plu.setOdeljenje(odeljenje2);
                    plu.setCena(arr.getInt(60));
                    lll = arr.getLong(46) & 0xFFFFFFFFFFFFL;
                    if ((lll & 0x800000000000L) > 0L) {
                        lll |= 0xFFFF000000000000L;
                    }
                    plu.setProdato(lll);
                    lll = arr.getLong(52) & 0xFFFFFFFFFFFFL;
                    if ((lll & 0x800000000000L) > 0L) {
                        lll |= 0xFFFF000000000000L;
                    }
                    plu.setKolicina(lll);
                    PLU.vec.add(plu);
                    this.revalidate();
                    this.repaint();
                    ++j;
                }
            } while (code++ != 32000);
        }
        finally {
            pd.setInstanceVisible(false);
            this.revalidate();
            this.repaint();
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void generateRandomArticlesMain() throws Exception {
        PLU.vec.removeAllElements();
        str = " 1-32000";
        max = 32000;
        if (GlavniFrame.PRINTER) {
            str = " 1-75000";
            max = 75000;
        }
        if (GlavniFrame.BEST_LC) {
            str = " 1-12000";
            max = 12000;
        }
        if ((str = JOptionPane.showInputDialog(GlavniFrame.getInstance(), (Object)(String.valueOf(LanguageStrings.getInstance().getStringByName("ENTER_VALUE_IN_RANGE")) + str))) == null) {
            return;
        }
        kk = 0;
        try {
            kk = Integer.parseInt(str);
        }
        catch (Exception e1) {
            throw new Exception(LanguageStrings.getInstance().getStringByName("ERROR_VALUE_NOT_CORRECT"));
        }
        if (kk <= 0 || kk > max) {
            throw new Exception(LanguageStrings.getInstance().getStringByName("ERROR_VALUE_NOT_CORRECT"));
        }
        pd = ProcessDialog.getInstance();
        pd.setMaximum(kk);
        pd.setVisible(true);
        try {
            i = 1;
            while (i < kk + 1) {
                r1 = Math.random();
                r2 = Math.random();
                plu = new PLU();
                plu.setBarCode(-1L);
                if (GlavniFrame.PRINTER) ** GOTO lbl49
                r3 = Math.random();
                ll = (long)(r3 * 9.223372036854776E18);
                if (GlavniFrame.BEST_LC) {
                    ll = (long)(r3 * 1.0066329E7);
                }
                if (String.valueOf(ll).indexOf(50) == 0) {
                    --i;
                } else {
                    exists = false;
                    e = PLU.vec.elements();
                    while (e.hasMoreElements()) {
                        pp = (PLU)e.nextElement();
                        if (pp.getBarCode() != ll) continue;
                        exists = true;
                        break;
                    }
                    if (exists) {
                        --i;
                    } else {
                        plu.setBarCode(ll);
lbl49:
                        // 2 sources

                        plu.setCode(i);
                        if (GlavniFrame.BEST_LC && !GlavniFrame.PRINTER) {
                            plu.setCode(-1);
                        }
                        plu.setCena((int)(r2 * 10000.0));
                        if (plu.getCena() <= 100) {
                            plu.setCena(plu.getCena() + 100);
                        }
                        plu.setJedinicaMere((int)(r1 * (double)(FiscallObjects.jediniceMere.length - 1)));
                        plu.setPoreskaStopa((byte)(r1 * (double)(FiscallObjects.poreskeStope.length - 1)));
                        plu.setOdeljenje((byte)(r2 * (double)(FiscallObjects.odeljenja.length - 1)));
                        str = "Artikal" + i + ' ';
                        j = 0;
                        while (j < (int)(15.0 * r1)) {
                            rnd = (int)(90.0 * Math.random());
                            while (rnd < 65) {
                                rnd += 10;
                            }
                            str = String.valueOf(str) + (char)rnd;
                            ++j;
                        }
                        plu.setDesc(str);
                        PLU.vec.add(plu);
                        pd.increaseBar();
                    }
                }
                ++i;
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    private final void generate1() {
        PLU.vec.removeAllElements();
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(32000);
        pd.setVisible(true);
        try {
            int kk = 32000;
            int i = 1;
            while (i < kk + 1) {
                PLU plu = new PLU();
                plu.setCode(i);
                plu.setCena((i + 1) * 22005);
                plu.setJedinicaMere(i % 9);
                plu.setPoreskaStopa((byte)((i + 2) % Constants.VATS_MAX_NUMBER));
                long k = i;
                if (i == 9999) {
                    while (k < 99999999999999L) {
                        if (i < 10) {
                            k *= 10L;
                            k += (long)i;
                            continue;
                        }
                        if (i < 100) {
                            k *= 100L;
                            k += (long)i;
                            continue;
                        }
                        if (i < 1000) {
                            k *= 1000L;
                            k += (long)i;
                            continue;
                        }
                        if (i < 10000) {
                            k *= 10000L;
                            if ((k += (long)i) >= 0L) continue;
                            k *= -1L;
                            break;
                        }
                        if (i >= 100000) continue;
                        k *= 100000L;
                        if ((k += (long)i) >= 0L) continue;
                        k *= -1L;
                        break;
                    }
                }
                if (i < 10) {
                    k *= 10L;
                    k += 0L;
                } else if (i < 100) {
                    k *= 100L;
                    k += 12L;
                } else if (i < 1000) {
                    k *= 1000L;
                    k += 14L;
                } else if (i < 10000) {
                    k *= 100L;
                    k += 16L;
                } else if (i < 10000) {
                    k *= 100L;
                    k += 17L;
                }
                plu.setBarCode(k);
                plu.setDesc("Article " + i);
                PLU.vec.add(plu);
                if (i % 320 == 319) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                pd.increaseBar();
                ++i;
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    private final void generate2() {
        PLU.vec.removeAllElements();
        long poml = 31249L;
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(32000);
        pd.setVisible(true);
        try {
            int kk = 32000;
            int i = 1;
            while (i < kk + 1) {
                PLU plu = new PLU();
                plu.setCode(i);
                plu.setCena((i + 1) * 22005);
                plu.setJedinicaMere(i % (FiscallObjects.jediniceMere.length - 1));
                plu.setPoreskaStopa((byte)((i + 2) % (FiscallObjects.poreskeStope.length - 1)));
                plu.setOdeljenje((byte)((i + 2) % (FiscallObjects.odeljenja.length - 1)));
                plu.setBarCode((long)(32000 - i) * poml);
                plu.setDesc("Article " + i);
                PLU.vec.add(plu);
                if (i % 320 == 319) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                pd.increaseBar();
                ++i;
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    private final void generate13() throws Exception {
        PLU.vec.removeAllElements();
        int kk = Integer.parseInt(JOptionPane.showInputDialog(GlavniFrame.getInstance(), (Object)"Unesi broj artikala(1-32000)"));
        if (kk <= 0 || kk > 32000) {
            throw new Exception("Wrong input");
        }
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(kk);
        pd.setVisible(true);
        try {
            int i = 1;
            while (i < kk + 1) {
                double r1 = Math.random();
                double r2 = Math.random();
                double r3 = Math.random();
                long ll = (long)(r3 * 9.223372036854776E18);
                if (String.valueOf(ll).indexOf(50) == 0) {
                    --i;
                } else {
                    ll = SysUtil.getValid_EAN13_Barcode(ll);
                    boolean exists = false;
                    Enumeration e = PLU.vec.elements();
                    while (e.hasMoreElements()) {
                        PLU pp = (PLU)e.nextElement();
                        if (pp.getBarCode() != ll) continue;
                        exists = true;
                        break;
                    }
                    if (exists) {
                        --i;
                    } else {
                        PLU plu = new PLU();
                        plu.setCode(i);
                        plu.setCena((int)(r2 * (double)MAX_PRICE));
                        if (plu.getCena() <= 100) {
                            plu.setCena((int)(r2 * (double)MAX_PRICE) + 100);
                        }
                        plu.setBarCode(ll);
                        plu.setJedinicaMere((int)(r1 * (double)(FiscallObjects.jediniceMere.length - 1)));
                        plu.setPoreskaStopa((byte)(r2 * (double)(FiscallObjects.poreskeStope.length - 1)));
                        plu.setOdeljenje((byte)(r2 * (double)(FiscallObjects.odeljenja.length - 1)));
                        plu.setDesc("Article " + i);
                        PLU.vec.add(plu);
                        pd.increaseBar();
                    }
                }
                ++i;
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    private final void generate14() throws Exception {
        PLU.vec.removeAllElements();
        int kk = Integer.parseInt(JOptionPane.showInputDialog(GlavniFrame.getInstance(), (Object)"Unesi broj artikala(1-32000)"));
        if (kk <= 0 || kk > 32000) {
            throw new Exception("Wrong input");
        }
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(kk);
        pd.setVisible(true);
        try {
            int i = 1;
            while (i < kk + 1) {
                double r1 = Math.random();
                double r2 = Math.random();
                double r3 = Math.random();
                long ll = (long)(r3 * 9.223372036854776E18);
                if (String.valueOf(ll).indexOf(50) == 0) {
                    --i;
                } else {
                    ll = SysUtil.getValid_EAN14_Barcode(ll);
                    boolean exists = false;
                    Enumeration e = PLU.vec.elements();
                    while (e.hasMoreElements()) {
                        PLU pp = (PLU)e.nextElement();
                        if (pp.getBarCode() != ll) continue;
                        exists = true;
                        break;
                    }
                    if (exists) {
                        --i;
                    } else {
                        PLU plu = new PLU();
                        plu.setCode(i);
                        plu.setCena((int)(r2 * (double)MAX_PRICE));
                        if (plu.getCena() <= 100) {
                            plu.setCena((int)(r2 * (double)MAX_PRICE) + 100);
                        }
                        plu.setBarCode(ll);
                        plu.setJedinicaMere((int)(r1 * (double)(FiscallObjects.jediniceMere.length - 1)));
                        plu.setPoreskaStopa((byte)(r2 * (double)(FiscallObjects.poreskeStope.length - 1)));
                        plu.setOdeljenje((byte)(r2 * (double)(FiscallObjects.odeljenja.length - 1)));
                        plu.setDesc("Article " + i);
                        PLU.vec.add(plu);
                        pd.increaseBar();
                    }
                }
                ++i;
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    private final void generate8() throws Exception {
        PLU.vec.removeAllElements();
        int kk = Integer.parseInt(JOptionPane.showInputDialog(GlavniFrame.getInstance(), (Object)"Unesi broj artikala(1-32000)"));
        if (kk <= 0 || kk > 32000) {
            throw new Exception("Wrong input");
        }
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(kk);
        pd.setVisible(true);
        try {
            int i = 1;
            while (i < kk + 1) {
                double r1 = Math.random();
                double r2 = Math.random();
                double r3 = Math.random();
                long ll = (long)(r3 * 9.223372036854776E18);
                if (String.valueOf(ll).indexOf(50) == 0) {
                    --i;
                } else {
                    ll = SysUtil.getValid_EAN8_Barcode(ll);
                    boolean exists = false;
                    Enumeration e = PLU.vec.elements();
                    while (e.hasMoreElements()) {
                        PLU pp = (PLU)e.nextElement();
                        if (pp.getBarCode() != ll) continue;
                        exists = true;
                        break;
                    }
                    if (exists) {
                        --i;
                    } else {
                        PLU plu = new PLU();
                        plu.setCode(i);
                        plu.setCena((int)(r2 * (double)MAX_PRICE));
                        if (plu.getCena() <= 100) {
                            plu.setCena((int)(r2 * (double)MAX_PRICE) + 100);
                        }
                        plu.setBarCode(ll);
                        plu.setJedinicaMere((int)(r1 * (double)(FiscallObjects.jediniceMere.length - 1)));
                        plu.setPoreskaStopa((byte)(r2 * (double)(FiscallObjects.poreskeStope.length - 1)));
                        plu.setOdeljenje((byte)(r2 * (double)(FiscallObjects.odeljenja.length - 1)));
                        plu.setDesc("Article " + i);
                        PLU.vec.add(plu);
                        pd.increaseBar();
                    }
                }
                ++i;
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public void changePrice() throws Exception {
        int[] kk = this.getSelectedRows();
        int nn = kk.length;
        if (nn <= 0) {
            return;
        }
        int i = 0;
        Command instance = Command.bigInstance;
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(nn);
        pd.setVisible(true);
        try {
            while (i < nn) {
                if (kk[i] < 0) break;
                if (kk[i] >= PLU.vec.size()) {
                    break;
                }
                instance.reset();
                instance.setCmd(11);
                while (instance.getPos() < 504) {
                    if (i >= nn || kk[i] < 0 || kk[i] >= PLU.vec.size()) break;
                    PLU plu = (PLU)PLU.vec.elementAt(kk[i]);
                    instance.addInt(plu.getCode());
                    instance.addInt(plu.getCena());
                    ++i;
                    pd.increaseBar();
                }
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(instance);
                Command ccc = port.receiveFrame();
                int e = ccc.getArray()[0] & 0xFF;
                if (11 == ccc.getCmd() || e == 0) continue;
                CommandsErrors.instanceMain.setError(e);
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public final void programm() throws Exception {
        int[] kk = this.getSelectedRows();
        int nn = kk.length;
        if (nn == 1) {
            int sel = this.getSelectedRow();
            if (sel < 0 || sel >= PLU.vec.size()) {
                return;
            }
            PLU plu = (PLU)PLU.vec.elementAt(sel);
            plu.sendToCR();
            return;
        }
        PLUWrapper.programSelected(kk, 0);
        if (PLUWrapper.ERROR) {
            throw new Exception(LanguageStrings.getInstance().getStringByName("BASE_CHECK_ERROR"));
        }
    }

    private final void readRangeByBarcode() throws Exception {
        PLU.vec.removeAllElements();
        int i = Integer.parseInt(JOptionPane.showInputDialog(this, (Object)"Enter start addres(1-32000)"));
        if (i <= 0 || i > 32000) {
            throw new Exception("Wrong input");
        }
        int k = Integer.parseInt(JOptionPane.showInputDialog(this, (Object)"Enter start addres(1-32000)"));
        if (k <= 0 || k > 32000 || k <= i) {
            throw new Exception("Wrong input");
        }
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(k - i);
        pd.setVisible(true);
        try {
            PLU plu = new PLU();
            while (i <= k) {
                plu.readFromCR_codeBAr(i);
                PLU.vec.add(plu);
                plu = new PLU();
                ++i;
                pd.increaseBar();
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    private final void readByBarcode() throws Exception {
        int[] k = this.getSelectedRows();
        int nn = k.length;
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(nn);
        pd.setVisible(true);
        try {
            int i = 0;
            while (i < nn) {
                int t = k[i];
                if (t < 0 || t >= PLU.vec.size()) {
                    return;
                }
                PLU plu = (PLU)PLU.vec.elementAt(t);
                plu.readFromCR_BARCode();
                pd.increaseBar();
                ++i;
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    private final void deleteALL() throws Exception {
        if (JOptionPane.showConfirmDialog(GlavniFrame.getInstance(), LanguageStrings.getAreYouSure(), "DELETE ALL", 2) != 0) {
            return;
        }
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            try {
                Command.instance.reset();
                Command.instance.setCmd(14);
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(Command.instance);
                port.receiveFrame(Command.instance);
                int e = Command.instance.getArray()[0] & 0xFF;
                if (14 != Command.instance.getCmd() && e != 0) {
                    CommandsErrors.instanceMain.setError(e);
                }
            }
            catch (Exception e) {
                if (e.getMessage().indexOf("Time out") < 0) {
                    throw e;
                }
                pd.setInstanceVisible(false);
            }
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }

    private final void deleteByCode() throws Exception {
        if (JOptionPane.showConfirmDialog(GlavniFrame.getInstance(), LanguageStrings.getAreYouSure(), "DELETE", 2) != 0) {
            return;
        }
        Command bigInstance = Command.bigInstance;
        int[] k = this.getSelectedRows();
        int nn = k.length;
        int i = 0;
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(nn);
        pd.setVisible(true);
        try {
            while (i < nn) {
                bigInstance.reset();
                bigInstance.setCmd(13);
                int pos = 0;
                while (i < nn) {
                    int t = k[i];
                    if (t < 0 || t >= PLU.vec.size()) {
                        ++i;
                        break;
                    }
                    PLU plu = (PLU)PLU.vec.elementAt(t);
                    bigInstance.addInt(plu.getCode());
                    pd.increaseBar();
                    ++i;
                    if (++pos == 128) break;
                }
                PortSerial port = PortSerial.getInstance();
                port.sendFrame(bigInstance);
                Command instance = port.receiveFrame();
                int e = instance.getArray()[0] & 0xFF;
                if (13 == instance.getCmd() || e == 0) continue;
                CommandsErrors.instanceMain.setError(e);
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public void deleteByBarCode() throws Exception {
        int[] k = this.getSelectedRows();
        int nn = k.length;
        int i = 0;
        while (i < nn) {
            int t = k[i];
            if (t < 0 || t >= PLU.vec.size()) break;
            PLU plu = (PLU)PLU.vec.elementAt(t);
            plu.deleteFROMCR_barCode();
            ++i;
        }
    }

    private void readByCode() throws Exception {
        int[] k = this.getSelectedRows();
        int nn = k.length;
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(nn);
        pd.setVisible(true);
        try {
            int i = 0;
            while (i < nn) {
                int t = k[i];
                if (t < 0 || t >= PLU.vec.size()) {
                    return;
                }
                PLU plu = (PLU)PLU.vec.elementAt(t);
                plu.readFromCR_Code();
                pd.increaseBar();
                ++i;
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public void printSelectedArticles() throws Exception {
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            int[] k = this.getSelectedRows();
            int nn = k.length;
            if (nn <= 0) {
                return;
            }
            if (k[k.length - 1] == PLU.vec.size()) {
                --nn;
            }
            int i = nn - 1;
            while (i >= 0) {
                int t = k[i];
                if (t < 0) break;
                if (t >= PLU.vec.size()) {
                    break;
                }
                PLU plu = (PLU)PLU.vec.elementAt(t);
                PLUWrapper.printArticle(plu.getCode());
                --i;
            }
        }
        finally {
            pd.setInstanceVisible(false);
        }
    }

    public void printArticlesByCode() throws Exception {
        String str = " 1-32000";
        int max = 32000;
        if (GlavniFrame.PRINTER) {
            str = " 1-75000";
            max = 75000;
        }
        if (GlavniFrame.BEST_LC) {
            str = " 1-12000";
            max = 12000;
        }
        if ((str = JOptionPane.showInputDialog(GlavniFrame.getInstance(), (Object)(String.valueOf(LanguageStrings.getInstance().getStringByName("ENTER_VALUE_IN_RANGE")) + str))) == null) {
            return;
        }
        int kk = 0;
        try {
            kk = Integer.parseInt(str);
        }
        catch (Exception e1) {
            throw new Exception(LanguageStrings.getInstance().getStringByName("ERROR_VALUE_NOT_CORRECT"));
        }
        if (kk <= 0 || kk > max) {
            throw new Exception(LanguageStrings.getInstance().getStringByName("ERROR_VALUE_NOT_CORRECT"));
        }
        PLUWrapper.printArticle(kk);
    }

    public void printAllArticles() throws Exception {
        PLUWrapper.printAllArticles();
        FiscalCommands.execCommand(Command.ROLL_PAPER);
        FiscalCommands.cutPaper();
    }

    public void saveToFile() throws Exception {
        File file = new File("ARTICLES", "plu.hcp");
        file.getParentFile().mkdirs();
        HCPfileChooser fc = new HCPfileChooser("hcp");
        fc.setCurrentDirectory(file.getParentFile());
        fc.setSelectedFile(file);
        fc.addExtension("bin");
        fc.setAcceptAllFileFilterUsed(true);
        file = fc.saveFile();
        if (file == null) {
            return;
        }
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream out = new FileOutputStream(file);
        ((OutputStream)out).write(1);
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(PLU.vec.size());
        pd.setVisible(true);
        BufferByte arr = new BufferByte();
        try {
            int i = 0;
            while (i < PLU.vec.size()) {
                arr.reset();
                PLU plu = (PLU)PLU.vec.elementAt(i);
                String str = plu.getDesc().trim();
                int t = str.length();
                if (t > 34) {
                    t = 34;
                }
                arr.add(16 + t);
                arr.addShortReversed(plu.getCode());
                arr.addLongReversed(plu.getBarCode());
                arr.add(str.getBytes());
                arr.add(plu.getOdeljenje());
                t = plu.getJedinicaMere();
                t &= 0xF;
                t <<= 4;
                arr.add(t |= plu.getPoreskaStopa() & 0xF);
                arr.addIntReversed(plu.getCena());
                ((OutputStream)out).write(arr.getBuffer(), 0, arr.getSize());
                pd.increaseBar();
                ++i;
            }
            ((OutputStream)out).write(13);
            ((OutputStream)out).write(10);
        }
        finally {
            ((OutputStream)out).close();
            pd.setVisible(false);
        }
    }

    public void changeLager() throws Exception {
        if (this.getSelectedRowCount() != 1) {
            throw new Exception(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_SELECT"));
        }
        int sel = this.getSelectedRow();
        if (sel < 0 || sel >= PLU.vec.size()) {
            return;
        }
        PLU plu = (PLU)PLU.vec.elementAt(sel);
        String s = JOptionPane.showInputDialog(GlavniFrame.getInstance(), (Object)LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_INPUT_LAGER"));
        if (s == null || s.length() <= 0) {
            return;
        }
        s.replace(',', '.');
        double dd = 0.0;
        try {
            dd = Double.parseDouble(s);
        }
        catch (Exception e) {
            throw new Exception(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_WRONG_LAGER_INPUT"));
        }
        int kk = (int)(dd * 1000.0);
        plu.setLager(kk);
        plu.changeLager();
    }

    public void addLager() throws Exception {
        if (this.getSelectedRowCount() != 1) {
            throw new Exception(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_SELECT"));
        }
        int sel = this.getSelectedRow();
        if (sel < 0 || sel >= PLU.vec.size()) {
            return;
        }
        PLU plu = (PLU)PLU.vec.elementAt(sel);
        String s = JOptionPane.showInputDialog(GlavniFrame.getInstance(), (Object)LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_ADD_LAGER"));
        if (s == null || s.length() <= 0) {
            return;
        }
        s.replace(',', '.');
        double dd = 0.0;
        try {
            dd = Double.parseDouble(s);
        }
        catch (Exception e) {
            throw new Exception(LanguageStrings.getInstance().getStringByName("ARTICLE_TABLE_WRONG_LAGER_INPUT"));
        }
        int kk = (int)(dd * 1000.0);
        plu.addLager(kk);
        plu.setLager(plu.getLager() + kk);
    }

    public void writeToBase() throws Exception {
        PLU.writeAllToBase();
    }

    public void loadFromBase() throws Exception {
        PLU.loadFromBase();
    }

    public void loadSaleFromBase() throws Exception {
        PLU.loadSaleFromBase();
    }

    public void loadFromFile() throws Exception {
        PLU.vec.removeAllElements();
        File file = new File("ARTICLES", "plu.hcp");
        HCPfileChooser fc = new HCPfileChooser("hcp");
        fc.setCurrentDirectory(file.getParentFile());
        fc.setSelectedFile(file);
        fc.addExtension("bin");
        fc.setAcceptAllFileFilterUsed(true);
        file = fc.openFile();
        if (file == null) {
            return;
        }
        int minSize = 16;
        int descSize = 34;
        FileInputStream in = new FileInputStream(file);
        BufferByte arr = new BufferByte();
        int pos = 1;
        try {
            Thread.sleep(5L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ProcessingDialog pd = ProcessingDialog.getInstance();
        pd.setInstanceVisible(true);
        try {
            while (((InputStream)in).available() >= minSize) {
                arr.reset();
                pos = ((InputStream)in).read();
                if (pos < 0) {
                    throw new Exception("read data - error");
                }
                int offset = descSize + minSize - pos;
                int r = ((InputStream)in).read(arr.getBuffer(), 0, pos);
                arr.setPosition(pos);
                if (r != pos) {
                    throw new Exception("read data lenght - error");
                }
                PLU plu = new PLU();
                plu.setCode(arr.getShort(0) & 0xFFFF);
                plu.setBarCode(arr.getLong(2));
                byte[] bb = new byte[descSize];
                System.arraycopy(arr.getBuffer(), 10, bb, 0, bb.length - offset);
                plu.setDesc(SysUtil.formatForReceive(bb));
                byte poreskaStopa = 0;
                int jedinicaMere = 0;
                byte odeljenje2 = 0;
                poreskaStopa = (byte)(poreskaStopa | (byte)arr.getValueAt(45 - offset) & 0xF);
                odeljenje2 = (byte)(odeljenje2 | (byte)arr.getValueAt(44 - offset));
                plu.setPoreskaStopa(poreskaStopa);
                plu.setJedinicaMere(jedinicaMere |= ((byte)arr.getValueAt(45 - offset) & 0xF0) >> 4);
                plu.setOdeljenje(odeljenje2);
                plu.setCena(arr.getInt(46 - offset));
                PLU.vec.add(plu);
                this.revalidate();
                this.repaint();
            }
        }
        finally {
            ((InputStream)in).close();
            pd.setInstanceVisible(false);
        }
    }

    public void saveLagerToFile() throws Exception {
        File file = new File("ARTICLES", "lager.hcp");
        file.getParentFile().mkdirs();
        HCPfileChooser fc = new HCPfileChooser("hcp");
        fc.setCurrentDirectory(file.getParentFile());
        fc.setSelectedFile(file);
        fc.setAcceptAllFileFilterUsed(true);
        file = fc.saveFile();
        if (file == null) {
            return;
        }
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream out = new FileOutputStream(file);
        ((OutputStream)out).write(3);
        ((OutputStream)out).write(11);
        int[] kk = this.getSelectedRows();
        int nn = kk.length;
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(nn);
        pd.setVisible(true);
        BufferByte arr = new BufferByte(6, 2);
        try {
            int i = 0;
            while (i < nn) {
                arr.reset();
                if (kk[i] < 0 || kk[i] >= PLU.vec.size()) break;
                PLU plu = (PLU)PLU.vec.elementAt(kk[i]);
                arr.addShortReversed(plu.getCode());
                arr.addIntReversed(plu.getLager());
                ((OutputStream)out).write(arr.getBuffer(), 0, arr.getSize());
                pd.increaseBar();
                ++i;
            }
            ((OutputStream)out).write(13);
            ((OutputStream)out).write(10);
        }
        finally {
            ((OutputStream)out).close();
            pd.setVisible(false);
        }
    }

    public void savePriceToFile() throws Exception {
        File file = new File("ARTICLES", "price.hcp");
        file.getParentFile().mkdirs();
        HCPfileChooser fc = new HCPfileChooser("hcp");
        fc.setCurrentDirectory(file.getParentFile());
        fc.setSelectedFile(file);
        fc.setAcceptAllFileFilterUsed(true);
        file = fc.saveFile();
        if (file == null) {
            return;
        }
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream out = new FileOutputStream(file);
        if (GlavniFrame.BEST_LC) {
            ((OutputStream)out).write(3);
        } else {
            ((OutputStream)out).write(2);
        }
        ((OutputStream)out).write(11);
        int[] kk = this.getSelectedRows();
        int nn = kk.length;
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(nn);
        pd.setVisible(true);
        BufferByte arr = new BufferByte(10, 2);
        try {
            int i = 0;
            while (i < nn) {
                arr.reset();
                if (kk[i] < 0 || kk[i] >= PLU.vec.size()) break;
                PLU plu = (PLU)PLU.vec.elementAt(kk[i]);
                if (GlavniFrame.BEST_LC) {
                    arr.addSixBytesReversed(plu.getBarCode());
                } else {
                    arr.addShortReversed(plu.getCode());
                }
                arr.addIntReversed(plu.getCena());
                ((OutputStream)out).write(arr.getBuffer(), 0, arr.getSize());
                pd.increaseBar();
                ++i;
            }
            ((OutputStream)out).write(13);
            ((OutputStream)out).write(10);
        }
        finally {
            ((OutputStream)out).close();
            pd.setVisible(false);
        }
    }

    public void decreasePrice() {
        int[] kk = this.getSelectedRows();
        int nn = kk.length;
        int i = 0;
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(nn);
        pd.setVisible(true);
        try {
            while (i < nn) {
                if (kk[i] < 0) break;
                if (kk[i] >= PLU.vec.size()) {
                    break;
                }
                PLU plu = (PLU)PLU.vec.elementAt(kk[i]);
                plu.setCena((int)((double)plu.getCena() * 0.01));
                ++i;
                pd.increaseBar();
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public void increasePrice() {
        int[] kk = this.getSelectedRows();
        int nn = kk.length;
        int i = 0;
        ProcessDialog pd = ProcessDialog.getInstance();
        pd.setMaximum(nn);
        pd.setVisible(true);
        try {
            while (i < nn) {
                if (kk[i] < 0) break;
                if (kk[i] >= PLU.vec.size()) {
                    break;
                }
                PLU plu = (PLU)PLU.vec.elementAt(kk[i]);
                plu.setCena(plu.getCena() * 100);
                ++i;
                pd.increaseBar();
            }
        }
        finally {
            pd.setVisible(false);
        }
    }

    public JToolTip createToolTip() {
        JToolTip tip = new JToolTip(){};
        tip.setBackground(HCPColors.getColorM4st());
        return tip;
    }

    protected void getFirstFreeCode() throws Exception {
        int c = 19;
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(c);
        instance.addInt(0);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        if (c != instance.getCmd() && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        JOptionPane.showMessageDialog(GlavniFrame.getInstance(), "CODE: " + instance.getInt(0), "OK", 1);
    }

    public class MainThread
    extends Thread {
        public static final byte READ_BY_BARCODE = 2;
        public static final byte READ_BY_CODE = 3;
        public static final byte READ_RANGE_BY_BARCODE = 4;
        public static final byte DELETE_BY_CODE = 5;
        public static final byte DELETE_BY_BARCODE = 6;
        public static final byte DELETE_ALL = 7;
        public static final byte PROGRAM = 8;
        public static final byte READ_SOLD = 9;
        public static final byte RESET_SOLD = 10;
        public static final byte READ_SOLD_NO_DEFINITION = 14;
        public static final byte GENERATE1 = 11;
        public static final byte GENERATE2 = 12;
        public static final byte GENERATE3 = 13;
        public static final byte SAVE_TO_FILE = 15;
        public static final byte LOAD_FROM_FILE = 16;
        public static final byte WRITE_TO_BASE = 17;
        public static final byte CHANGE_PRICE = 18;
        public static final byte SAVE_PRICE_TO_FILE = 19;
        public static final byte INCREASE_PRICE = 20;
        public static final byte DECREASE_PRICE = 21;
        public static final byte GENERATE13 = 22;
        public static final byte GENERATE8 = 23;
        public static final byte GENERATE14 = 24;
        public static final byte LOAD_FROM_BASE = 25;
        public static final byte LOAD_SALE_FROM_BASE = 26;
        public static final byte PRINT_ARTICLES = 30;
        public static final byte PRINT_SELECTED_ARTICLES = 31;
        public static final byte PRINT_ARTICLES_BY_CODE = 32;
        public static final byte NEXT_FREE_CODE = 33;
        private int job = 0;

        public MainThread() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void setJob(int j) throws Exception {
            GlavniFrame glavniFrame = GlavniFrame.getInstance();
            synchronized (glavniFrame) {
                if (this.job != 0) {
                    throw new Exception(LanguageStrings.getProgramIsBusy());
                }
                this.job = j;
                this.notify();
            }
        }

        public synchronized int getJob() {
            while (this.job == 0) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.job;
        }

        public void run() {
            while (true) {
                this.getJob();
                try {
                    switch (this.job) {
                        case 2: {
                            TableArticle.this.readByBarcode();
                            break;
                        }
                        case 3: {
                            TableArticle.this.readByCode();
                            break;
                        }
                        case 4: {
                            TableArticle.this.readRangeByBarcode();
                            break;
                        }
                        case 5: {
                            TableArticle.this.deleteByCode();
                            break;
                        }
                        case 6: {
                            TableArticle.this.deleteByBarCode();
                            break;
                        }
                        case 7: {
                            TableArticle.this.deleteALL();
                            break;
                        }
                        case 8: {
                            TableArticle.this.programm();
                            break;
                        }
                        case 9: {
                            TableArticle.this.readSold();
                            break;
                        }
                        case 10: {
                            TableArticle.this.resetSold();
                            break;
                        }
                        case 11: {
                            TableArticle.this.generate1();
                            break;
                        }
                        case 12: {
                            TableArticle.this.generate2();
                            break;
                        }
                        case 13: {
                            TableArticle.this.generateRandomArticlesMain();
                            break;
                        }
                        case 22: {
                            TableArticle.this.generate13();
                            break;
                        }
                        case 24: {
                            TableArticle.this.generate14();
                            break;
                        }
                        case 23: {
                            TableArticle.this.generate8();
                            break;
                        }
                        case 14: {
                            TableArticle.this.readSoldNoDefinition();
                            break;
                        }
                        case 15: {
                            TableArticle.this.saveToFile();
                            break;
                        }
                        case 16: {
                            TableArticle.this.loadFromFile();
                            break;
                        }
                        case 17: {
                            TableArticle.this.writeToBase();
                            break;
                        }
                        case 25: {
                            TableArticle.this.loadFromBase();
                            break;
                        }
                        case 26: {
                            TableArticle.this.loadSaleFromBase();
                            break;
                        }
                        case 18: {
                            TableArticle.this.changePrice();
                            break;
                        }
                        case 19: {
                            TableArticle.this.savePriceToFile();
                            break;
                        }
                        case 20: {
                            TableArticle.this.increasePrice();
                            break;
                        }
                        case 21: {
                            TableArticle.this.decreasePrice();
                            break;
                        }
                        case 30: {
                            TableArticle.this.printAllArticles();
                            break;
                        }
                        case 32: {
                            TableArticle.this.printArticlesByCode();
                            break;
                        }
                        case 31: {
                            TableArticle.this.printSelectedArticles();
                            break;
                        }
                        case 33: {
                            TableArticle.this.getFirstFreeCode();
                        }
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e.getMessage(), "ERROR", 0);
                }
                TableArticle.this.pointer.revalidate();
                TableArticle.this.pointer.repaint();
                this.job = 0;
            }
        }
    }

    protected final class PopListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            int c = ((JMenuItem)e.getSource()).getMnemonic();
            try {
                switch (c) {
                    case 78: {
                        TxtImporer.importXls();
                        break;
                    }
                    case 43: {
                        TableArticle.this.runner.setJob(20);
                        break;
                    }
                    case 45: {
                        TableArticle.this.runner.setJob(21);
                        break;
                    }
                    case 80: {
                        TableArticle.this.runner.setJob(19);
                        break;
                    }
                    case 67: {
                        TableArticle.this.runner.setJob(18);
                        break;
                    }
                    case 66: {
                        TableArticle.this.runner.setJob(17);
                        break;
                    }
                    case 94: {
                        TableArticle.this.runner.setJob(25);
                        break;
                    }
                    case 42: {
                        TableArticle.this.runner.setJob(26);
                        break;
                    }
                    case 76: {
                        TableArticle.this.runner.setJob(16);
                        break;
                    }
                    case 83: {
                        TableArticle.this.runner.setJob(15);
                        break;
                    }
                    case 90: {
                        TableArticle.this.runner.setJob(14);
                        break;
                    }
                    case 88: {
                        TableArticle.this.runner.setJob(9);
                        break;
                    }
                    case 89: {
                        TableArticle.this.runner.setJob(10);
                        break;
                    }
                    case 48: {
                        TableArticle.this.runner.setJob(11);
                        break;
                    }
                    case 71: {
                        TableArticle.this.runner.setJob(12);
                        break;
                    }
                    case 36: {
                        TableArticle.this.runner.setJob(24);
                        break;
                    }
                    case 64: {
                        TableArticle.this.runner.setJob(22);
                        break;
                    }
                    case 35: {
                        TableArticle.this.runner.setJob(23);
                        break;
                    }
                    case 51: {
                        TableArticle.this.runner.setJob(13);
                        break;
                    }
                    case 85: {
                        TableArticle.this.runner.setJob(8);
                        break;
                    }
                    case 87: {
                        TableArticle.this.runner.setJob(4);
                        break;
                    }
                    case 49: {
                        TableArticle.this.runner.setJob(7);
                        break;
                    }
                    case 73: {
                        TableArticle.this.runner.setJob(2);
                        break;
                    }
                    case 54: {
                        TableArticle.this.runner.setJob(3);
                        break;
                    }
                    case 68: {
                        TableArticle.this.runner.setJob(5);
                        break;
                    }
                    case 69: {
                        TableArticle.this.runner.setJob(6);
                        break;
                    }
                    case 70: {
                        SearchPluDialog.getInstance().setVisible(true);
                        break;
                    }
                    case 84: {
                        ExcelImporer.importXls();
                        break;
                    }
                    case 82: {
                        TableArticle.this.export();
                        break;
                    }
                    case 62: {
                        switch (TableArticle.this.getSelectedColumn() - 1) {
                            default: {
                                return;
                            }
                            case 0: {
                                PLUSorter.quicksortByDescription(0, TableArticle.this.getRowCount() - 2);
                                break;
                            }
                            case 1: {
                                PLUSorter.quicksortByCode(0, TableArticle.this.getRowCount() - 2);
                                break;
                            }
                            case 2: {
                                PLUSorter.quicksortByBarcode(0, TableArticle.this.getRowCount() - 2);
                                break;
                            }
                            case 3: {
                                PLUSorter.quicksortByPrice(0, TableArticle.this.getRowCount() - 2);
                                break;
                            }
                            case 7: {
                                PLUSorter.quicksortByAmount(0, TableArticle.this.getRowCount() - 2);
                                break;
                            }
                            case 8: {
                                PLUSorter.quicksortBySold(0, TableArticle.this.getRowCount() - 2);
                            }
                        }
                        TableArticle.this.revalidate();
                        TableArticle.this.repaint();
                        break;
                    }
                    case 60: {
                        switch (TableArticle.this.getSelectedColumn() - 1) {
                            default: {
                                return;
                            }
                            case 0: {
                                PLUSorter.quicksortByDescription(0, TableArticle.this.getRowCount() - 2);
                                PLUSorter.reversePLUVec();
                                break;
                            }
                            case 1: {
                                PLUSorter.quicksortByCode(0, TableArticle.this.getRowCount() - 2);
                                PLUSorter.reversePLUVec();
                                break;
                            }
                            case 2: {
                                PLUSorter.quicksortByBarcode(0, TableArticle.this.getRowCount() - 2);
                                PLUSorter.reversePLUVec();
                                break;
                            }
                            case 3: {
                                PLUSorter.quicksortByPrice(0, TableArticle.this.getRowCount() - 2);
                                PLUSorter.reversePLUVec();
                                break;
                            }
                            case 7: {
                                PLUSorter.quicksortByAmount(0, TableArticle.this.getRowCount() - 2);
                                PLUSorter.reversePLUVec();
                                break;
                            }
                            case 8: {
                                PLUSorter.quicksortBySold(0, TableArticle.this.getRowCount() - 2);
                                PLUSorter.reversePLUVec();
                            }
                        }
                        TableArticle.this.revalidate();
                        TableArticle.this.repaint();
                    }
                }
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(GlavniFrame.getInstance(), e1.getMessage(), " ERROR", 0);
            }
        }
    }
}

