/*
 * Decompiled with CFR 0.152.
 */
package tables.articlesTable;

import gui.GlavniFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import objects.PLU;

public class ArticleTableCellRenderer
extends JTextField
implements TableCellRenderer {
    public ArticleTableCellRenderer(int alinement) {
        this.setHorizontalAlignment(alinement);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setFont(new Font(GlavniFrame.font.getName(), GlavniFrame.font.getStyle(), GlavniFrame.font.getSize() + 2));
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setText(value.toString());
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        if (PLU.vec.size() <= row) {
            return this;
        }
        if (PLU.vec.size() == 0) {
            return this;
        }
        PLU plu = (PLU)PLU.vec.get(row);
        if (plu.errorCode == 0) {
            return this;
        }
        if ((plu.errorCode & 0x10) > 0) {
            this.setBackground(Color.RED);
            this.setForeground(Color.CYAN);
            return this;
        }
        if ((plu.errorCode & 4) > 0 && column == 1) {
            this.setBackground(Color.RED);
            this.setForeground(Color.CYAN);
        }
        if ((plu.errorCode & 1) > 0 && column == 2) {
            this.setBackground(Color.RED);
            this.setForeground(Color.CYAN);
        }
        if ((plu.errorCode & 2) > 0 && column == 3) {
            this.setBackground(Color.RED);
            this.setForeground(Color.CYAN);
        }
        if ((plu.errorCode & 8) > 0 && column == 2) {
            this.setBackground(Color.RED);
            this.setForeground(Color.CYAN);
        }
        return this;
    }
}

